package com.easesource.iot.springbootapps.datacenter.config;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import javax.sql.DataSource;

/**
 * @author Nick Zhang
 * @date 2019-02-28
 */
@Configuration
public class EaseSystemDataSourceConfig {

    @Bean(name = "easesystemDataSource")
    @Qualifier("easesystemDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.hikari.easesystem")
    DataSource easesystemDataSource() {
        return DataSourceBuilder.create().type(HikariDataSource.class).build();
    }

    @Bean(name = "easesystemTransactionManager")
    @Qualifier("easesystemTransactionManager")
    public DataSourceTransactionManager easesystemTransactionManager(@Qualifier("easesystemDataSource") DataSource easesystemDataSource) {
        return new DataSourceTransactionManager(easesystemDataSource);
    }

}
