package com.easesource.iot.springbootapps.datacenter.config;

import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

import javax.annotation.Nonnull;
import java.util.concurrent.ScheduledThreadPoolExecutor;

/**
 * @author Nick Zhang
 */
@Configuration
public class MultiTaskScheduleConfig implements SchedulingConfigurer {

    @Override
    public void configureTasks(@Nonnull ScheduledTaskRegistrar scheduledTaskRegistrar) {
        scheduledTaskRegistrar.setScheduler(new ScheduledThreadPoolExecutor(32, new BasicThreadFactory.Builder().namingPattern("datacenter-task-scheduling-pool-%02d").daemon(true).build()));
    }

}
