package com.easesource.iot.springbootapps.datacenter.task.Schedule;

import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.DateUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.AccessMgmtService;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.easesource.iot.datacenter.openservice.entity.*;
import com.easesource.iot.datacenter.openservice.request.MeasDataLatestBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayGetRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayQueryRequest;
import com.easesource.iot.datacenter.openservice.response.MeasDataLatestBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataTaskService;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayGetResponse;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayQueryResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.quartz.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.*;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

/**
 * 累计曲线定时清楚任务
 */
@DisallowConcurrentExecution
@Component(value = "MeasDataCumFreezeCurveAutoClearTask")
public class MeasDataCumFreezeCurveAutoClearTask implements Job {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource(name = "accessMgmtService")
    private AccessMgmtService accessMgmtService;

    @Resource(name = "measDataStoreService")
    private MeasDataStoreService measDataStoreService;

    @Resource(name = "measDataTaskService")
    private MeasDataTaskService measDataTaskService;

    public MeasDataCumFreezeCurveAutoClearTask() {
        super();
    }

    @Resource(name = "pool")
    private ThreadPoolExecutor poolExecutor;


    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        Set<String> orgNoSet = (Set<String>) dataMap.get("orgNoSet");
        logger.info(">>>>>>> orgNoSet >>>> {}", JSONObject.toJSON(orgNoSet));
        LocalDate now = LocalDate.now();
        List<MeasDataTaskDo> taskList = measDataTaskService.getTaskList();
        Map<String, List<MeasDataTaskDo>> groupByTaskType = taskList.stream().collect(Collectors.groupingBy(MeasDataTaskDo::getOrgNo));
        for(String orgNo : orgNoSet) {
            String clearDays = groupByTaskType.get(orgNo).get(0).getClearDays();
            if (StringUtils.isBlank(clearDays)){
                return;
            }
            LocalDate daysAgo = now.minusDays(Integer.parseInt(clearDays));
            Date date = Date.from(daysAgo.atStartOfDay(ZoneId.systemDefault()).toInstant());
            Date dateNext = DateUtils.addDays(Date.from(daysAgo.atStartOfDay(ZoneId.systemDefault()).toInstant()),1);
            final long gmtFreeze = date.getTime();
            final long gmtFreezeEnd = dateNext.getTime();
            RunAccessGatewayQueryResponse runAccessGatewayQueryResponse = accessMgmtService.queryRunAccessGateway(new RunAccessGatewayQueryRequest(null, Sets.newHashSet(orgNo), null, null, null, null, null, null, null, null, null, null, null, null));
            if(runAccessGatewayQueryResponse.isSuccess() && runAccessGatewayQueryResponse.getRunAccessGatewayList().size() > 0) {
                for(final RunAccessGatewayVo runAccessGatewayVo : runAccessGatewayQueryResponse.getRunAccessGatewayList()) {
                    poolExecutor.execute(new FreezeTask(gmtFreeze, gmtFreezeEnd,runAccessGatewayVo));
                }
            }
        }
    }

    private class FreezeTask implements Runnable {

        private final long gmtFreezeStart;
        private final long gmtFreezeEnd;
        private final RunAccessGatewayVo runAccessGatewayVo;

        public FreezeTask(long gmtFreezeStart,long gmtFreezeEnd, RunAccessGatewayVo runAccessGatewayVo) {
            this.gmtFreezeStart = gmtFreezeStart;
            this.gmtFreezeEnd = gmtFreezeEnd;
            this.runAccessGatewayVo = runAccessGatewayVo;
        }

        @Override
        public void run() {
            try {
                RunAccessGatewayGetResponse runAccessGatewayGetResponse = accessMgmtService.getRunAccessGateway(new RunAccessGatewayGetRequest(runAccessGatewayVo.getId(), runAccessGatewayVo.getOrgNo(), null, null, "clear", null, null, null));
                if(runAccessGatewayGetResponse.isSuccess() && runAccessGatewayGetResponse.getRunMeasPointList().size() > 0) {
                    Set<Long> measPointIdSet = runAccessGatewayGetResponse.getRunMeasPointList().stream().map(RunMeasPointVo::getId).collect(Collectors.toSet());
                    logger.info(">>>>>>> 定时删除一年前累计数据任务开始 >>>>,开始时间:{},结束时间:{},{}",gmtFreezeStart, gmtFreezeEnd, JSONObject.toJSON(measPointIdSet));
                    long start = System.currentTimeMillis();
                    measDataStoreService.deleteMeasDataCumFreezeCurveDay(measPointIdSet, gmtFreezeStart, gmtFreezeEnd);
                    logger.info(">>>>>>> 定时删除一年前累计数据任务结束 >>>>,耗时:{}",System.currentTimeMillis() - start);
                }
                Thread.sleep(10); //让任务执行慢点
            }
            catch(InterruptedException e) {
                logger.error(e.getMessage(), e.fillInStackTrace());
            }
        }

        public long getGmtFreezeStart() {
            return gmtFreezeStart;
        }

        public long getGmtFreezeEnd() {
            return gmtFreezeEnd;
        }

        public RunAccessGatewayVo getRunAccessGatewayVo() {
            return runAccessGatewayVo;
        }

        @Override
        public String toString() {
            return "FreezeTask{" +
                "gmtFreeze=" + gmtFreezeStart +
                "gmtFreezeEnd=" + gmtFreezeEnd +
                ", runAccessGatewayVo=" + runAccessGatewayVo +
                '}';
        }
    }




}
