package com.easesource.iot.springbootapps.datacenter.task;

import com.alibaba.fastjson.JSONObject;
import com.easesource.iot.datacenter.openservice.entity.MeasDataTaskDo;
import com.easesource.iot.datacenter.openservice.response.MeasDataTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Component
@Order(100)
public class ScheduleJobInitListener implements CommandLineRunner {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    /**
     * 用来验证cron表达式是否正确
     */
    private static final String regEx = "^\\s*($|#|\\w+\\s*=|(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?(?:,(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?)*)\\s+(\\?|\\*|(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?(?:,(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?)*)\\s+(\\?|\\*|(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?(?:,(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?)*|\\?|\\*|(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?(?:,(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?)*)\\s+(\\?|\\*|(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?(?:,(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?)*|\\?|\\*|(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?(?:,(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?)*)(|\\s)+(\\?|\\*|(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?(?:,(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?)*))$";


    @Resource(name = "measDataTaskService")
    private MeasDataTaskService measDataTaskService;

    @Resource
    private QuartzManager quartzManager;

    @Override
    public void run(String... arg0) throws Exception {
        try {
            this.initSchedule();
        } catch (Exception e) {
            logger.error("初始化定时任务错误：", e);
        }

    }

    /**
     * 加入任务
     */
    private void initSchedule() {
        Map<String, Map<String, List<MeasDataTaskDo>>> map = getTaskMap();
        if (map == null) {
            return;
        }
        quartzManager.addJob(map);
    }

    /**
     * 从数据库中获取定时任务数据
     */
    private Map<String, Map<String, List<MeasDataTaskDo>>> getTaskMap() {
        List<MeasDataTaskDo> list = measDataTaskService.getTaskList();
        if (list == null || list.size() == 0) {
            return null;
        }
        for (MeasDataTaskDo task : list) {
            String cron = task.getCron();
            if (!cron.matches(regEx)) {
                logger.error("表达式 [{}] 错误，将不执行，涉及到的数据库数据： {}", cron, JSONObject.toJSONString(task));
                list.remove(task);
            }
        }
        Map<String, Map<String, List<MeasDataTaskDo>>> resultMap = new HashMap<>();
        if (list.size() > 0) {
            //1.按照类别进行分级
            Map<String, List<MeasDataTaskDo>> groupByTaskType = list.stream().collect(Collectors.groupingBy(MeasDataTaskDo::getTaskType));
            //2.根据cron表达式进行分级
            groupByTaskType.forEach((taskType, taskList) -> {
                Map<String, List<MeasDataTaskDo>> taskMap = taskList.stream().collect(Collectors.groupingBy(MeasDataTaskDo::getCron));
                resultMap.put(taskType, taskMap);
            });
            logger.info("最终可以跑的数据 >>>> {}", JSONObject.toJSON(resultMap));
            return resultMap;
        } else {
            return null;
        }
    }


}
