package com.easesource.iot.springbootapps.datacenter.task.Schedule;

import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.DateUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.AccessMgmtService;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;
import com.easesource.iot.datacenter.openservice.entity.RunAccessGatewayVo;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointVo;
import com.easesource.iot.datacenter.openservice.request.MeasDataLatestBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayGetRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayQueryRequest;
import com.easesource.iot.datacenter.openservice.response.MeasDataLatestBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayGetResponse;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayQueryResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.curator.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.quartz.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 累计曲线定时任务
 */
@DisallowConcurrentExecution
@Component(value = "measDataCumFreezeCurveAutoTask")
public class MeasDataCumFreezeCurveAutoTask implements Job {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String[] MEAS_ITEM_CODE_ARRAY = new String[] {
        "gen_watt_paet",
        "gen_watt_pae1",
        "gen_watt_pae2",
        "gen_watt_pae3",
        "gen_watt_pae4",
        "gen_watt_raet",
        "gen_watt_rae1",
        "gen_watt_rae2",
        "gen_watt_rae3",
        "gen_watt_rae4",
        "gen_watt_caet",
        "gen_watt_cae1",
        "gen_watt_cae2",
        "gen_watt_cae3",
        "gen_watt_cae4",
        "gen_watt_pret",
        "gen_watt_pre1",
        "gen_watt_pre2",
        "gen_watt_pre3",
        "gen_watt_pre4",
        "gen_watt_rret",
        "gen_watt_rre1",
        "gen_watt_rre2",
        "gen_watt_rre3",
        "gen_watt_rre4",
        "gen_watt_q1ret",
        "gen_watt_q1re1",
        "gen_watt_q1re2",
        "gen_watt_q1re3",
        "gen_watt_q1re4",
        "gen_watt_q2ret",
        "gen_watt_q2re1",
        "gen_watt_q2re2",
        "gen_watt_q2re3",
        "gen_watt_q2re4",
        "gen_watt_q3ret",
        "gen_watt_q3re1",
        "gen_watt_q3re2",
        "gen_watt_q3re3",
        "gen_watt_q3re4",
        "gen_watt_q4ret",
        "gen_watt_q4re1",
        "gen_watt_q4re2",
        "gen_watt_q4re3",
        "gen_watt_q4re4",
        "gen_watt_paet_cd",
        "gen_watt_paet_yd",
        "gen_watt_paet_cm",
        "gen_watt_paet_ym",
        "gen_watt_paet_cy",
        "gen_watt_paet_yy",
        "gen_watt_lpct_cd",
        "gen_watt_lpct",
        "gen_watt_bpct_cd",
        "gen_watt_bpct",
        "gen_watt_spct_cd",
        "gen_watt_spct",
        "gen_watt_escc_cd",
        "gen_watt_escc",
        "gen_watt_esdc_cd",
        "gen_watt_esdc",
        "gen_water_wcumt",
        "gen_gas_gcumt",
        "gen_heat_hcumt",
        "gen_heat_wcumt",
        "gen_heat_whcumt",
        "gen_watt_wp_paet",
        "gen_gas_stpcumt",
        "gen_watt_aircond_paet",
        "gen_watt_fridge_paet",
        "gen_watt_television_paet",
        "gen_watt_washer_paet",
        "gen_watt_paea",
        "gen_watt_paeb",
        "gen_watt_paec"
    };

    @Resource(name = "accessMgmtService")
    private AccessMgmtService accessMgmtService;

    @Resource(name = "measDataService")
    private MeasDataService measDataService;

    @Resource(name = "measDataStoreService")
    private MeasDataStoreService measDataStoreService;

    public MeasDataCumFreezeCurveAutoTask() {
        super();
    }

    @Resource(name = "pool")
    private ThreadPoolExecutor poolExecutor;

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        Set<String> orgNoSet = (Set<String>) dataMap.get("orgNoSet");
        logger.info(">>>>>>> orgNoSet >>>> {}", JSONObject.toJSON(orgNoSet));
        Date now = new Date();
        final long gmtFreeze = DateConvertUtils.convertFromString(DateConvertUtils.convertToString(now, "yyyy-MM-dd HH:mm"), "yyyy-MM-dd HH:mm").getTime();
        for(String orgNo : orgNoSet) {
            RunAccessGatewayQueryResponse runAccessGatewayQueryResponse = accessMgmtService.queryRunAccessGateway(new RunAccessGatewayQueryRequest(null, Sets.newHashSet(orgNo), null, null, null, null, null, null, null, null, null, null, null, null));
            if(runAccessGatewayQueryResponse.isSuccess() && runAccessGatewayQueryResponse.getRunAccessGatewayList().size() > 0) {
                for(final RunAccessGatewayVo runAccessGatewayVo : runAccessGatewayQueryResponse.getRunAccessGatewayList()) {
                    poolExecutor.execute(new FreezeTask(gmtFreeze, runAccessGatewayVo));
                }
            }
        }
    }

    private class FreezeTask implements Runnable {

        private final long gmtFreeze;
        private final RunAccessGatewayVo runAccessGatewayVo;

        public FreezeTask(long gmtFreeze, RunAccessGatewayVo runAccessGatewayVo) {
            this.gmtFreeze = gmtFreeze;
            this.runAccessGatewayVo = runAccessGatewayVo;
        }

        @Override
        public void run() {
            try {
                RunAccessGatewayGetResponse runAccessGatewayGetResponse = accessMgmtService.getRunAccessGateway(new RunAccessGatewayGetRequest(runAccessGatewayVo.getId(), null, null, null, null, null, null, null));
                if(runAccessGatewayGetResponse.isSuccess() && runAccessGatewayGetResponse.getRunMeasPointList().size() > 0) {
                    int i = 1;
                    Set<Long> measPointIdSet = runAccessGatewayGetResponse.getRunMeasPointList().stream().map(RunMeasPointVo::getId).collect(Collectors.toSet());
                    MeasDataLatestBatchGetRequest measDataLatestBatchGetRequest = new MeasDataLatestBatchGetRequest();
                    measDataLatestBatchGetRequest.setMeasPointIdSet(measPointIdSet);
                    measDataLatestBatchGetRequest.setMeasItemCodeSet(new HashSet<>(Arrays.asList(MEAS_ITEM_CODE_ARRAY)));
                    measDataLatestBatchGetRequest.setGmtMeasDataLatest(DateUtils.addMonths(new Date(), -6).getTime());
                    MeasDataLatestBatchGetResponse measDataLatestBatchGetResponse = measDataService.batchGetMeasDataLatest(measDataLatestBatchGetRequest);
                    if(measDataLatestBatchGetResponse.isSuccess()) {
                        Map<Long, Map<String, MeasDataLatestInfo>> batchMeasDataMap = measDataLatestBatchGetResponse.getBatchMeasDataMap();
                        if(batchMeasDataMap != null) {
                            List<MeasDataCumFreezeCurveDo> measDataCumFreezeCurveDoList = Lists.newArrayList();
                            batchMeasDataMap.forEach((measPointId, measDataMap) -> {
                                measDataMap.forEach((measItemCode, measDataLatestInfo) -> {
                                    long interval = (gmtFreeze - measDataLatestInfo.getGmtMeasDataLatest());
                                    int minuteOfDay = DateUtils.getMinuteOfDay(new Date(gmtFreeze));
                                    if(StringUtils.equals(measItemCode, "gen_watt_paet_cd")) {              // 当日发电量
                                        if(interval >= 60 * 60 * 1000 && minuteOfDay == 0) {
                                            measDataLatestInfo.setMeasDataValue(new BigDecimal("0.0"));
                                            measDataLatestInfo.setGmtMeasDataLatest(gmtFreeze);
                                            measDataLatestInfo.setMeasDataSource(4);
                                            measDataStoreService.updateMeasDataLatest(measPointId, measItemCode, JsonConvertUtils.convertFromString(JsonConvertUtils.convertToString(measDataLatestInfo), Map.class));
                                        }
                                    }
                                    else if(StringUtils.equals(measItemCode, "gen_watt_paet_cm")) {         // 当月发电量
                                        int dayOfMonth = DateUtils.getDayOfMonth(new Date(gmtFreeze));
                                        if(interval >= 60 * 60 * 1000 && minuteOfDay == 0 && dayOfMonth == 1) {
                                            measDataLatestInfo.setMeasDataValue(new BigDecimal("0.0"));
                                            measDataLatestInfo.setGmtMeasDataLatest(gmtFreeze);
                                            measDataLatestInfo.setMeasDataSource(4);
                                            measDataStoreService.updateMeasDataLatest(measPointId, measItemCode, JsonConvertUtils.convertFromString(JsonConvertUtils.convertToString(measDataLatestInfo), Map.class));
                                        }
                                    }
                                    else if(StringUtils.equals(measItemCode, "gen_watt_paet_cy")) {         // 当年发电量
                                        int dayOfYear = DateUtils.getDayOfYear(new Date(gmtFreeze));
                                        if(interval >= 60 * 60 * 1000 && minuteOfDay == 0 && dayOfYear == 1) {
                                            measDataLatestInfo.setMeasDataValue(new BigDecimal("0.0"));
                                            measDataLatestInfo.setGmtMeasDataLatest(gmtFreeze);
                                            measDataLatestInfo.setMeasDataSource(4);
                                            measDataStoreService.updateMeasDataLatest(measPointId, measItemCode, JsonConvertUtils.convertFromString(JsonConvertUtils.convertToString(measDataLatestInfo), Map.class));
                                        }
                                    }
                                    MeasDataCumFreezeCurveDo measDataCumFreezeCurveDo = new MeasDataCumFreezeCurveDo();
                                    measDataCumFreezeCurveDo.setMeasPointId(measPointId);
                                    measDataCumFreezeCurveDo.setMeasItemCode(measItemCode);
                                    measDataCumFreezeCurveDo.setGmtMeasFreeze(gmtFreeze);
                                    measDataCumFreezeCurveDo.setMeasDataValue((BigDecimal) measDataLatestInfo.getMeasDataValue());
                                    measDataCumFreezeCurveDo.setMeasDataRate(new BigDecimal("1.0"));
                                    measDataCumFreezeCurveDo.setMeasDataSource(0);
                                    measDataCumFreezeCurveDo.setGmtMeasData(measDataLatestInfo.getGmtMeasDataLatest());
                                    measDataCumFreezeCurveDo.setFreezeMode(0);
                                    measDataCumFreezeCurveDo.setGmtCreate(System.currentTimeMillis());
                                    measDataCumFreezeCurveDo.setGmtModified(System.currentTimeMillis());
                                    measDataCumFreezeCurveDoList.add(measDataCumFreezeCurveDo);

                                });
                                //logger.info("cum数据 >>>终端id：{} 量测点标识 {} 量测项id： {}", runAccessGatewayVo.getId(), measDataMap.keySet(), measPointId);
                            });
                            List<List<MeasDataCumFreezeCurveDo>> partList = Lists.partition(measDataCumFreezeCurveDoList, 50);
                            for (List<MeasDataCumFreezeCurveDo> list : partList) {
                                measDataStoreService.batchInsertOrUpdateMeasDataCumFreezeCurve(list);
                                Thread.sleep(10);
                            }
                            //partList.forEach(list -> measDataStoreService.batchInsertOrUpdateMeasDataCumFreezeCurve(list));
                        }
                    }
                }
                Thread.sleep(10); //让任务执行慢点
            }
            catch(InterruptedException e) {
                logger.error(e.getMessage(), e.fillInStackTrace());
            }
        }

        public long getGmtFreeze() {
            return gmtFreeze;
        }

        public RunAccessGatewayVo getRunAccessGatewayVo() {
            return runAccessGatewayVo;
        }

        @Override
        public String toString() {
            return "FreezeTask{" +
                "gmtFreeze=" + gmtFreeze +
                ", runAccessGatewayVo=" + runAccessGatewayVo +
                '}';
        }
    }




}
