/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.RegExUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.DevAccessRegisterService;
import com.easesource.iot.datacenter.openservice.constant.DevLifeStateEnum;
import com.easesource.iot.datacenter.openservice.constant.DevRunStatusEnum;
import com.easesource.iot.datacenter.openservice.constant.UpcommTypeEnum;
import com.easesource.iot.datacenter.openservice.dao.DevAccessDao;
import com.easesource.iot.datacenter.openservice.dao.DevAccessGatewayDao;
import com.easesource.iot.datacenter.openservice.dao.DevAccessMeasureDao;
import com.easesource.iot.datacenter.openservice.dao.DevAccessTrunkingDao;
import com.easesource.iot.datacenter.openservice.dao.LogDevAccessEntityDao;
import com.easesource.iot.datacenter.openservice.dao.RunAccessGatewayDao;
import com.easesource.iot.datacenter.openservice.dao.RunMeasPointDao;
import com.easesource.iot.datacenter.openservice.entity.DevAccessDo;
import com.easesource.iot.datacenter.openservice.entity.DevAccessGatewayDo;
import com.easesource.iot.datacenter.openservice.entity.DevAccessGatewayVo;
import com.easesource.iot.datacenter.openservice.entity.DevAccessMeasureDo;
import com.easesource.iot.datacenter.openservice.entity.DevAccessTrunkingDo;
import com.easesource.iot.datacenter.openservice.entity.LogDevAccessEntityDo;
import com.easesource.iot.datacenter.openservice.entity.RunAccessGatewayDo;
import com.easesource.iot.datacenter.openservice.entity.RunAccessGatewayVo;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointDo;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointVo;
import com.easesource.iot.datacenter.openservice.request.GmDevMeterModifyRequest;
import com.easesource.iot.datacenter.openservice.request.GmDevTermCancelRequest;
import com.easesource.iot.datacenter.openservice.request.GmDevTermModifyRequest;
import com.easesource.iot.datacenter.openservice.request.GmDevTermRegisterRequest;
import com.easesource.iot.datacenter.openservice.request.NewDevAccessGatewayRegisterRequest;
import com.easesource.iot.datacenter.openservice.request.RegisteredDevAccessGatewayGetRequest;
import com.easesource.iot.datacenter.openservice.response.GmDevMeterModifyResponse;
import com.easesource.iot.datacenter.openservice.response.GmDevTermCancelResponse;
import com.easesource.iot.datacenter.openservice.response.GmDevTermModifyResponse;
import com.easesource.iot.datacenter.openservice.response.GmDevTermRegisterResponse;
import com.easesource.iot.datacenter.openservice.response.NewDevAccessGatewayRegisterResponse;
import com.easesource.iot.datacenter.openservice.response.RegisteredDevAccessGatewayGetResponse;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="devAccessRegisterService")
public class DevAccessRegisterServiceImpl
extends AbstractBaseService
implements DevAccessRegisterService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private DevAccessDao devAccessDao;
    @Resource
    private DevAccessGatewayDao devAccessGatewayDao;
    @Resource
    private DevAccessTrunkingDao devAccessTrunkingDao;
    @Resource
    private DevAccessMeasureDao devAccessMeasureDao;
    @Resource
    private RunAccessGatewayDao runAccessGatewayDao;
    @Resource
    private RunMeasPointDao runMeasPointDao;
    @Resource
    private LogDevAccessEntityDao logDevAccessEntityDao;

    public RegisteredDevAccessGatewayGetResponse getRegisteredDevAccessGateway(RegisteredDevAccessGatewayGetRequest getRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRegisteredDevAccessGateway >>>>>>> ");
            this.logger.debug(" RegisteredDevAccessGatewayGetRequest         : " + JsonConvertUtils.convertToString((Object)getRequest));
        }
        RegisteredDevAccessGatewayGetResponse getResponse = new RegisteredDevAccessGatewayGetResponse();
        getResponse.setReturnCode("FAILURE");
        getResponse.setFailureCode("-1");
        if (getRequest != null && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr()})) {
            DevAccessGatewayVo devAccessGatewayVo = this.devAccessGatewayDao.getDevAccessGatewayVoByUpcommProtoAndUpcommLogicAddr(getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setDevAccessGateway(devAccessGatewayVo);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RegisteredDevAccessGatewayGetResponse        : " + JsonConvertUtils.convertToString((Object)getResponse));
            this.logger.debug(" <<<<<<<< end getRegisteredDevAccessGateway <<<<<<<< ");
        }
        return getResponse;
    }

    public NewDevAccessGatewayRegisterResponse registerNewDevAccessGateway(NewDevAccessGatewayRegisterRequest registerRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start registerNewDevAccessGateway >>>>>>> ");
            this.logger.debug(" NewDevAccessGatewayRegisterRequest           : " + JsonConvertUtils.convertToString((Object)registerRequest));
        }
        NewDevAccessGatewayRegisterResponse registerResponse = new NewDevAccessGatewayRegisterResponse();
        registerResponse.setReturnCode("FAILURE");
        registerResponse.setFailureCode("-1");
        if (registerRequest != null && registerRequest.getDevAccessGatewayParent() != null) {
            Long devAccessGatewayParentId = this.iotDeviceIdGenerator.nextId();
            DevAccessDo devAccessGatewayParent = registerRequest.getDevAccessGatewayParent();
            devAccessGatewayParent.setId(devAccessGatewayParentId);
            DevAccessGatewayDo devAccessGatewayDo = registerRequest.getDevAccessGatewayDo();
            devAccessGatewayDo.setId(devAccessGatewayParentId);
            RunAccessGatewayDo runAccessGatewayDo = registerRequest.getRunAccessGatewayDo();
            runAccessGatewayDo.setId(devAccessGatewayParentId);
            int measPointCount = runAccessGatewayDo.getMeasPointCount();
            this.devAccessDao.insert(devAccessGatewayParent);
            this.devAccessGatewayDao.insert(devAccessGatewayDo);
            this.runAccessGatewayDao.insert(runAccessGatewayDo);
            if (devAccessGatewayParent.getDevAccessSortNo().contains("SZ")) {
                DevAccessMeasureDo devAccessMeasureDo = new DevAccessMeasureDo();
                devAccessMeasureDo.setId(devAccessGatewayParent.getId());
                devAccessMeasureDo.setMeasCommMode("ACSAMP");
                devAccessMeasureDo.setMeasCommProto("TCP_SZ");
                devAccessMeasureDo.setMeasCommAddr(devAccessGatewayParent.getDevAccessNo());
                devAccessMeasureDo.setEnableElec(true);
                devAccessMeasureDo.setEnableWater(false);
                devAccessMeasureDo.setEnableGas(false);
                devAccessMeasureDo.setEnableHeat(false);
                devAccessMeasureDo.setVersion(1);
                this.devAccessMeasureDao.insert(devAccessMeasureDo);
                RunMeasPointDo runMeasPointDo = new RunMeasPointDo();
                runMeasPointDo.setId(devAccessGatewayParentId);
                runMeasPointDo.setOrgNo(devAccessGatewayParent.getOrgNo());
                runMeasPointDo.setAccessGatewayId(devAccessGatewayParentId);
                runMeasPointDo.setAccessTrunkingId(Long.valueOf(0L));
                runMeasPointDo.setAccessMeasureId(devAccessGatewayParent.getId());
                runMeasPointDo.setMeasKind(1);
                runMeasPointDo.setMeasSn(0);
                runMeasPointDo.setMeasCommMode("ACSAMP");
                runMeasPointDo.setMeasCommProto("TCP_SZ");
                runMeasPointDo.setMeasCommAddr(devAccessGatewayParent.getDevAccessNo());
                runMeasPointDo.setMeasCommPort(1);
                runMeasPointDo.setGmtMessageUp(System.currentTimeMillis());
                runMeasPointDo.setGmtMeasdataUp(System.currentTimeMillis());
                runMeasPointDo.setGmtAlarmUp(System.currentTimeMillis());
                runMeasPointDo.setGmtCreate(System.currentTimeMillis());
                runMeasPointDo.setGmtModified(System.currentTimeMillis());
                runMeasPointDo.setVersion(1);
                this.runMeasPointDao.insert(runMeasPointDo);
            }
            List devAccessMeasureParentList = registerRequest.getDevAccessMeasureParentList();
            List devAccessMeasureDoList = registerRequest.getDevAccessMeasureDoList();
            for (int i = 0; i < measPointCount; ++i) {
                Long devAccessMeasureParentId = this.iotDeviceIdGenerator.nextId();
                DevAccessDo devAccessMeasureParent = (DevAccessDo)devAccessMeasureParentList.get(i);
                devAccessMeasureParent.setId(devAccessMeasureParentId);
                DevAccessMeasureDo devAccessMeasureDo = (DevAccessMeasureDo)devAccessMeasureDoList.get(i);
                devAccessMeasureDo.setId(devAccessMeasureParentId);
                this.devAccessDao.insert(devAccessMeasureParent);
                this.devAccessMeasureDao.insert(devAccessMeasureDo);
                RunMeasPointDo runMeasPointDo = new RunMeasPointDo();
                runMeasPointDo.setId(Long.valueOf(this.iotDeviceIdGenerator.nextId()));
                runMeasPointDo.setOrgNo(devAccessMeasureParent.getOrgNo());
                runMeasPointDo.setAccessGatewayId(devAccessGatewayParentId);
                runMeasPointDo.setAccessTrunkingId(Long.valueOf(0L));
                runMeasPointDo.setAccessMeasureId(devAccessMeasureParentId);
                runMeasPointDo.setMeasKind(1);
                runMeasPointDo.setMeasSn(devAccessMeasureParent.getDevAccessSortNo().contains("SZ") ? 0 : Integer.parseInt(devAccessMeasureDo.getMeasCommAddr()));
                runMeasPointDo.setMeasCommMode(devAccessMeasureDo.getMeasCommMode());
                runMeasPointDo.setMeasCommProto(devAccessMeasureDo.getMeasCommProto());
                runMeasPointDo.setMeasCommAddr(devAccessMeasureDo.getMeasCommAddr());
                runMeasPointDo.setMeasCommPort(1);
                runMeasPointDo.setGmtMessageUp(System.currentTimeMillis());
                runMeasPointDo.setGmtMeasdataUp(System.currentTimeMillis());
                runMeasPointDo.setGmtAlarmUp(System.currentTimeMillis());
                runMeasPointDo.setGmtCreate(System.currentTimeMillis());
                runMeasPointDo.setGmtModified(System.currentTimeMillis());
                runMeasPointDo.setVersion(1);
                this.runMeasPointDao.insert(runMeasPointDo);
            }
            registerResponse.setReturnCode("SUCCESS");
            registerResponse.setFailureCode(null);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" NewDevAccessGatewayRegisterResponse          : " + JsonConvertUtils.convertToString((Object)registerResponse));
            this.logger.debug(" <<<<<<<< end registerNewDevAccessGateway <<<<<<<< ");
        }
        return registerResponse;
    }

    public GmDevTermCancelResponse cancelGmDevTerm(GmDevTermCancelRequest cancelRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start cancelGmDevTerm >>>>>>> ");
            this.logger.debug(" GmDevTermCancelRequest       : " + JsonConvertUtils.convertToString((Object)cancelRequest));
        }
        GmDevTermCancelResponse cancelResponse = new GmDevTermCancelResponse();
        cancelResponse.setReturnCode("FAILURE");
        cancelResponse.setFailureCode("-1");
        if (cancelRequest != null) {
            boolean hasAllAcsampRunMeasPointList;
            Long accessGatewayId = cancelRequest.getAccessGatewayId();
            AtomicReference<Long> acsampMeasPointIdRef = new AtomicReference<Long>(0L);
            if (accessGatewayId == null || accessGatewayId <= 0L) {
                cancelResponse.setReturnCode("FAILURE");
                cancelResponse.setFailureCode("10000006");
                cancelResponse.setFailureMsg("\u4f20\u5165\u7684\u63a5\u5165\u7f51\u5173\u8bbe\u5907\u6807\u8bc6\u975e\u6cd5");
                return cancelResponse;
            }
            DevAccessDo devAccessDo = (DevAccessDo)this.devAccessDao.get(accessGatewayId);
            RunAccessGatewayVo runAccessGatewayVo = this.runAccessGatewayDao.getRunAccessGatewayVoById(accessGatewayId);
            List<RunMeasPointVo> runMeasPointList = this.runMeasPointDao.getRunMeasPointVoListByAccessGatewayId(accessGatewayId);
            if (CollectionUtils.isNotEmpty(runMeasPointList) && !(hasAllAcsampRunMeasPointList = runMeasPointList.stream().allMatch(t -> StringUtils.equals((CharSequence)t.getMeasCommMode(), (CharSequence)"ACSAMP")))) {
                cancelResponse.setReturnCode("FAILURE");
                cancelResponse.setFailureCode("10000007");
                cancelResponse.setFailureMsg("\u63a5\u5165\u7f51\u5173\u8bbe\u5907\u4e0b\u6709\u5176\u4ed6\u63a5\u5165\u91cf\u6d4b\u8868\u8ba1\u8bbe\u5907\uff0c\u8bf7\u5148\u62c6\u9664\uff01");
                return cancelResponse;
            }
            if (devAccessDo != null && runAccessGatewayVo != null && !devAccessDo.getId().equals(runAccessGatewayVo.getId())) {
                cancelResponse.setReturnCode("FAILURE");
                cancelResponse.setFailureCode("10000122");
                cancelResponse.setFailureMsg("\u63a5\u5165\u7f51\u5173\u8bbe\u5907\u548c\u63a5\u5165\u7f51\u5173\u8bbe\u5907\u8fd0\u884c\u5de5\u51b5\u5b9e\u4f53\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5220\u9664");
                return cancelResponse;
            }
            if (devAccessDo != null) {
                DevAccessMeasureDo devAccessMeasureDo;
                DevAccessTrunkingDo devAccessTrunkingDo;
                LinkedHashMap oldEntityMap = Maps.newLinkedHashMap();
                oldEntityMap.put("devAccess", devAccessDo);
                DevAccessGatewayDo devAccessGatewayDo = (DevAccessGatewayDo)this.devAccessGatewayDao.get(accessGatewayId);
                if (devAccessGatewayDo != null) {
                    oldEntityMap.put("devAccessGateway", devAccessGatewayDo);
                    this.devAccessGatewayDao.delete(devAccessGatewayDo);
                }
                if ((devAccessTrunkingDo = (DevAccessTrunkingDo)this.devAccessTrunkingDao.get(accessGatewayId)) != null) {
                    oldEntityMap.put("devAccessTrunking", devAccessTrunkingDo);
                    this.devAccessTrunkingDao.delete(devAccessTrunkingDo);
                }
                if ((devAccessMeasureDo = (DevAccessMeasureDo)this.devAccessMeasureDao.get(accessGatewayId)) != null) {
                    oldEntityMap.put("devAccessMeasure", devAccessMeasureDo);
                    this.devAccessMeasureDao.delete(devAccessMeasureDo);
                }
                this.devAccessDao.delete(devAccessDo);
                LogDevAccessEntityDo logDevAccessEntity = new LogDevAccessEntityDo();
                logDevAccessEntity.setId(Long.valueOf(this.iotDeviceIdGenerator.nextId()));
                logDevAccessEntity.setLogType(3);
                logDevAccessEntity.setDevAccessId(accessGatewayId);
                logDevAccessEntity.setOldEntity(JsonConvertUtils.convertToString((Object)oldEntityMap, (PropertyNamingStrategy)PropertyNamingStrategy.SNAKE_CASE));
                logDevAccessEntity.setNewEntity(JsonConvertUtils.convertToString((Object)Maps.newLinkedHashMap()));
                logDevAccessEntity.setAlterPathway((String)StringUtils.defaultIfBlank((CharSequence)cancelRequest.getPathway(), (CharSequence)"PC_WEBAPP"));
                logDevAccessEntity.setAlterOper((String)StringUtils.defaultIfBlank((CharSequence)cancelRequest.getOperator(), (CharSequence)"$UNKNOWN^"));
                logDevAccessEntity.setGmtAlter(System.currentTimeMillis());
                this.logDevAccessEntityDao.insertLog(logDevAccessEntity);
            }
            if (runAccessGatewayVo != null) {
                this.runAccessGatewayDao.deleteById(runAccessGatewayVo.getId());
            }
            if (CollectionUtils.isNotEmpty(runMeasPointList)) {
                runMeasPointList.forEach(t -> {
                    acsampMeasPointIdRef.set(t.getId());
                    this.runMeasPointDao.deleteById(t.getId());
                });
            }
            cancelResponse.setReturnCode("SUCCESS");
            cancelResponse.setFailureCode(null);
            cancelResponse.setAccessGatewayId(accessGatewayId);
            cancelResponse.setAcsampMeasPointId(acsampMeasPointIdRef.get());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" GmDevTermCancelResponse      : " + JsonConvertUtils.convertToString((Object)cancelResponse));
            this.logger.debug(" <<<<<<<< end cancelGmDevTerm <<<<<<<< ");
        }
        return cancelResponse;
    }

    @Transactional(rollbackFor={Exception.class})
    public GmDevTermModifyResponse modifyGmDevTerm(GmDevTermModifyRequest modifyRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start modifyGmDevTerm >>>>>>> ");
            this.logger.debug(" GmDevTermModifyRequest       : " + JsonConvertUtils.convertToString((Object)modifyRequest));
        }
        this.logger.info("\u7f16\u8f91\u7ec8\u7aef>>>>>>>>>>>>>>>>>>>>>>" + JSONObject.toJSONString((Object)modifyRequest));
        GmDevTermModifyResponse modifyResponse = new GmDevTermModifyResponse();
        modifyResponse.setReturnCode("FAILURE");
        modifyResponse.setFailureCode("-1");
        if (modifyRequest != null) {
            RunAccessGatewayVo runAccessGatewayVo;
            DevAccessDo devAccessDo;
            DevAccessMeasureDo oldDevAccessMeasureDo;
            DevAccessTrunkingDo oldDevAccessTrunkingDo;
            Long accessGatewayId = modifyRequest.getAccessGatewayId();
            if (accessGatewayId == null || accessGatewayId <= 0L) {
                modifyResponse.setReturnCode("FAILURE");
                modifyResponse.setFailureCode("10000006");
                modifyResponse.setFailureMsg("\u4f20\u5165\u7684\u63a5\u5165\u7f51\u5173\u8bbe\u5907\u6807\u8bc6\u975e\u6cd5");
                return modifyResponse;
            }
            DevAccessDo oldDevAccessDo = (DevAccessDo)this.devAccessDao.get(accessGatewayId);
            RunAccessGatewayVo oldRunAccessGatewayVo = this.runAccessGatewayDao.getRunAccessGatewayVoById(accessGatewayId);
            List<RunMeasPointVo> oldRunMeasPointList = this.runMeasPointDao.getRunMeasPointVoListByAccessGatewayId(accessGatewayId);
            if (oldDevAccessDo == null) {
                modifyResponse.setReturnCode("FAILURE");
                modifyResponse.setFailureCode("10000008");
                modifyResponse.setFailureMsg("\u63a5\u5165\u7f51\u5173\u8bbe\u5907\u4e0d\u5b58\u5728");
                return modifyResponse;
            }
            LinkedHashMap oldEntityMap = Maps.newLinkedHashMap();
            oldEntityMap.put("devAccess", oldDevAccessDo);
            DevAccessGatewayDo oldDevAccessGatewayDo = (DevAccessGatewayDo)this.devAccessGatewayDao.get(accessGatewayId);
            if (oldDevAccessGatewayDo != null) {
                oldEntityMap.put("devAccessGateway", oldDevAccessGatewayDo);
            }
            if ((oldDevAccessTrunkingDo = (DevAccessTrunkingDo)this.devAccessTrunkingDao.get(accessGatewayId)) != null) {
                oldEntityMap.put("devAccessTrunking", oldDevAccessTrunkingDo);
            }
            if ((oldDevAccessMeasureDo = (DevAccessMeasureDo)this.devAccessMeasureDao.get(accessGatewayId)) != null) {
                oldEntityMap.put("devAccessMeasure", oldDevAccessMeasureDo);
            }
            String orgNo = StringUtils.trim((String)modifyRequest.getOrgNo());
            String devTermNo = StringUtils.trim((String)modifyRequest.getDevTermNo());
            String devTermName = StringUtils.trim((String)modifyRequest.getDevTermName());
            String devTermCommProto = StringUtils.trim((String)modifyRequest.getDevTermCommProto());
            String devTermCommProtoVer = StringUtils.trim((String)modifyRequest.getDevTermCommProtoVer());
            Integer devTermCommMode = modifyRequest.getDevTermCommMode();
            String devTermCommAddr = StringUtils.trim((String)modifyRequest.getDevTermCommAddr());
            String devTermCommParam = StringUtils.trim((String)modifyRequest.getDevTermCommParam());
            String productKey = StringUtils.trim((String)modifyRequest.getProductKey());
            String devAccessSortNo = null;
            String upcommProto = null;
            String upcommProtoVer = null;
            String upcommLogicAddr = devTermCommAddr;
            int upcommType = 0;
            String upcommParam = devTermCommParam;
            Boolean encrypt = modifyRequest.getEncrypt();
            String encryptType = StringUtils.trim((String)modifyRequest.getEncryptType());
            String encryptInfo = StringUtils.trim((String)modifyRequest.getEncryptInfo());
            String acsampMeasCommMode = "ACSAMP";
            String acsampMeasCommProto = null;
            String acsampMeasCommAddr = null;
            if (StringUtils.isNotBlank((CharSequence)devTermCommProto) && devTermCommMode != null) {
                if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"GAEADCU")) {
                    devAccessSortNo = "GAEADCU";
                    if (devTermCommMode == 1) {
                        upcommProto = "TCP_GAEADCU";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    } else if (devTermCommMode == 2) {
                        upcommProto = "UDP_GAEADCU";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"V4");
                    productKey = "GAEA_DCU_V4";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = devTermNo;
                    if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)8)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a8\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                        return modifyResponse;
                    }
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"DLT698_45")) {
                    devAccessSortNo = "DLT698_45";
                    if (devTermCommMode == 1) {
                        upcommProto = "TCP_DLT698_45";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    } else if (devTermCommMode == 2) {
                        upcommProto = "UDP_DLT698_45";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"2017");
                    productKey = "DLT698_45_2017";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = devTermNo;
                    if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)12)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a12\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                        return modifyResponse;
                    }
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"DLT698_45_WITH_1867")) {
                    devAccessSortNo = "DLT698_45_WITH_1867";
                    if (devTermCommMode == 1) {
                        upcommProto = "TCP_DLT698_45_WITH_1867";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    } else if (devTermCommMode == 2) {
                        upcommProto = "UDP_DLT698_45_WITH_1867";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"2020");
                    productKey = "DLT698_45_WITH_1867_2017";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = devTermNo;
                    if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)8)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a8\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                        return modifyResponse;
                    }
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"QGDW1376_1")) {
                    devAccessSortNo = "QGDW1376_1";
                    if (devTermCommMode == 1) {
                        upcommProto = "TCP_QGDW1376_1";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    } else if (devTermCommMode == 2) {
                        upcommProto = "UDP_QGDW1376_1";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"2013");
                    productKey = "QGDW1376_1_2013";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = devTermNo;
                    if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)8)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a8\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                        return modifyResponse;
                    }
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"IEC104")) {
                    devAccessSortNo = "IEC104";
                    if (devTermCommMode == 1) {
                        upcommProto = "TCP_IEC104";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    } else if (devTermCommMode == 2) {
                        upcommProto = "UDP_IEC104";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"STD");
                    productKey = "IEC_104_STD";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = StringUtils.leftPad((String)upcommLogicAddr, (int)10, (char)'0') + "00";
                    if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)4)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a4\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                        return modifyResponse;
                    }
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"HUAYUN104")) {
                    devAccessSortNo = "HUAYUN104";
                    if (devTermCommMode == 1) {
                        upcommProto = "TCP_HUAYUN104";
                        upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                    } else if (devTermCommMode == 2) {
                        upcommProto = "UDP_HUAYUN104";
                        upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                    }
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"");
                    productKey = "HUAYUN104";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;
                    if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)12)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a12\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                        return modifyResponse;
                    }
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"MQTT_JALASMART")) {
                    devAccessSortNo = "JALASMART_GATEWAY";
                    if (devTermCommMode != 1) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000012");
                        modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u65b9\u5f0f\u4e0d\u652f\u6301");
                        return modifyResponse;
                    }
                    upcommProto = "MQTT_JALASMART";
                    upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.6");
                    productKey = "b03b99VXEV1";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"MQTT_TIMUIOT")) {
                    devAccessSortNo = "TIMUIOT_GATEWAY";
                    if (devTermCommMode != 1) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000012");
                        modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u65b9\u5f0f\u4e0d\u652f\u6301");
                        return modifyResponse;
                    }
                    upcommProto = "MQTT_TIMUIOT";
                    upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.28");
                    productKey = "YINDE";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;
                    if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)12)) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000011");
                        modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a12\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                        return modifyResponse;
                    }
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"MQTT_DINGIIOT")) {
                    devAccessSortNo = "DINGIIOT_GATEWAY";
                    if (devTermCommMode != 1) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000012");
                        modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u65b9\u5f0f\u4e0d\u652f\u6301");
                        return modifyResponse;
                    }
                    upcommProto = "MQTT_DINGIIOT";
                    upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.2");
                    productKey = "dingiiot";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"MQTT_IDCCIOT")) {
                    devAccessSortNo = "IDCCIOT_GATEWAY";
                    if (devTermCommMode != 1) {
                        modifyResponse.setReturnCode("FAILURE");
                        modifyResponse.setFailureCode("10000012");
                        modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u65b9\u5f0f\u4e0d\u652f\u6301");
                        return modifyResponse;
                    }
                    upcommProto = "MQTT_IDCCIOT";
                    upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.2");
                    productKey = "IDCCIOT";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"LWM2M_CTWING")) {
                    devAccessSortNo = "LWM2M_CTWING_GATEWAY";
                    upcommProto = "LWM2M_CTWING_GATEWAY";
                    upcommType = UpcommTypeEnum.UDP_LWM2M.getType();
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.9.0");
                    productKey = "LWM2M_CTWING";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"WSAPI_SUNTRONT")) {
                    devAccessSortNo = "WSAPI_SUNTRONT_GATEWAY";
                    devTermCommMode = 2;
                    upcommProto = "WSAPI_SUNTRONT_GATEWAY";
                    upcommType = UpcommTypeEnum.UDP_LWM2M.getType();
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.0");
                    productKey = "WSAPI_SUNTRONT";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;
                } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"ENOSIOT_API_2")) {
                    devAccessSortNo = "ENOSIOT_API_2_GATEWAY";
                    devTermCommMode = 1;
                    upcommProto = "ENOSIOT_API_2_GATEWAY";
                    upcommType = UpcommTypeEnum.TCP_HTTP.getType();
                    upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"V2");
                    productKey = "ENOSIOT_API_2";
                    acsampMeasCommProto = upcommProto;
                    acsampMeasCommAddr = upcommLogicAddr;
                } else {
                    modifyResponse.setReturnCode("FAILURE");
                    modifyResponse.setFailureCode("10000010");
                    modifyResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u89c4\u7ea6\u4e0d\u652f\u6301");
                    return modifyResponse;
                }
            }
            String devAccessNo = devTermNo;
            if (!(StringUtils.equals((CharSequence)orgNo, (CharSequence)oldDevAccessDo.getOrgNo()) && StringUtils.equals((CharSequence)devAccessSortNo, (CharSequence)oldDevAccessDo.getDevAccessSortNo()) && StringUtils.equals((CharSequence)devAccessNo, (CharSequence)oldDevAccessDo.getDevAccessNo()) || (devAccessDo = this.devAccessDao.getByOrgNoAndDevAccessSortNoAndDevAccessNo(orgNo, devAccessSortNo, devAccessNo)) == null || devAccessDo.getId() <= 0L)) {
                modifyResponse.setReturnCode("FAILURE");
                modifyResponse.setFailureCode("10000020");
                modifyResponse.setFailureMsg("\u8be5\u91c7\u96c6\u7ec8\u7aef\u7f16\u53f7\u5df2\u5b58\u5728");
            }
            if (!(StringUtils.equals((CharSequence)productKey, (CharSequence)oldRunAccessGatewayVo.getProductKey()) && StringUtils.equals((CharSequence)upcommProto, (CharSequence)oldRunAccessGatewayVo.getUpcommProto()) && StringUtils.equals((CharSequence)upcommLogicAddr, (CharSequence)oldRunAccessGatewayVo.getUpcommLogicAddr()) || (runAccessGatewayVo = this.runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndUpcommProtoAndUpcommLogicAddr(productKey, upcommProto, upcommLogicAddr)) == null || runAccessGatewayVo.getId() <= 0L)) {
                modifyResponse.setReturnCode("FAILURE");
                modifyResponse.setFailureCode("10000021");
                modifyResponse.setFailureMsg("\u8be5\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u5df2\u5b58\u5728");
            }
            LinkedHashMap newEntityMap = Maps.newLinkedHashMap();
            DevAccessDo newDevAccessDo = null;
            try {
                newDevAccessDo = (DevAccessDo)BeanUtils.cloneBean((Object)oldDevAccessDo);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.logger.error(e.getMessage(), e.fillInStackTrace());
            }
            if (newDevAccessDo != null) {
                if (StringUtils.isNotBlank((CharSequence)orgNo)) {
                    newDevAccessDo.setOrgNo(orgNo);
                }
                if (StringUtils.isNotBlank((CharSequence)devAccessSortNo)) {
                    newDevAccessDo.setDevAccessSortNo(devAccessSortNo);
                }
                if (StringUtils.isNotBlank((CharSequence)devAccessNo)) {
                    newDevAccessDo.setDevAccessNo(devAccessNo);
                }
                if (StringUtils.isNotBlank((CharSequence)devTermName)) {
                    newDevAccessDo.setDevAccessName(devTermName);
                    newDevAccessDo.setDevAccessDesc(devTermName);
                }
                if (StringUtils.isNotBlank((CharSequence)modifyRequest.getMfrCode())) {
                    newDevAccessDo.setMfrCode(StringUtils.trim((String)modifyRequest.getMfrCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)modifyRequest.getModelCode())) {
                    newDevAccessDo.setModelCode(StringUtils.trim((String)modifyRequest.getModelCode()));
                }
                newDevAccessDo.setValid(true);
                newDevAccessDo.setGmtModified(System.currentTimeMillis());
                newDevAccessDo.setVersion(newDevAccessDo.getSortSn() + 1);
                this.devAccessDao.update(newDevAccessDo);
                newEntityMap.put("devAccess", newDevAccessDo);
                if (oldDevAccessGatewayDo != null) {
                    DevAccessGatewayDo newDevAccessGatewayDo = null;
                    try {
                        newDevAccessGatewayDo = (DevAccessGatewayDo)BeanUtils.cloneBean((Object)oldDevAccessGatewayDo);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        this.logger.error(e.getMessage(), e.fillInStackTrace());
                    }
                    if (newDevAccessGatewayDo != null) {
                        if (StringUtils.isNotBlank((CharSequence)upcommProto)) {
                            newDevAccessGatewayDo.setUpcommProto(upcommProto);
                        }
                        if (StringUtils.isNotBlank((CharSequence)upcommProtoVer)) {
                            newDevAccessGatewayDo.setUpcommProtoVer(upcommProtoVer);
                        }
                        if (StringUtils.isNotBlank((CharSequence)upcommLogicAddr)) {
                            newDevAccessGatewayDo.setUpcommLogicAddr(upcommLogicAddr);
                        }
                        if (upcommType > 0) {
                            newDevAccessGatewayDo.setUpcommType(upcommType);
                        }
                        if (StringUtils.isNotBlank((CharSequence)upcommParam)) {
                            newDevAccessGatewayDo.setUpcommParam(upcommParam);
                        }
                        if (encrypt != null) {
                            newDevAccessGatewayDo.setEncrypt(encrypt.booleanValue());
                        }
                        if (StringUtils.isNotBlank((CharSequence)encryptType)) {
                            newDevAccessGatewayDo.setEncryptType(encryptType);
                        }
                        if (StringUtils.isNotBlank((CharSequence)encryptInfo)) {
                            newDevAccessGatewayDo.setEncryptInfo(encryptInfo);
                        }
                        newDevAccessGatewayDo.setVersion(newDevAccessGatewayDo.getVersion() + 1);
                        this.devAccessGatewayDao.update(newDevAccessGatewayDo);
                        newEntityMap.put("devAccessGateway", newDevAccessGatewayDo);
                    }
                }
                if (oldDevAccessMeasureDo != null && StringUtils.isNotBlank((CharSequence)acsampMeasCommProto) && StringUtils.isNotBlank((CharSequence)acsampMeasCommAddr)) {
                    DevAccessMeasureDo newDevAccessMeasureDo = null;
                    try {
                        newDevAccessMeasureDo = (DevAccessMeasureDo)BeanUtils.cloneBean((Object)oldDevAccessMeasureDo);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        this.logger.error(e.getMessage(), e.fillInStackTrace());
                    }
                    if (newDevAccessMeasureDo != null) {
                        if (StringUtils.isNotBlank((CharSequence)acsampMeasCommMode)) {
                            newDevAccessMeasureDo.setMeasCommMode(acsampMeasCommMode);
                        }
                        if (StringUtils.isNotBlank((CharSequence)acsampMeasCommProto)) {
                            newDevAccessMeasureDo.setMeasCommProto(acsampMeasCommProto);
                        }
                        if (StringUtils.isNotBlank((CharSequence)acsampMeasCommAddr)) {
                            newDevAccessMeasureDo.setMeasCommAddr(acsampMeasCommAddr);
                        }
                        newDevAccessMeasureDo.setVersion(newDevAccessMeasureDo.getVersion() + 1);
                        this.devAccessMeasureDao.update(newDevAccessMeasureDo);
                        newEntityMap.put("devAccessMeasure", newDevAccessMeasureDo);
                    }
                }
                LogDevAccessEntityDo logDevAccessEntity = new LogDevAccessEntityDo();
                logDevAccessEntity.setId(Long.valueOf(this.iotDeviceIdGenerator.nextId()));
                logDevAccessEntity.setLogType(2);
                logDevAccessEntity.setDevAccessId(accessGatewayId);
                logDevAccessEntity.setOldEntity(JsonConvertUtils.convertToString((Object)oldEntityMap, (PropertyNamingStrategy)PropertyNamingStrategy.SNAKE_CASE));
                logDevAccessEntity.setNewEntity(JsonConvertUtils.convertToString((Object)newEntityMap, (PropertyNamingStrategy)PropertyNamingStrategy.SNAKE_CASE));
                logDevAccessEntity.setAlterPathway((String)StringUtils.defaultIfBlank((CharSequence)modifyRequest.getPathway(), (CharSequence)"PC_WEBAPP"));
                logDevAccessEntity.setAlterOper((String)StringUtils.defaultIfBlank((CharSequence)modifyRequest.getOperator(), (CharSequence)"$UNKNOWN^"));
                logDevAccessEntity.setGmtAlter(System.currentTimeMillis());
                this.logDevAccessEntityDao.insertLog(logDevAccessEntity);
            }
            RunAccessGatewayDo newRunAccessGatewayDo = null;
            try {
                newRunAccessGatewayDo = new RunAccessGatewayDo();
                BeanUtils.copyProperties((Object)newRunAccessGatewayDo, (Object)oldRunAccessGatewayVo);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.logger.error(e.getMessage(), e.fillInStackTrace());
            }
            if (newRunAccessGatewayDo.getId() > 0L) {
                if (StringUtils.isNotBlank((CharSequence)orgNo)) {
                    newRunAccessGatewayDo.setOrgNo(orgNo);
                }
                if (StringUtils.isNotBlank((CharSequence)productKey)) {
                    newRunAccessGatewayDo.setProductKey(productKey);
                }
                if (StringUtils.isNotBlank((CharSequence)devAccessNo)) {
                    newRunAccessGatewayDo.setClientId(devAccessNo);
                }
                if (StringUtils.isNotBlank((CharSequence)upcommProto)) {
                    newRunAccessGatewayDo.setUpcommProto(upcommProto);
                }
                if (StringUtils.isNotBlank((CharSequence)upcommProtoVer)) {
                    newRunAccessGatewayDo.setUpcommProtoVer(upcommProtoVer);
                }
                if (StringUtils.isNotBlank((CharSequence)upcommLogicAddr)) {
                    newRunAccessGatewayDo.setUpcommLogicAddr(upcommLogicAddr);
                }
                if (upcommType > 0) {
                    newRunAccessGatewayDo.setUpcommType(upcommType);
                }
                if (StringUtils.isNotBlank((CharSequence)upcommParam)) {
                    newRunAccessGatewayDo.setUpcommParam(upcommParam);
                }
                if (encrypt != null) {
                    newRunAccessGatewayDo.setEncrypt(encrypt.booleanValue());
                }
                if (StringUtils.isNotBlank((CharSequence)encryptType)) {
                    newRunAccessGatewayDo.setEncryptType(encryptType);
                }
                if (StringUtils.isNotBlank((CharSequence)encryptInfo)) {
                    newRunAccessGatewayDo.setEncryptInfo(encryptInfo);
                }
                newRunAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                newRunAccessGatewayDo.setVersion(newRunAccessGatewayDo.getVersion() + 1);
                this.runAccessGatewayDao.update(newRunAccessGatewayDo);
            }
            Long acsampMeasPointId = null;
            if (CollectionUtils.isNotEmpty(oldRunMeasPointList)) {
                for (RunMeasPointVo oldRunMeasPointVo : oldRunMeasPointList) {
                    if (!"ACSAMP".equals(oldRunMeasPointVo.getMeasCommMode())) continue;
                    RunMeasPointDo newRunMeasPointDo = null;
                    try {
                        newRunMeasPointDo = new RunMeasPointDo();
                        BeanUtils.copyProperties((Object)newRunMeasPointDo, (Object)oldRunMeasPointVo);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        this.logger.error(e.getMessage(), e.fillInStackTrace());
                    }
                    if (newRunMeasPointDo.getId() <= 0L) continue;
                    acsampMeasPointId = newRunMeasPointDo.getId();
                    if (StringUtils.isNotBlank((CharSequence)orgNo)) {
                        newRunMeasPointDo.setOrgNo(orgNo);
                    }
                    if (StringUtils.isNotBlank((CharSequence)acsampMeasCommMode)) {
                        newRunMeasPointDo.setMeasCommMode(acsampMeasCommMode);
                    }
                    if (StringUtils.isNotBlank((CharSequence)acsampMeasCommProto)) {
                        newRunMeasPointDo.setMeasCommProto(acsampMeasCommProto);
                    }
                    if (StringUtils.isNotBlank((CharSequence)acsampMeasCommAddr)) {
                        newRunMeasPointDo.setMeasCommAddr(acsampMeasCommAddr);
                    }
                    newRunMeasPointDo.setGmtModified(System.currentTimeMillis());
                    newRunMeasPointDo.setVersion(newRunMeasPointDo.getVersion() + 1);
                    this.runMeasPointDao.update(newRunMeasPointDo);
                }
            }
            modifyResponse.setReturnCode("SUCCESS");
            modifyResponse.setFailureCode(null);
            modifyResponse.setAccessGatewayId(accessGatewayId);
            modifyResponse.setAcsampMeasPointId(acsampMeasPointId);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" GmDevTermModifyResponse      : " + JsonConvertUtils.convertToString((Object)modifyResponse));
            this.logger.debug(" <<<<<<<< end modifyGmDevTerm <<<<<<<< ");
        }
        return modifyResponse;
    }

    public GmDevTermRegisterResponse registerGmDevTerm(GmDevTermRegisterRequest registerRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start registerGmDevTerm >>>>>>> ");
            this.logger.debug(" GmDevTermRegisterRequest     : " + JsonConvertUtils.convertToString((Object)registerRequest));
        }
        GmDevTermRegisterResponse registerResponse = new GmDevTermRegisterResponse();
        registerResponse.setReturnCode("FAILURE");
        registerResponse.setFailureCode("-1");
        if (registerRequest != null) {
            RunAccessGatewayVo runAccessGatewayVo;
            String devAccessNo;
            DevAccessDo devAccessDo;
            if (StringUtils.isBlank((CharSequence)registerRequest.getOrgNo())) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000000");
                registerResponse.setFailureMsg("\u4f20\u5165\u5355\u4f4d\u7f16\u53f7\u4e3a\u7a7a");
                return registerResponse;
            }
            if (StringUtils.isBlank((CharSequence)registerRequest.getDevTermNo())) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000001");
                registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u7f16\u53f7\u4e3a\u7a7a");
                return registerResponse;
            }
            if (StringUtils.isBlank((CharSequence)registerRequest.getDevTermName())) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000002");
                registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u540d\u79f0\u4e3a\u7a7a");
                return registerResponse;
            }
            if (StringUtils.isBlank((CharSequence)registerRequest.getDevTermCommProto())) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000003");
                registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u89c4\u7ea6\u4e3a\u7a7a");
                return registerResponse;
            }
            if (StringUtils.isBlank((CharSequence)registerRequest.getDevTermCommAddr())) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000004");
                registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u4e3a\u7a7a");
                return registerResponse;
            }
            if (registerRequest.getDevTermCommMode() != 1) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000005");
                registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u65b9\u5f0f\u975e\u6cd5");
                return registerResponse;
            }
            String orgNo = StringUtils.trim((String)registerRequest.getOrgNo());
            String devTermNo = StringUtils.trim((String)registerRequest.getDevTermNo());
            String devTermName = StringUtils.trim((String)registerRequest.getDevTermName());
            String devTermCommProto = StringUtils.trim((String)registerRequest.getDevTermCommProto());
            String devTermCommProtoVer = StringUtils.trim((String)registerRequest.getDevTermCommProtoVer());
            Integer devTermCommMode = registerRequest.getDevTermCommMode();
            String devTermCommAddr = StringUtils.trim((String)registerRequest.getDevTermCommAddr());
            String productKey = StringUtils.trim((String)registerRequest.getProductKey());
            String devAccessSortNo = null;
            boolean gateway = true;
            boolean trunking = false;
            boolean measure = true;
            String upcommProto = null;
            String upcommProtoVer = null;
            String upcommLogicAddr = devTermCommAddr;
            int upcommType = 0;
            String upcommParam = "{}";
            boolean encrypt = false;
            String encryptType = "";
            String encryptInfo = "{}";
            String acsampMeasCommMode = "ACSAMP";
            String acsampMeasCommProto = null;
            String acsampMeasCommAddr = null;
            if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"GAEADCU")) {
                devAccessSortNo = "GAEADCU";
                if (devTermCommMode == 1) {
                    upcommProto = "TCP_GAEADCU";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                } else if (devTermCommMode == 2) {
                    upcommProto = "UDP_GAEADCU";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"V4");
                productKey = "GAEA_DCU_V4";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = devTermNo;
                if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)8)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a8\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                    return registerResponse;
                }
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"DLT698_45")) {
                devAccessSortNo = "DLT698_45";
                if (devTermCommMode == 1) {
                    upcommProto = "TCP_DLT698_45";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                } else if (devTermCommMode == 2) {
                    upcommProto = "UDP_DLT698_45";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"2017");
                productKey = "DLT698_45_2017";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = devTermNo;
                if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)12)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a12\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                    return registerResponse;
                }
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"DLT698_45_WITH_1867")) {
                devAccessSortNo = "DLT698_45_WITH_1867";
                if (devTermCommMode == 1) {
                    upcommProto = "TCP_DLT698_45_WITH_1867";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                } else if (devTermCommMode == 2) {
                    upcommProto = "UDP_DLT698_45_WITH_1867";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"2020");
                productKey = "DLT698_45_WITH_1867_2017";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = devTermNo;
                if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)8)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a8\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                    return registerResponse;
                }
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"QGDW1376_1")) {
                devAccessSortNo = "QGDW1376_1";
                if (devTermCommMode == 1) {
                    upcommProto = "TCP_QGDW1376_1";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                } else if (devTermCommMode == 2) {
                    upcommProto = "UDP_QGDW1376_1";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"2013");
                productKey = "QGDW1376_1_2013";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = devTermNo;
                if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)8)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a8\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                    return registerResponse;
                }
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"IEC104")) {
                devAccessSortNo = "IEC104";
                if (devTermCommMode == 1) {
                    upcommProto = "TCP_IEC104";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                } else if (devTermCommMode == 2) {
                    upcommProto = "UDP_IEC104";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"STD");
                productKey = "IEC_104_STD";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = StringUtils.leftPad((String)upcommLogicAddr, (int)10, (char)'0') + "00";
                if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)4)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a4\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                    return registerResponse;
                }
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"HUAYUN104")) {
                devAccessSortNo = "HUAYUN104";
                if (devTermCommMode == 1) {
                    upcommProto = "TCP_HUAYUN104";
                    upcommType = UpcommTypeEnum.TCP_SOCKET.getType();
                } else if (devTermCommMode == 2) {
                    upcommProto = "UDP_HUAYUN104";
                    upcommType = UpcommTypeEnum.UDP_SOCKET.getType();
                }
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"");
                productKey = "HUAYUN104";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;
                if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)12)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a12\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                    return registerResponse;
                }
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"MQTT_JALASMART")) {
                devAccessSortNo = "JALASMART_GATEWAY";
                if (devTermCommMode != 1) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000012");
                    registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u65b9\u5f0f\u4e0d\u652f\u6301");
                    return registerResponse;
                }
                upcommProto = "MQTT_JALASMART";
                upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.6");
                productKey = "b03b99VXEV1";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"MQTT_TIMUIOT")) {
                devAccessSortNo = "TIMUIOT_GATEWAY";
                if (devTermCommMode != 1) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000012");
                    registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u65b9\u5f0f\u4e0d\u652f\u6301");
                    return registerResponse;
                }
                upcommProto = "MQTT_TIMUIOT";
                upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.28");
                productKey = "YINDE";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;
                if (!RegExUtils.isHexStrValid((String)upcommLogicAddr, (int)12)) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000011");
                    registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u975e\u6cd5\uff0c\u5fc5\u987b\u4e3a12\u4f4d16\u8fdb\u5236\u5b57\u7b26\u4e32");
                    return registerResponse;
                }
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"MQTT_DINGIIOT")) {
                devAccessSortNo = "DINGIIOT_GATEWAY";
                if (devTermCommMode != 1) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000012");
                    registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u65b9\u5f0f\u4e0d\u652f\u6301");
                    return registerResponse;
                }
                upcommProto = "MQTT_DINGIIOT";
                upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.2");
                productKey = "dingiiot";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"MQTT_IDCCIOT")) {
                devAccessSortNo = "IDCCIOT_GATEWAY";
                if (devTermCommMode != 1) {
                    registerResponse.setReturnCode("FAILURE");
                    registerResponse.setFailureCode("10000012");
                    registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u65b9\u5f0f\u4e0d\u652f\u6301");
                    return registerResponse;
                }
                upcommProto = "MQTT_IDCCIOT";
                upcommType = UpcommTypeEnum.TCP_MQTT.getType();
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.2");
                productKey = "IDCCIOT";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"LWM2M_CTWING")) {
                devAccessSortNo = "LWM2M_CTWING_GATEWAY";
                upcommProto = "LWM2M_CTWING_GATEWAY";
                upcommType = UpcommTypeEnum.UDP_LWM2M.getType();
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.9.0");
                productKey = "LWM2M_CTWING";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"WSAPI_SUNTRONT")) {
                devAccessSortNo = "WSAPI_SUNTRONT_GATEWAY";
                devTermCommMode = 2;
                upcommProto = "WSAPI_SUNTRONT_GATEWAY";
                upcommType = UpcommTypeEnum.UDP_LWM2M.getType();
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"1.0");
                productKey = "WSAPI_SUNTRONT";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;
            } else if (StringUtils.equals((CharSequence)devTermCommProto, (CharSequence)"ENOSIOT_API_2")) {
                devAccessSortNo = "ENOSIOT_API_2_GATEWAY";
                devTermCommMode = 1;
                upcommProto = "ENOSIOT_API_2_GATEWAY";
                upcommType = UpcommTypeEnum.TCP_HTTP.getType();
                upcommProtoVer = (String)StringUtils.defaultIfBlank((CharSequence)devTermCommProtoVer, (CharSequence)"V2");
                productKey = "ENOSIOT_API_2";
                acsampMeasCommProto = upcommProto;
                acsampMeasCommAddr = upcommLogicAddr;
            } else {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000010");
                registerResponse.setFailureMsg("\u4f20\u5165\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u89c4\u7ea6\u4e0d\u652f\u6301");
                return registerResponse;
            }
            if ((devAccessDo = this.devAccessDao.getByOrgNoAndDevAccessSortNoAndDevAccessNo(orgNo, devAccessSortNo, devAccessNo = devTermNo)) != null && devAccessDo.getId() > 0L) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000020");
                registerResponse.setFailureMsg("\u8be5\u91c7\u96c6\u7ec8\u7aef\u7f16\u53f7\u5df2\u5b58\u5728");
            }
            if ((runAccessGatewayVo = this.runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndUpcommProtoAndUpcommLogicAddr(productKey, upcommProto, upcommLogicAddr)) != null && runAccessGatewayVo.getId() > 0L) {
                registerResponse.setReturnCode("FAILURE");
                registerResponse.setFailureCode("10000021");
                registerResponse.setFailureMsg("\u8be5\u91c7\u96c6\u7ec8\u7aef\u901a\u8baf\u5730\u5740\u5df2\u5b58\u5728");
            }
            LinkedHashMap newEntityMap = Maps.newLinkedHashMap();
            Long accessGatewayId = this.iotDeviceIdGenerator.nextId();
            devAccessDo = new DevAccessDo();
            devAccessDo.setId(accessGatewayId);
            devAccessDo.setOrgNo(orgNo);
            devAccessDo.setDevAccessSortNo(devAccessSortNo);
            devAccessDo.setDevAccessNo(devAccessNo);
            devAccessDo.setDevAccessName(devTermName);
            devAccessDo.setDevAccessDesc(devTermName);
            devAccessDo.setDevAccessDetail("{}");
            devAccessDo.setGateway(gateway);
            devAccessDo.setTrunking(trunking);
            devAccessDo.setMeasure(measure);
            devAccessDo.setLifeState(DevLifeStateEnum.RUNNING.getCode());
            devAccessDo.setMfrCode(StringUtils.trimToEmpty((String)registerRequest.getMfrCode()));
            devAccessDo.setModelCode(StringUtils.trimToEmpty((String)registerRequest.getModelCode()));
            devAccessDo.setSortSn(1);
            devAccessDo.setValid(true);
            devAccessDo.setGmtCreate(System.currentTimeMillis());
            devAccessDo.setGmtModified(System.currentTimeMillis());
            devAccessDo.setGmtInvalid(0L);
            devAccessDo.setVersion(1);
            this.devAccessDao.insert(devAccessDo);
            newEntityMap.put("devAccess", devAccessDo);
            DevAccessGatewayDo devAccessGatewayDo = new DevAccessGatewayDo();
            devAccessGatewayDo.setId(accessGatewayId);
            devAccessGatewayDo.setUpcommProto(upcommProto);
            devAccessGatewayDo.setUpcommProtoVer(upcommProtoVer);
            devAccessGatewayDo.setUpcommLogicAddr(upcommLogicAddr);
            devAccessGatewayDo.setUpcommType(upcommType);
            devAccessGatewayDo.setUpcommParam(upcommParam);
            devAccessGatewayDo.setEncrypt(encrypt);
            devAccessGatewayDo.setEncryptType(encryptType);
            devAccessGatewayDo.setEncryptInfo(encryptInfo);
            devAccessGatewayDo.setVersion(1);
            this.devAccessGatewayDao.insert(devAccessGatewayDo);
            newEntityMap.put("devAccessGateway", devAccessGatewayDo);
            if (StringUtils.isNotBlank((CharSequence)acsampMeasCommProto) && StringUtils.isNotBlank((CharSequence)acsampMeasCommAddr)) {
                DevAccessMeasureDo devAccessMeasureDo = new DevAccessMeasureDo();
                devAccessMeasureDo.setId(accessGatewayId);
                devAccessMeasureDo.setMeasCommMode(acsampMeasCommMode);
                devAccessMeasureDo.setMeasCommProto(acsampMeasCommProto);
                devAccessMeasureDo.setMeasCommAddr(acsampMeasCommAddr);
                devAccessMeasureDo.setEnableElec(true);
                devAccessMeasureDo.setElecPhaseCount(3);
                devAccessMeasureDo.setEnableWater(false);
                devAccessMeasureDo.setEnableGas(false);
                devAccessMeasureDo.setEnableHeat(false);
                devAccessMeasureDo.setEnableSteam(false);
                devAccessMeasureDo.setVersion(1);
                this.devAccessMeasureDao.insert(devAccessMeasureDo);
                newEntityMap.put("devAccessMeasure", devAccessMeasureDo);
            }
            RunAccessGatewayDo runAccessGatewayDo = new RunAccessGatewayDo();
            runAccessGatewayDo.setId(accessGatewayId);
            runAccessGatewayDo.setOrgNo(orgNo);
            runAccessGatewayDo.setProductKey(productKey);
            runAccessGatewayDo.setClientId(devAccessNo);
            runAccessGatewayDo.setUpcommProto(upcommProto);
            runAccessGatewayDo.setUpcommProtoVer(upcommProtoVer);
            runAccessGatewayDo.setUpcommLogicAddr(upcommLogicAddr);
            runAccessGatewayDo.setUpcommType(upcommType);
            runAccessGatewayDo.setUpcommParam(upcommParam);
            runAccessGatewayDo.setCascade(false);
            runAccessGatewayDo.setParentId(Long.valueOf(0L));
            runAccessGatewayDo.setEncrypt(encrypt);
            runAccessGatewayDo.setEncryptType(encryptType);
            runAccessGatewayDo.setEncryptInfo(encryptInfo);
            runAccessGatewayDo.setRunStatus(DevRunStatusEnum.GOTORUN.getStatus());
            runAccessGatewayDo.setRunParam("{}");
            runAccessGatewayDo.setRunMode(1);
            runAccessGatewayDo.setRunHeartbeatCycle(30);
            runAccessGatewayDo.setMeasPointCount(1);
            runAccessGatewayDo.setOnline(false);
            runAccessGatewayDo.setGmtConnectedAt(0L);
            runAccessGatewayDo.setGmtHeartbeatUp(0L);
            runAccessGatewayDo.setGmtMessageUp(0L);
            runAccessGatewayDo.setGmtMeasdataUp(0L);
            runAccessGatewayDo.setGmtAlarmUp(0L);
            runAccessGatewayDo.setGmtOffline(0L);
            runAccessGatewayDo.setGmtCreate(System.currentTimeMillis());
            runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
            runAccessGatewayDo.setVersion(1);
            this.runAccessGatewayDao.insert(runAccessGatewayDo);
            Long acsampMeasPointId = this.iotDeviceIdGenerator.nextId();
            if (StringUtils.isNotBlank((CharSequence)acsampMeasCommProto) && StringUtils.isNotBlank((CharSequence)acsampMeasCommAddr)) {
                RunMeasPointDo runMeasPointDo = new RunMeasPointDo();
                runMeasPointDo.setId(acsampMeasPointId);
                runMeasPointDo.setOrgNo(orgNo);
                runMeasPointDo.setAccessGatewayId(accessGatewayId);
                runMeasPointDo.setAccessTrunkingId(Long.valueOf(0L));
                runMeasPointDo.setAccessMeasureId(accessGatewayId);
                runMeasPointDo.setMeasKind(0);
                runMeasPointDo.setMeasSn(0);
                runMeasPointDo.setMeasCommMode(acsampMeasCommMode);
                runMeasPointDo.setMeasCommProto(acsampMeasCommProto);
                runMeasPointDo.setMeasCommAddr(acsampMeasCommAddr);
                runMeasPointDo.setMeasCommPort(0);
                runMeasPointDo.setMeasCommParam("{}");
                runMeasPointDo.setGmtMessageUp(0L);
                runMeasPointDo.setGmtMeasdataUp(0L);
                runMeasPointDo.setGmtAlarmUp(0L);
                runMeasPointDo.setGmtCreate(System.currentTimeMillis());
                runMeasPointDo.setGmtModified(System.currentTimeMillis());
                runMeasPointDo.setVersion(1);
                this.runMeasPointDao.insert(runMeasPointDo);
            }
            LogDevAccessEntityDo logDevAccessEntity = new LogDevAccessEntityDo();
            logDevAccessEntity.setId(Long.valueOf(this.iotDeviceIdGenerator.nextId()));
            logDevAccessEntity.setLogType(1);
            logDevAccessEntity.setDevAccessId(accessGatewayId);
            logDevAccessEntity.setOldEntity(JsonConvertUtils.convertToString((Object)Maps.newLinkedHashMap()));
            logDevAccessEntity.setNewEntity(JsonConvertUtils.convertToString((Object)newEntityMap, (PropertyNamingStrategy)PropertyNamingStrategy.SNAKE_CASE));
            logDevAccessEntity.setAlterPathway((String)StringUtils.defaultIfBlank((CharSequence)registerRequest.getPathway(), (CharSequence)"PC_WEBAPP"));
            logDevAccessEntity.setAlterOper((String)StringUtils.defaultIfBlank((CharSequence)registerRequest.getOperator(), (CharSequence)"$UNKNOWN^"));
            logDevAccessEntity.setGmtAlter(System.currentTimeMillis());
            this.logDevAccessEntityDao.insertLog(logDevAccessEntity);
            registerResponse.setReturnCode("SUCCESS");
            registerResponse.setFailureCode(null);
            registerResponse.setAccessGatewayId(accessGatewayId);
            registerResponse.setAcsampMeasPointId(acsampMeasPointId);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" GmDevTermRegisterResponse    : " + JsonConvertUtils.convertToString((Object)registerResponse));
            this.logger.debug(" <<<<<<<< end registerGmDevTerm <<<<<<<< ");
        }
        return registerResponse;
    }

    public GmDevMeterModifyResponse modifyGmDevMeter(GmDevMeterModifyRequest gmDevMeterModifyRequest) {
        GmDevMeterModifyResponse gmDevMeterModifyResponse = new GmDevMeterModifyResponse();
        RunMeasPointDo runMeasPointDo = null;
        try {
            runMeasPointDo = (RunMeasPointDo)BeanUtils.cloneBean((Object)gmDevMeterModifyRequest);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        runMeasPointDo.setId(gmDevMeterModifyRequest.getRunMeasPointId());
        this.runMeasPointDao.update(runMeasPointDo);
        gmDevMeterModifyResponse.setRunMeasPointId(gmDevMeterModifyRequest.getRunMeasPointId());
        gmDevMeterModifyResponse.setReturnCode("SUCCESS");
        gmDevMeterModifyResponse.setFailureCode(null);
        return gmDevMeterModifyResponse;
    }
}

