/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.service.impl;

import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.IotPointMeasItemCodeService;
import com.easesource.iot.datacenter.openservice.dao.IotMeasItemCodeDao;
import com.easesource.iot.datacenter.openservice.dao.IotPointMeasItemCodeDao;
import com.easesource.iot.datacenter.openservice.entity.IotPointMeasItemCodeDo;
import com.easesource.iot.datacenter.openservice.request.IotPointMeasItemCodeRequest;
import com.easesource.iot.datacenter.openservice.response.IotPointMeasItemCodeResponse;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="IotPointMeasItemCodeService")
public class IotPointMeasItemCodeServiceImpl
extends AbstractBaseService
implements IotPointMeasItemCodeService {
    @Autowired
    private IotMeasItemCodeDao iotMeasItemCodeDao;
    @Autowired
    private IotPointMeasItemCodeDao iotPointMeasItemCodeDao;

    @Transactional(rollbackFor={Exception.class})
    public IotPointMeasItemCodeResponse insertOrUpdatePointMeasItemCode(List<IotPointMeasItemCodeRequest> iotPointMeasItemCodeRequests) {
        IotPointMeasItemCodeResponse iotPointMeasItemCodeResponse = new IotPointMeasItemCodeResponse();
        List<String> measItemCodeList = this.iotMeasItemCodeDao.getMeasItemCodeList();
        long now = System.currentTimeMillis();
        for (IotPointMeasItemCodeRequest iotPointMeasItemCodeRequest : iotPointMeasItemCodeRequests) {
            if (!measItemCodeList.contains(iotPointMeasItemCodeRequest.getMeasItemCode())) {
                iotPointMeasItemCodeResponse.setFailureCode("500");
                iotPointMeasItemCodeResponse.setReturnCode("FAILURE");
                iotPointMeasItemCodeResponse.setFailureMsg(iotPointMeasItemCodeRequest.getMeasItemCode() + "\u7f16\u7801\u4e0d\u5b58\u5728,\u8bf7\u8c03\u6574\u7f16\u7801\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u65b0\u52a0\u7f16\u7801\uff01\uff01\uff01");
                return iotPointMeasItemCodeResponse;
            }
            IotPointMeasItemCodeDo iotPointMeasItemCodeDo = this.iotPointMeasItemCodeDao.getIotPointMeasItemCode(iotPointMeasItemCodeRequest);
            if (iotPointMeasItemCodeRequest.getId() != null) {
                if (iotPointMeasItemCodeDo != null && !iotPointMeasItemCodeDo.getId().equals(iotPointMeasItemCodeRequest.getId()) && iotPointMeasItemCodeDo.getPointItemCode().equals(iotPointMeasItemCodeRequest.getPointItemCode())) {
                    iotPointMeasItemCodeResponse.setFailureCode("500");
                    iotPointMeasItemCodeResponse.setReturnCode("FAILURE");
                    iotPointMeasItemCodeResponse.setFailureMsg(iotPointMeasItemCodeRequest.getPointItemCode() + "\u70b9\u4f4d\u91cd\u590d\uff01\uff01\uff01");
                    return iotPointMeasItemCodeResponse;
                }
                IotPointMeasItemCodeDo iotPointMeasItemCodeDoupdate = new IotPointMeasItemCodeDo();
                BeanUtils.copyProperties((Object)iotPointMeasItemCodeRequest, (Object)iotPointMeasItemCodeDoupdate);
                iotPointMeasItemCodeDoupdate.setMeasItemCode(iotPointMeasItemCodeRequest.getMeasItemCode());
                iotPointMeasItemCodeDoupdate.setPointItemCode(iotPointMeasItemCodeRequest.getPointItemCode());
                iotPointMeasItemCodeDoupdate.setMeasCommProto(iotPointMeasItemCodeRequest.getMeasCommProto());
                iotPointMeasItemCodeDoupdate.setGmtCreate(Long.valueOf(now));
                iotPointMeasItemCodeDoupdate.setGmtModified(Long.valueOf(now));
                this.iotPointMeasItemCodeDao.update(iotPointMeasItemCodeDoupdate);
                continue;
            }
            if (iotPointMeasItemCodeDo != null && iotPointMeasItemCodeDo.getPointItemCode().equals(iotPointMeasItemCodeRequest.getPointItemCode())) {
                iotPointMeasItemCodeResponse.setFailureCode("500");
                iotPointMeasItemCodeResponse.setReturnCode("FAILURE");
                iotPointMeasItemCodeResponse.setFailureMsg(iotPointMeasItemCodeRequest.getPointItemCode() + "\u70b9\u4f4d\u91cd\u590d\uff01\uff01\uff01");
                return iotPointMeasItemCodeResponse;
            }
            IotPointMeasItemCodeDo iotPointMeasItemCodeDonew = new IotPointMeasItemCodeDo();
            BeanUtils.copyProperties((Object)iotPointMeasItemCodeRequest, (Object)iotPointMeasItemCodeDonew);
            iotPointMeasItemCodeDonew.setMeasCommMode("RS485");
            iotPointMeasItemCodeDonew.setIsValid(1);
            iotPointMeasItemCodeDonew.setIsDelete(0);
            iotPointMeasItemCodeDonew.setGmtCreate(Long.valueOf(now));
            iotPointMeasItemCodeDonew.setGmtModified(Long.valueOf(now));
            this.iotPointMeasItemCodeDao.insert(iotPointMeasItemCodeDonew);
        }
        iotPointMeasItemCodeResponse.setReturnCode("SUCCESS");
        return iotPointMeasItemCodeResponse;
    }

    public void deletePointMeasItemCode(IotPointMeasItemCodeRequest iotPointMeasItemCodeRequest) {
        this.iotPointMeasItemCodeDao.updateForDelete(iotPointMeasItemCodeRequest.getId());
    }

    public List<IotPointMeasItemCodeDo> selectIotPointMeasItemCodeList(String measCommProto) {
        List<IotPointMeasItemCodeDo> iotPointMeasItemCodeDoList = this.iotPointMeasItemCodeDao.getIotPointMeasItemCodeList(measCommProto);
        return iotPointMeasItemCodeDoList;
    }
}

