/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.service.impl;

import com.easesource.commons.util.DateUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Sorter;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasStatService;
import com.easesource.iot.datacenter.openservice.dao.MeasDataCumFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataInsFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveVo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveVo;
import com.easesource.iot.datacenter.openservice.entity.MeasStatCumDayValue;
import com.easesource.iot.datacenter.openservice.entity.MeasStatCumMonthValue;
import com.easesource.iot.datacenter.openservice.entity.MeasStatCumYearValue;
import com.easesource.iot.datacenter.openservice.entity.MeasStatInsDayValue;
import com.easesource.iot.datacenter.openservice.entity.MeasStatInsMonthValue;
import com.easesource.iot.datacenter.openservice.entity.MeasStatInsYearValue;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumDayBatchGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumDayBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumDayGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumDayGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumMonthBatchGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumMonthBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumMonthGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumMonthGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumYearBatchGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumYearBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumYearGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatCumYearGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsDayBatchGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsDayBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsDayGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsDayGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsMonthBatchGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsMonthBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsMonthGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsMonthGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsYearBatchGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsYearBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsYearGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasStatInsYearGetRequest;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumDayBatchGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumDayBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumDayGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumDayGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumMonthBatchGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumMonthBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumMonthGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumMonthGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumYearBatchGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumYearBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumYearGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatCumYearGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsDayBatchGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsDayBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsDayGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsDayGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsMonthBatchGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsMonthBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsMonthGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsMonthGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsYearBatchGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsYearBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsYearGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasStatInsYearGetResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="measStatService")
public class MeasStatServiceImpl
extends AbstractBaseService
implements MeasStatService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private MeasDataCumFreezeCurveDao measDataCumFreezeCurveDao;
    @Resource
    private MeasDataInsFreezeCurveDao measDataInsFreezeCurveDao;

    public MeasStatInsDayGetResponse getMeasStatInsDay(MeasStatInsDayGetRequest measStatInsDayGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasStatInsDay >>>>>>> ");
            this.logger.debug(" MeasStatInsDayGetRequest         : " + JsonConvertUtils.convertToString((Object)measStatInsDayGetRequest));
        }
        MeasStatInsDayGetResponse response = new MeasStatInsDayGetResponse();
        Long measPointId = measStatInsDayGetRequest.getMeasPointId();
        Set measItemCodeSet = measStatInsDayGetRequest.getMeasItemCodeSet();
        Date dateMeasStat = DateConvertUtils.convertFromString((String)measStatInsDayGetRequest.getDateMeasStat(), (String[])DateConvertUtils.PATTERNS_DATE);
        HashMap measStatMap = Maps.newHashMap();
        long gmtMeasFreezeStart = dateMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addDays((Date)dateMeasStat, (int)1).getTime();
        HashMap rangeMeasDataInsFreezeCurveMap = Maps.newHashMap();
        for (String measItemCode : measItemCodeSet) {
            HashMap params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataInsFreezeCurveVo> measDataInsFreezeCurveList = this.measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            rangeMeasDataInsFreezeCurveMap.put(measItemCode, measDataInsFreezeCurveList);
        }
        rangeMeasDataInsFreezeCurveMap.forEach((k, v) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("key : value = " + k + " : " + JsonConvertUtils.convertToString((Object)v));
            }
            AtomicReference<Integer> cntRef = new AtomicReference<Integer>(0);
            AtomicReference<BigDecimal> sumRef = new AtomicReference<BigDecimal>(new BigDecimal("0.0"));
            AtomicReference<Object> gmtMaxRef = new AtomicReference<Object>(null);
            AtomicReference<Object> maxRef = new AtomicReference<Object>(null);
            AtomicReference<Object> gmtMinRef = new AtomicReference<Object>(null);
            AtomicReference<Object> minRef = new AtomicReference<Object>(null);
            AtomicReference<BigDecimal> rateRef = new AtomicReference<BigDecimal>(new BigDecimal("1.0"));
            v.forEach(o -> {
                BigDecimal ptRate;
                BigDecimal ctRate;
                BigDecimal selfRate = o.getSelfRate();
                if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                    selfRate = new BigDecimal("1.0");
                }
                if ((ctRate = o.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ctRate = new BigDecimal("1.0");
                }
                if ((ptRate = o.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = o.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
                if (measStatInsDayGetRequest.getMeasDataSideType() == 1) {
                    if (StringUtils.containsAny((CharSequence)o.getMeasItemCode(), (CharSequence[])new CharSequence[]{"gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus"})) {
                        measDataValue = o.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                    } else if (StringUtils.containsAny((CharSequence)o.getMeasItemCode(), (CharSequence[])new CharSequence[]{"gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus"})) {
                        measDataValue = o.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, RoundingMode.HALF_UP);
                    } else if (StringUtils.containsAny((CharSequence)o.getMeasItemCode(), (CharSequence[])new CharSequence[]{"gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus"})) {
                        measDataValue = o.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                    }
                }
                cntRef.set((Integer)cntRef.get() + 1);
                sumRef.set(((BigDecimal)sumRef.get()).add(measDataValue));
                if (maxRef.get() == null || ((BigDecimal)maxRef.get()).compareTo(measDataValue) < 0) {
                    gmtMaxRef.set(o.getGmtMeasFreeze());
                    maxRef.set(measDataValue);
                }
                if (minRef.get() == null || ((BigDecimal)minRef.get()).compareTo(measDataValue) > 0) {
                    gmtMinRef.set(o.getGmtMeasFreeze());
                    minRef.set(measDataValue);
                }
                rateRef.set(o.getMeasDataRate());
            });
            if (cntRef.get() > 0) {
                MeasStatInsDayValue measStatInsDayValue = new MeasStatInsDayValue();
                measStatInsDayValue.setMeasPointId(measPointId);
                measStatInsDayValue.setMeasItemCode(k);
                measStatInsDayValue.setDateMeasStat(DateConvertUtils.convertToString((Date)dateMeasStat, (String)"yyyyMMdd"));
                measStatInsDayValue.setMeasDataRate(rateRef.get());
                measStatInsDayValue.setAvgValue(sumRef.get().divide(new BigDecimal(cntRef.get().toString()), 8, RoundingMode.HALF_UP));
                measStatInsDayValue.setMaxValue((BigDecimal)maxRef.get());
                measStatInsDayValue.setGmtMaxValue(((Long)gmtMaxRef.get()).longValue());
                measStatInsDayValue.setMinValue((BigDecimal)minRef.get());
                measStatInsDayValue.setGmtMinValue(((Long)gmtMinRef.get()).longValue());
                measStatInsDayValue.setStatDataSource("meas_data_ins_freeze_curve");
                measStatInsDayValue.setStatDataCount(cntRef.get().intValue());
                measStatInsDayValue.setGmtCreate(gmtMeasFreezeEnd);
                measStatInsDayValue.setGmtModified(System.currentTimeMillis());
                measStatMap.put(k, measStatInsDayValue);
            }
        });
        response.setMeasPointId(measPointId);
        response.setMeasStatMap((Map)measStatMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatInsDayGetResponse        : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasStatInsDay <<<<<<<< ");
        }
        return response;
    }

    public MeasStatInsDayBatchGetResponse batchGetMeasStatInsDay(MeasStatInsDayBatchGetRequest measStatInsDayBatchGetRequest) {
        return null;
    }

    public MeasStatInsDayGetRangeResponse getRangeMeasStatInsDay(MeasStatInsDayGetRangeRequest measStatInsDayGetRangeRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRangeMeasStatInsDay >>>>>>> ");
            this.logger.debug(" MeasStatInsDayGetRangeRequest    : " + JsonConvertUtils.convertToString((Object)measStatInsDayGetRangeRequest));
        }
        MeasStatInsDayGetRangeResponse response = new MeasStatInsDayGetRangeResponse();
        Long measPointId = measStatInsDayGetRangeRequest.getMeasPointId();
        Set measItemCodeSet = measStatInsDayGetRangeRequest.getMeasItemCodeSet();
        Date dateMeasStatStart = DateConvertUtils.convertFromString((String)measStatInsDayGetRangeRequest.getDateMeasStatStart(), (String[])DateConvertUtils.PATTERNS_DATE);
        Date dateMeasStatEnd = DateConvertUtils.convertFromString((String)measStatInsDayGetRangeRequest.getDateMeasStatEnd(), (String[])DateConvertUtils.PATTERNS_DATE);
        HashMap measStatListMap = Maps.newHashMap();
        Date dateMeasStat = dateMeasStatStart;
        while (dateMeasStat.before(dateMeasStatEnd)) {
            MeasStatInsDayGetRequest measStatInsDayGetRequest = new MeasStatInsDayGetRequest();
            measStatInsDayGetRequest.setMeasPointId(measPointId);
            measStatInsDayGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatInsDayGetRequest.setDateMeasStat(DateConvertUtils.convertToString((Date)dateMeasStat, (String)"yyyyMMdd"));
            measStatInsDayGetRequest.setMeasDataSideType(measStatInsDayGetRangeRequest.getMeasDataSideType());
            MeasStatInsDayGetResponse measStatInsDayGetResponse = this.getMeasStatInsDay(measStatInsDayGetRequest);
            if (measStatInsDayGetResponse.isSuccess()) {
                measStatInsDayGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List measStatInsDayValueList = (List)measStatListMap.get(k);
                    if (CollectionUtils.isEmpty((Collection)measStatInsDayValueList)) {
                        measStatInsDayValueList = Lists.newArrayList();
                    }
                    measStatInsDayValueList.add(v);
                    measStatListMap.put(k, measStatInsDayValueList);
                });
            }
            dateMeasStat = DateUtils.addDays((Date)dateMeasStat, (int)1);
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatListMap((Map)measStatListMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatInsDayGetRangeResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getRangeMeasStatInsDay <<<<<<<< ");
        }
        return response;
    }

    public MeasStatInsDayBatchGetRangeResponse batchGetRangeMeasStatInsDay(MeasStatInsDayBatchGetRangeRequest measStatInsDayBatchGetRangeRequest) {
        return null;
    }

    public MeasStatInsMonthGetResponse getMeasStatInsMonth(MeasStatInsMonthGetRequest measStatInsMonthGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasStatInsMonth >>>>>>> ");
            this.logger.debug(" MeasStatInsMonthGetRequest       : " + JsonConvertUtils.convertToString((Object)measStatInsMonthGetRequest));
        }
        MeasStatInsMonthGetResponse response = new MeasStatInsMonthGetResponse();
        Long measPointId = measStatInsMonthGetRequest.getMeasPointId();
        Set measItemCodeSet = measStatInsMonthGetRequest.getMeasItemCodeSet();
        Date monthMeasStat = DateConvertUtils.convertFromString((String)measStatInsMonthGetRequest.getMonthMeasStat(), (String[])DateConvertUtils.PATTERNS_MONTH);
        HashMap measStatMap = Maps.newHashMap();
        long gmtMeasFreezeStart = monthMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addMonths((Date)monthMeasStat, (int)1).getTime();
        HashMap rangeMeasDataInsFreezeCurveMap = Maps.newHashMap();
        for (String measItemCode : measItemCodeSet) {
            HashMap params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataInsFreezeCurveVo> measDataInsFreezeCurveList = this.measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            rangeMeasDataInsFreezeCurveMap.put(measItemCode, measDataInsFreezeCurveList);
        }
        rangeMeasDataInsFreezeCurveMap.forEach((k, v) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("key : value = " + k + " : " + JsonConvertUtils.convertToString((Object)v));
            }
            AtomicReference<Integer> cntRef = new AtomicReference<Integer>(0);
            AtomicReference<BigDecimal> sumRef = new AtomicReference<BigDecimal>(new BigDecimal("0.0"));
            AtomicReference<Object> gmtMaxRef = new AtomicReference<Object>(null);
            AtomicReference<Object> maxRef = new AtomicReference<Object>(null);
            AtomicReference<Object> gmtMinRef = new AtomicReference<Object>(null);
            AtomicReference<Object> minRef = new AtomicReference<Object>(null);
            AtomicReference<BigDecimal> rateRef = new AtomicReference<BigDecimal>(new BigDecimal("1.0"));
            v.forEach(o -> {
                BigDecimal ptRate;
                BigDecimal ctRate;
                BigDecimal selfRate = o.getSelfRate();
                if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                    selfRate = new BigDecimal("1.0");
                }
                if ((ctRate = o.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ctRate = new BigDecimal("1.0");
                }
                if ((ptRate = o.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = o.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
                if (measStatInsMonthGetRequest.getMeasDataSideType() == 1) {
                    if (StringUtils.containsAny((CharSequence)o.getMeasItemCode(), (CharSequence[])new CharSequence[]{"gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus"})) {
                        measDataValue = o.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                    } else if (StringUtils.containsAny((CharSequence)o.getMeasItemCode(), (CharSequence[])new CharSequence[]{"gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus"})) {
                        measDataValue = o.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, RoundingMode.HALF_UP);
                    } else if (StringUtils.containsAny((CharSequence)o.getMeasItemCode(), (CharSequence[])new CharSequence[]{"gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus"})) {
                        measDataValue = o.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                    }
                }
                cntRef.set((Integer)cntRef.get() + 1);
                sumRef.set(((BigDecimal)sumRef.get()).add(measDataValue));
                if (maxRef.get() == null || ((BigDecimal)maxRef.get()).compareTo(measDataValue) < 0) {
                    gmtMaxRef.set(o.getGmtMeasFreeze());
                    maxRef.set(measDataValue);
                }
                if (minRef.get() == null || ((BigDecimal)minRef.get()).compareTo(measDataValue) > 0) {
                    gmtMinRef.set(o.getGmtMeasFreeze());
                    minRef.set(measDataValue);
                }
                rateRef.set(o.getMeasDataRate());
            });
            if (cntRef.get() > 0) {
                MeasStatInsMonthValue measStatInsMonthValue = new MeasStatInsMonthValue();
                measStatInsMonthValue.setMeasPointId(measPointId);
                measStatInsMonthValue.setMeasItemCode(k);
                measStatInsMonthValue.setMonthMeasStat(DateConvertUtils.convertToString((Date)monthMeasStat, (String)"yyyyMM"));
                measStatInsMonthValue.setMeasDataRate(rateRef.get());
                measStatInsMonthValue.setAvgValue(sumRef.get().divide(new BigDecimal(cntRef.get().toString()), 8, RoundingMode.HALF_UP));
                measStatInsMonthValue.setMaxValue((BigDecimal)maxRef.get());
                measStatInsMonthValue.setGmtMaxValue(((Long)gmtMaxRef.get()).longValue());
                measStatInsMonthValue.setMinValue((BigDecimal)minRef.get());
                measStatInsMonthValue.setGmtMinValue(((Long)gmtMinRef.get()).longValue());
                measStatInsMonthValue.setStatDataSource("meas_data_ins_freeze_curve");
                measStatInsMonthValue.setStatDataCount(cntRef.get().intValue());
                measStatInsMonthValue.setGmtCreate(gmtMeasFreezeEnd);
                measStatInsMonthValue.setGmtModified(System.currentTimeMillis());
                measStatMap.put(k, measStatInsMonthValue);
            }
        });
        response.setMeasPointId(measPointId);
        response.setMeasStatMap((Map)measStatMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatInsMonthGetResponse      : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasStatInsMonth <<<<<<<< ");
        }
        return response;
    }

    public MeasStatInsMonthBatchGetResponse batchGetMeasStatInsMonth(MeasStatInsMonthBatchGetRequest measStatInsMonthBatchGetRequest) {
        return null;
    }

    public MeasStatInsMonthGetRangeResponse getRangeMeasStatInsMonth(MeasStatInsMonthGetRangeRequest measStatInsMonthGetRangeRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRangeMeasStatInsMonth >>>>>>> ");
            this.logger.debug(" MeasStatInsMonthGetRangeRequest  : " + JsonConvertUtils.convertToString((Object)measStatInsMonthGetRangeRequest));
        }
        MeasStatInsMonthGetRangeResponse response = new MeasStatInsMonthGetRangeResponse();
        Long measPointId = measStatInsMonthGetRangeRequest.getMeasPointId();
        Set measItemCodeSet = measStatInsMonthGetRangeRequest.getMeasItemCodeSet();
        Date monthMeasStatStart = DateConvertUtils.convertFromString((String)measStatInsMonthGetRangeRequest.getMonthMeasStatStart(), (String[])DateConvertUtils.PATTERNS_MONTH);
        Date monthMeasStatEnd = DateConvertUtils.convertFromString((String)measStatInsMonthGetRangeRequest.getMonthMeasStatEnd(), (String[])DateConvertUtils.PATTERNS_MONTH);
        HashMap measStatListMap = Maps.newHashMap();
        Date monthMeasStat = monthMeasStatStart;
        while (monthMeasStat.before(monthMeasStatEnd)) {
            MeasStatInsMonthGetRequest measStatInsMonthGetRequest = new MeasStatInsMonthGetRequest();
            measStatInsMonthGetRequest.setMeasPointId(measPointId);
            measStatInsMonthGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatInsMonthGetRequest.setMonthMeasStat(DateConvertUtils.convertToString((Date)monthMeasStat, (String)"yyyyMM"));
            measStatInsMonthGetRequest.setMeasDataSideType(measStatInsMonthGetRangeRequest.getMeasDataSideType());
            MeasStatInsMonthGetResponse measStatInsMonthGetResponse = this.getMeasStatInsMonth(measStatInsMonthGetRequest);
            if (measStatInsMonthGetResponse.isSuccess()) {
                measStatInsMonthGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List measStatInsMonthValueList = (List)measStatListMap.get(k);
                    if (CollectionUtils.isEmpty((Collection)measStatInsMonthValueList)) {
                        measStatInsMonthValueList = Lists.newArrayList();
                    }
                    measStatInsMonthValueList.add(v);
                    measStatListMap.put(k, measStatInsMonthValueList);
                });
            }
            monthMeasStat = DateUtils.addMonths((Date)monthMeasStat, (int)1);
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatListMap((Map)measStatListMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatInsMonthGetRangeResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getRangeMeasStatInsMonth <<<<<<<< ");
        }
        return response;
    }

    public MeasStatInsMonthBatchGetRangeResponse batchGetRangeMeasStatInsMonth(MeasStatInsMonthBatchGetRangeRequest measStatInsMonthBatchGetRangeRequest) {
        return null;
    }

    public MeasStatInsYearGetResponse getMeasStatInsYear(MeasStatInsYearGetRequest measStatInsYearGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasStatInsYear >>>>>>> ");
            this.logger.debug(" MeasStatInsYearGetRequest        : " + JsonConvertUtils.convertToString((Object)measStatInsYearGetRequest));
        }
        MeasStatInsYearGetResponse response = new MeasStatInsYearGetResponse();
        Long measPointId = measStatInsYearGetRequest.getMeasPointId();
        Set measItemCodeSet = measStatInsYearGetRequest.getMeasItemCodeSet();
        Date yearMeasStat = DateConvertUtils.convertFromString((String)measStatInsYearGetRequest.getYearMeasStat(), (String[])DateConvertUtils.PATTERNS_YEAR);
        HashMap measStatMap = Maps.newHashMap();
        long gmtMeasFreezeStart = yearMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addYears((Date)yearMeasStat, (int)1).getTime();
        HashMap rangeMeasDataInsFreezeCurveMap = Maps.newHashMap();
        for (String measItemCode : measItemCodeSet) {
            HashMap params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataInsFreezeCurveVo> measDataInsFreezeCurveList = this.measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            rangeMeasDataInsFreezeCurveMap.put(measItemCode, measDataInsFreezeCurveList);
        }
        rangeMeasDataInsFreezeCurveMap.forEach((k, v) -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("key : value = " + k + " : " + JsonConvertUtils.convertToString((Object)v));
            }
            AtomicReference<Integer> cntRef = new AtomicReference<Integer>(0);
            AtomicReference<BigDecimal> sumRef = new AtomicReference<BigDecimal>(new BigDecimal("0.0"));
            AtomicReference<Object> gmtMaxRef = new AtomicReference<Object>(null);
            AtomicReference<Object> maxRef = new AtomicReference<Object>(null);
            AtomicReference<Object> gmtMinRef = new AtomicReference<Object>(null);
            AtomicReference<Object> minRef = new AtomicReference<Object>(null);
            AtomicReference<BigDecimal> rateRef = new AtomicReference<BigDecimal>(new BigDecimal("1.0"));
            v.forEach(o -> {
                BigDecimal ptRate;
                BigDecimal ctRate;
                BigDecimal selfRate = o.getSelfRate();
                if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                    selfRate = new BigDecimal("1.0");
                }
                if ((ctRate = o.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ctRate = new BigDecimal("1.0");
                }
                if ((ptRate = o.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = o.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
                if (measStatInsYearGetRequest.getMeasDataSideType() == 1) {
                    if (StringUtils.containsAny((CharSequence)o.getMeasItemCode(), (CharSequence[])new CharSequence[]{"gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus"})) {
                        measDataValue = o.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                    } else if (StringUtils.containsAny((CharSequence)o.getMeasItemCode(), (CharSequence[])new CharSequence[]{"gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus"})) {
                        measDataValue = o.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, RoundingMode.HALF_UP);
                    } else if (StringUtils.containsAny((CharSequence)o.getMeasItemCode(), (CharSequence[])new CharSequence[]{"gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus"})) {
                        measDataValue = o.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                    }
                }
                cntRef.set((Integer)cntRef.get() + 1);
                sumRef.set(((BigDecimal)sumRef.get()).add(measDataValue));
                if (maxRef.get() == null || ((BigDecimal)maxRef.get()).compareTo(measDataValue) < 0) {
                    gmtMaxRef.set(o.getGmtMeasFreeze());
                    maxRef.set(measDataValue);
                }
                if (minRef.get() == null || ((BigDecimal)minRef.get()).compareTo(measDataValue) > 0) {
                    gmtMinRef.set(o.getGmtMeasFreeze());
                    minRef.set(measDataValue);
                }
                rateRef.set(o.getMeasDataRate());
            });
            if (cntRef.get() > 0) {
                MeasStatInsYearValue measStatInsYearValue = new MeasStatInsYearValue();
                measStatInsYearValue.setMeasPointId(measPointId);
                measStatInsYearValue.setMeasItemCode(k);
                measStatInsYearValue.setYearMeasStat(DateConvertUtils.convertToString((Date)yearMeasStat, (String)"yyyy"));
                measStatInsYearValue.setMeasDataRate(rateRef.get());
                measStatInsYearValue.setAvgValue(sumRef.get().divide(new BigDecimal(cntRef.get().toString()), 8, RoundingMode.HALF_UP));
                measStatInsYearValue.setMaxValue((BigDecimal)maxRef.get());
                measStatInsYearValue.setGmtMaxValue(((Long)gmtMaxRef.get()).longValue());
                measStatInsYearValue.setMinValue((BigDecimal)minRef.get());
                measStatInsYearValue.setGmtMinValue(((Long)gmtMinRef.get()).longValue());
                measStatInsYearValue.setStatDataSource("meas_data_ins_freeze_curve");
                measStatInsYearValue.setStatDataCount(cntRef.get().intValue());
                measStatInsYearValue.setGmtCreate(gmtMeasFreezeEnd);
                measStatInsYearValue.setGmtModified(System.currentTimeMillis());
                measStatMap.put(k, measStatInsYearValue);
            }
        });
        response.setMeasPointId(measPointId);
        response.setMeasStatMap((Map)measStatMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatInsMonthGetResponse      : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasStatInsYear <<<<<<<< ");
        }
        return response;
    }

    public MeasStatInsYearBatchGetResponse batchGetMeasStatInsYear(MeasStatInsYearBatchGetRequest measStatInsYearBatchGetRequest) {
        return null;
    }

    public MeasStatInsYearGetRangeResponse getRangeMeasStatInsYear(MeasStatInsYearGetRangeRequest measStatInsYearGetRangeRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRangeMeasStatInsYear >>>>>>> ");
            this.logger.debug(" MeasStatInsYearGetRangeRequest   : " + JsonConvertUtils.convertToString((Object)measStatInsYearGetRangeRequest));
        }
        MeasStatInsYearGetRangeResponse response = new MeasStatInsYearGetRangeResponse();
        Long measPointId = measStatInsYearGetRangeRequest.getMeasPointId();
        Set measItemCodeSet = measStatInsYearGetRangeRequest.getMeasItemCodeSet();
        Date yearMeasStatStart = DateConvertUtils.convertFromString((String)measStatInsYearGetRangeRequest.getYearMeasStatStart(), (String[])DateConvertUtils.PATTERNS_YEAR);
        Date yearMeasStatEnd = DateConvertUtils.convertFromString((String)measStatInsYearGetRangeRequest.getYearMeasStatEnd(), (String[])DateConvertUtils.PATTERNS_YEAR);
        HashMap measStatListMap = Maps.newHashMap();
        Date yearMeasStat = yearMeasStatStart;
        while (yearMeasStat.before(yearMeasStatEnd)) {
            MeasStatInsYearGetRequest measStatInsYearGetRequest = new MeasStatInsYearGetRequest();
            measStatInsYearGetRequest.setMeasPointId(measPointId);
            measStatInsYearGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatInsYearGetRequest.setYearMeasStat(DateConvertUtils.convertToString((Date)yearMeasStat, (String)"yyyy"));
            measStatInsYearGetRequest.setMeasDataSideType(measStatInsYearGetRangeRequest.getMeasDataSideType());
            MeasStatInsYearGetResponse measStatInsYearGetResponse = this.getMeasStatInsYear(measStatInsYearGetRequest);
            if (measStatInsYearGetResponse.isSuccess()) {
                measStatInsYearGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List measStatInsYearValueList = (List)measStatListMap.get(k);
                    if (CollectionUtils.isEmpty((Collection)measStatInsYearValueList)) {
                        measStatInsYearValueList = Lists.newArrayList();
                    }
                    measStatInsYearValueList.add(v);
                    measStatListMap.put(k, measStatInsYearValueList);
                });
            }
            yearMeasStat = DateUtils.addYears((Date)yearMeasStat, (int)1);
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatListMap((Map)measStatListMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatInsYearGetRangeResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getRangeMeasStatInsYear <<<<<<<< ");
        }
        return response;
    }

    public MeasStatInsYearBatchGetRangeResponse batchGetRangeMeasStatInsYear(MeasStatInsYearBatchGetRangeRequest measStatInsYearBatchGetRangeRequest) {
        return null;
    }

    public MeasStatCumDayGetResponse getMeasStatCumDay(MeasStatCumDayGetRequest measStatCumDayGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasStatCumDay >>>>>>> ");
            this.logger.debug(" MeasStatCumDayGetRequest         : " + JsonConvertUtils.convertToString((Object)measStatCumDayGetRequest));
        }
        MeasStatCumDayGetResponse response = new MeasStatCumDayGetResponse();
        Long measPointId = measStatCumDayGetRequest.getMeasPointId();
        Set measItemCodeSet = measStatCumDayGetRequest.getMeasItemCodeSet();
        Date dateMeasStat = DateConvertUtils.convertFromString((String)measStatCumDayGetRequest.getDateMeasStat(), (String[])DateConvertUtils.PATTERNS_DATE);
        int intervalCnt = 96;
        int curveInterval = measStatCumDayGetRequest.getCurveInterval();
        if (curveInterval < 15) {
            curveInterval = 15;
            intervalCnt = 96;
        }
        if (curveInterval > 15 && curveInterval <= 60) {
            curveInterval = 60;
            intervalCnt = 24;
        }
        if (curveInterval > 60) {
            curveInterval = 1440;
            intervalCnt = 1;
        }
        long gmtMeasFreezeStart = dateMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addMinutes((Date)DateUtils.addDays((Date)dateMeasStat, (int)1), (int)1).getTime();
        HashMap measStatMap = Maps.newHashMap();
        for (String measItemCode : measItemCodeSet) {
            HashMap params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = this.measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            BigDecimal measDataRate = null;
            BigDecimal startDval = null;
            long gmtStartDval = 0L;
            BigDecimal endDval = null;
            long gmtEndDval = 0L;
            BigDecimal usageDval = null;
            BigDecimal[] usageQvals = new BigDecimal[intervalCnt];
            Object[] readingQvals = new BigDecimal[intervalCnt + 1];
            String statDataSource = "meas_data_cum_freeze_curve";
            int ic = 0;
            HashMap mapQuarter = Maps.newHashMap();
            for (long gmtMeasFreezeClock = gmtMeasFreezeStart; gmtMeasFreezeClock < gmtMeasFreezeEnd; gmtMeasFreezeClock += (long)curveInterval * 60L * 1000L) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[" + String.format("%2d", ic) + "] gmtMeasFreezeClock   : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasFreezeClock), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                mapQuarter.put(gmtMeasFreezeClock, ic);
                ++ic;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" readingQvals : " + Arrays.toString(readingQvals));
            }
            for (MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo : measDataCumFreezeCurveList) {
                Integer index;
                BigDecimal ptRate;
                BigDecimal ctRate;
                BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
                if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                    selfRate = new BigDecimal("1.0");
                }
                if ((ctRate = measDataCumFreezeCurveVo.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ctRate = new BigDecimal("1.0");
                }
                if ((ptRate = measDataCumFreezeCurveVo.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
                if (measStatCumDayGetRequest.getMeasDataSideType() == 1 && StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre"})) {
                    measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                }
                if ((index = (Integer)mapQuarter.get(measDataCumFreezeCurveVo.getGmtMeasFreeze())) == null) continue;
                if (startDval == null) {
                    startDval = measDataValue;
                    gmtStartDval = measDataCumFreezeCurveVo.getGmtMeasFreeze();
                }
                measDataRate = measDataCumFreezeCurveVo.getMeasDataRate();
                endDval = measDataValue;
                gmtEndDval = measDataCumFreezeCurveVo.getGmtMeasFreeze();
                readingQvals[index.intValue()] = measDataValue;
            }
            for (int i = 0; i < intervalCnt; ++i) {
                usageQvals[i] = readingQvals[i + 1] != null && readingQvals[i] != null ? ((BigDecimal)readingQvals[i + 1]).subtract(((BigDecimal)readingQvals[i]).setScale(8, RoundingMode.HALF_UP)) : null;
            }
            BigDecimal bigDecimal = usageDval = endDval != null && startDval != null ? endDval.subtract(startDval).setScale(8, RoundingMode.HALF_UP) : null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" startDval    : " + startDval);
                this.logger.debug(" gmtStartDval : " + DateConvertUtils.convertToString((Date)new Date(gmtStartDval), (String)"yyyy-MM-dd HH:mm:ss"));
                this.logger.debug(" endDval      : " + endDval);
                this.logger.debug(" gmtEndDval   : " + DateConvertUtils.convertToString((Date)new Date(gmtEndDval), (String)"yyyy-MM-dd HH:mm:ss"));
                this.logger.debug(" readingQvals : " + Arrays.toString(readingQvals));
            }
            measStatMap.put(measItemCode, new MeasStatCumDayValue(measPointId, measItemCode, DateConvertUtils.convertToString((Date)dateMeasStat, (String)"yyyyMMdd"), measDataRate, startDval, gmtStartDval, endDval, gmtEndDval, usageDval, usageQvals, statDataSource, gmtEndDval, gmtEndDval));
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatMap((Map)measStatMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatCumDayGetResponse        : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasStatCumDay <<<<<<<< ");
        }
        return response;
    }

    public MeasStatCumDayBatchGetResponse batchGetMeasStatCumDay(MeasStatCumDayBatchGetRequest measStatCumDayBatchGetRequest) {
        return null;
    }

    public MeasStatCumDayGetRangeResponse getRangeMeasStatCumDay(MeasStatCumDayGetRangeRequest measStatCumDayGetRangeRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRangeMeasStatCumDay >>>>>>> ");
            this.logger.debug(" MeasStatCumDayGetRangeRequest    : " + JsonConvertUtils.convertToString((Object)measStatCumDayGetRangeRequest));
        }
        MeasStatCumDayGetRangeResponse response = new MeasStatCumDayGetRangeResponse();
        Long measPointId = measStatCumDayGetRangeRequest.getMeasPointId();
        Set measItemCodeSet = measStatCumDayGetRangeRequest.getMeasItemCodeSet();
        Date dateMeasStatStart = DateConvertUtils.convertFromString((String)measStatCumDayGetRangeRequest.getDateMeasStatStart(), (String[])DateConvertUtils.PATTERNS_DATE);
        Date dateMeasStatEnd = DateConvertUtils.convertFromString((String)measStatCumDayGetRangeRequest.getDateMeasStatEnd(), (String[])DateConvertUtils.PATTERNS_DATE);
        HashMap measStatListMap = Maps.newHashMap();
        Date dateMeasStat = dateMeasStatStart;
        while (dateMeasStat.before(dateMeasStatEnd)) {
            MeasStatCumDayGetRequest measStatCumDayGetRequest = new MeasStatCumDayGetRequest();
            measStatCumDayGetRequest.setMeasPointId(measPointId);
            measStatCumDayGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatCumDayGetRequest.setDateMeasStat(DateConvertUtils.convertToString((Date)dateMeasStat, (String)"yyyyMMdd"));
            measStatCumDayGetRequest.setMeasDataSideType(measStatCumDayGetRangeRequest.getMeasDataSideType());
            measStatCumDayGetRequest.setCurveInterval(measStatCumDayGetRangeRequest.getCurveInterval());
            MeasStatCumDayGetResponse measStatCumDayGetResponse = this.getMeasStatCumDay(measStatCumDayGetRequest);
            if (measStatCumDayGetResponse.isSuccess()) {
                measStatCumDayGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List measStatCumDayValueList = (List)measStatListMap.get(k);
                    if (CollectionUtils.isEmpty((Collection)measStatCumDayValueList)) {
                        measStatCumDayValueList = Lists.newArrayList();
                    }
                    measStatCumDayValueList.add(v);
                    measStatListMap.put(k, measStatCumDayValueList);
                });
            }
            dateMeasStat = DateUtils.addDays((Date)dateMeasStat, (int)1);
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatListMap((Map)measStatListMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatCumDayGetRangeResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getRangeMeasStatCumDay <<<<<<<< ");
        }
        return response;
    }

    public MeasStatCumDayBatchGetRangeResponse batchGetRangeMeasStatCumDay(MeasStatCumDayBatchGetRangeRequest measStatCumDayBatchGetRangeRequest) {
        return null;
    }

    public MeasStatCumMonthGetResponse getMeasStatCumMonth(MeasStatCumMonthGetRequest measStatCumMonthGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasStatCumMonth >>>>>>> ");
            this.logger.debug(" MeasStatCumMonthGetRequest       : " + JsonConvertUtils.convertToString((Object)measStatCumMonthGetRequest));
        }
        MeasStatCumMonthGetResponse response = new MeasStatCumMonthGetResponse();
        Long measPointId = measStatCumMonthGetRequest.getMeasPointId();
        Set measItemCodeSet = measStatCumMonthGetRequest.getMeasItemCodeSet();
        Date monthMeasStat = DateConvertUtils.convertFromString((String)measStatCumMonthGetRequest.getMonthMeasStat(), (String[])DateConvertUtils.PATTERNS_MONTH);
        HashMap measStatMap = Maps.newHashMap();
        long gmtMeasFreezeStart = monthMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addMillis((Date)DateUtils.addMonths((Date)monthMeasStat, (int)1), (int)1).getTime();
        for (String measItemCode : measItemCodeSet) {
            HashMap params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            params.put("isDateZero", "true");
            List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = this.measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            BigDecimal measDataRate = null;
            BigDecimal startMval = null;
            long gmtStartMval = 0L;
            BigDecimal endMval = null;
            long gmtEndMval = 0L;
            BigDecimal usageMval = null;
            int days = DateUtils.getDaysOfMonth((Date)monthMeasStat);
            BigDecimal[] usageDvals = new BigDecimal[days];
            Object[] readingDvals = new BigDecimal[days + 1];
            String statDataSource = "meas_data_cum_freeze_curve";
            int ic = 0;
            HashMap mapDay = Maps.newHashMap();
            for (long gmtMeasFreezeClock = gmtMeasFreezeStart; gmtMeasFreezeClock < gmtMeasFreezeEnd; gmtMeasFreezeClock += 86400000L) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[" + String.format("%2d", ic) + "] gmtMeasFreezeClock   : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasFreezeClock), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                mapDay.put(gmtMeasFreezeClock, ic);
                ++ic;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" readingDvals : " + Arrays.toString(readingDvals));
            }
            for (MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo : measDataCumFreezeCurveList) {
                Integer index;
                BigDecimal ptRate;
                BigDecimal ctRate;
                BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
                if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                    selfRate = new BigDecimal("1.0");
                }
                if ((ctRate = measDataCumFreezeCurveVo.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ctRate = new BigDecimal("1.0");
                }
                if ((ptRate = measDataCumFreezeCurveVo.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
                if (measStatCumMonthGetRequest.getMeasDataSideType() == 1 && StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre"})) {
                    measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                }
                if ((index = (Integer)mapDay.get(measDataCumFreezeCurveVo.getGmtMeasFreeze())) == null) continue;
                if (startMval == null) {
                    startMval = measDataValue;
                    gmtStartMval = measDataCumFreezeCurveVo.getGmtMeasFreeze();
                }
                measDataRate = measDataCumFreezeCurveVo.getMeasDataRate();
                endMval = measDataValue;
                gmtEndMval = measDataCumFreezeCurveVo.getGmtMeasFreeze();
                readingDvals[index.intValue()] = measDataValue;
            }
            for (int i = 0; i < days; ++i) {
                usageDvals[i] = readingDvals[i + 1] != null && readingDvals[i] != null ? ((BigDecimal)readingDvals[i + 1]).subtract(((BigDecimal)readingDvals[i]).setScale(8, RoundingMode.HALF_UP)) : null;
            }
            BigDecimal bigDecimal = usageMval = endMval != null && startMval != null ? endMval.subtract(startMval).setScale(8, RoundingMode.HALF_UP) : null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" startMval    : " + startMval);
                this.logger.debug(" gmtStartMval : " + DateConvertUtils.convertToString((Date)new Date(gmtStartMval), (String)"yyyy-MM-dd HH:mm:ss"));
                this.logger.debug(" endMval      : " + endMval);
                this.logger.debug(" gmtEndMval   : " + DateConvertUtils.convertToString((Date)new Date(gmtEndMval), (String)"yyyy-MM-dd HH:mm:ss"));
                this.logger.debug(" readingDvals : " + Arrays.toString(readingDvals));
            }
            measStatMap.put(measItemCode, new MeasStatCumMonthValue(measPointId, measItemCode, DateConvertUtils.convertToString((Date)monthMeasStat, (String)"yyyyMM"), measDataRate, startMval, gmtStartMval, endMval, gmtEndMval, usageMval, usageDvals, statDataSource, gmtEndMval, gmtEndMval));
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatMap((Map)measStatMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatCumMonthGetResponse      : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasStatCumMonth <<<<<<<< ");
        }
        return response;
    }

    public MeasStatCumMonthBatchGetResponse batchGetMeasStatCumMonth(MeasStatCumMonthBatchGetRequest measStatCumMonthBatchGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start batchGetMeasStatCumMonth >>>>>>> ");
            this.logger.debug(" MeasStatCumMonthBatchGetRequest       : " + JsonConvertUtils.convertToString((Object)measStatCumMonthBatchGetRequest));
        }
        MeasStatCumMonthBatchGetResponse response = new MeasStatCumMonthBatchGetResponse();
        HashMap batchMeasStatMap = Maps.newHashMap();
        Set measPointIdSet = measStatCumMonthBatchGetRequest.getMeasPointIdSet();
        Set measItemCodeSet = measStatCumMonthBatchGetRequest.getMeasItemCodeSet();
        String monthMeasStat = measStatCumMonthBatchGetRequest.getMonthMeasStat();
        int measDataSideType = measStatCumMonthBatchGetRequest.getMeasDataSideType();
        if (measPointIdSet.size() > 0) {
            measPointIdSet.stream().forEach(measPointId -> {
                MeasStatCumMonthGetRequest measStatCumMonthGetRequest = new MeasStatCumMonthGetRequest();
                measStatCumMonthGetRequest.setMeasPointId(measPointId);
                measStatCumMonthGetRequest.setMeasItemCodeSet(measItemCodeSet);
                measStatCumMonthGetRequest.setMonthMeasStat(monthMeasStat);
                measStatCumMonthGetRequest.setMeasDataSideType(measDataSideType);
                MeasStatCumMonthGetResponse measStatCumMonthGetResponse = this.getMeasStatCumMonth(measStatCumMonthGetRequest);
                if (measStatCumMonthGetResponse != null && measStatCumMonthGetResponse.isSuccess()) {
                    batchMeasStatMap.put(measStatCumMonthGetResponse.getMeasPointId(), measStatCumMonthGetResponse.getMeasStatMap());
                }
            });
        }
        response.setBatchMeasStatMap((Map)batchMeasStatMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatCumMonthBatchGetResponse      : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end batchGetMeasStatCumMonth <<<<<<<< ");
        }
        return response;
    }

    public MeasStatCumMonthGetRangeResponse getRangeMeasStatCumMonth(MeasStatCumMonthGetRangeRequest measStatCumMonthGetRangeRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRangeMeasStatCumMonth >>>>>>> ");
            this.logger.debug(" MeasStatCumMonthGetRangeRequest  : " + JsonConvertUtils.convertToString((Object)measStatCumMonthGetRangeRequest));
        }
        MeasStatCumMonthGetRangeResponse response = new MeasStatCumMonthGetRangeResponse();
        Long measPointId = measStatCumMonthGetRangeRequest.getMeasPointId();
        Set measItemCodeSet = measStatCumMonthGetRangeRequest.getMeasItemCodeSet();
        Date monthMeasStatStart = DateConvertUtils.convertFromString((String)measStatCumMonthGetRangeRequest.getMonthMeasStatStart(), (String[])DateConvertUtils.PATTERNS_MONTH);
        Date monthMeasStatEnd = DateConvertUtils.convertFromString((String)measStatCumMonthGetRangeRequest.getMonthMeasStatEnd(), (String[])DateConvertUtils.PATTERNS_MONTH);
        HashMap measStatListMap = Maps.newHashMap();
        Date monthMeasStat = monthMeasStatStart;
        while (monthMeasStat.before(monthMeasStatEnd)) {
            MeasStatCumMonthGetRequest measStatCumMonthGetRequest = new MeasStatCumMonthGetRequest();
            measStatCumMonthGetRequest.setMeasPointId(measPointId);
            measStatCumMonthGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatCumMonthGetRequest.setMonthMeasStat(DateConvertUtils.convertToString((Date)monthMeasStat, (String)"yyyyMM"));
            measStatCumMonthGetRequest.setMeasDataSideType(measStatCumMonthGetRangeRequest.getMeasDataSideType());
            MeasStatCumMonthGetResponse measStatCumMonthGetResponse = this.getMeasStatCumMonth(measStatCumMonthGetRequest);
            if (measStatCumMonthGetResponse.isSuccess()) {
                measStatCumMonthGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List measStatCumMonthValueList = (List)measStatListMap.get(k);
                    if (CollectionUtils.isEmpty((Collection)measStatCumMonthValueList)) {
                        measStatCumMonthValueList = Lists.newArrayList();
                    }
                    measStatCumMonthValueList.add(v);
                    measStatListMap.put(k, measStatCumMonthValueList);
                });
            }
            monthMeasStat = DateUtils.addMonths((Date)monthMeasStat, (int)1);
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatListMap((Map)measStatListMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatCumMonthGetRangeResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getRangeMeasStatCumMonth <<<<<<<< ");
        }
        return response;
    }

    public MeasStatCumMonthBatchGetRangeResponse batchGetRangeMeasStatCumMonth(MeasStatCumMonthBatchGetRangeRequest measStatCumMonthBatchGetRangeRequest) {
        return null;
    }

    public MeasStatCumYearGetResponse getMeasStatCumYear(MeasStatCumYearGetRequest measStatCumYearGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasStatCumYear >>>>>>> ");
            this.logger.debug(" MeasStatCumYearGetRequest        : " + JsonConvertUtils.convertToString((Object)measStatCumYearGetRequest));
        }
        MeasStatCumYearGetResponse response = new MeasStatCumYearGetResponse();
        Long measPointId = measStatCumYearGetRequest.getMeasPointId();
        Set measItemCodeSet = measStatCumYearGetRequest.getMeasItemCodeSet();
        Date yearMeasStat = DateConvertUtils.convertFromString((String)measStatCumYearGetRequest.getYearMeasStat(), (String[])DateConvertUtils.PATTERNS_YEAR);
        HashMap measStatMap = Maps.newHashMap();
        long gmtMeasFreezeStart = yearMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addMillis((Date)DateUtils.addYears((Date)yearMeasStat, (int)1), (int)1).getTime();
        for (String measItemCode : measItemCodeSet) {
            HashMap params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            params.put("isMonthFirst", "true");
            List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = this.measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            BigDecimal measDataRate = null;
            BigDecimal startYval = null;
            long gmtStartYval = 0L;
            BigDecimal endYval = null;
            long gmtEndYval = 0L;
            BigDecimal usageYval = null;
            BigDecimal[] usageMvals = new BigDecimal[12];
            Object[] readingMvals = new BigDecimal[13];
            String statDataSource = "meas_data_cum_freeze_curve";
            long gmtMeasFreezeClock = gmtMeasFreezeStart;
            int ic = 0;
            HashMap mapDay = Maps.newHashMap();
            while (gmtMeasFreezeClock < gmtMeasFreezeEnd) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[" + String.format("%2d", ic) + "] gmtMeasFreezeClock   : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasFreezeClock), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                mapDay.put(gmtMeasFreezeClock, ic);
                ++ic;
                gmtMeasFreezeClock = DateUtils.addMonths((Date)new Date(gmtMeasFreezeClock), (int)1).getTime();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" readingMvals : " + Arrays.toString(readingMvals));
            }
            for (MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo : measDataCumFreezeCurveList) {
                Integer index;
                BigDecimal ptRate;
                BigDecimal ctRate;
                BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
                if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                    selfRate = new BigDecimal("1.0");
                }
                if ((ctRate = measDataCumFreezeCurveVo.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ctRate = new BigDecimal("1.0");
                }
                if ((ptRate = measDataCumFreezeCurveVo.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
                if (measStatCumYearGetRequest.getMeasDataSideType() == 1 && StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre"})) {
                    measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                }
                if ((index = (Integer)mapDay.get(measDataCumFreezeCurveVo.getGmtMeasFreeze())) == null) continue;
                if (startYval == null) {
                    startYval = measDataValue;
                    gmtStartYval = measDataCumFreezeCurveVo.getGmtMeasFreeze();
                }
                measDataRate = measDataCumFreezeCurveVo.getMeasDataRate();
                endYval = measDataValue;
                gmtEndYval = measDataCumFreezeCurveVo.getGmtMeasFreeze();
                readingMvals[index.intValue()] = measDataValue;
            }
            for (int i = 0; i < 12; ++i) {
                usageMvals[i] = readingMvals[i + 1] != null && readingMvals[i] != null ? ((BigDecimal)readingMvals[i + 1]).subtract(((BigDecimal)readingMvals[i]).setScale(8, RoundingMode.HALF_UP)) : null;
            }
            BigDecimal bigDecimal = usageYval = endYval != null && startYval != null ? endYval.subtract(startYval).setScale(8, RoundingMode.HALF_UP) : null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" startYval    : " + startYval);
                this.logger.debug(" gmtStartYval : " + DateConvertUtils.convertToString((Date)new Date(gmtStartYval), (String)"yyyy-MM-dd HH:mm:ss"));
                this.logger.debug(" endYval      : " + endYval);
                this.logger.debug(" gmtEndYval   : " + DateConvertUtils.convertToString((Date)new Date(gmtEndYval), (String)"yyyy-MM-dd HH:mm:ss"));
                this.logger.debug(" readingMvals : " + Arrays.toString(readingMvals));
            }
            measStatMap.put(measItemCode, new MeasStatCumYearValue(measPointId, measItemCode, DateConvertUtils.convertToString((Date)yearMeasStat, (String)"yyyy"), measDataRate, startYval, gmtStartYval, endYval, gmtEndYval, usageYval, usageMvals, statDataSource, gmtEndYval, gmtEndYval));
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatMap((Map)measStatMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatCumYearGetResponse      : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasStatCumYear <<<<<<<< ");
        }
        return response;
    }

    public MeasStatCumYearBatchGetResponse batchGetMeasStatCumYear(MeasStatCumYearBatchGetRequest measStatCumYearBatchGetRequest) {
        return null;
    }

    public MeasStatCumYearGetRangeResponse getRangeMeasStatCumYear(MeasStatCumYearGetRangeRequest measStatCumYearGetRangeRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRangeMeasStatCumYear >>>>>>> ");
            this.logger.debug(" MeasStatCumYearGetRangeRequest   : " + JsonConvertUtils.convertToString((Object)measStatCumYearGetRangeRequest));
        }
        MeasStatCumYearGetRangeResponse response = new MeasStatCumYearGetRangeResponse();
        Long measPointId = measStatCumYearGetRangeRequest.getMeasPointId();
        Set measItemCodeSet = measStatCumYearGetRangeRequest.getMeasItemCodeSet();
        Date yearMeasStatStart = DateConvertUtils.convertFromString((String)measStatCumYearGetRangeRequest.getYearMeasStatStart(), (String[])DateConvertUtils.PATTERNS_YEAR);
        Date yearMeasStatEnd = DateConvertUtils.convertFromString((String)measStatCumYearGetRangeRequest.getYearMeasStatEnd(), (String[])DateConvertUtils.PATTERNS_YEAR);
        HashMap measStatListMap = Maps.newHashMap();
        Date yearMeasStat = yearMeasStatStart;
        while (yearMeasStat.before(yearMeasStatEnd)) {
            MeasStatCumYearGetRequest measStatCumYearGetRequest = new MeasStatCumYearGetRequest();
            measStatCumYearGetRequest.setMeasPointId(measPointId);
            measStatCumYearGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatCumYearGetRequest.setYearMeasStat(DateConvertUtils.convertToString((Date)yearMeasStat, (String)"yyyy"));
            measStatCumYearGetRequest.setMeasDataSideType(measStatCumYearGetRangeRequest.getMeasDataSideType());
            MeasStatCumYearGetResponse measStatCumYearGetResponse = this.getMeasStatCumYear(measStatCumYearGetRequest);
            if (measStatCumYearGetResponse.isSuccess()) {
                measStatCumYearGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List measStatCumYearValueList = (List)measStatListMap.get(k);
                    if (CollectionUtils.isEmpty((Collection)measStatCumYearValueList)) {
                        measStatCumYearValueList = Lists.newArrayList();
                    }
                    measStatCumYearValueList.add(v);
                    measStatListMap.put(k, measStatCumYearValueList);
                });
            }
            yearMeasStat = DateUtils.addYears((Date)yearMeasStat, (int)1);
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatListMap((Map)measStatListMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasStatCumYearGetRangeResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getRangeMeasStatCumYear <<<<<<<< ");
        }
        return response;
    }

    public MeasStatCumYearBatchGetRangeResponse batchGetRangeMeasStatCumYear(MeasStatCumYearBatchGetRangeRequest measStatCumYearBatchGetRangeRequest) {
        return null;
    }
}

