package com.easesource.iot.datacenter.openservice.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.iot.datacenter.openservice.entity.RunAccessGatewayDo;
import com.easesource.iot.datacenter.openservice.entity.RunAccessGatewayVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-08
 */
public interface RunAccessGatewayDao extends CrudMapper<RunAccessGatewayDo, Long> {

    int deleteById(Long id);

    RunAccessGatewayVo getRunAccessGatewayVoById(Long id);

    RunAccessGatewayVo getRunAccessGatewayVoByOrgNoAndDevAccessSortNoAndDevAccessNo(@Param("orgNo") String orgNo, @Param("devAccessSortNo") String devAccessSortNo, @Param("devAccessNo") String devAccessNo);

    RunAccessGatewayVo getRunAccessGatewayVoByProductKeyAndClientId(@Param("productKey") String productKey, @Param("clientId") String clientId);

    RunAccessGatewayVo getRunAccessGatewayVoByProductKeyAndUpcommProtoAndUpcommLogicAddr(@Param("productKey") String productKey, @Param("upcommProto") String upcommProto, @Param("upcommLogicAddr") String upcommLogicAddr);

    int getRunAccessGatewayVoCount(@Param("params") Map<String, Object> params);

    List<RunAccessGatewayVo> getRunAccessGatewayVoList(@Param("params") Map<String, Object> params, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);
}
