/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.AccessMgmtService;
import com.easesource.iot.datacenter.openservice.dao.DevAccessDao;
import com.easesource.iot.datacenter.openservice.dao.DevAccessGatewayDao;
import com.easesource.iot.datacenter.openservice.dao.DevAccessMeasureDao;
import com.easesource.iot.datacenter.openservice.dao.DevAccessTrunkingDao;
import com.easesource.iot.datacenter.openservice.dao.LogDevAccessEntityDao;
import com.easesource.iot.datacenter.openservice.dao.RunAccessGatewayDao;
import com.easesource.iot.datacenter.openservice.dao.RunMeasPointDao;
import com.easesource.iot.datacenter.openservice.entity.DevAccessDo;
import com.easesource.iot.datacenter.openservice.entity.DevAccessMeasureDo;
import com.easesource.iot.datacenter.openservice.entity.LogDevAccessEntityDo;
import com.easesource.iot.datacenter.openservice.entity.RunAccessGatewayDo;
import com.easesource.iot.datacenter.openservice.entity.RunAccessGatewayVo;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointChangeLogDo;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointDo;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointVo;
import com.easesource.iot.datacenter.openservice.request.DevAccessGatewayQueryRequest;
import com.easesource.iot.datacenter.openservice.request.EditMeterRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayAddToOrgRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayDeleteFromOrgRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayGetRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayNameAndDescUpdateRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayOfflineSetRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayOpsInfoUpdateRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayQueryRequest;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayRunStatusUpdateRequest;
import com.easesource.iot.datacenter.openservice.request.RunMeasPointGetRequest;
import com.easesource.iot.datacenter.openservice.request.RunMeasPointNameAndDescUpdateRequest;
import com.easesource.iot.datacenter.openservice.request.RunMeasPointOpsInfoBatchUpdateRequest;
import com.easesource.iot.datacenter.openservice.request.RunMeasPointOpsInfoUpdateRequest;
import com.easesource.iot.datacenter.openservice.request.SyncRequest;
import com.easesource.iot.datacenter.openservice.response.BrushMeterResponse;
import com.easesource.iot.datacenter.openservice.response.DevAccessGatewayQueryResponse;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayAddToOrgResponse;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayDeleteFromOrgResponse;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayGetResponse;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayNameAndDescUpdateResponse;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayOfflineSetResponse;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayOpsInfoUpdateResponse;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayQueryResponse;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayRunStatusUpdateResponse;
import com.easesource.iot.datacenter.openservice.response.RunMeasPointGetResponse;
import com.easesource.iot.datacenter.openservice.response.RunMeasPointListResponse;
import com.easesource.iot.datacenter.openservice.response.RunMeasPointNameAndDescUpdateResponse;
import com.easesource.iot.datacenter.openservice.response.RunMeasPointOpsInfoBatchUpdateResponse;
import com.easesource.iot.datacenter.openservice.response.RunMeasPointOpsInfoUpdateResponse;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="accessMgmtService")
public class AccessMgmtServiceImpl
extends AbstractBaseService
implements AccessMgmtService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private DevAccessDao devAccessDao;
    @Resource
    private DevAccessGatewayDao devAccessGatewayDao;
    @Resource
    private DevAccessTrunkingDao devAccessTrunkingDao;
    @Resource
    private DevAccessMeasureDao devAccessMeasureDao;
    @Resource
    private RunAccessGatewayDao runAccessGatewayDao;
    @Resource
    private RunMeasPointDao runMeasPointDao;
    @Resource
    private LogDevAccessEntityDao logDevAccessEntityDao;

    public DevAccessGatewayQueryResponse queryDevAccessGateway(DevAccessGatewayQueryRequest devAccessGatewayQueryRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start queryDevAccessGateway >>>>>>> ");
            this.logger.debug(" DevAccessGatewayQueryRequest     : " + JsonConvertUtils.convertToString((Object)devAccessGatewayQueryRequest));
        }
        DevAccessGatewayQueryResponse response = new DevAccessGatewayQueryResponse();
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" DevAccessGatewayQueryResponse    : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end queryDevAccessGateway <<<<<<<< ");
        }
        return response;
    }

    public RunAccessGatewayGetResponse getRunAccessGateway(RunAccessGatewayGetRequest getRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRunAccessGateway >>>>>>> ");
            this.logger.debug(" RunAccessGatewayGetRequest   : " + JsonConvertUtils.convertToString((Object)getRequest));
        }
        RunAccessGatewayGetResponse getResponse = new RunAccessGatewayGetResponse();
        getResponse.setReturnCode("FAILURE");
        getResponse.setFailureCode("-1");
        if (getRequest != null && getRequest.getDevAccessId() != null && getRequest.getDevAccessId() > 0L) {
            RunAccessGatewayVo runAccessGateway = this.runAccessGatewayDao.getRunAccessGatewayVoById(getRequest.getDevAccessId());
            List<RunMeasPointVo> runMeasPointList = this.runMeasPointDao.getRunMeasPointVoListByAccessGatewayId(getRequest.getDevAccessId());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        } else if (getRequest != null && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo()})) {
            RunAccessGatewayVo runAccessGateway = this.runAccessGatewayDao.getRunAccessGatewayVoByOrgNoAndDevAccessSortNoAndDevAccessNo(getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo());
            List<RunMeasPointVo> runMeasPointList = this.runMeasPointDao.getRunMeasPointVoListByOrgNoAndDevAccessGatewaySortNoAndDevAccessGatewayNo(getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        } else if (getRequest != null && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{getRequest.getProductKey(), getRequest.getClientId()})) {
            RunAccessGatewayVo runAccessGateway = this.runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndClientId(getRequest.getProductKey(), getRequest.getClientId());
            List<RunMeasPointVo> runMeasPointList = this.runMeasPointDao.getRunMeasPointVoListByProductKeyAndClientId(getRequest.getProductKey(), getRequest.getClientId());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        } else if (getRequest != null && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{getRequest.getProductKey(), getRequest.getDevAccessNo(), getRequest.getUpcommProto()})) {
            List<RunMeasPointVo> runMeasPointList = this.runMeasPointDao.getRunMeasPointVoListByIdClear(getRequest.getDevAccessNo(), getRequest.getUpcommProto());
            RunAccessGatewayVo runAccessGateway = new RunAccessGatewayVo();
            if (runMeasPointList.size() > 0) {
                runAccessGateway = this.runAccessGatewayDao.getRunAccessGatewayVoById(runMeasPointList.get(0).getAccessGatewayId());
            }
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        } else if (getRequest != null && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr()})) {
            RunAccessGatewayVo runAccessGateway = this.runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndUpcommProtoAndUpcommLogicAddr(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr());
            List<RunMeasPointVo> runMeasPointList = this.runMeasPointDao.getRunMeasPointVoListByProductKeyAndUpcommProtoAndUpcommLogicAddr(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RunAccessGatewayGetResponse  : " + JsonConvertUtils.convertToString((Object)getResponse));
            this.logger.debug(" <<<<<<<< end getRunAccessGateway <<<<<<<< ");
        }
        return getResponse;
    }

    public RunAccessGatewayNameAndDescUpdateResponse updateRunAccessGatewayNameAndDesc(RunAccessGatewayNameAndDescUpdateRequest runAccessGatewayNameAndDescUpdateRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start updateRunAccessGatewayNameAndDesc >>>>>>> ");
            this.logger.debug(" RunAccessGatewayNameAndDescUpdateRequest : " + JsonConvertUtils.convertToString((Object)runAccessGatewayNameAndDescUpdateRequest));
        }
        RunAccessGatewayNameAndDescUpdateResponse response = new RunAccessGatewayNameAndDescUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayNameAndDescUpdateRequest.getDevAccessId();
        if (devAccessId != null && devAccessId > 0L) {
            DevAccessDo devAccessDo = (DevAccessDo)this.devAccessDao.get(devAccessId);
            if (devAccessDo != null && StringUtils.isNotBlank((CharSequence)runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessName())) {
                devAccessDo.setDevAccessName(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessName());
            }
            if (devAccessDo != null && StringUtils.isNotBlank((CharSequence)runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessDesc())) {
                devAccessDo.setDevAccessDesc(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessDesc());
            }
            this.devAccessDao.update(devAccessDo);
            RunAccessGatewayVo runAccessGatewayVo = this.runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RunAccessGatewayNameAndDescUpdateResponse  : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end updateRunAccessGatewayNameAndDesc <<<<<<<< ");
        }
        return response;
    }

    public RunAccessGatewayRunStatusUpdateResponse updateRunAccessGatewayRunStatus(RunAccessGatewayRunStatusUpdateRequest runAccessGatewayRunStatusUpdateRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start updateRunAccessGatewayRunStatus >>>>>>> ");
            this.logger.debug(" RunAccessGatewayRunStatusUpdateRequest   : " + JsonConvertUtils.convertToString((Object)runAccessGatewayRunStatusUpdateRequest));
        }
        RunAccessGatewayRunStatusUpdateResponse response = new RunAccessGatewayRunStatusUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayRunStatusUpdateRequest.getDevAccessId();
        if (devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = (RunAccessGatewayDo)this.runAccessGatewayDao.get(devAccessId);
            if (runAccessGatewayDo != null) {
                runAccessGatewayDo.setRunStatus(runAccessGatewayRunStatusUpdateRequest.getRunStatus());
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                this.runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = this.runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RunAccessGatewayRunStatusUpdateResponse      : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end updateRunAccessGatewayRunStatus <<<<<<<< ");
        }
        return response;
    }

    public RunAccessGatewayOpsInfoUpdateResponse updateRunAccessGatewayOpsInfo(RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start updateRunAccessGatewayOpsInfo >>>>>>> ");
            this.logger.debug(" RunAccessGatewayOpsInfoUpdateRequest     : " + JsonConvertUtils.convertToString((Object)runAccessGatewayOpsInfoUpdateRequest));
        }
        RunAccessGatewayOpsInfoUpdateResponse response = new RunAccessGatewayOpsInfoUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayOpsInfoUpdateRequest.getDevAccessId();
        if (devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = (RunAccessGatewayDo)this.runAccessGatewayDao.get(devAccessId);
            if (runAccessGatewayDo != null) {
                if (StringUtils.isNotBlank((CharSequence)runAccessGatewayOpsInfoUpdateRequest.getRunParam())) {
                    runAccessGatewayDo.setRunParam(runAccessGatewayOpsInfoUpdateRequest.getRunParam());
                }
                if (StringUtils.isNotBlank((CharSequence)runAccessGatewayOpsInfoUpdateRequest.getRunClientIp())) {
                    runAccessGatewayDo.setRunClientIp(runAccessGatewayOpsInfoUpdateRequest.getRunClientIp());
                }
                if (ObjectUtils.isNotNull((Object)runAccessGatewayOpsInfoUpdateRequest.getRunClientPort())) {
                    runAccessGatewayDo.setRunClientPort(runAccessGatewayOpsInfoUpdateRequest.getRunClientPort());
                }
                if (StringUtils.isNotBlank((CharSequence)runAccessGatewayOpsInfoUpdateRequest.getRunServerIp())) {
                    runAccessGatewayDo.setRunServerIp(runAccessGatewayOpsInfoUpdateRequest.getRunServerIp());
                }
                if (ObjectUtils.isNotNull((Object)runAccessGatewayOpsInfoUpdateRequest.getRunServerPort())) {
                    runAccessGatewayDo.setRunServerPort(runAccessGatewayOpsInfoUpdateRequest.getRunServerPort());
                }
                if (StringUtils.isNotBlank((CharSequence)runAccessGatewayOpsInfoUpdateRequest.getRunServerApn())) {
                    runAccessGatewayDo.setRunServerApn(runAccessGatewayOpsInfoUpdateRequest.getRunServerApn());
                }
                if (StringUtils.isNotBlank((CharSequence)runAccessGatewayOpsInfoUpdateRequest.getSoftwareVer())) {
                    runAccessGatewayDo.setSoftwareVer(runAccessGatewayOpsInfoUpdateRequest.getSoftwareVer());
                }
                if (StringUtils.isNotBlank((CharSequence)runAccessGatewayOpsInfoUpdateRequest.getHardwareVer())) {
                    runAccessGatewayDo.setHardwareVer(runAccessGatewayOpsInfoUpdateRequest.getHardwareVer());
                }
                if (ObjectUtils.isNotNull((Object)runAccessGatewayOpsInfoUpdateRequest.getGmtConnectedAt())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtConnectedAt(runAccessGatewayOpsInfoUpdateRequest.getGmtConnectedAt().longValue());
                }
                if (ObjectUtils.isNotNull((Object)runAccessGatewayOpsInfoUpdateRequest.getGmtHeartbeatUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtHeartbeatUp(runAccessGatewayOpsInfoUpdateRequest.getGmtHeartbeatUp().longValue());
                }
                if (ObjectUtils.isNotNull((Object)runAccessGatewayOpsInfoUpdateRequest.getGmtMessageUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtMessageUp(runAccessGatewayOpsInfoUpdateRequest.getGmtMessageUp().longValue());
                }
                if (ObjectUtils.isNotNull((Object)runAccessGatewayOpsInfoUpdateRequest.getGmtMeasdataUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtMeasdataUp(runAccessGatewayOpsInfoUpdateRequest.getGmtMeasdataUp().longValue());
                }
                if (ObjectUtils.isNotNull((Object)runAccessGatewayOpsInfoUpdateRequest.getGmtAlarmUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtAlarmUp(runAccessGatewayOpsInfoUpdateRequest.getGmtAlarmUp().longValue());
                }
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                this.runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = this.runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RunAccessGatewayOpsInfoUpdateResponse        : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end updateRunAccessGatewayOpsInfo <<<<<<<< ");
        }
        return response;
    }

    public RunAccessGatewayOfflineSetResponse setRunAccessGatewayOffline(RunAccessGatewayOfflineSetRequest runAccessGatewayOfflineSetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start setRunAccessGatewayOffline >>>>>>> ");
            this.logger.debug(" RunAccessGatewayOfflineSetRequest        : " + JsonConvertUtils.convertToString((Object)runAccessGatewayOfflineSetRequest));
        }
        RunAccessGatewayOfflineSetResponse response = new RunAccessGatewayOfflineSetResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayOfflineSetRequest.getDevAccessId();
        if (devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = (RunAccessGatewayDo)this.runAccessGatewayDao.get(devAccessId);
            if (runAccessGatewayDo != null) {
                runAccessGatewayDo.setOnline(false);
                runAccessGatewayDo.setGmtOffline(runAccessGatewayOfflineSetRequest.getGmtOffline());
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                this.runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = this.runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RunAccessGatewayOfflineSetResponse       : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end setRunAccessGatewayOffline <<<<<<<< ");
        }
        return response;
    }

    public RunAccessGatewayAddToOrgResponse addToOrgRunAccessGateway(RunAccessGatewayAddToOrgRequest runAccessGatewayAddToOrgRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start addToOrgRunAccessGateway >>>>>>> ");
            this.logger.debug(" RunAccessGatewayAddToOrgRequest          : " + JsonConvertUtils.convertToString((Object)runAccessGatewayAddToOrgRequest));
        }
        RunAccessGatewayAddToOrgResponse response = new RunAccessGatewayAddToOrgResponse();
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RunAccessGatewayAddToOrgResponse         : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end addToOrgRunAccessGateway <<<<<<<< ");
        }
        return response;
    }

    public RunAccessGatewayDeleteFromOrgResponse deleteFromOrgRunAccessGateway(RunAccessGatewayDeleteFromOrgRequest runAccessGatewayDeleteFromOrgRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start deleteFromOrgRunAccessGateway >>>>>>> ");
            this.logger.debug(" RunAccessGatewayDeleteFromOrgRequest     : " + JsonConvertUtils.convertToString((Object)runAccessGatewayDeleteFromOrgRequest));
        }
        RunAccessGatewayDeleteFromOrgResponse response = new RunAccessGatewayDeleteFromOrgResponse();
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RunAccessGatewayDeleteFromOrgResponse    : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end deleteFromOrgRunAccessGateway <<<<<<<< ");
        }
        return response;
    }

    public RunAccessGatewayQueryResponse queryRunAccessGateway(RunAccessGatewayQueryRequest queryRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start queryRunAccessGateway >>>>>>> ");
            this.logger.debug(" RunAccessGatewayQueryRequest     : " + JsonConvertUtils.convertToString((Object)queryRequest));
        }
        RunAccessGatewayQueryResponse queryResponse = new RunAccessGatewayQueryResponse();
        queryResponse.setReturnCode("FAILURE");
        queryResponse.setFailureCode("-1");
        Set devAccessIdSet = queryRequest.getDevAccessIdSet();
        Set orgNoSet = queryRequest.getOrgNoSet();
        Set devAccessSortNoSet = queryRequest.getDevAccessSortNoSet();
        Set devAccessNoSet = queryRequest.getDevAccessNoSet();
        Set productKeySet = queryRequest.getProductKeySet();
        Set clientIdSet = queryRequest.getClientIdSet();
        HashMap params = Maps.newHashMap();
        if (devAccessIdSet != null && devAccessIdSet.size() > 0) {
            params.put("devAccessId", devAccessIdSet.iterator().next());
        } else if (orgNoSet != null && orgNoSet.size() > 0) {
            params.put("orgNo", orgNoSet.iterator().next());
        } else if (devAccessSortNoSet != null && devAccessSortNoSet.size() > 0) {
            params.put("devAccessSortNo", devAccessSortNoSet.iterator().next());
        } else if (devAccessNoSet != null && devAccessNoSet.size() > 0) {
            params.put("devAccessNo", devAccessNoSet.iterator().next());
        } else if (productKeySet != null && productKeySet.size() > 0) {
            params.put("productKey", productKeySet.iterator().next());
        } else if (clientIdSet != null && clientIdSet.size() > 0) {
            params.put("clientId", clientIdSet.iterator().next());
        }
        int runAccessGatewayVoCount = this.runAccessGatewayDao.getRunAccessGatewayVoCount(params);
        List<RunAccessGatewayVo> runAccessGatewayVoList = this.runAccessGatewayDao.getRunAccessGatewayVoList(params, null, null);
        queryResponse.setReturnCode("SUCCESS");
        queryResponse.setFailureCode(null);
        queryResponse.setRunAccessGatewayCount(runAccessGatewayVoCount);
        queryResponse.setRunAccessGatewayList(runAccessGatewayVoList);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RunAccessGatewayQueryResponse    : " + JsonConvertUtils.convertToString((Object)queryResponse));
            this.logger.debug(" <<<<<<<< end queryRunAccessGateway <<<<<<<< ");
        }
        return queryResponse;
    }

    public RunMeasPointGetResponse getRunMeasPoint(RunMeasPointGetRequest getRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRunMeasPoint >>>>>>> ");
            this.logger.debug(" RunMeasPointGetRequest       : " + JsonConvertUtils.convertToString((Object)getRequest));
        }
        RunMeasPointGetResponse getResponse = new RunMeasPointGetResponse();
        getResponse.setReturnCode("FAILURE");
        getResponse.setFailureCode("-1");
        Long measPointId = getRequest.getMeasPointId();
        if (measPointId != null && measPointId > 0L) {
            RunMeasPointVo runMeasPointVo = this.runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunMeasPoint(runMeasPointVo);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RunMeasPointGetResponse      : " + JsonConvertUtils.convertToString((Object)getResponse));
            this.logger.debug(" <<<<<<<< end getRunMeasPoint <<<<<<<< ");
        }
        return getResponse;
    }

    public RunMeasPointNameAndDescUpdateResponse updateRunMeasPointNameAndDesc(RunMeasPointNameAndDescUpdateRequest runMeasPointNameAndDescUpdateRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start updateRunMeasPointNameAndDesc >>>>>>> ");
            this.logger.debug(" RunMeasPointNameAndDescUpdateRequest     : " + JsonConvertUtils.convertToString((Object)runMeasPointNameAndDescUpdateRequest));
        }
        RunMeasPointNameAndDescUpdateResponse response = new RunMeasPointNameAndDescUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long measPointId = runMeasPointNameAndDescUpdateRequest.getMeasPointId();
        if (measPointId != null && measPointId > 0L) {
            RunMeasPointDo runMeasPointDo = (RunMeasPointDo)this.runMeasPointDao.get(measPointId);
            if (runMeasPointDo != null && runMeasPointDo.getAccessMeasureId() != null && runMeasPointDo.getAccessMeasureId() > 0L) {
                Long accessMeasureId = runMeasPointDo.getAccessMeasureId();
                DevAccessDo devAccessDo = (DevAccessDo)this.devAccessDao.get(accessMeasureId);
                if (devAccessDo != null && StringUtils.isNotBlank((CharSequence)runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureName())) {
                    devAccessDo.setDevAccessName(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureName());
                }
                if (devAccessDo != null && StringUtils.isNotBlank((CharSequence)runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureDesc())) {
                    devAccessDo.setDevAccessDesc(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureDesc());
                }
                this.devAccessDao.update(devAccessDo);
            }
            RunMeasPointVo runMeasPointVo = this.runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunMeasPoint(runMeasPointVo);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RunMeasPointNameAndDescUpdateResponse    : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end updateRunMeasPointNameAndDesc <<<<<<<< ");
        }
        return response;
    }

    public RunMeasPointOpsInfoUpdateResponse updateRunMeasPointOpsInfo(RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start updateRunMeasPointOpsInfo >>>>>>> ");
            this.logger.debug(" RunMeasPointOpsInfoUpdateRequest         : " + JsonConvertUtils.convertToString((Object)runMeasPointOpsInfoUpdateRequest));
        }
        RunMeasPointOpsInfoUpdateResponse response = new RunMeasPointOpsInfoUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long measPointId = runMeasPointOpsInfoUpdateRequest.getMeasPointId();
        if (measPointId != null && measPointId > 0L) {
            RunMeasPointDo runMeasPointDo = (RunMeasPointDo)this.runMeasPointDao.get(measPointId);
            if (runMeasPointDo != null && runMeasPointDo.getAccessMeasureId() != null && runMeasPointDo.getAccessMeasureId() > 0L) {
                if (ObjectUtils.isNotNull((Object)runMeasPointOpsInfoUpdateRequest.getGmtMessageUp())) {
                    runMeasPointDo.setGmtMessageUp(runMeasPointOpsInfoUpdateRequest.getGmtMessageUp().longValue());
                }
                if (ObjectUtils.isNotNull((Object)runMeasPointOpsInfoUpdateRequest.getGmtMeasdataUp())) {
                    runMeasPointDo.setGmtMeasdataUp(runMeasPointOpsInfoUpdateRequest.getGmtMeasdataUp().longValue());
                }
                if (ObjectUtils.isNotNull((Object)runMeasPointOpsInfoUpdateRequest.getGmtAlarmUp())) {
                    runMeasPointDo.setGmtAlarmUp(runMeasPointOpsInfoUpdateRequest.getGmtAlarmUp().longValue());
                }
                runMeasPointDo.setGmtModified(System.currentTimeMillis());
                this.runMeasPointDao.update(runMeasPointDo);
            }
            RunMeasPointVo runMeasPointVo = this.runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunMeasPoint(runMeasPointVo);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" RunMeasPointOpsInfoUpdateResponse        : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end updateRunMeasPointOpsInfo <<<<<<<< ");
        }
        return response;
    }

    public RunMeasPointOpsInfoBatchUpdateResponse batchUpdateRunMeasPointOpsInfo(RunMeasPointOpsInfoBatchUpdateRequest runMeasPointOpsInfoBatchUpdateRequest) {
        RunMeasPointOpsInfoBatchUpdateResponse response = new RunMeasPointOpsInfoBatchUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        ArrayList<RunMeasPointVo> runMeasPointList = new ArrayList<RunMeasPointVo>();
        for (Long measPointId : runMeasPointOpsInfoBatchUpdateRequest.getMeasPointIdList()) {
            if (measPointId <= 0L) continue;
            RunMeasPointDo runMeasPointDo = (RunMeasPointDo)this.runMeasPointDao.get(measPointId);
            if (runMeasPointDo != null && runMeasPointDo.getAccessMeasureId() != null && runMeasPointDo.getAccessMeasureId() > 0L) {
                if (ObjectUtils.isNotNull((Object)runMeasPointOpsInfoBatchUpdateRequest.getGmtMessageUp())) {
                    runMeasPointDo.setGmtMessageUp(runMeasPointOpsInfoBatchUpdateRequest.getGmtMessageUp().longValue());
                }
                if (ObjectUtils.isNotNull((Object)runMeasPointOpsInfoBatchUpdateRequest.getGmtMeasdataUp())) {
                    runMeasPointDo.setGmtMeasdataUp(runMeasPointOpsInfoBatchUpdateRequest.getGmtMeasdataUp().longValue());
                }
                if (ObjectUtils.isNotNull((Object)runMeasPointOpsInfoBatchUpdateRequest.getGmtAlarmUp())) {
                    runMeasPointDo.setGmtAlarmUp(runMeasPointOpsInfoBatchUpdateRequest.getGmtAlarmUp().longValue());
                }
                runMeasPointDo.setGmtModified(System.currentTimeMillis());
                this.runMeasPointDao.update(runMeasPointDo);
            }
            RunMeasPointVo runMeasPointVo = this.runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            runMeasPointList.add(runMeasPointVo);
        }
        response.setReturnCode("SUCCESS");
        response.setFailureCode(null);
        response.setRunMeasPointList(runMeasPointList);
        return response;
    }

    @Transactional(rollbackFor={Exception.class})
    public RunAccessGatewayRunStatusUpdateResponse brushMeter(String mac, String key) {
        RunAccessGatewayRunStatusUpdateResponse response = new RunAccessGatewayRunStatusUpdateResponse();
        List<RunMeasPointVo> runMeasPointDoList = this.runMeasPointDao.getRunMeasPointListBySn(mac, null);
        if (CollectionUtils.isEmpty(runMeasPointDoList)) {
            return null;
        }
        long now = System.currentTimeMillis();
        long id = this.iotDeviceIdGenerator.nextId();
        DevAccessDo devAccessDoOld = (DevAccessDo)this.devAccessDao.get(runMeasPointDoList.get(0).getAccessMeasureId());
        DevAccessDo devAccessDo = new DevAccessDo();
        devAccessDo.setId(Long.valueOf(id));
        devAccessDo.setOrgNo(runMeasPointDoList.get(0).getOrgNo());
        devAccessDo.setDevAccessSortNo("HEPSTD-PV-METER");
        devAccessDo.setDevAccessNo(mac + "-" + key);
        devAccessDo.setDevAccessName(key);
        devAccessDo.setDevAccessDesc(key);
        devAccessDo.setDevAccessDetail("{}");
        devAccessDo.setGateway(false);
        devAccessDo.setTrunking(false);
        devAccessDo.setMeasure(true);
        devAccessDo.setLifeState("03");
        devAccessDo.setMfrCode("HEPSTD");
        devAccessDo.setModelCode("HEPSTD-PV-INVERTER");
        devAccessDo.setSortSn(1);
        devAccessDo.setValid(true);
        devAccessDo.setGmtCreate(now);
        devAccessDo.setGmtModified(now);
        devAccessDo.setGmtInvalid(0L);
        devAccessDo.setVersion(devAccessDoOld.getVersion() + 1);
        this.devAccessDao.insert(devAccessDo);
        DevAccessMeasureDo devAccessMeasureDoOld = (DevAccessMeasureDo)this.devAccessMeasureDao.get(runMeasPointDoList.get(0).getAccessMeasureId());
        DevAccessMeasureDo devAccessMeasureDo = new DevAccessMeasureDo();
        devAccessMeasureDo.setId(Long.valueOf(id));
        devAccessMeasureDo.setMeasCommMode("RS485");
        devAccessMeasureDo.setMeasCommAddr(key);
        devAccessMeasureDo.setMeasCommProto("MODBUS-RTU");
        devAccessMeasureDo.setEnableElec(true);
        devAccessMeasureDo.setVersion(devAccessMeasureDoOld.getVersion() + 1);
        this.devAccessMeasureDao.insert(devAccessMeasureDo);
        RunMeasPointDo runMeasPointDo = new RunMeasPointDo();
        runMeasPointDo.setId(Long.valueOf(this.iotDeviceIdGenerator.nextId()));
        runMeasPointDo.setOrgNo(runMeasPointDoList.get(0).getOrgNo());
        runMeasPointDo.setAccessMeasureId(Long.valueOf(id));
        runMeasPointDo.setAccessTrunkingId(Long.valueOf(0L));
        runMeasPointDo.setAccessGatewayId(runMeasPointDoList.get(0).getAccessGatewayId());
        runMeasPointDo.setMeasKind(0);
        runMeasPointDo.setMeasSn(0);
        runMeasPointDo.setMeasCommMode("RS485");
        runMeasPointDo.setMeasCommAddr(key);
        runMeasPointDo.setMeasCommProto("MODBUS-RTU");
        runMeasPointDo.setMeasCommPort(0);
        runMeasPointDo.setGmtMessageUp(now);
        runMeasPointDo.setGmtMeasdataUp(now);
        runMeasPointDo.setGmtAlarmUp(0L);
        runMeasPointDo.setGmtCreate(now);
        runMeasPointDo.setGmtModified(now);
        runMeasPointDo.setVersion(runMeasPointDoList.get(0).getVersion() + 1);
        this.runMeasPointDao.insert(runMeasPointDo);
        RunMeasPointChangeLogDo runMeasPointChangeLogDo = new RunMeasPointChangeLogDo();
        org.springframework.beans.BeanUtils.copyProperties((Object)runMeasPointDo, (Object)runMeasPointChangeLogDo);
        runMeasPointChangeLogDo.setSn(mac);
        this.runMeasPointDao.insertRunMeasPointLog(runMeasPointChangeLogDo);
        response.setReturnCode("SUCCESS");
        response.setFailureCode(null);
        this.logger.info("\u7ec8\u7aef\u5730\u5740\uff1a " + mac + " \u4e09\u5f20\u8868\u5237\u65b0\u6210\u529f");
        return response;
    }

    public RunMeasPointListResponse getRunMeasPointListBySn(String sn) {
        List<RunMeasPointVo> runMeasPointDoList = this.runMeasPointDao.getRunMeasPointListBySn(sn, "1");
        RunMeasPointListResponse runMeasPointListResponse = new RunMeasPointListResponse();
        runMeasPointListResponse.setRunMeasPointList(runMeasPointDoList);
        return runMeasPointListResponse;
    }

    public BrushMeterResponse addTermMeter(String devTermNo, String devMeterNo) {
        this.logger.info("\u88c5\u63a5\u7ec8\u7aef\u8868\u8ba1====\u300b\u7ec8\u7aef\u5730\u5740\uff1a " + devTermNo + " \u6dfb\u52a0\u8868\u8ba1\u5730\u5740\uff1a " + devMeterNo);
        RunMeasPointListResponse runMeasPointListResponse = this.getRunMeasPointListBySn(devTermNo);
        List runMeasPointList = runMeasPointListResponse.getRunMeasPointList();
        List measCommAddrList = runMeasPointList.stream().filter(runMeasPointVo -> runMeasPointVo.getMeasCommAddr().equals(devMeterNo)).collect(Collectors.toList());
        BrushMeterResponse brushMeterResponse = new BrushMeterResponse();
        if (CollectionUtils.isEmpty(measCommAddrList)) {
            List<RunMeasPointVo> runMeasPointDoList = this.runMeasPointDao.getRunMeasPointListBySn(devTermNo, null);
            if (CollectionUtils.isEmpty(runMeasPointDoList)) {
                return null;
            }
            long now = System.currentTimeMillis();
            long id = this.iotDeviceIdGenerator.nextId();
            DevAccessDo devAccessDoOld = (DevAccessDo)this.devAccessDao.get(runMeasPointDoList.get(0).getAccessMeasureId());
            DevAccessDo devAccessDo = new DevAccessDo();
            devAccessDo.setId(Long.valueOf(id));
            devAccessDo.setOrgNo(runMeasPointDoList.get(0).getOrgNo());
            devAccessDo.setDevAccessSortNo("HEPSTD-PV-METER");
            devAccessDo.setDevAccessNo(devTermNo + "-" + devMeterNo);
            devAccessDo.setDevAccessName(devMeterNo);
            devAccessDo.setDevAccessDesc(devMeterNo);
            devAccessDo.setDevAccessDetail("{}");
            devAccessDo.setGateway(false);
            devAccessDo.setTrunking(false);
            devAccessDo.setMeasure(true);
            devAccessDo.setLifeState("03");
            devAccessDo.setMfrCode("HEPSTD");
            devAccessDo.setModelCode("HEPSTD-PV-INVERTER");
            devAccessDo.setSortSn(1);
            devAccessDo.setValid(true);
            devAccessDo.setGmtCreate(now);
            devAccessDo.setGmtModified(now);
            devAccessDo.setGmtInvalid(0L);
            devAccessDo.setVersion(devAccessDoOld == null ? 1 : devAccessDoOld.getVersion() + 1);
            this.devAccessDao.insert(devAccessDo);
            DevAccessMeasureDo devAccessMeasureDoOld = (DevAccessMeasureDo)this.devAccessMeasureDao.get(runMeasPointDoList.get(0).getAccessMeasureId());
            DevAccessMeasureDo devAccessMeasureDo = new DevAccessMeasureDo();
            devAccessMeasureDo.setId(Long.valueOf(id));
            devAccessMeasureDo.setMeasCommMode("RS485");
            devAccessMeasureDo.setMeasCommAddr(devMeterNo);
            devAccessMeasureDo.setMeasCommProto("MODBUS-RTU");
            devAccessMeasureDo.setEnableElec(true);
            devAccessMeasureDo.setVersion(devAccessMeasureDoOld.getVersion() + 1);
            this.devAccessMeasureDao.insert(devAccessMeasureDo);
            RunMeasPointDo runMeasPointDo = new RunMeasPointDo();
            runMeasPointDo.setId(Long.valueOf(this.iotDeviceIdGenerator.nextId()));
            runMeasPointDo.setOrgNo(runMeasPointDoList.get(0).getOrgNo());
            runMeasPointDo.setAccessMeasureId(Long.valueOf(id));
            runMeasPointDo.setAccessTrunkingId(Long.valueOf(0L));
            runMeasPointDo.setAccessGatewayId(runMeasPointDoList.get(0).getAccessGatewayId());
            runMeasPointDo.setMeasKind(0);
            runMeasPointDo.setMeasSn(0);
            runMeasPointDo.setMeasCommMode("RS485");
            runMeasPointDo.setMeasCommAddr(devMeterNo);
            runMeasPointDo.setMeasCommProto("MODBUS-RTU");
            runMeasPointDo.setMeasCommPort(0);
            runMeasPointDo.setGmtMessageUp(now);
            runMeasPointDo.setGmtMeasdataUp(now);
            runMeasPointDo.setGmtAlarmUp(0L);
            runMeasPointDo.setGmtCreate(now);
            runMeasPointDo.setGmtModified(now);
            runMeasPointDo.setVersion(runMeasPointDoList.get(0).getVersion() + 1);
            this.runMeasPointDao.insert(runMeasPointDo);
            RunMeasPointChangeLogDo runMeasPointChangeLogDo = new RunMeasPointChangeLogDo();
            org.springframework.beans.BeanUtils.copyProperties((Object)runMeasPointDo, (Object)runMeasPointChangeLogDo);
            runMeasPointChangeLogDo.setSn(devTermNo);
            this.runMeasPointDao.insertRunMeasPointLog(runMeasPointChangeLogDo);
            this.logger.info("\u7ec8\u7aef\u5730\u5740\uff1a " + devTermNo + " \u4e09\u5f20\u8868\u5237\u65b0\u6210\u529f");
            brushMeterResponse.setRunMeasPointId(runMeasPointDo.getId());
            brushMeterResponse.setAccessMeasureId(runMeasPointDo.getAccessMeasureId());
            this.logger.info("\u88c5\u63a5\u6210\u529f\u8fd4\u56de=============>" + JSONObject.toJSONString((Object)brushMeterResponse));
            return brushMeterResponse;
        }
        brushMeterResponse.setRunMeasPointId(((RunMeasPointVo)measCommAddrList.get(0)).getId());
        brushMeterResponse.setAccessMeasureId(((RunMeasPointVo)measCommAddrList.get(0)).getAccessMeasureId());
        this.logger.info("\u88c5\u63a5\u6210\u529f\u8fd4\u56de=============>" + JSONObject.toJSONString((Object)brushMeterResponse));
        return brushMeterResponse;
    }

    public void delTermMeter(Long runMeasPointId) {
        this.logger.info("\u5220\u9664\u8868\u8ba1\uff1a" + runMeasPointId);
        if (runMeasPointId == 0L) {
            return;
        }
        RunMeasPointDo runMeasPointDo = (RunMeasPointDo)this.runMeasPointDao.get(runMeasPointId);
        DevAccessDo devAccessDo = new DevAccessDo();
        devAccessDo.setId(runMeasPointDo.getAccessMeasureId());
        this.devAccessDao.delete(devAccessDo);
        DevAccessMeasureDo devAccessMeasureDo = new DevAccessMeasureDo();
        devAccessMeasureDo.setId(runMeasPointDo.getAccessMeasureId());
        this.devAccessMeasureDao.delete(devAccessMeasureDo);
        this.runMeasPointDao.delete(runMeasPointDo);
    }

    public void editMeter(EditMeterRequest editMeterRequest) {
        this.logger.info("\u4fee\u6539\u8868\u8ba1\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)editMeterRequest));
        Long runMeasPointId = editMeterRequest.getRunMeasPointId();
        RunMeasPointVo runMeasPointVo = this.runMeasPointDao.getRunMeasPointVoByMeasPointId(runMeasPointId);
        if (runMeasPointVo == null) {
            return;
        }
        Long accessMeasureId = runMeasPointVo.getAccessMeasureId();
        DevAccessDo devAccessDoOld = (DevAccessDo)this.devAccessDao.get(accessMeasureId);
        DevAccessMeasureDo oldDevAccessMeasureDo = (DevAccessMeasureDo)this.devAccessMeasureDao.get(accessMeasureId);
        LinkedHashMap newEntityMap = Maps.newLinkedHashMap();
        DevAccessDo newDevAccessDo = null;
        DevAccessMeasureDo newDevAccessMeasureDo = null;
        try {
            newDevAccessDo = (DevAccessDo)BeanUtils.cloneBean((Object)devAccessDoOld);
            newDevAccessMeasureDo = (DevAccessMeasureDo)BeanUtils.cloneBean((Object)oldDevAccessMeasureDo);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.error(e.getMessage(), e.fillInStackTrace());
        }
        String orgNo = editMeterRequest.getOrgNo();
        String measCommAddrTerm = runMeasPointVo.getMeasCommAddr();
        String measCommAddr = editMeterRequest.getMeasCommAddr();
        String measCommMode = editMeterRequest.getMeasCommMode();
        String measCommProto = editMeterRequest.getMeasCommProto();
        if (newDevAccessDo != null) {
            if (StringUtils.isNotBlank((CharSequence)orgNo)) {
                newDevAccessDo.setOrgNo(orgNo);
            }
            if (StringUtils.isNotBlank((CharSequence)measCommAddr)) {
                newDevAccessDo.setDevAccessNo(measCommAddrTerm + "-" + measCommAddr);
                newDevAccessDo.setDevAccessName(measCommAddr);
                newDevAccessDo.setDevAccessDesc(measCommAddr);
            }
            newDevAccessDo.setGmtModified(System.currentTimeMillis());
            newDevAccessDo.setVersion(newDevAccessDo.getSortSn() + 1);
            this.devAccessDao.update(newDevAccessDo);
            newEntityMap.put("devAccess", newDevAccessDo);
        }
        if (newDevAccessMeasureDo != null) {
            if (StringUtils.isNotBlank((CharSequence)measCommAddr)) {
                newDevAccessMeasureDo.setMeasCommAddr(measCommAddr);
            }
            if (StringUtils.isNotBlank((CharSequence)measCommMode)) {
                newDevAccessMeasureDo.setMeasCommMode(measCommMode);
            }
            if (StringUtils.isNotBlank((CharSequence)measCommProto)) {
                newDevAccessMeasureDo.setMeasCommProto(measCommProto);
            }
            this.devAccessMeasureDao.update(newDevAccessMeasureDo);
            newEntityMap.put("devAccessMeasure", newDevAccessMeasureDo);
        }
        LinkedHashMap oldEntityMap = Maps.newLinkedHashMap();
        oldEntityMap.put("devAccess", devAccessDoOld);
        oldEntityMap.put("devAccessMeasure", oldDevAccessMeasureDo);
        LogDevAccessEntityDo logDevAccessEntity = new LogDevAccessEntityDo();
        logDevAccessEntity.setId(Long.valueOf(this.iotDeviceIdGenerator.nextId()));
        logDevAccessEntity.setLogType(4);
        logDevAccessEntity.setDevAccessId(accessMeasureId);
        logDevAccessEntity.setOldEntity(JsonConvertUtils.convertToString((Object)oldEntityMap, (PropertyNamingStrategy)PropertyNamingStrategy.SNAKE_CASE));
        logDevAccessEntity.setNewEntity(JsonConvertUtils.convertToString((Object)newEntityMap, (PropertyNamingStrategy)PropertyNamingStrategy.SNAKE_CASE));
        logDevAccessEntity.setAlterPathway("PC_WEBAPP");
        logDevAccessEntity.setAlterOper("editMeterAdmin");
        logDevAccessEntity.setGmtAlter(System.currentTimeMillis());
        this.logDevAccessEntityDao.insertLog(logDevAccessEntity);
        this.runMeasPointDao.editMeter(editMeterRequest);
    }

    @Transactional(rollbackFor={Exception.class})
    public RunMeasPointListResponse sync(List<SyncRequest> syncRequests) {
        RunMeasPointListResponse runMeasPointListResponse = new RunMeasPointListResponse();
        ArrayList<RunMeasPointVo> runMeasPointList = new ArrayList<RunMeasPointVo>();
        for (SyncRequest syncRequest : syncRequests) {
            RunMeasPointVo runMeasPointVo = this.runMeasPointDao.selectByGatewayIdMeterNo(syncRequest.getDevMeterNo(), syncRequest.getAccessGatewayId());
            if (runMeasPointVo != null) {
                if (runMeasPointVo.getMeasSn() != syncRequest.getMeasSn() || !runMeasPointVo.getMeasCommProto().equals(syncRequest.getMeasCommProto())) {
                    RunMeasPointDo runMeasPointDo = new RunMeasPointDo();
                    runMeasPointDo.setId(runMeasPointVo.getId());
                    runMeasPointDo.setMeasSn(syncRequest.getMeasSn());
                    runMeasPointDo.setMeasCommProto(syncRequest.getMeasCommProto());
                    this.runMeasPointDao.update(runMeasPointDo);
                    runMeasPointVo.setMeasSn(syncRequest.getMeasSn());
                    runMeasPointVo.setMeasCommProto(syncRequest.getMeasCommProto());
                }
                runMeasPointList.add(runMeasPointVo);
                continue;
            }
            long now = System.currentTimeMillis();
            long id = this.iotDeviceIdGenerator.nextId();
            String mac = syncRequest.getDevTermNo();
            String key = syncRequest.getDevMeterNo();
            String orgNo = syncRequest.getOrgNo();
            DevAccessDo devAccessDo = new DevAccessDo();
            devAccessDo.setId(Long.valueOf(id));
            devAccessDo.setOrgNo(orgNo);
            devAccessDo.setDevAccessSortNo("HEPSTD-PV-METER");
            devAccessDo.setDevAccessNo(mac + "-" + key);
            devAccessDo.setDevAccessName(key);
            devAccessDo.setDevAccessDesc(key);
            devAccessDo.setDevAccessDetail("{}");
            devAccessDo.setGateway(false);
            devAccessDo.setTrunking(false);
            devAccessDo.setMeasure(true);
            devAccessDo.setLifeState("03");
            devAccessDo.setMfrCode("HEPSTD");
            devAccessDo.setModelCode("HEPSTD-PV-INVERTER");
            devAccessDo.setSortSn(1);
            devAccessDo.setValid(true);
            devAccessDo.setGmtCreate(now);
            devAccessDo.setGmtModified(now);
            devAccessDo.setGmtInvalid(0L);
            devAccessDo.setVersion(1);
            this.devAccessDao.insert(devAccessDo);
            DevAccessMeasureDo devAccessMeasureDo = new DevAccessMeasureDo();
            devAccessMeasureDo.setId(Long.valueOf(id));
            devAccessMeasureDo.setMeasCommMode("RS485");
            devAccessMeasureDo.setMeasCommAddr(key);
            devAccessMeasureDo.setMeasCommProto(syncRequest.getMeasCommProto());
            devAccessMeasureDo.setEnableElec(true);
            devAccessMeasureDo.setVersion(1);
            this.devAccessMeasureDao.insert(devAccessMeasureDo);
            RunMeasPointDo runMeasPointDo = new RunMeasPointDo();
            runMeasPointDo.setId(Long.valueOf(this.iotDeviceIdGenerator.nextId()));
            runMeasPointDo.setOrgNo(orgNo);
            runMeasPointDo.setAccessMeasureId(Long.valueOf(id));
            runMeasPointDo.setAccessTrunkingId(Long.valueOf(0L));
            runMeasPointDo.setAccessGatewayId(syncRequest.getAccessGatewayId());
            runMeasPointDo.setMeasKind(0);
            runMeasPointDo.setMeasSn(syncRequest.getMeasSn());
            runMeasPointDo.setMeasCommMode("RS485");
            runMeasPointDo.setMeasCommAddr(key);
            runMeasPointDo.setMeasCommProto(syncRequest.getMeasCommProto());
            runMeasPointDo.setMeasCommPort(0);
            runMeasPointDo.setGmtMessageUp(now);
            runMeasPointDo.setGmtMeasdataUp(now);
            runMeasPointDo.setGmtAlarmUp(0L);
            runMeasPointDo.setGmtCreate(now);
            runMeasPointDo.setGmtModified(now);
            runMeasPointDo.setVersion(1);
            this.runMeasPointDao.insert(runMeasPointDo);
            org.springframework.beans.BeanUtils.copyProperties((Object)runMeasPointDo, (Object)runMeasPointVo);
            runMeasPointList.add(runMeasPointVo);
        }
        runMeasPointListResponse.setRunMeasPointList(runMeasPointList);
        runMeasPointListResponse.setReturnCode("SUCCESS");
        return runMeasPointListResponse;
    }
}

