/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.easesource.iot.datacenter.openservice.dao.MeasDataCumFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataInsFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataLatestSynchronizerDao;
import com.easesource.iot.datacenter.openservice.entity.GmDevMeterSynchronizerDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestVo;
import com.easesource.iot.datacenter.openservice.util.DataWarehouse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="measDataStoreService")
public class MeasDataStoreServiceImpl
extends AbstractBaseService
implements MeasDataStoreService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private MeasDataCumFreezeCurveDao measDataCumFreezeCurveDao;
    @Resource
    private MeasDataInsFreezeCurveDao measDataInsFreezeCurveDao;
    @Resource
    private MeasDataLatestSynchronizerDao measDataLatestSynchronizerDao;
    @Resource
    private DataWarehouse dataWarehouse;

    public void updateMeasDataLatest(Long measPointId, String measItemCode, Map<String, Object> measDataInfo) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start updateMeasDataLatest >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
            this.logger.debug(" measDataInfo     : " + JsonConvertUtils.convertToString(measDataInfo));
        }
        MeasDataLatestVo measDataLatestVo = DataWarehouse.getMeasDataLatest(measPointId, measItemCode);
        GmDevMeterSynchronizerDo gmDevMeterSynchronizerDo = this.measDataLatestSynchronizerDao.getRate(measPointId);
        if (measDataLatestVo == null) {
            measDataLatestVo = new MeasDataLatestVo();
            measDataLatestVo.setId(Long.valueOf(this.iotDataIdGenerator.nextId()));
            if (gmDevMeterSynchronizerDo != null) {
                measDataLatestVo.setSelfRate(gmDevMeterSynchronizerDo.getSelfRate());
                measDataLatestVo.setCtRate(gmDevMeterSynchronizerDo.getCtRate());
                measDataLatestVo.setPtRate(gmDevMeterSynchronizerDo.getPtRate());
            }
            measDataLatestVo.setGmtCreate(System.currentTimeMillis());
        }
        if (gmDevMeterSynchronizerDo != null) {
            measDataLatestVo.setSelfRate(gmDevMeterSynchronizerDo.getSelfRate());
            measDataLatestVo.setCtRate(gmDevMeterSynchronizerDo.getCtRate());
            measDataLatestVo.setPtRate(gmDevMeterSynchronizerDo.getPtRate());
        }
        measDataLatestVo.setMeasPointId(measPointId);
        measDataLatestVo.setMeasItemCode(measItemCode);
        measDataLatestVo.setMeasDataInfo(JsonConvertUtils.convertToString(measDataInfo));
        measDataLatestVo.setGmtModified(System.currentTimeMillis());
        DataWarehouse.updateMeasDataLatest(measDataLatestVo);
    }

    public void batchUpdateMeasDataLatest(Map<Long, Map<String, Map<String, Object>>> batchMeasDataInfosMap) {
        if (batchMeasDataInfosMap == null) {
            return;
        }
        HashMap batchmap = Maps.newHashMap();
        Set<Long> measPointIdSet = batchMeasDataInfosMap.keySet();
        HashSet measItemCodeSet = Sets.newHashSet();
        for (Long measPointId : batchMeasDataInfosMap.keySet()) {
            Map<String, Map<String, Object>> insideMap = batchMeasDataInfosMap.get(measPointId);
            if (insideMap == null) continue;
            for (String measItemCode : insideMap.keySet()) {
                measItemCodeSet.add(measItemCode);
                Map<String, Object> measDataInfo = insideMap.get(measItemCode);
                if (measDataInfo == null) continue;
                batchmap.put(measPointId + "#" + measItemCode, measDataInfo);
            }
        }
        List<Object> measDataLatestDoList = Lists.newArrayList();
        if (measPointIdSet.size() > 0 && measItemCodeSet.size() > 0) {
            measDataLatestDoList = DataWarehouse.getListByMeasPointIdSetAndMeasItemCodeSet(measPointIdSet, measItemCodeSet);
        }
        ArrayList results = Lists.newArrayList();
        HashMap batchmap2 = Maps.newHashMap();
        if (measDataLatestDoList != null) {
            measDataLatestDoList.forEach(measDataLatestDo -> batchmap2.put(measDataLatestDo.getMeasPointId() + "#" + measDataLatestDo.getMeasItemCode(), measDataLatestDo));
        }
        batchmap.forEach((k, v) -> {
            if (batchmap2.size() == 0) {
                String[] ss = k.split("#");
                MeasDataLatestDo md = null;
                if (ss.length == 2) {
                    md = new MeasDataLatestDo();
                    md.setId(Long.valueOf(this.iotDataIdGenerator.nextId()));
                    md.setMeasPointId(Long.valueOf(ss[0]));
                    md.setMeasItemCode(ss[1]);
                    md.setMeasDataInfo(JsonConvertUtils.convertToString((Object)v));
                    md.setGmtCreate(System.currentTimeMillis());
                    md.setGmtModified(System.currentTimeMillis());
                }
                if (md != null) {
                    results.add(md);
                }
            } else {
                MeasDataLatestDo md = (MeasDataLatestDo)batchmap2.get(k);
                if (md != null) {
                    md.setMeasDataInfo(JsonConvertUtils.convertToString((Object)v));
                    md.setGmtModified(System.currentTimeMillis());
                } else {
                    String[] ss = k.split("#");
                    if (ss.length == 2) {
                        md = new MeasDataLatestDo();
                        md.setId(Long.valueOf(this.iotDataIdGenerator.nextId()));
                        md.setMeasPointId(Long.valueOf(ss[0]));
                        md.setMeasItemCode(ss[1]);
                        md.setMeasDataInfo(JsonConvertUtils.convertToString((Object)v));
                        md.setGmtCreate(System.currentTimeMillis());
                        md.setGmtModified(System.currentTimeMillis());
                    }
                }
                if (md != null) {
                    results.add(md);
                }
            }
        });
        if (results.size() > 0) {
            for (MeasDataLatestDo latestDo : results) {
                this.dataWarehouse.insertmeasLatest(latestDo);
            }
        }
    }

    public void deleteMeasDataLatest(Long measPointId, String measItemCode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start deleteMeasDataLatest >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
        }
        DataWarehouse.deleteByMeasPointIdAndMeasItemCode(measPointId, measItemCode);
    }

    public void insertOrUpdateMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start insertOrUpdateMeasDataCumFreezeCurve >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
            this.logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasFreeze), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" measDataValue    : " + measDataValue);
            this.logger.debug(" measDataRate     : " + measDataRate);
            this.logger.debug(" measDataSource   : " + measDataSource);
            this.logger.debug(" gmtMeasData      : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasData), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" freezeMode       : " + freezeMode);
        }
        MeasDataCumFreezeCurveDo measDataCumFreezeCurveDo = new MeasDataCumFreezeCurveDo();
        measDataCumFreezeCurveDo.setId(Long.valueOf(this.iotDataIdGenerator.nextId()));
        measDataCumFreezeCurveDo.setMeasPointId(measPointId);
        measDataCumFreezeCurveDo.setMeasItemCode(measItemCode);
        measDataCumFreezeCurveDo.setGmtMeasFreeze(gmtMeasFreeze);
        measDataCumFreezeCurveDo.setMeasDataValue(measDataValue);
        measDataCumFreezeCurveDo.setMeasDataRate(measDataRate);
        measDataCumFreezeCurveDo.setMeasDataSource(measDataSource);
        measDataCumFreezeCurveDo.setGmtMeasData(gmtMeasData);
        measDataCumFreezeCurveDo.setFreezeMode(freezeMode);
        measDataCumFreezeCurveDo.setGmtCreate(System.currentTimeMillis());
        measDataCumFreezeCurveDo.setGmtModified(System.currentTimeMillis());
        this.measDataCumFreezeCurveDao.insert(measDataCumFreezeCurveDo);
    }

    public void batchInsertOrUpdateMeasDataCumFreezeCurve(List<MeasDataCumFreezeCurveDo> measDataCumFreezeCurveDoList) {
        ArrayList results = Lists.newArrayList();
        measDataCumFreezeCurveDoList.forEach(m -> {
            if (m.getId() == null || m.getId() == 0L) {
                m.setId(Long.valueOf(this.iotDataIdGenerator.nextId()));
                results.add(m);
            }
        });
        this.measDataCumFreezeCurveDao.batchInsertOrUpdate(results);
    }

    public void deleteMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze) {
    }

    public void deleteMeasDataCumFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd) {
        if (gmtMeasFreeze == 0L || gmtMeasFreezeEnd == 0L || gmtMeasFreezeEnd < gmtMeasFreeze) {
            return;
        }
        this.logger.info("\u5f00\u59cb\u5220\u9664\u4efb\u52a1>>>>>>>>>>" + JSONObject.toJSONString(measPointIds));
        this.measDataCumFreezeCurveDao.deleteByMeasPointIdAndGmtMeasFreeze(measPointIds, gmtMeasFreeze, gmtMeasFreezeEnd);
    }

    public void insertOrUpdateMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start insertOrUpdateMeasDataInsFreezeCurve >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
            this.logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasFreeze), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" measDataValue    : " + measDataValue);
            this.logger.debug(" measDataRate     : " + measDataRate);
            this.logger.debug(" measDataSource   : " + measDataSource);
            this.logger.debug(" gmtMeasData      : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasData), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" freezeMode       : " + freezeMode);
        }
        MeasDataInsFreezeCurveDo measDataInsFreezeCurveDo = new MeasDataInsFreezeCurveDo();
        measDataInsFreezeCurveDo.setId(Long.valueOf(this.iotDataIdGenerator.nextId()));
        measDataInsFreezeCurveDo.setMeasPointId(measPointId);
        measDataInsFreezeCurveDo.setMeasItemCode(measItemCode);
        measDataInsFreezeCurveDo.setGmtMeasFreeze(gmtMeasFreeze);
        measDataInsFreezeCurveDo.setMeasDataValue(measDataValue);
        measDataInsFreezeCurveDo.setMeasDataRate(measDataRate);
        measDataInsFreezeCurveDo.setMeasDataSource(measDataSource);
        measDataInsFreezeCurveDo.setGmtMeasData(gmtMeasData);
        measDataInsFreezeCurveDo.setFreezeMode(freezeMode);
        measDataInsFreezeCurveDo.setGmtCreate(System.currentTimeMillis());
        measDataInsFreezeCurveDo.setGmtModified(System.currentTimeMillis());
        this.measDataInsFreezeCurveDao.insert(measDataInsFreezeCurveDo);
    }

    public void batchInsertOrUpdateMeasDataInsFreezeCurve(List<MeasDataInsFreezeCurveDo> measDataInsFreezeCurveDoList) {
        ArrayList results = Lists.newArrayList();
        measDataInsFreezeCurveDoList.forEach(m -> {
            if (m.getId() == null || m.getId() == 0L) {
                m.setId(Long.valueOf(this.iotDataIdGenerator.nextId()));
                results.add(m);
            }
        });
        this.measDataInsFreezeCurveDao.batchInsertOrUpdate(results);
    }

    public void deleteMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze) {
    }

    public void deleteMeasDataInsFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd) {
        if (gmtMeasFreeze == 0L || gmtMeasFreezeEnd == 0L || gmtMeasFreezeEnd < gmtMeasFreeze) {
            return;
        }
        this.logger.info("\u5f00\u59cb\u5220\u9664\u4efb\u52a1>>>>>>>>>>" + JSONObject.toJSONString(measPointIds));
        this.measDataInsFreezeCurveDao.deleteByMeasPointIdAndGmtMeasFreeze(measPointIds, gmtMeasFreeze, gmtMeasFreezeEnd);
    }
}

