package com.easesource.iot.datacenter.openservice.tablestore;

import com.alicloud.openservices.tablestore.ClientConfiguration;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author Nick
 */
public class TableStoreSource implements Serializable {

    private static final long serialVersionUID = -5711636877577658704L;
    private String endPoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String instanceName;
    private ClientConfiguration clientConfiguration;

    public String getEndPoint() {
        return endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public String getAccessKeyId() {
        return accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getInstanceName() {
        return instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public ClientConfiguration getClientConfiguration() {
        return clientConfiguration;
    }

    public void setClientConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public String toString() {
        return "TableStoreSource{" +
            "endPoint='" + endPoint + '\'' +
            ", accessKeyId='" + accessKeyId + '\'' +
            ", accessKeySecret='" + accessKeySecret + '\'' +
            ", instanceName='" + instanceName + '\'' +
            ", clientConfiguration=" + clientConfiguration +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) {
            return true;
        }
        if(o == null || getClass() != o.getClass()) {
            return false;
        }
        TableStoreSource that = (TableStoreSource) o;
        return Objects.equals(endPoint, that.endPoint) &&
            Objects.equals(accessKeyId, that.accessKeyId) &&
            Objects.equals(accessKeySecret, that.accessKeySecret) &&
            Objects.equals(instanceName, that.instanceName) &&
            Objects.equals(clientConfiguration, that.clientConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(endPoint, accessKeyId, accessKeySecret, instanceName, clientConfiguration);
    }
}
