/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.tablestore;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.BatchWriteRowResponse;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.DeleteRowResponse;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.PutRowResponse;
import com.alicloud.openservices.tablestore.model.UpdateRowRequest;
import com.alicloud.openservices.tablestore.model.UpdateRowResponse;
import com.easesource.iot.datacenter.openservice.tablestore.TableStoreOperations;
import com.easesource.iot.datacenter.openservice.tablestore.TableStoreSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreTemplate
implements TableStoreOperations {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SyncClient syncClient;
    private final AsyncClient asyncClient;
    private final TableStoreSource tablestoreSource;

    public TableStoreTemplate(TableStoreSource tablestoreSource) {
        this.syncClient = new SyncClient(tablestoreSource.getEndPoint(), tablestoreSource.getAccessKeyId(), tablestoreSource.getAccessKeySecret(), tablestoreSource.getInstanceName(), tablestoreSource.getClientConfiguration());
        this.asyncClient = new AsyncClient(tablestoreSource.getEndPoint(), tablestoreSource.getAccessKeyId(), tablestoreSource.getAccessKeySecret(), tablestoreSource.getInstanceName(), tablestoreSource.getClientConfiguration());
        this.tablestoreSource = tablestoreSource;
    }

    public SyncClient getSyncClient() {
        return this.syncClient;
    }

    public AsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    public TableStoreSource getTablestoreSource() {
        return this.tablestoreSource;
    }

    @Override
    public PutRowResponse putRowSync(PutRowRequest putRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.putRow(putRowRequest);
    }

    @Override
    public GetRowResponse getRowSync(GetRowRequest getRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.getRow(getRowRequest);
    }

    @Override
    public UpdateRowResponse updateRowSync(UpdateRowRequest updateRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.updateRow(updateRowRequest);
    }

    @Override
    public DeleteRowResponse deleteRowSync(DeleteRowRequest deleteRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.deleteRow(deleteRowRequest);
    }

    @Override
    public BatchGetRowResponse batchGetRowSync(BatchGetRowRequest batchGetRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.batchGetRow(batchGetRowRequest);
    }

    @Override
    public BatchWriteRowResponse batchWriteRowSync(BatchWriteRowRequest batchWriteRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.batchWriteRow(batchWriteRowRequest);
    }

    @Override
    public GetRangeResponse getRangeSync(GetRangeRequest getRangeRequest) throws TableStoreException, ClientException {
        return this.syncClient.getRange(getRangeRequest);
    }
}

