/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.tablestore.dao.impl;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.easesource.commons.util.DateUtils;
import com.easesource.commons.util.NumberUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveValue;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;
import com.easesource.iot.datacenter.openservice.tablestore.AbstractEaseIotBaseTableStoreDao;
import com.easesource.iot.datacenter.openservice.tablestore.TableStoreTemplate;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataInsFreezeCurveDao;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class MeasDataInsFreezeCurveDaoImpl
extends AbstractEaseIotBaseTableStoreDao
implements MeasDataInsFreezeCurveDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="easeIotTableStoreTemplate")
    private TableStoreTemplate easeIotTableStoreTemplate;
    @Qualifier(value="easeIotJdbcTemplate")
    @Resource(name="easeIotJdbcTemplate")
    private JdbcTemplate easeIotJdbcTemplate;

    @Override
    public int updateMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        String partKey = Joiner.on((char)'_').skipNulls().join((Object)DateConvertUtils.convertToString((long)gmtMeasFreeze, (String)"yyyy"), (Object)measPointId, new Object[0]);
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("part_key", PrimaryKeyValue.fromString((String)partKey));
        primaryKeyBuilder.addPrimaryKeyColumn("meas_point_id", PrimaryKeyValue.fromLong((long)measPointId));
        primaryKeyBuilder.addPrimaryKeyColumn("meas_item_code", PrimaryKeyValue.fromString((String)measItemCode));
        primaryKeyBuilder.addPrimaryKeyColumn("gmt_meas_freeze", PrimaryKeyValue.fromLong((long)gmtMeasFreeze));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowPutChange rowPutChange = new RowPutChange("meas_data_ins_freeze_curve", primaryKey);
        rowPutChange.addColumn(new Column("meas_data_value", ColumnValue.fromDouble((double)measDataValue.doubleValue()), System.currentTimeMillis()));
        rowPutChange.addColumn(new Column("meas_data_rate", ColumnValue.fromDouble((double)measDataRate.doubleValue()), System.currentTimeMillis()));
        rowPutChange.addColumn(new Column("meas_data_source", ColumnValue.fromLong((long)measDataSource), System.currentTimeMillis()));
        rowPutChange.addColumn(new Column("gmt_meas_data", ColumnValue.fromLong((long)gmtMeasData), System.currentTimeMillis()));
        rowPutChange.addColumn(new Column("freeze_mode", ColumnValue.fromLong((long)freezeMode), System.currentTimeMillis()));
        PutRowRequest putRowRequest = new PutRowRequest(rowPutChange);
        this.easeIotTableStoreTemplate.putRowSync(putRowRequest);
        return 1;
    }

    @Override
    public int deleteMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze) {
        String partKey = Joiner.on((char)'_').skipNulls().join((Object)DateConvertUtils.convertToString((long)gmtMeasFreeze, (String)"yyyy"), (Object)measPointId, new Object[0]);
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("part_key", PrimaryKeyValue.fromString((String)partKey));
        primaryKeyBuilder.addPrimaryKeyColumn("meas_point_id", PrimaryKeyValue.fromLong((long)measPointId));
        primaryKeyBuilder.addPrimaryKeyColumn("meas_item_code", PrimaryKeyValue.fromString((String)measItemCode));
        primaryKeyBuilder.addPrimaryKeyColumn("gmt_meas_freeze", PrimaryKeyValue.fromLong((long)gmtMeasFreeze));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowDeleteChange rowDeleteChange = new RowDeleteChange("meas_data_ins_freeze_curve", primaryKey);
        DeleteRowRequest deleteRowRequest = new DeleteRowRequest(rowDeleteChange);
        this.easeIotTableStoreTemplate.deleteRowSync(deleteRowRequest);
        return 1;
    }

    @Override
    public int batchUpdateMeasDataInsFreezeCurve(Long measPointId, Map<String, MeasDataLatestInfo> measDataLatestInfoMap, long gmtMeasFreeze, int freezeMode) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, MeasDataInsFreezeCurveValue> getMeasDataInsFreezeCurveValueMap(Long measPointId, Set<String> measItemCodeSet, long gmtMeasFreeze, Integer measDataSideType) {
        BigDecimal ptRate;
        BigDecimal ctRate;
        BigDecimal selfRate;
        Map gdmMap;
        SqlParamsBuilder sqlParamsBuilder = new SqlParamsBuilder();
        sqlParamsBuilder.append("SELECT gdm.meas_point_id, gdm.self_rate, gdm.ct_rate, gdm.pt_rate ");
        sqlParamsBuilder.append(" FROM iesms.gm_dev_meter gdm ");
        sqlParamsBuilder.append(" WHERE gdm.meas_point_id = ? ", (Object)measPointId);
        sqlParamsBuilder.append(" LIMIT 1 ");
        try {
            gdmMap = (Map)this.easeIotJdbcTemplate.queryForObject(sqlParamsBuilder.getSql(), sqlParamsBuilder.getParams(), this.mapRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            gdmMap = null;
        }
        BigDecimal bigDecimal = selfRate = gdmMap != null ? (BigDecimal)gdmMap.get("self_rate") : new BigDecimal("1.0");
        if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
            selfRate = new BigDecimal("1.0");
        }
        BigDecimal bigDecimal2 = ctRate = gdmMap != null ? (BigDecimal)gdmMap.get("ct_rate") : new BigDecimal("1.0");
        if (ctRate == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
            ctRate = new BigDecimal("1.0");
        }
        BigDecimal bigDecimal3 = ptRate = gdmMap != null ? (BigDecimal)gdmMap.get("pt_rate") : new BigDecimal("1.0");
        if (ptRate == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
            ptRate = new BigDecimal("1.0");
        }
        HashMap measDataInsFreezeCurveValueMap = Maps.newHashMap();
        ArrayList measItemCodeList = Lists.newArrayList(measItemCodeSet);
        List listList = Lists.partition((List)measItemCodeList, (int)100);
        for (List list : listList) {
            HashSet measItemCodeSetTemp = Sets.newHashSet((Iterable)list);
            MultiRowQueryCriteria multiRowQueryCriteria = new MultiRowQueryCriteria("meas_data_ins_freeze_curve");
            for (String measItemCode : measItemCodeSetTemp) {
                if (!StringUtils.isNotBlank((CharSequence)measItemCode)) continue;
                String partKey = Joiner.on((char)'_').skipNulls().join((Object)DateConvertUtils.convertToString((long)gmtMeasFreeze, (String)"yyyy"), (Object)measPointId, new Object[0]);
                try {
                    PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
                    primaryKeyBuilder.addPrimaryKeyColumn("part_key", PrimaryKeyValue.fromString((String)partKey));
                    primaryKeyBuilder.addPrimaryKeyColumn("meas_point_id", PrimaryKeyValue.fromLong((long)measPointId));
                    primaryKeyBuilder.addPrimaryKeyColumn("meas_item_code", PrimaryKeyValue.fromString((String)measItemCode));
                    primaryKeyBuilder.addPrimaryKeyColumn("gmt_meas_freeze", PrimaryKeyValue.fromLong((long)gmtMeasFreeze));
                    PrimaryKey primaryKey = primaryKeyBuilder.build();
                    multiRowQueryCriteria.addRow(primaryKey);
                }
                catch (Exception _e) {
                    this.logger.error(_e.getMessage(), _e.fillInStackTrace());
                }
            }
            if (multiRowQueryCriteria.isEmpty()) {
                return measDataInsFreezeCurveValueMap;
            }
            multiRowQueryCriteria.setMaxVersions(1);
            multiRowQueryCriteria.addColumnsToGet(Arrays.asList("meas_data_value", "meas_data_rate", "meas_data_source", "gmt_meas_data", "freeze_mode"));
            BatchGetRowRequest batchGetRowRequest = new BatchGetRowRequest();
            batchGetRowRequest.addMultiRowQueryCriteria(multiRowQueryCriteria);
            BatchGetRowResponse batchGetRowResponse = null;
            try {
                batchGetRowResponse = this.easeIotTableStoreTemplate.batchGetRowSync(batchGetRowRequest);
                List rowResults = batchGetRowResponse.getBatchGetRowResult("meas_data_ins_freeze_curve");
                if (rowResults == null || rowResults.size() <= 0) continue;
                for (BatchGetRowResponse.RowResult rowResult : rowResults) {
                    MeasDataInsFreezeCurveValue measDataInsFreezeCurveValue;
                    if (rowResult.isSucceed()) {
                        MeasDataInsFreezeCurveValue measDataInsFreezeCurveValue2;
                        Row row = rowResult.getRow();
                        if (row == null || (measDataInsFreezeCurveValue2 = this.row2MeasDataInsFreezeCurveValue(row, measDataSideType, selfRate, ctRate, ptRate)) == null || !StringUtils.isNotBlank((CharSequence)measDataInsFreezeCurveValue2.getMeasItemCode())) continue;
                        measDataInsFreezeCurveValueMap.put(measDataInsFreezeCurveValue2.getMeasItemCode(), measDataInsFreezeCurveValue2);
                        continue;
                    }
                    PrimaryKey primaryKey = batchGetRowRequest.getPrimaryKey(rowResult.getTableName(), rowResult.getIndex());
                    if (primaryKey == null) continue;
                    SingleRowQueryCriteria criteria = new SingleRowQueryCriteria("meas_data_ins_freeze_curve", primaryKey);
                    criteria.setMaxVersions(1);
                    criteria.addColumnsToGet(Arrays.asList("meas_point_id", "meas_item_code", "meas_data_value", "meas_data_rate", "meas_data_source", "gmt_meas_data", "freeze_mode"));
                    GetRowRequest getRowRequest = new GetRowRequest(criteria);
                    GetRowResponse getRowResponse = this.easeIotTableStoreTemplate.getRowSync(getRowRequest);
                    Row row = getRowResponse.getRow();
                    if (row == null || (measDataInsFreezeCurveValue = this.row2MeasDataInsFreezeCurveValue(row, measDataSideType, selfRate, ctRate, ptRate)) == null || !StringUtils.isNotBlank((CharSequence)measDataInsFreezeCurveValue.getMeasItemCode())) continue;
                    measDataInsFreezeCurveValueMap.put(measDataInsFreezeCurveValue.getMeasItemCode(), measDataInsFreezeCurveValue);
                }
            }
            catch (ClientException | TableStoreException e) {
                this.logger.error(e.getMessage(), e.fillInStackTrace());
            }
            finally {
                if (batchGetRowResponse == null) continue;
                batchGetRowResponse = null;
            }
        }
        return measDataInsFreezeCurveValueMap;
    }

    @Override
    public Map<String, List<MeasDataInsFreezeCurveValue>> getRangeMeasDataInsFreezeCurveValueMap(Long measPointId, Set<String> measItemCodeSet, long gmtMeasFreezeStart, long gmtMeasFreezeEnd, Integer measDataSideType) {
        BigDecimal ptRate;
        BigDecimal ctRate;
        BigDecimal selfRate;
        Map gdmMap;
        if (gmtMeasFreezeStart >= gmtMeasFreezeEnd) {
            this.logger.warn("gmtMeasFreezeStart must be less than gmtMeasFreezeEnd.");
            return Maps.newHashMap();
        }
        int gmtMeasFreezeStartYear = DateUtils.getYear((Date)new Date(gmtMeasFreezeStart));
        int gmtMeasFreezeEndYear = DateUtils.getYear((Date)new Date(gmtMeasFreezeEnd));
        ArrayList gmtMeasFreezeStartList = Lists.newArrayList();
        ArrayList gmtMeasFreezeEndList = Lists.newArrayList();
        if (gmtMeasFreezeStartYear == gmtMeasFreezeEndYear) {
            gmtMeasFreezeStartList.add(gmtMeasFreezeStart);
            gmtMeasFreezeEndList.add(gmtMeasFreezeEnd);
        } else if (gmtMeasFreezeStartYear + 1 == gmtMeasFreezeEndYear) {
            gmtMeasFreezeStartList.add(gmtMeasFreezeStart);
            gmtMeasFreezeEndList.add(DateUtils.addMillis((Date)DateConvertUtils.convertFromString((String)Joiner.on((char)'-').join((Object)DateConvertUtils.convertToString((long)gmtMeasFreezeEnd, (String)"yyyy"), (Object)"01", new Object[]{"01"}), (String[])DateConvertUtils.PATTERNS_DATE), (int)-1).getTime());
            gmtMeasFreezeStartList.add(DateConvertUtils.convertFromString((String)Joiner.on((char)'-').join((Object)DateConvertUtils.convertToString((long)gmtMeasFreezeEnd, (String)"yyyy"), (Object)"01", new Object[]{"01"}), (String[])DateConvertUtils.PATTERNS_DATE).getTime());
            gmtMeasFreezeEndList.add(gmtMeasFreezeEnd);
        } else {
            this.logger.warn("gmtMeasFreezeStart ~ gmtMeasFreezeEnd is not beyond two years.");
            return Maps.newHashMap();
        }
        SqlParamsBuilder sqlParamsBuilder = new SqlParamsBuilder();
        sqlParamsBuilder.append("SELECT gdm.meas_point_id, gdm.self_rate, gdm.ct_rate, gdm.pt_rate ");
        sqlParamsBuilder.append(" FROM iesms.gm_dev_meter gdm ");
        sqlParamsBuilder.append(" WHERE gdm.meas_point_id = ? ", (Object)measPointId);
        sqlParamsBuilder.append(" LIMIT 1 ");
        try {
            gdmMap = (Map)this.easeIotJdbcTemplate.queryForObject(sqlParamsBuilder.getSql(), sqlParamsBuilder.getParams(), this.mapRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            gdmMap = null;
        }
        BigDecimal bigDecimal = selfRate = gdmMap != null ? (BigDecimal)gdmMap.get("self_rate") : new BigDecimal("1.0");
        if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
            selfRate = new BigDecimal("1.0");
        }
        BigDecimal bigDecimal2 = ctRate = gdmMap != null ? (BigDecimal)gdmMap.get("ct_rate") : new BigDecimal("1.0");
        if (ctRate == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
            ctRate = new BigDecimal("1.0");
        }
        BigDecimal bigDecimal3 = ptRate = gdmMap != null ? (BigDecimal)gdmMap.get("pt_rate") : new BigDecimal("1.0");
        if (ptRate == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
            ptRate = new BigDecimal("1.0");
        }
        HashMap rangeMeasDataInsFreezeCurveValueMap = Maps.newHashMap();
        for (String measItemCode : measItemCodeSet) {
            if (!StringUtils.isNotBlank((CharSequence)measItemCode)) continue;
            ArrayList results = Lists.newArrayList();
            for (int i = 0; i < gmtMeasFreezeStartList.size(); ++i) {
                results.addAll(this.getMeasDataInsFreezeCurveValueList(measPointId, measItemCode, (Long)gmtMeasFreezeStartList.get(i), (Long)gmtMeasFreezeEndList.get(i), measDataSideType, selfRate, ctRate, ptRate));
            }
            rangeMeasDataInsFreezeCurveValueMap.put(measItemCode, results);
        }
        return rangeMeasDataInsFreezeCurveValueMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MeasDataInsFreezeCurveValue> getMeasDataInsFreezeCurveValueList(Long measPointId, String measItemCode, long gmtMeasFreezeStart, long gmtMeasFreezeEnd, Integer measDataSideType, BigDecimal selfRate, BigDecimal ctRate, BigDecimal ptRate) {
        int gmtMeasFreezeEndYear;
        int gmtMeasFreezeStartYear = DateUtils.getYear((Date)new Date(gmtMeasFreezeStart));
        if (gmtMeasFreezeStartYear != (gmtMeasFreezeEndYear = DateUtils.getYear((Date)new Date(gmtMeasFreezeEnd)))) {
            this.logger.warn("gmtMeasFreezeStart ~ gmtMeasFreezeEnd must be the same year.");
            return Lists.newArrayList();
        }
        String startPartKey = Joiner.on((char)'_').skipNulls().join((Object)DateConvertUtils.convertToString((long)gmtMeasFreezeStart, (String)"yyyy"), (Object)measPointId, new Object[0]);
        String endPartKey = Joiner.on((char)'_').skipNulls().join((Object)DateConvertUtils.convertToString((long)gmtMeasFreezeEnd, (String)"yyyy"), (Object)measPointId, new Object[0]);
        RangeRowQueryCriteria rangeRowQueryCriteria = new RangeRowQueryCriteria("meas_data_ins_freeze_curve");
        rangeRowQueryCriteria.setMaxVersions(1);
        rangeRowQueryCriteria.setInclusiveStartPrimaryKey(this.createMeasDataInsFreezeCurvePrimaryKey(startPartKey, measPointId, measItemCode, gmtMeasFreezeStart));
        rangeRowQueryCriteria.setExclusiveEndPrimaryKey(this.createMeasDataInsFreezeCurvePrimaryKey(endPartKey, measPointId, measItemCode, gmtMeasFreezeEnd));
        rangeRowQueryCriteria.addColumnsToGet(Arrays.asList("meas_data_value", "meas_data_rate", "meas_data_source", "gmt_meas_data", "freeze_mode"));
        ArrayList results = Lists.newArrayList();
        GetRangeResponse getRangeResponse = null;
        try {
            while (true) {
                getRangeResponse = this.easeIotTableStoreTemplate.getRangeSync(new GetRangeRequest(rangeRowQueryCriteria));
                for (Row row : getRangeResponse.getRows()) {
                    results.add(this.row2MeasDataInsFreezeCurveValue(row, measDataSideType, selfRate, ctRate, ptRate));
                }
                if (getRangeResponse.getNextStartPrimaryKey() != null) {
                    rangeRowQueryCriteria.setInclusiveStartPrimaryKey(getRangeResponse.getNextStartPrimaryKey());
                    continue;
                }
                break;
            }
        }
        catch (ClientException | TableStoreException e) {
            this.logger.error(e.getMessage(), e.fillInStackTrace());
        }
        finally {
            if (getRangeResponse != null) {
                getRangeResponse = null;
            }
        }
        return results;
    }

    private PrimaryKey createMeasDataInsFreezeCurvePrimaryKey(String partKey, Long measPointId, String measItemCode, long gmtMeasFreeze) {
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("part_key", PrimaryKeyValue.fromString((String)partKey));
        primaryKeyBuilder.addPrimaryKeyColumn("meas_point_id", PrimaryKeyValue.fromLong((long)measPointId));
        primaryKeyBuilder.addPrimaryKeyColumn("meas_item_code", PrimaryKeyValue.fromString((String)measItemCode));
        primaryKeyBuilder.addPrimaryKeyColumn("gmt_meas_freeze", PrimaryKeyValue.fromLong((long)gmtMeasFreeze));
        return primaryKeyBuilder.build();
    }

    private MeasDataInsFreezeCurveValue row2MeasDataInsFreezeCurveValue(Row row, Integer measDataSideType, BigDecimal selfRate, BigDecimal ctRate, BigDecimal ptRate) {
        PrimaryKey primaryKey;
        MeasDataInsFreezeCurveValue measDataInsFreezeCurveValue = null;
        if (row != null && (primaryKey = row.getPrimaryKey()) != null) {
            Column freezeModeCol;
            Column gmtMeasDataCol;
            Column measDataSourceCol;
            Column measDataRateCol;
            PrimaryKeyColumn measPointIdCol = primaryKey.getPrimaryKeyColumn("meas_point_id");
            PrimaryKeyColumn measItemCodeCol = primaryKey.getPrimaryKeyColumn("meas_item_code");
            PrimaryKeyColumn gmtMeasFreezeCol = primaryKey.getPrimaryKeyColumn("gmt_meas_freeze");
            Long measPointId = measPointIdCol.getValue().asLong();
            String measItemCode = measItemCodeCol.getValue().asString();
            long gmtMeasFreeze = gmtMeasFreezeCol.getValue().asLong();
            measDataInsFreezeCurveValue = new MeasDataInsFreezeCurveValue();
            measDataInsFreezeCurveValue.setMeasPointId(measPointId);
            measDataInsFreezeCurveValue.setMeasItemCode(measItemCode);
            measDataInsFreezeCurveValue.setGmtMeasFreeze(gmtMeasFreeze);
            Column measDataValueCol = row.getLatestColumn("meas_data_value");
            if (measDataValueCol != null) {
                BigDecimal measDataValue = new BigDecimal(String.valueOf(measDataValueCol.getValue().asDouble())).setScale(8, 6);
                if (measDataSideType != null && measDataSideType == 1) {
                    if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus"})) {
                        measDataValue = measDataValue.multiply(selfRate).multiply(ptRate).setScale(6, 4);
                    } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus"})) {
                        measDataValue = measDataValue.multiply(selfRate).multiply(ctRate).setScale(6, 4);
                    } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus"})) {
                        measDataValue = measDataValue.multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, 4);
                    }
                }
                measDataInsFreezeCurveValue.setMeasDataValue(measDataValue);
                measDataInsFreezeCurveValue.setGmtCreate(measDataValueCol.getTimestamp());
                measDataInsFreezeCurveValue.setGmtModified(measDataValueCol.getTimestamp());
            }
            if ((measDataRateCol = row.getLatestColumn("meas_data_rate")) != null) {
                measDataInsFreezeCurveValue.setMeasDataRate(new BigDecimal(String.valueOf(measDataRateCol.getValue().asDouble())).setScale(8, 6));
            }
            if ((measDataSourceCol = row.getLatestColumn("meas_data_source")) != null) {
                measDataInsFreezeCurveValue.setMeasDataSource(NumberUtils.toInt((String)String.valueOf(measDataSourceCol.getValue().asLong()), (int)0));
            }
            if ((gmtMeasDataCol = row.getLatestColumn("gmt_meas_data")) != null) {
                long gmtMeasData = gmtMeasDataCol.getValue().asLong();
                measDataInsFreezeCurveValue.setGmtMeasDataReading(gmtMeasData);
            }
            if ((freezeModeCol = row.getLatestColumn("freeze_mode")) != null) {
                int freezeMode = NumberUtils.toInt((String)String.valueOf(freezeModeCol.getValue().asLong()), (int)0);
                measDataInsFreezeCurveValue.setFreezeMode(freezeMode);
            }
        }
        return measDataInsFreezeCurveValue;
    }
}

