package com.easesource.iot.datacenter.openservice.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestVo;
import org.apache.ibatis.annotations.Param;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-08
 */
public interface MeasDataLatest4RdsDao extends CrudMapper<MeasDataLatestDo, Long> {

    /**
     * 通过量测点标识和量测项编码更新量测点最新数据实体
     * @param measDataLatestDo
     *          量测点最新数据实体
     * @return
     *          结果
     */
    int updateByMeasPointIdAndMeasItemCode(MeasDataLatestDo measDataLatestDo);

    /**
     * 通过量测点标识和量测项编码删除量测点最新数据实体
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @return
     *          结果
     */
    int deleteByMeasPointIdAndMeasItemCode(@Param("measPointId") Long measPointId, @Param("measItemCode") String measItemCode);

    /**
     * 通过量测点标识和量测项编码获取量测点最新数据实体
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @return
     *          量测点最新数据实体
     */
    MeasDataLatestDo getByMeasPointIdAndMeasItemCode(@Param("measPointId") Long measPointId, @Param("measItemCode") String measItemCode);

    /**
     * 通过量测点标识和量测项编码获取量测点最新数据视图
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @return
     *          量测点最新数据实体
     */
    MeasDataLatestVo getMeasDataLatestVoByMeasPointIdAndMeasItemCode(@Param("measPointId") Long measPointId, @Param("measItemCode") String measItemCode);

}
