package com.easesource.iot.datacenter.openservice.tablestore;

import com.alicloud.openservices.tablestore.AsyncClient;
import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Nick
 */
public class TableStoreTemplate implements TableStoreOperations {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    private final SyncClient syncClient;
    private final AsyncClient asyncClient;
    private final TableStoreSource tablestoreSource;

    public TableStoreTemplate(TableStoreSource tablestoreSource) {
        this.syncClient = new SyncClient(tablestoreSource.getEndPoint(), tablestoreSource.getAccessKeyId(), tablestoreSource.getAccessKeySecret(), tablestoreSource.getInstanceName(), tablestoreSource.getClientConfiguration());
        this.asyncClient = new AsyncClient(tablestoreSource.getEndPoint(), tablestoreSource.getAccessKeyId(), tablestoreSource.getAccessKeySecret(), tablestoreSource.getInstanceName(), tablestoreSource.getClientConfiguration());
        this.tablestoreSource = tablestoreSource;
    }

    public SyncClient getSyncClient() {
        return syncClient;
    }

    public AsyncClient getAsyncClient() {
        return asyncClient;
    }

    public TableStoreSource getTablestoreSource() {
        return tablestoreSource;
    }

    @Override
    public PutRowResponse putRowSync(PutRowRequest putRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.putRow(putRowRequest);
    }

    @Override
    public GetRowResponse getRowSync(GetRowRequest getRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.getRow(getRowRequest);
    }

    @Override
    public UpdateRowResponse updateRowSync(UpdateRowRequest updateRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.updateRow(updateRowRequest);
    }

    @Override
    public DeleteRowResponse deleteRowSync(DeleteRowRequest deleteRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.deleteRow(deleteRowRequest);
    }

    @Override
    public BatchGetRowResponse batchGetRowSync(BatchGetRowRequest batchGetRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.batchGetRow(batchGetRowRequest);
    }

    @Override
    public BatchWriteRowResponse batchWriteRowSync(BatchWriteRowRequest batchWriteRowRequest) throws TableStoreException, ClientException {
        return this.syncClient.batchWriteRow(batchWriteRowRequest);
    }

    @Override
    public GetRangeResponse getRangeSync(GetRangeRequest getRangeRequest) throws TableStoreException, ClientException {
        return this.syncClient.getRange(getRangeRequest);
    }

}
