/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.tablestore.service.impl;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveValue;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveValue;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;
import com.easesource.iot.datacenter.openservice.request.MeasDataAlarmDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeCurveBatchGetMTPsRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeCurveBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeCurveGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeCurveGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeDayGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeDayGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataInsDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataInsFreezeCurveGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataInsFreezeCurveGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataLatestBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataLatestGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataStateBoolDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataStateCharDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataStatsDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.response.MeasDataAlarmDiscreteGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumDiscreteGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveBatchGetMTPsResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeDayGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeDayGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataInsDiscreteGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataInsFreezeCurveGetRangeListResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataInsFreezeCurveGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataInsFreezeCurveGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataLatestBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataLatestGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataStateBoolDiscreteGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataStateCharDiscreteGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataStatsDiscreteGetRangeResponse;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataCumFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataInsFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataLatestDao;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="measDataService")
public class MeasDataServiceImpl
extends AbstractBaseService
implements MeasDataService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private MeasDataLatestDao measDataLatestDao;
    @Resource
    private MeasDataCumFreezeCurveDao measDataCumFreezeCurveDao;
    @Resource
    private MeasDataInsFreezeCurveDao measDataInsFreezeCurveDao;

    public MeasDataLatestGetResponse getMeasDataLatest(MeasDataLatestGetRequest measDataLatestGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasDataLatest >>>>>>> ");
            this.logger.debug(" MeasDataLatestGetRequest     : " + JsonConvertUtils.convertToString((Object)measDataLatestGetRequest));
        }
        MeasDataLatestGetResponse response = new MeasDataLatestGetResponse();
        Long measPointId = measDataLatestGetRequest.getMeasPointId();
        Set measItemCodeSet = measDataLatestGetRequest.getMeasItemCodeSet();
        Map<String, MeasDataLatestInfo> measDataMap = this.measDataLatestDao.getMeasDataLatestInfoMap(measPointId, measItemCodeSet, measDataLatestGetRequest.getMeasDataSideType());
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataLatestGetResponse    : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasDataLatest <<<<<<<< ");
        }
        return response;
    }

    public MeasDataLatestBatchGetResponse batchGetMeasDataLatest(MeasDataLatestBatchGetRequest measDataLatestBatchGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start batchGetMeasDataLatest >>>>>>> ");
            this.logger.debug(" MeasDataLatestBatchGetRequest    : " + JsonConvertUtils.convertToString((Object)measDataLatestBatchGetRequest));
        }
        MeasDataLatestBatchGetResponse response = new MeasDataLatestBatchGetResponse();
        Set measPointIdSet = measDataLatestBatchGetRequest.getMeasPointIdSet();
        Set measItemCodeSet = measDataLatestBatchGetRequest.getMeasItemCodeSet();
        Map<Long, Map<String, MeasDataLatestInfo>> batchMeasDataMap = this.measDataLatestDao.batchGetMeasDataLatestInfoMap(measPointIdSet, measItemCodeSet, measDataLatestBatchGetRequest.getMeasDataSideType());
        response.setBatchMeasDataMap(batchMeasDataMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataLatestBatchGetResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end batchGetMeasDataLatest <<<<<<<< ");
        }
        return response;
    }

    public MeasDataInsDiscreteGetRangeResponse getRangeMeasDataInsDiscrete(MeasDataInsDiscreteGetRangeRequest measDataInsDiscreteGetRangeRequest) {
        return null;
    }

    public MeasDataInsFreezeCurveGetResponse getMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRequest measDataInsFreezeCurveGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasDataInsFreezeCurve >>>>>>> ");
            this.logger.debug(" MeasDataInsFreezeCurveGetRequest     : " + JsonConvertUtils.convertToString((Object)measDataInsFreezeCurveGetRequest));
        }
        MeasDataInsFreezeCurveGetResponse response = new MeasDataInsFreezeCurveGetResponse();
        Long measPointId = measDataInsFreezeCurveGetRequest.getMeasPointId();
        Set measItemCodeSet = measDataInsFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataInsFreezeCurveGetRequest.getGmtMeasFreeze();
        Map<String, MeasDataInsFreezeCurveValue> measDataMap = this.measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreeze, measDataInsFreezeCurveGetRequest.getMeasDataSideType());
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataInsFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasDataInsFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    public MeasDataInsFreezeCurveGetRangeResponse getRangeMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRangeRequest measDataInsFreezeCurveGetRangeRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRangeMeasDataInsFreezeCurve >>>>>>> ");
            this.logger.debug(" MeasDataInsFreezeCurveGetRangeRequest    : " + JsonConvertUtils.convertToString((Object)measDataInsFreezeCurveGetRangeRequest));
        }
        MeasDataInsFreezeCurveGetRangeResponse response = new MeasDataInsFreezeCurveGetRangeResponse();
        Long measPointId = measDataInsFreezeCurveGetRangeRequest.getMeasPointId();
        Set measItemCodeSet = measDataInsFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        Map<String, List<MeasDataInsFreezeCurveValue>> measDataListMap = this.measDataInsFreezeCurveDao.getRangeMeasDataInsFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreezeStart, gmtMeasFreezeEnd, measDataInsFreezeCurveGetRangeRequest.getMeasDataSideType());
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap(measDataListMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataInsFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getRangeMeasDataInsFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    public MeasDataInsFreezeCurveGetRangeListResponse getRangeMeasDataInsFreezeCurveList(List<MeasDataInsFreezeCurveGetRangeRequest> measDataInsFreezeCurveGetRangeRequest) {
        return null;
    }

    public MeasDataCumDiscreteGetRangeResponse getRangeMeasDataCumDiscrete(MeasDataCumDiscreteGetRangeRequest measDataCumDiscreteGetRangeRequest) {
        return null;
    }

    public MeasDataCumFreezeCurveGetResponse getMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRequest measDataCumFreezeCurveGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasDataCumFreezeCurve >>>>>>> ");
            this.logger.debug(" MeasDataCumFreezeCurveGetRequest     : " + JsonConvertUtils.convertToString((Object)measDataCumFreezeCurveGetRequest));
        }
        MeasDataCumFreezeCurveGetResponse response = new MeasDataCumFreezeCurveGetResponse();
        Long measPointId = measDataCumFreezeCurveGetRequest.getMeasPointId();
        Set measItemCodeSet = measDataCumFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveGetRequest.getGmtMeasFreeze();
        Map<String, MeasDataCumFreezeCurveValue> measDataMap = this.measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreeze, measDataCumFreezeCurveGetRequest.getMeasDataSideType());
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataCumFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    public MeasDataCumFreezeCurveBatchGetResponse batchGetMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetRequest measDataCumFreezeCurveBatchGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start batchGetMeasDataCumFreezeCurve >>>>>>> ");
            this.logger.debug(" MeasDataCumFreezeCurveBatchGetRequest     : " + JsonConvertUtils.convertToString((Object)measDataCumFreezeCurveBatchGetRequest));
        }
        MeasDataCumFreezeCurveBatchGetResponse response = new MeasDataCumFreezeCurveBatchGetResponse();
        Set measPointIdSet = measDataCumFreezeCurveBatchGetRequest.getMeasPointIdSet();
        Set measItemCodeSet = measDataCumFreezeCurveBatchGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveBatchGetRequest.getGmtMeasFreeze();
        HashMap batchMeasDataMap = Maps.newHashMap();
        for (Long measPointId : measPointIdSet) {
            Map<String, MeasDataCumFreezeCurveValue> measDataMap = this.measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreeze, measDataCumFreezeCurveBatchGetRequest.getMeasDataSideType());
            batchMeasDataMap.put(measPointId, measDataMap);
        }
        response.setBatchMeasDataMap((Map)batchMeasDataMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataCumFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    public MeasDataCumFreezeCurveBatchGetMTPsResponse batchGetMTPsMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetMTPsRequest measDataCumFreezeCurveBatchGetMTPsRequest) {
        return null;
    }

    public MeasDataCumFreezeCurveGetRangeResponse getRangeMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRangeRequest measDataCumFreezeCurveGetRangeRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRangeMeasDataCumFreezeCurve >>>>>>> ");
            this.logger.debug(" MeasDataCumFreezeCurveGetRangeRequest    : " + JsonConvertUtils.convertToString((Object)measDataCumFreezeCurveGetRangeRequest));
        }
        MeasDataCumFreezeCurveGetRangeResponse response = new MeasDataCumFreezeCurveGetRangeResponse();
        Long measPointId = measDataCumFreezeCurveGetRangeRequest.getMeasPointId();
        Set measItemCodeSet = measDataCumFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        Map<String, List<MeasDataCumFreezeCurveValue>> measDataListMap = this.measDataCumFreezeCurveDao.getRangeMeasDataCumFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreezeStart, gmtMeasFreezeEnd, measDataCumFreezeCurveGetRangeRequest.getMeasDataSideType());
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap(measDataListMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataCumFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getRangeMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    public MeasDataCumFreezeDayGetResponse getMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRequest measDataCumFreezeDayGetRequest) {
        return null;
    }

    public MeasDataCumFreezeDayGetRangeResponse getRangeMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRangeRequest measDataCumFreezeDayGetRangeRequest) {
        return null;
    }

    public MeasDataStateBoolDiscreteGetRangeResponse getRangeMeasDataStateBoolDiscrete(MeasDataStateBoolDiscreteGetRangeRequest measDataStateBoolDiscreteGetRangeRequest) {
        return null;
    }

    public MeasDataStateCharDiscreteGetRangeResponse getRangeMeasDataStateCharDiscrete(MeasDataStateCharDiscreteGetRangeRequest measDataStateCharDiscreteGetRangeRequest) {
        return null;
    }

    public MeasDataStatsDiscreteGetRangeResponse getRangeMeasDataStatsDiscrete(MeasDataStatsDiscreteGetRangeRequest measDataStatsDiscreteGetRangeRequest) {
        return null;
    }

    public MeasDataAlarmDiscreteGetRangeResponse getRangeMeasDataAlarmDiscrete(MeasDataAlarmDiscreteGetRangeRequest measDataAlarmDiscreteGetRangeRequest) {
        return null;
    }
}

