/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.tablestore.service.impl;

import com.easesource.commons.util.NumberUtils;
import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataCumFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataInsFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataLatestDao;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="measDataStoreService")
public class MeasDataStoreServiceImpl
extends AbstractBaseService
implements MeasDataStoreService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private MeasDataLatestDao measDataLatestDao;
    @Resource
    private MeasDataCumFreezeCurveDao measDataCumFreezeCurveDao;
    @Resource
    private MeasDataInsFreezeCurveDao measDataInsFreezeCurveDao;

    public void updateMeasDataLatest(Long measPointId, String measItemCode, Map<String, Object> measDataInfo) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start updateMeasDataLatest >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
            this.logger.debug(" measDataInfo     : " + JsonConvertUtils.convertToString(measDataInfo));
        }
        if (this.logger.isInfoEnabled() && StringUtils.equals((CharSequence)measItemCode, (CharSequence)"gen_watt_paet")) {
            this.logger.debug(" measPointId  : " + measPointId);
            this.logger.debug(" measItemCode : " + measItemCode);
            this.logger.debug(" measDataInfo : " + JsonConvertUtils.convertToString(measDataInfo));
        }
        int measDataSource = NumberUtils.toInt((String)ObjectUtils.toStringDefaultEmpty((Object)measDataInfo.get("measDataSource")), (int)0);
        long gmtMeasDataLatest = NumberUtils.toLong((String)ObjectUtils.toStringDefaultEmpty((Object)measDataInfo.get("gmtMeasDataLatest")), (long)System.currentTimeMillis());
        int result = this.measDataLatestDao.updateMeasDataInfoLatest(measPointId, measItemCode, measDataInfo, measDataSource, gmtMeasDataLatest);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" updateMeasDataLatest {} ", (Object)(result > 0 ? "success" : "failure"));
            this.logger.debug(" <<<<<<<< end updateMeasDataLatest <<<<<<<< ");
        }
    }

    public void batchUpdateMeasDataLatest(Map<Long, Map<String, Map<String, Object>>> batchMeasDataInfosMap) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start batchUpdateMeasDataLatest >>>>>>> ");
            this.logger.debug(" batchMeasDataInfosMap    : " + JsonConvertUtils.convertToString(batchMeasDataInfosMap));
        }
        int result = this.measDataLatestDao.batchUpdateMeasDataInfoLatest(batchMeasDataInfosMap);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" batchUpdateMeasDataLatest {} ", (Object)(result > 0 ? "success" : "failure"));
            this.logger.debug(" <<<<<<<< end batchUpdateMeasDataLatest <<<<<<<< ");
        }
    }

    public void deleteMeasDataLatest(Long measPointId, String measItemCode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start deleteMeasDataLatest >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
        }
        int result = this.measDataLatestDao.deleteByMeasPointIdAndMeasItemCode(measPointId, measItemCode);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" deleteMeasDataLatest {} ", (Object)(result > 0 ? "success" : "failure"));
            this.logger.debug(" <<<<<<<< end deleteMeasDataLatest <<<<<<<< ");
        }
    }

    public void insertOrUpdateMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start insertOrUpdateMeasDataCumFreezeCurve >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
            this.logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasFreeze), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" measDataValue    : " + measDataValue);
            this.logger.debug(" measDataRate     : " + measDataRate);
            this.logger.debug(" measDataSource   : " + measDataSource);
            this.logger.debug(" gmtMeasData      : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasData), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" freezeMode       : " + freezeMode);
        }
        int result = this.measDataCumFreezeCurveDao.updateMeasDataCumFreezeCurve(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataRate, measDataSource, gmtMeasData, freezeMode);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" insertOrUpdateMeasDataCumFreezeCurve {} ", (Object)(result > 0 ? "success" : "failure"));
            this.logger.debug(" <<<<<<<< end insertOrUpdateMeasDataCumFreezeCurve <<<<<<<< ");
        }
    }

    public void batchInsertOrUpdateMeasDataCumFreezeCurve(List<MeasDataCumFreezeCurveDo> measDataCumFreezeCurveDoList) {
    }

    public void deleteMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start deleteMeasDataCumFreezeCurve >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
            this.logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasFreeze), (String)"yyyyMMddHHmmssSSS"));
        }
        int result = this.measDataCumFreezeCurveDao.deleteMeasDataCumFreezeCurve(measPointId, measItemCode, gmtMeasFreeze);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" deleteMeasDataCumFreezeCurve {} ", (Object)(result > 0 ? "success" : "failure"));
            this.logger.debug(" <<<<<<<< end deleteMeasDataCumFreezeCurve <<<<<<<< ");
        }
    }

    public void deleteMeasDataCumFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd) {
    }

    public void insertOrUpdateMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start insertOrUpdateMeasDataInsFreezeCurve >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
            this.logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasFreeze), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" measDataValue    : " + measDataValue);
            this.logger.debug(" measDataRate     : " + measDataRate);
            this.logger.debug(" measDataSource   : " + measDataSource);
            this.logger.debug(" gmtMeasData      : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasData), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" freezeMode       : " + freezeMode);
        }
        int result = this.measDataInsFreezeCurveDao.updateMeasDataInsFreezeCurve(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataRate, measDataSource, gmtMeasData, freezeMode);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" insertOrUpdateMeasDataInsFreezeCurve {} ", (Object)(result > 0 ? "success" : "failure"));
            this.logger.debug(" <<<<<<<< end insertOrUpdateMeasDataInsFreezeCurve <<<<<<<< ");
        }
    }

    public void batchInsertOrUpdateMeasDataInsFreezeCurve(List<MeasDataInsFreezeCurveDo> measDataInsFreezeCurveDoList) {
    }

    public void deleteMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start deleteMeasDataInsFreezeCurve >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
            this.logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasFreeze), (String)"yyyyMMddHHmmssSSS"));
        }
        int result = this.measDataInsFreezeCurveDao.deleteMeasDataInsFreezeCurve(measPointId, measItemCode, gmtMeasFreeze);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" deleteMeasDataInsFreezeCurve {} ", (Object)(result > 0 ? "success" : "failure"));
            this.logger.debug(" <<<<<<<< end deleteMeasDataInsFreezeCurve <<<<<<<< ");
        }
    }

    public void deleteMeasDataInsFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd) {
    }
}

