package com.easesource.iot.datacenter.openservice.dao;

import com.easesource.data.jdbc.mybatis.CrudMapper;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointDo;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-08
 */
public interface RunMeasPointDao extends CrudMapper<RunMeasPointDo, Long> {

    int deleteById(Long id);

    RunMeasPointVo getRunMeasPointVoByMeasPointId(Long id);

    List<RunMeasPointVo> batchGetRunMeasPointVoListByMeasPointIdList(@Param("measPointIdList") List<Long> measPointIdList);

    List<RunMeasPointVo> getRunMeasPointVoListByAccessGatewayId(@Param("accessGatewayId") Long accessGatewayId);

    List<RunMeasPointVo> getRunMeasPointVoListByOrgNoAndDevAccessGatewaySortNoAndDevAccessGatewayNo(@Param("orgNo") String orgNo, @Param("devAccessGatewaySortNo") String devAccessGatewaySortNo, @Param("devAccessGatewayNo") String devAccessGatewayNo);

    List<RunMeasPointVo> getRunMeasPointVoListByProductKeyAndClientId(@Param("productKey") String productKey, @Param("clientId") String clientId);

    List<RunMeasPointVo> getRunMeasPointVoListByProductKeyAndUpcommProtoAndUpcommLogicAddr(@Param("productKey") String productKey, @Param("upcommProto") String upcommProto, @Param("upcommLogicAddr") String upcommLogicAddr);

    int batchUpdateRunMeasPointOpsInfo(@Param("measPointIdList") List<Long> measPointIdList, @Param("gmtMessageUp") Long gmtMessageUp, @Param("gmtMeasdataUp") Long gmtMeasdataUp, @Param("gmtAlarmUp") Long gmtAlarmUp, @Param("gmtModified") Long gmtModified);

}
