package com.easesource.iot.datacenter.openservice.service.impl;

import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.AccessMgmtService;
import com.easesource.iot.datacenter.openservice.dao.*;
import com.easesource.iot.datacenter.openservice.entity.*;
import com.easesource.iot.datacenter.openservice.request.*;
import com.easesource.iot.datacenter.openservice.response.*;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "accessMgmtService")
public class AccessMgmtServiceImpl extends AbstractBaseService implements AccessMgmtService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private DevAccessDao devAccessDao;

    @Resource
    private DevAccessGatewayDao devAccessGatewayDao;

    @Resource
    private DevAccessTrunkingDao devAccessTrunkingDao;

    @Resource
    private DevAccessMeasureDao devAccessMeasureDao;

    @Resource
    private RunAccessGatewayDao runAccessGatewayDao;

    @Resource
    private RunMeasPointDao runMeasPointDao;

    @Override
    public DevAccessGatewayQueryResponse queryDevAccessGateway(DevAccessGatewayQueryRequest devAccessGatewayQueryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start queryDevAccessGateway >>>>>>> ");
            logger.debug(" DevAccessGatewayQueryRequest     : " + JsonConvertUtils.convertToString(devAccessGatewayQueryRequest));
        }

        DevAccessGatewayQueryResponse response = new DevAccessGatewayQueryResponse();
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" DevAccessGatewayQueryResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end queryDevAccessGateway <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayGetResponse getRunAccessGateway(RunAccessGatewayGetRequest getRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRunAccessGateway >>>>>>> ");
            logger.debug(" RunAccessGatewayGetRequest   : " + JsonConvertUtils.convertToString(getRequest));
        }

        RunAccessGatewayGetResponse getResponse = new RunAccessGatewayGetResponse();
        getResponse.setReturnCode("FAILURE");
        getResponse.setFailureCode("-1");
        if(getRequest != null && getRequest.getDevAccessId() != null && getRequest.getDevAccessId() > 0L) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoById(getRequest.getDevAccessId());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByAccessGatewayId(getRequest.getDevAccessId());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        else if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo())) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoByOrgNoAndDevAccessSortNoAndDevAccessNo(getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByOrgNoAndDevAccessGatewaySortNoAndDevAccessGatewayNo(getRequest.getOrgNo(), getRequest.getDevAccessSortNo(), getRequest.getDevAccessNo());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        else if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getProductKey(), getRequest.getClientId())) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndClientId(getRequest.getProductKey(), getRequest.getClientId());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByProductKeyAndClientId(getRequest.getProductKey(), getRequest.getClientId());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }
        else if(getRequest != null && !StringUtils.isAnyBlank(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr())) {
            RunAccessGatewayVo runAccessGateway = runAccessGatewayDao.getRunAccessGatewayVoByProductKeyAndUpcommProtoAndUpcommLogicAddr(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr());
            List<RunMeasPointVo> runMeasPointList = runMeasPointDao.getRunMeasPointVoListByProductKeyAndUpcommProtoAndUpcommLogicAddr(getRequest.getProductKey(), getRequest.getUpcommProto(), getRequest.getUpcommLogicAddr());
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunAccessGateway(runAccessGateway);
            getResponse.setRunMeasPointList(runMeasPointList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayGetResponse  : " + JsonConvertUtils.convertToString(getResponse));
            logger.debug(" <<<<<<<< end getRunAccessGateway <<<<<<<< ");
        }
        return getResponse;
    }

    @Override
    public RunAccessGatewayNameAndDescUpdateResponse updateRunAccessGatewayNameAndDesc(RunAccessGatewayNameAndDescUpdateRequest runAccessGatewayNameAndDescUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateRunAccessGatewayNameAndDesc >>>>>>> ");
            logger.debug(" RunAccessGatewayNameAndDescUpdateRequest : " + JsonConvertUtils.convertToString(runAccessGatewayNameAndDescUpdateRequest));
        }

        RunAccessGatewayNameAndDescUpdateResponse response = new RunAccessGatewayNameAndDescUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayNameAndDescUpdateRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            DevAccessDo devAccessDo = devAccessDao.get(devAccessId);
            if(devAccessDo != null && StringUtils.isNotBlank(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessName())) {
                devAccessDo.setDevAccessName(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessName());
            }
            if(devAccessDo != null && StringUtils.isNotBlank(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessDesc())) {
                devAccessDo.setDevAccessDesc(runAccessGatewayNameAndDescUpdateRequest.getNewDevAccessDesc());
            }
            devAccessDao.update(devAccessDo);
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayNameAndDescUpdateResponse  : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end updateRunAccessGatewayNameAndDesc <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayRunStatusUpdateResponse updateRunAccessGatewayRunStatus(RunAccessGatewayRunStatusUpdateRequest runAccessGatewayRunStatusUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateRunAccessGatewayRunStatus >>>>>>> ");
            logger.debug(" RunAccessGatewayRunStatusUpdateRequest   : " + JsonConvertUtils.convertToString(runAccessGatewayRunStatusUpdateRequest));
        }

        RunAccessGatewayRunStatusUpdateResponse response = new RunAccessGatewayRunStatusUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayRunStatusUpdateRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = runAccessGatewayDao.get(devAccessId);
            if(runAccessGatewayDo != null) {
                runAccessGatewayDo.setRunStatus(runAccessGatewayRunStatusUpdateRequest.getRunStatus());
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayRunStatusUpdateResponse      : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end updateRunAccessGatewayRunStatus <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayOpsInfoUpdateResponse updateRunAccessGatewayOpsInfo(RunAccessGatewayOpsInfoUpdateRequest runAccessGatewayOpsInfoUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateRunAccessGatewayOpsInfo >>>>>>> ");
            logger.debug(" RunAccessGatewayOpsInfoUpdateRequest     : " + JsonConvertUtils.convertToString(runAccessGatewayOpsInfoUpdateRequest));
        }

        RunAccessGatewayOpsInfoUpdateResponse response = new RunAccessGatewayOpsInfoUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayOpsInfoUpdateRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = runAccessGatewayDao.get(devAccessId);
            if(runAccessGatewayDo != null) {
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunParam())) {
                    runAccessGatewayDo.setRunParam(runAccessGatewayOpsInfoUpdateRequest.getRunParam());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunClientIp())) {
                    runAccessGatewayDo.setRunClientIp(runAccessGatewayOpsInfoUpdateRequest.getRunClientIp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getRunClientPort())) {
                    runAccessGatewayDo.setRunClientPort(runAccessGatewayOpsInfoUpdateRequest.getRunClientPort());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunServerIp())) {
                    runAccessGatewayDo.setRunServerIp(runAccessGatewayOpsInfoUpdateRequest.getRunServerIp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getRunServerPort())) {
                    runAccessGatewayDo.setRunServerPort(runAccessGatewayOpsInfoUpdateRequest.getRunServerPort());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getRunServerApn())) {
                    runAccessGatewayDo.setRunServerApn(runAccessGatewayOpsInfoUpdateRequest.getRunServerApn());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getSoftwareVer())) {
                    runAccessGatewayDo.setSoftwareVer(runAccessGatewayOpsInfoUpdateRequest.getSoftwareVer());
                }
                if(StringUtils.isNotBlank(runAccessGatewayOpsInfoUpdateRequest.getHardwareVer())) {
                    runAccessGatewayDo.setHardwareVer(runAccessGatewayOpsInfoUpdateRequest.getHardwareVer());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtConnectedAt())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtConnectedAt(runAccessGatewayOpsInfoUpdateRequest.getGmtConnectedAt());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtHeartbeatUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtHeartbeatUp(runAccessGatewayOpsInfoUpdateRequest.getGmtHeartbeatUp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtMessageUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtMessageUp(runAccessGatewayOpsInfoUpdateRequest.getGmtMessageUp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtMeasdataUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtMeasdataUp(runAccessGatewayOpsInfoUpdateRequest.getGmtMeasdataUp());
                }
                if(ObjectUtils.isNotNull(runAccessGatewayOpsInfoUpdateRequest.getGmtAlarmUp())) {
                    runAccessGatewayDo.setOnline(true);
                    runAccessGatewayDo.setGmtAlarmUp(runAccessGatewayOpsInfoUpdateRequest.getGmtAlarmUp());
                }
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayOpsInfoUpdateResponse        : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end updateRunAccessGatewayOpsInfo <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayOfflineSetResponse setRunAccessGatewayOffline(RunAccessGatewayOfflineSetRequest runAccessGatewayOfflineSetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start setRunAccessGatewayOffline >>>>>>> ");
            logger.debug(" RunAccessGatewayOfflineSetRequest        : " + JsonConvertUtils.convertToString(runAccessGatewayOfflineSetRequest));
        }

        RunAccessGatewayOfflineSetResponse response = new RunAccessGatewayOfflineSetResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long devAccessId = runAccessGatewayOfflineSetRequest.getDevAccessId();
        if(devAccessId != null && devAccessId > 0L) {
            RunAccessGatewayDo runAccessGatewayDo = runAccessGatewayDao.get(devAccessId);
            if(runAccessGatewayDo != null) {
                runAccessGatewayDo.setOnline(false);
                runAccessGatewayDo.setGmtOffline(runAccessGatewayOfflineSetRequest.getGmtOffline());
                runAccessGatewayDo.setGmtModified(System.currentTimeMillis());
                runAccessGatewayDao.update(runAccessGatewayDo);
            }
            RunAccessGatewayVo runAccessGatewayVo = runAccessGatewayDao.getRunAccessGatewayVoById(devAccessId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunAccessGateway(runAccessGatewayVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayOfflineSetResponse       : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end setRunAccessGatewayOffline <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayAddToOrgResponse addToOrgRunAccessGateway(RunAccessGatewayAddToOrgRequest runAccessGatewayAddToOrgRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start addToOrgRunAccessGateway >>>>>>> ");
            logger.debug(" RunAccessGatewayAddToOrgRequest          : " + JsonConvertUtils.convertToString(runAccessGatewayAddToOrgRequest));
        }

        RunAccessGatewayAddToOrgResponse response = new RunAccessGatewayAddToOrgResponse();
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayAddToOrgResponse         : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end addToOrgRunAccessGateway <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayDeleteFromOrgResponse deleteFromOrgRunAccessGateway(RunAccessGatewayDeleteFromOrgRequest runAccessGatewayDeleteFromOrgRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start deleteFromOrgRunAccessGateway >>>>>>> ");
            logger.debug(" RunAccessGatewayDeleteFromOrgRequest     : " + JsonConvertUtils.convertToString(runAccessGatewayDeleteFromOrgRequest));
        }

        RunAccessGatewayDeleteFromOrgResponse response = new RunAccessGatewayDeleteFromOrgResponse();
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayDeleteFromOrgResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end deleteFromOrgRunAccessGateway <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayQueryResponse queryRunAccessGateway(RunAccessGatewayQueryRequest queryRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start queryRunAccessGateway >>>>>>> ");
            logger.debug(" RunAccessGatewayQueryRequest     : " + JsonConvertUtils.convertToString(queryRequest));
        }

        RunAccessGatewayQueryResponse queryResponse = new RunAccessGatewayQueryResponse();
        queryResponse.setReturnCode("FAILURE");
        queryResponse.setFailureCode("-1");
        Set<Long> devAccessIdSet = queryRequest.getDevAccessIdSet();
        Set<String> orgNoSet = queryRequest.getOrgNoSet();
        Set<String> devAccessSortNoSet = queryRequest.getDevAccessSortNoSet();
        Set<String> devAccessNoSet = queryRequest.getDevAccessNoSet();
        Set<String> productKeySet = queryRequest.getProductKeySet();
        Set<String> clientIdSet = queryRequest.getClientIdSet();
        Map<String, Object> params = Maps.newHashMap();
        if(devAccessIdSet != null && devAccessIdSet.size() > 0) {
            params.put("devAccessId", devAccessIdSet.iterator().next());
        }
        else if(orgNoSet != null && orgNoSet.size() > 0) {
            params.put("orgNo", orgNoSet.iterator().next());
        }
        else if(devAccessSortNoSet != null && devAccessSortNoSet.size() > 0) {
            params.put("devAccessSortNo", devAccessSortNoSet.iterator().next());
        }
        else if(devAccessNoSet != null && devAccessNoSet.size() > 0) {
            params.put("devAccessNo", devAccessNoSet.iterator().next());
        }
        else if(productKeySet != null && productKeySet.size() > 0) {
            params.put("productKey", productKeySet.iterator().next());
        }
        else if(clientIdSet != null && clientIdSet.size() > 0) {
            params.put("clientId", clientIdSet.iterator().next());
        }
        int runAccessGatewayVoCount = runAccessGatewayDao.getRunAccessGatewayVoCount(params);
        List<RunAccessGatewayVo> runAccessGatewayVoList = runAccessGatewayDao.getRunAccessGatewayVoList(params, null, null);
        queryResponse.setReturnCode("SUCCESS");
        queryResponse.setFailureCode(null);
        queryResponse.setRunAccessGatewayCount(runAccessGatewayVoCount);
        queryResponse.setRunAccessGatewayList(runAccessGatewayVoList);

        if(logger.isDebugEnabled()) {
            logger.debug(" RunAccessGatewayQueryResponse    : " + JsonConvertUtils.convertToString(queryResponse));
            logger.debug(" <<<<<<<< end queryRunAccessGateway <<<<<<<< ");
        }
        return queryResponse;
    }

    @Override
    public RunMeasPointGetResponse getRunMeasPoint(RunMeasPointGetRequest getRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRunMeasPoint >>>>>>> ");
            logger.debug(" RunMeasPointGetRequest       : " + JsonConvertUtils.convertToString(getRequest));
        }

        RunMeasPointGetResponse getResponse = new RunMeasPointGetResponse();
        getResponse.setReturnCode("FAILURE");
        getResponse.setFailureCode("-1");
        Long measPointId = getRequest.getMeasPointId();
        if(measPointId != null && measPointId > 0L) {
            RunMeasPointVo runMeasPointVo = runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            getResponse.setReturnCode("SUCCESS");
            getResponse.setFailureCode(null);
            getResponse.setRunMeasPoint(runMeasPointVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunMeasPointGetResponse      : " + JsonConvertUtils.convertToString(getResponse));
            logger.debug(" <<<<<<<< end getRunMeasPoint <<<<<<<< ");
        }
        return getResponse;
    }

    @Override
    public RunMeasPointNameAndDescUpdateResponse updateRunMeasPointNameAndDesc(RunMeasPointNameAndDescUpdateRequest runMeasPointNameAndDescUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateRunMeasPointNameAndDesc >>>>>>> ");
            logger.debug(" RunMeasPointNameAndDescUpdateRequest     : " + JsonConvertUtils.convertToString(runMeasPointNameAndDescUpdateRequest));
        }

        RunMeasPointNameAndDescUpdateResponse response = new RunMeasPointNameAndDescUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long measPointId = runMeasPointNameAndDescUpdateRequest.getMeasPointId();
        if(measPointId != null && measPointId > 0L) {
            RunMeasPointDo runMeasPointDo = runMeasPointDao.get(measPointId);
            if(runMeasPointDo != null && runMeasPointDo.getAccessMeasureId() != null && runMeasPointDo.getAccessMeasureId() > 0L) {
                Long accessMeasureId = runMeasPointDo.getAccessMeasureId();
                DevAccessDo devAccessDo = devAccessDao.get(accessMeasureId);
                if(devAccessDo != null && StringUtils.isNotBlank(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureName())) {
                    devAccessDo.setDevAccessName(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureName());
                }
                if(devAccessDo != null && StringUtils.isNotBlank(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureDesc())) {
                    devAccessDo.setDevAccessDesc(runMeasPointNameAndDescUpdateRequest.getNewAccessMeasureDesc());
                }
                devAccessDao.update(devAccessDo);
            }

            RunMeasPointVo runMeasPointVo = runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunMeasPoint(runMeasPointVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunMeasPointNameAndDescUpdateResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end updateRunMeasPointNameAndDesc <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunMeasPointOpsInfoUpdateResponse updateRunMeasPointOpsInfo(RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateRunMeasPointOpsInfo >>>>>>> ");
            logger.debug(" RunMeasPointOpsInfoUpdateRequest         : " + JsonConvertUtils.convertToString(runMeasPointOpsInfoUpdateRequest));
        }

        RunMeasPointOpsInfoUpdateResponse response = new RunMeasPointOpsInfoUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        Long measPointId = runMeasPointOpsInfoUpdateRequest.getMeasPointId();
        if(measPointId != null && measPointId > 0L) {
            RunMeasPointDo runMeasPointDo = runMeasPointDao.get(measPointId);
            if(runMeasPointDo != null && runMeasPointDo.getAccessMeasureId() != null && runMeasPointDo.getAccessMeasureId() > 0L) {
                if(ObjectUtils.isNotNull(runMeasPointOpsInfoUpdateRequest.getGmtMessageUp())) {
                    runMeasPointDo.setGmtMessageUp(runMeasPointOpsInfoUpdateRequest.getGmtMessageUp());
                }
                if(ObjectUtils.isNotNull(runMeasPointOpsInfoUpdateRequest.getGmtMeasdataUp())) {
                    runMeasPointDo.setGmtMeasdataUp(runMeasPointOpsInfoUpdateRequest.getGmtMeasdataUp());
                }
                if(ObjectUtils.isNotNull(runMeasPointOpsInfoUpdateRequest.getGmtAlarmUp())) {
                    runMeasPointDo.setGmtAlarmUp(runMeasPointOpsInfoUpdateRequest.getGmtAlarmUp());
                }
                runMeasPointDo.setGmtModified(System.currentTimeMillis());
                runMeasPointDao.update(runMeasPointDo);
            }

            RunMeasPointVo runMeasPointVo = runMeasPointDao.getRunMeasPointVoByMeasPointId(measPointId);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunMeasPoint(runMeasPointVo);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunMeasPointOpsInfoUpdateResponse        : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end updateRunMeasPointOpsInfo <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunMeasPointOpsInfoBatchUpdateResponse batchUpdateRunMeasPointOpsInfo(RunMeasPointOpsInfoBatchUpdateRequest runMeasPointOpsInfoBatchUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start batchUpdateRunMeasPointOpsInfo >>>>>>> ");
            logger.debug(" RunMeasPointOpsInfoBatchUpdateRequest    : " + JsonConvertUtils.convertToString(runMeasPointOpsInfoBatchUpdateRequest));
        }

        RunMeasPointOpsInfoBatchUpdateResponse response = new RunMeasPointOpsInfoBatchUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        List<Long> measPointIdList = runMeasPointOpsInfoBatchUpdateRequest.getMeasPointIdList();
        if(measPointIdList != null && measPointIdList.size() > 0) {
            runMeasPointDao.batchUpdateRunMeasPointOpsInfo(measPointIdList, runMeasPointOpsInfoBatchUpdateRequest.getGmtMessageUp(), runMeasPointOpsInfoBatchUpdateRequest.getGmtMeasdataUp(), runMeasPointOpsInfoBatchUpdateRequest.getGmtAlarmUp(), System.currentTimeMillis());
            List<RunMeasPointVo> runMeasPointVoList = runMeasPointDao.batchGetRunMeasPointVoListByMeasPointIdList(measPointIdList);
            response.setReturnCode("SUCCESS");
            response.setFailureCode(null);
            response.setRunMeasPointList(runMeasPointVoList);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" RunMeasPointOpsInfoBatchUpdateResponse        : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end batchUpdateRunMeasPointOpsInfo <<<<<<<< ");
        }
        return response;
    }

    @Override
    public RunAccessGatewayRunStatusUpdateResponse brushMeter(String mac, String key) {
        RunAccessGatewayRunStatusUpdateResponse response = new RunAccessGatewayRunStatusUpdateResponse();
        response.setReturnCode("FAILURE");
        response.setFailureCode("-1");
        //查终端





        return response;
    }

    @Override
    public RunMeasPointListResponse getRunMeasPointListBySn(String sn) {
        return null;
    }

    @Override
    public BrushMeterResponse addTermMeter(String devTermNo, String devMeterNo) {
        return null;
    }

    @Override
    public void delTermMeter(Long runMeasPointId) {
        return;
    }

    @Override
    public void editMeter(EditMeterRequest editMeterRequest) {

    }

    @Override
    public RunMeasPointListResponse sync(List<SyncRequest> syncRequests) {
        return null;
    }
}
