package com.easesource.iot.datacenter.openservice.service.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.easesource.iot.datacenter.openservice.dao.MeasDataCumFreezeCurve4RdsDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataInsFreezeCurve4RdsDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataLatest4RdsDao;
import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestDo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "measDataStoreService4Rds")
public class MeasDataStoreService4RdsImpl extends AbstractBaseService implements MeasDataStoreService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private MeasDataLatest4RdsDao measDataLatest4RdsDao;

    @Resource
    private MeasDataCumFreezeCurve4RdsDao measDataCumFreezeCurve4RdsDao;

    @Resource
    private MeasDataInsFreezeCurve4RdsDao measDataInsFreezeCurve4RdsDao;

    @Override
    public void updateMeasDataLatest(Long measPointId, String measItemCode, Map<String, Object> measDataInfo) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateMeasDataLatest >>>>>>> ");
            logger.debug(" measPointId      : " + measPointId);
            logger.debug(" measItemCode     : " + measItemCode);
            logger.debug(" measDataInfo     : " + JsonConvertUtils.convertToString(measDataInfo));
        }
        MeasDataLatestDo measDataLatestDo = new MeasDataLatestDo();
        measDataLatestDo.setMeasPointId(measPointId);
        measDataLatestDo.setMeasItemCode(measItemCode);
        measDataLatestDo.setMeasDataInfo(JsonConvertUtils.convertToString(measDataInfo));
        measDataLatestDo.setGmtModified(System.currentTimeMillis());
        int result = measDataLatest4RdsDao.updateByMeasPointIdAndMeasItemCode(measDataLatestDo);
        if(result > 0) {
            if(logger.isDebugEnabled()) {
                logger.debug(" measDataLatestDo is exists, update success! ");
            }
        }
        else {
            measDataLatestDo.setId(iotDataIdGenerator.nextId());
            measDataLatestDo.setGmtCreate(measDataLatestDo.getGmtModified());
            result = measDataLatest4RdsDao.insert(measDataLatestDo);
            if(result > 0) {
                if(logger.isDebugEnabled()) {
                    logger.debug(" measDataLatestDo is not exists, insert success! ");
                }
            }
        }
    }

    @Override
    public void batchUpdateMeasDataLatest(Map<Long, Map<String, Map<String, Object>>> batchMeasDataInfosMap) {

    }

    @Override
    public void deleteMeasDataLatest(Long measPointId, String measItemCode) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start deleteMeasDataLatest >>>>>>> ");
            logger.debug(" measPointId      : " + measPointId);
            logger.debug(" measItemCode     : " + measItemCode);
        }
        int result = measDataLatest4RdsDao.deleteByMeasPointIdAndMeasItemCode(measPointId, measItemCode);
        if(result > 0) {
            if(logger.isDebugEnabled()) {
                logger.debug(" measDataLatestDo is exists, delete success! ");
            }
        }
        else {
            if(logger.isDebugEnabled()) {
                logger.debug(" measDataLatestDo is not exists. ");
            }
        }
    }

    @Override
    public void insertOrUpdateMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start insertOrUpdateMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" measPointId      : " + measPointId);
            logger.debug(" measItemCode     : " + measItemCode);
            logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString(new Date(gmtMeasFreeze), DateConvertUtils.PATTERN_DATETIMEWITHMS_WITHOUTSPR));
            logger.debug(" measDataValue    : " + measDataValue);
            logger.debug(" measDataRate     : " + measDataRate);
            logger.debug(" measDataSource   : " + measDataSource);
            logger.debug(" gmtMeasData      : " + DateConvertUtils.convertToString(new Date(gmtMeasData), DateConvertUtils.PATTERN_DATETIMEWITHMS_WITHOUTSPR));
            logger.debug(" freezeMode       : " + freezeMode);
        }
        MeasDataCumFreezeCurveDo measDataCumFreezeCurveDo = new MeasDataCumFreezeCurveDo();
        measDataCumFreezeCurveDo.setId(iotDataIdGenerator.nextId());
        measDataCumFreezeCurveDo.setMeasPointId(measPointId);
        measDataCumFreezeCurveDo.setMeasItemCode(measItemCode);
        measDataCumFreezeCurveDo.setGmtMeasFreeze(gmtMeasFreeze);
        measDataCumFreezeCurveDo.setMeasDataValue(measDataValue);
        measDataCumFreezeCurveDo.setMeasDataRate(measDataRate);
        measDataCumFreezeCurveDo.setMeasDataSource(measDataSource);
        measDataCumFreezeCurveDo.setGmtMeasData(gmtMeasData);
        measDataCumFreezeCurveDo.setFreezeMode(freezeMode);
        measDataCumFreezeCurveDo.setGmtCreate(System.currentTimeMillis());
        measDataCumFreezeCurveDo.setGmtModified(System.currentTimeMillis());
        measDataCumFreezeCurve4RdsDao.insert(measDataCumFreezeCurveDo);
    }

    @Override
    public void batchInsertOrUpdateMeasDataCumFreezeCurve(List<MeasDataCumFreezeCurveDo> measDataCumFreezeCurveDoList) {

    }

    @Override
    public void deleteMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze) {

    }

    @Override
    public void deleteMeasDataCumFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd) {

    }

    @Override
    public void insertOrUpdateMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start insertOrUpdateMeasDataInsFreezeCurve >>>>>>> ");
            logger.debug(" measPointId      : " + measPointId);
            logger.debug(" measItemCode     : " + measItemCode);
            logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString(new Date(gmtMeasFreeze), DateConvertUtils.PATTERN_DATETIMEWITHMS_WITHOUTSPR));
            logger.debug(" measDataValue    : " + measDataValue);
            logger.debug(" measDataRate     : " + measDataRate);
            logger.debug(" measDataSource   : " + measDataSource);
            logger.debug(" gmtMeasData      : " + DateConvertUtils.convertToString(new Date(gmtMeasData), DateConvertUtils.PATTERN_DATETIMEWITHMS_WITHOUTSPR));
            logger.debug(" freezeMode       : " + freezeMode);
        }
        MeasDataInsFreezeCurveDo measDataInsFreezeCurveDo = new MeasDataInsFreezeCurveDo();
        measDataInsFreezeCurveDo.setId(iotDataIdGenerator.nextId());
        measDataInsFreezeCurveDo.setMeasPointId(measPointId);
        measDataInsFreezeCurveDo.setMeasItemCode(measItemCode);
        measDataInsFreezeCurveDo.setGmtMeasFreeze(gmtMeasFreeze);
        measDataInsFreezeCurveDo.setMeasDataValue(measDataValue);
        measDataInsFreezeCurveDo.setMeasDataRate(measDataRate);
        measDataInsFreezeCurveDo.setMeasDataSource(measDataSource);
        measDataInsFreezeCurveDo.setGmtMeasData(gmtMeasData);
        measDataInsFreezeCurveDo.setFreezeMode(freezeMode);
        measDataInsFreezeCurveDo.setGmtCreate(System.currentTimeMillis());
        measDataInsFreezeCurveDo.setGmtModified(System.currentTimeMillis());
        measDataInsFreezeCurve4RdsDao.insert(measDataInsFreezeCurveDo);
    }

    @Override
    public void batchInsertOrUpdateMeasDataInsFreezeCurve(List<MeasDataInsFreezeCurveDo> measDataInsFreezeCurveDoList) {

    }

    @Override
    public void deleteMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze) {

    }

    @Override
    public void deleteMeasDataInsFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd) {

    }

}
