package com.easesource.iot.datacenter.openservice.tablestore.dao;

import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;

import java.util.Map;
import java.util.Set;

/**
 * @author Nick Zhang
 */
public interface MeasDataLatestDao {

    /**
     * 插入量测点最新数据
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @param measDataInfoMap
     *          量测数据信息
     * @param measDataSource
     *          量测数据来源
     * @param gmtMeasDataLatest
     *          量测数据最近时间
     * @return
     *          结果
     */
    int updateMeasDataInfoLatest(Long measPointId, String measItemCode, Map<String, Object> measDataInfoMap, int measDataSource, long gmtMeasDataLatest);

    /**
     * 批量插入量测点最新数据
     *
     * @param batchMeasDataInfosMap
     *          批量量测数据信息Map
     * @return
     *          结果
     */
    int batchUpdateMeasDataInfoLatest(Map<Long, Map<String, Map<String, Object>>> batchMeasDataInfosMap);

    /**
     * 通过量测点标识和量测项编码删除量测点最新数据实体
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @return
     *          结果
     */
    int deleteByMeasPointIdAndMeasItemCode(Long measPointId, String measItemCode);

    /**
     * 获取量测点最新数据Map
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCodeSet
     *          量测项编码集
     * @return
     *          量测点最新数据Map
     */
    Map<String, MeasDataLatestInfo> getMeasDataLatestInfoMap(Long measPointId, Set<String> measItemCodeSet, Integer measDataSideType);

    /**
     * 获取批量量测点数据信息Map
     *
     * @param measPointIdSet
     *          量测点标识集
     * @param measItemCodeSet
     *          量测项编码集
     * @return
     *          批量量测点数据信息Map
     */
    Map<Long, Map<String, MeasDataLatestInfo>> batchGetMeasDataLatestInfoMap(Set<Long> measPointIdSet, Set<String> measItemCodeSet, Integer measDataSideType);

}
