package com.easesource.iot.datacenter.openservice.tablestore.service.impl;

import com.easesource.commons.util.NumberUtils;
import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataCumFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataInsFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataLatestDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "measDataStoreService")
public class MeasDataStoreServiceImpl extends AbstractBaseService implements MeasDataStoreService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private MeasDataLatestDao measDataLatestDao;

    @Resource
    private MeasDataCumFreezeCurveDao measDataCumFreezeCurveDao;

    @Resource
    private MeasDataInsFreezeCurveDao measDataInsFreezeCurveDao;

    @Override
    public void updateMeasDataLatest(Long measPointId, String measItemCode, Map<String, Object> measDataInfo) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start updateMeasDataLatest >>>>>>> ");
            logger.debug(" measPointId      : " + measPointId);
            logger.debug(" measItemCode     : " + measItemCode);
            logger.debug(" measDataInfo     : " + JsonConvertUtils.convertToString(measDataInfo));
        }
        if(logger.isInfoEnabled()) {
            if(StringUtils.equals(measItemCode, "gen_watt_paet")) {
                logger.debug(" measPointId  : " + measPointId);
                logger.debug(" measItemCode : " + measItemCode);
                logger.debug(" measDataInfo : " + JsonConvertUtils.convertToString(measDataInfo));
            }
        }
        int measDataSource = NumberUtils.toInt(ObjectUtils.toStringDefaultEmpty(measDataInfo.get("measDataSource")), 0);
        long gmtMeasDataLatest = NumberUtils.toLong(ObjectUtils.toStringDefaultEmpty(measDataInfo.get("gmtMeasDataLatest")), System.currentTimeMillis());
        int result = measDataLatestDao.updateMeasDataInfoLatest(measPointId, measItemCode, measDataInfo, measDataSource, gmtMeasDataLatest);
        if(logger.isDebugEnabled()) {
            logger.debug(" updateMeasDataLatest {} ", (result > 0 ? "success" : "failure"));
            logger.debug(" <<<<<<<< end updateMeasDataLatest <<<<<<<< ");
        }
    }

    @Override
    public void batchUpdateMeasDataLatest(Map<Long, Map<String, Map<String, Object>>> batchMeasDataInfosMap) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start batchUpdateMeasDataLatest >>>>>>> ");
            logger.debug(" batchMeasDataInfosMap    : " + JsonConvertUtils.convertToString(batchMeasDataInfosMap));
        }
        int result = measDataLatestDao.batchUpdateMeasDataInfoLatest(batchMeasDataInfosMap);
        if(logger.isDebugEnabled()) {
            logger.debug(" batchUpdateMeasDataLatest {} ", (result > 0 ? "success" : "failure"));
            logger.debug(" <<<<<<<< end batchUpdateMeasDataLatest <<<<<<<< ");
        }
    }

    @Override
    public void deleteMeasDataLatest(Long measPointId, String measItemCode) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start deleteMeasDataLatest >>>>>>> ");
            logger.debug(" measPointId      : " + measPointId);
            logger.debug(" measItemCode     : " + measItemCode);
        }
        int result = measDataLatestDao.deleteByMeasPointIdAndMeasItemCode(measPointId, measItemCode);
        if(logger.isDebugEnabled()) {
            logger.debug(" deleteMeasDataLatest {} ", (result > 0 ? "success" : "failure"));
            logger.debug(" <<<<<<<< end deleteMeasDataLatest <<<<<<<< ");
        }
    }

    @Override
    public void insertOrUpdateMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start insertOrUpdateMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" measPointId      : " + measPointId);
            logger.debug(" measItemCode     : " + measItemCode);
            logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString(new Date(gmtMeasFreeze), DateConvertUtils.PATTERN_DATETIMEWITHMS_WITHOUTSPR));
            logger.debug(" measDataValue    : " + measDataValue);
            logger.debug(" measDataRate     : " + measDataRate);
            logger.debug(" measDataSource   : " + measDataSource);
            logger.debug(" gmtMeasData      : " + DateConvertUtils.convertToString(new Date(gmtMeasData), DateConvertUtils.PATTERN_DATETIMEWITHMS_WITHOUTSPR));
            logger.debug(" freezeMode       : " + freezeMode);
        }
        int result = measDataCumFreezeCurveDao.updateMeasDataCumFreezeCurve(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataRate, measDataSource, gmtMeasData, freezeMode);
        if(logger.isDebugEnabled()) {
            logger.debug(" insertOrUpdateMeasDataCumFreezeCurve {} ", (result > 0 ? "success" : "failure"));
            logger.debug(" <<<<<<<< end insertOrUpdateMeasDataCumFreezeCurve <<<<<<<< ");
        }
    }

    @Override
    public void batchInsertOrUpdateMeasDataCumFreezeCurve(List<MeasDataCumFreezeCurveDo> measDataCumFreezeCurveDoList) {

    }

    @Override
    public void deleteMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start deleteMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" measPointId      : " + measPointId);
            logger.debug(" measItemCode     : " + measItemCode);
            logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString(new Date(gmtMeasFreeze), DateConvertUtils.PATTERN_DATETIMEWITHMS_WITHOUTSPR));
        }
        int result = measDataCumFreezeCurveDao.deleteMeasDataCumFreezeCurve(measPointId, measItemCode, gmtMeasFreeze);
        if(logger.isDebugEnabled()) {
            logger.debug(" deleteMeasDataCumFreezeCurve {} ", (result > 0 ? "success" : "failure"));
            logger.debug(" <<<<<<<< end deleteMeasDataCumFreezeCurve <<<<<<<< ");
        }
    }

    @Override
    public void deleteMeasDataCumFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd) {

    }

    @Override
    public void insertOrUpdateMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start insertOrUpdateMeasDataInsFreezeCurve >>>>>>> ");
            logger.debug(" measPointId      : " + measPointId);
            logger.debug(" measItemCode     : " + measItemCode);
            logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString(new Date(gmtMeasFreeze), DateConvertUtils.PATTERN_DATETIMEWITHMS_WITHOUTSPR));
            logger.debug(" measDataValue    : " + measDataValue);
            logger.debug(" measDataRate     : " + measDataRate);
            logger.debug(" measDataSource   : " + measDataSource);
            logger.debug(" gmtMeasData      : " + DateConvertUtils.convertToString(new Date(gmtMeasData), DateConvertUtils.PATTERN_DATETIMEWITHMS_WITHOUTSPR));
            logger.debug(" freezeMode       : " + freezeMode);
        }
        int result = measDataInsFreezeCurveDao.updateMeasDataInsFreezeCurve(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataRate, measDataSource, gmtMeasData, freezeMode);
        if(logger.isDebugEnabled()) {
            logger.debug(" insertOrUpdateMeasDataInsFreezeCurve {} ", (result > 0 ? "success" : "failure"));
            logger.debug(" <<<<<<<< end insertOrUpdateMeasDataInsFreezeCurve <<<<<<<< ");
        }
    }

    @Override
    public void batchInsertOrUpdateMeasDataInsFreezeCurve(List<MeasDataInsFreezeCurveDo> measDataInsFreezeCurveDoList) {

    }

    @Override
    public void deleteMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start deleteMeasDataInsFreezeCurve >>>>>>> ");
            logger.debug(" measPointId      : " + measPointId);
            logger.debug(" measItemCode     : " + measItemCode);
            logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString(new Date(gmtMeasFreeze), DateConvertUtils.PATTERN_DATETIMEWITHMS_WITHOUTSPR));
        }
        int result = measDataInsFreezeCurveDao.deleteMeasDataInsFreezeCurve(measPointId, measItemCode, gmtMeasFreeze);
        if(logger.isDebugEnabled()) {
            logger.debug(" deleteMeasDataInsFreezeCurve {} ", (result > 0 ? "success" : "failure"));
            logger.debug(" <<<<<<<< end deleteMeasDataInsFreezeCurve <<<<<<<< ");
        }
    }

    @Override
    public void deleteMeasDataInsFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd) {

    }

}
