/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.service.impl;

import com.easesource.commons.util.NumberUtils;
import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Sorter;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.dao.MeasDataCumFreezeCurve4RdsDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataInsFreezeCurve4RdsDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataLatest4RdsDao;
import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveValue;
import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveVo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveValue;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveVo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestVo;
import com.easesource.iot.datacenter.openservice.request.MeasDataAlarmDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeCurveBatchGetMTPsRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeCurveBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeCurveGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeCurveGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeDayGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataCumFreezeDayGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataInsDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataInsFreezeCurveGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataInsFreezeCurveGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataLatestBatchGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataLatestGetRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataStateBoolDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataStateCharDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.request.MeasDataStatsDiscreteGetRangeRequest;
import com.easesource.iot.datacenter.openservice.response.MeasDataAlarmDiscreteGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumDiscreteGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveBatchGetMTPsResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeCurveGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeDayGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataCumFreezeDayGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataInsDiscreteGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataInsFreezeCurveGetRangeListResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataInsFreezeCurveGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataInsFreezeCurveGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataLatestBatchGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataLatestGetResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataStateBoolDiscreteGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataStateCharDiscreteGetRangeResponse;
import com.easesource.iot.datacenter.openservice.response.MeasDataStatsDiscreteGetRangeResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="measDataService4Rds")
public class MeasDataService4RdsImpl
extends AbstractBaseService
implements MeasDataService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private MeasDataLatest4RdsDao measDataLatest4RdsDao;
    @Resource
    private MeasDataCumFreezeCurve4RdsDao measDataCumFreezeCurve4RdsDao;
    @Resource
    private MeasDataInsFreezeCurve4RdsDao measDataInsFreezeCurve4RdsDao;

    public MeasDataLatestGetResponse getMeasDataLatest(MeasDataLatestGetRequest measDataLatestGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasDataLatest >>>>>>> ");
            this.logger.debug(" MeasDataLatestGetRequest     : " + JsonConvertUtils.convertToString((Object)measDataLatestGetRequest));
        }
        MeasDataLatestGetResponse response = new MeasDataLatestGetResponse();
        Long measPointId = measDataLatestGetRequest.getMeasPointId();
        Set measItemCodeSet = measDataLatestGetRequest.getMeasItemCodeSet();
        HashMap measDataMap = Maps.newHashMap();
        for (String measItemCode : measItemCodeSet) {
            BigDecimal ptRate;
            BigDecimal ctRate;
            MeasDataLatestVo measDataLatestVo = this.measDataLatest4RdsDao.getMeasDataLatestVoByMeasPointIdAndMeasItemCode(measPointId, measItemCode);
            if (measDataLatestVo == null || measDataLatestVo.getMeasDataInfo() == null) continue;
            Map measDataInfoMap = (Map)JsonConvertUtils.convertFromString((String)measDataLatestVo.getMeasDataInfo(), Map.class);
            String measDataClassName = (String)measDataInfoMap.get("measDataClass");
            Class measDataClass = null;
            Object measDataValue = null;
            BigDecimal selfRate = measDataLatestVo.getSelfRate();
            if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                selfRate = new BigDecimal("1.0");
            }
            if ((ctRate = measDataLatestVo.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                ctRate = new BigDecimal("1.0");
            }
            if ((ptRate = measDataLatestVo.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                ptRate = new BigDecimal("1.0");
            }
            if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.math.BigDecimal")) {
                measDataClass = BigDecimal.class;
                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).setScale(6, 4);
                if (measDataLatestGetRequest.getMeasDataSideType() == 1) {
                    if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus"})) {
                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ptRate).setScale(6, 4);
                    } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus"})) {
                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).setScale(6, 4);
                    } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus"})) {
                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, 4);
                    } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre"})) {
                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, 4);
                    }
                }
            } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.lang.Boolean")) {
                measDataClass = Boolean.class;
                measDataValue = Boolean.valueOf(measDataInfoMap.get("measDataValue").toString());
            } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.lang.String")) {
                measDataClass = String.class;
                measDataValue = measDataInfoMap.get("measDataValue").toString();
            } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.lang.Integer")) {
                measDataClass = Integer.class;
                measDataValue = Integer.valueOf(measDataInfoMap.get("measDataValue").toString());
            } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.lang.Long")) {
                measDataClass = Long.class;
                measDataValue = Long.valueOf(measDataInfoMap.get("measDataValue").toString());
            } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.util.Date")) {
                measDataClass = Date.class;
                measDataValue = new Date(Long.parseLong(measDataInfoMap.get("measDataValue").toString()));
            }
            int measDataSource = NumberUtils.toInt((String)ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("measDataSource")), (int)0);
            long gmtMeasDataLatest = NumberUtils.toLong((String)ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("gmtMeasDataLatest")), (long)System.currentTimeMillis());
            measDataMap.put(measItemCode, new MeasDataLatestInfo(measPointId, measItemCode, measDataClass, measDataValue, measDataSource, gmtMeasDataLatest, measDataLatestVo.getGmtCreate(), measDataLatestVo.getGmtModified()));
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap((Map)measDataMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataLatestGetResponse    : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasDataLatest <<<<<<<< ");
        }
        return response;
    }

    public MeasDataLatestBatchGetResponse batchGetMeasDataLatest(MeasDataLatestBatchGetRequest measDataLatestBatchGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start batchGetMeasDataLatest >>>>>>> ");
            this.logger.debug(" MeasDataLatestBatchGetRequest    : " + JsonConvertUtils.convertToString((Object)measDataLatestBatchGetRequest));
        }
        MeasDataLatestBatchGetResponse response = new MeasDataLatestBatchGetResponse();
        Set measPointIdSet = measDataLatestBatchGetRequest.getMeasPointIdSet();
        Set measItemCodeSet = measDataLatestBatchGetRequest.getMeasItemCodeSet();
        HashMap batchMeasDataMap = Maps.newHashMap();
        for (Long measPointId : measPointIdSet) {
            HashMap measDataMap = Maps.newHashMap();
            for (String measItemCode : measItemCodeSet) {
                BigDecimal ptRate;
                BigDecimal ctRate;
                MeasDataLatestVo measDataLatestVo = this.measDataLatest4RdsDao.getMeasDataLatestVoByMeasPointIdAndMeasItemCode(measPointId, measItemCode);
                if (measDataLatestVo == null || measDataLatestVo.getMeasDataInfo() == null) continue;
                Map measDataInfoMap = (Map)JsonConvertUtils.convertFromString((String)measDataLatestVo.getMeasDataInfo(), Map.class);
                String measDataClassName = (String)measDataInfoMap.get("measDataClass");
                Class measDataClass = null;
                Object measDataValue = null;
                BigDecimal selfRate = measDataLatestVo.getSelfRate();
                if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                    selfRate = new BigDecimal("1.0");
                }
                if ((ctRate = measDataLatestVo.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ctRate = new BigDecimal("1.0");
                }
                if ((ptRate = measDataLatestVo.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ptRate = new BigDecimal("1.0");
                }
                if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.math.BigDecimal")) {
                    measDataClass = BigDecimal.class;
                    measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).setScale(6, 4);
                    if (measDataLatestBatchGetRequest.getMeasDataSideType() == 1) {
                        if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus"})) {
                            measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ptRate).setScale(6, 4);
                        } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus"})) {
                            measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).setScale(6, 4);
                        } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus"})) {
                            measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, 4);
                        } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre"})) {
                            measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, 4);
                        }
                    }
                } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.lang.Boolean")) {
                    measDataClass = Boolean.class;
                    measDataValue = Boolean.valueOf(measDataInfoMap.get("measDataValue").toString());
                } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.lang.String")) {
                    measDataClass = String.class;
                    measDataValue = measDataInfoMap.get("measDataValue").toString();
                } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.lang.Integer")) {
                    measDataClass = Integer.class;
                    measDataValue = Integer.valueOf(measDataInfoMap.get("measDataValue").toString());
                } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.util.Date")) {
                    measDataClass = Date.class;
                    measDataValue = new Date(Long.parseLong(measDataInfoMap.get("measDataValue").toString()));
                }
                int measDataSource = NumberUtils.toInt((String)ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("measDataSource")), (int)0);
                long gmtMeasDataLatest = NumberUtils.toLong((String)ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("gmtMeasDataLatest")), (long)System.currentTimeMillis());
                measDataMap.put(measItemCode, new MeasDataLatestInfo(measPointId, measItemCode, measDataClass, measDataValue, measDataSource, gmtMeasDataLatest, measDataLatestVo.getGmtCreate(), measDataLatestVo.getGmtModified()));
            }
            batchMeasDataMap.put(measPointId, measDataMap);
        }
        response.setBatchMeasDataMap((Map)batchMeasDataMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataLatestBatchGetResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end batchGetMeasDataLatest <<<<<<<< ");
        }
        return response;
    }

    public MeasDataInsDiscreteGetRangeResponse getRangeMeasDataInsDiscrete(MeasDataInsDiscreteGetRangeRequest measDataInsDiscreteGetRangeRequest) {
        return null;
    }

    public MeasDataInsFreezeCurveGetResponse getMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRequest measDataInsFreezeCurveGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasDataInsFreezeCurve >>>>>>> ");
            this.logger.debug(" MeasDataInsFreezeCurveGetRequest     : " + JsonConvertUtils.convertToString((Object)measDataInsFreezeCurveGetRequest));
        }
        MeasDataInsFreezeCurveGetResponse response = new MeasDataInsFreezeCurveGetResponse();
        Long measPointId = measDataInsFreezeCurveGetRequest.getMeasPointId();
        Set measItemCodeSet = measDataInsFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataInsFreezeCurveGetRequest.getGmtMeasFreeze();
        HashMap measDataMap = Maps.newHashMap();
        for (String measItemCode : measItemCodeSet) {
            BigDecimal ptRate;
            BigDecimal ctRate;
            MeasDataInsFreezeCurveVo measDataInsFreezeCurveVo = this.measDataInsFreezeCurve4RdsDao.getMeasDataInsFreezeCurveVoByMeasPointIdAndMeasItemCodeAndGmtMeasFreeze(measPointId, measItemCode, gmtMeasFreeze);
            if (measDataInsFreezeCurveVo == null) continue;
            BigDecimal selfRate = measDataInsFreezeCurveVo.getSelfRate();
            if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                selfRate = new BigDecimal("1.0");
            }
            if ((ctRate = measDataInsFreezeCurveVo.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                ctRate = new BigDecimal("1.0");
            }
            if ((ptRate = measDataInsFreezeCurveVo.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                ptRate = new BigDecimal("1.0");
            }
            BigDecimal measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().setScale(6, 4);
            if (measDataInsFreezeCurveGetRequest.getMeasDataSideType() == 1) {
                if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus"})) {
                    measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, 4);
                } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus"})) {
                    measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, 4);
                } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus"})) {
                    measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, 4);
                }
            }
            measDataMap.put(measItemCode, new MeasDataInsFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataInsFreezeCurveVo.getMeasDataRate().setScale(6, 4), measDataInsFreezeCurveVo.getMeasDataSource(), measDataInsFreezeCurveVo.getFreezeMode(), measDataInsFreezeCurveVo.getGmtMeasData(), measDataInsFreezeCurveVo.getGmtCreate(), measDataInsFreezeCurveVo.getGmtModified()));
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap((Map)measDataMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataInsFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasDataInsFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    public MeasDataInsFreezeCurveGetRangeResponse getRangeMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRangeRequest measDataInsFreezeCurveGetRangeRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRangeMeasDataInsFreezeCurve >>>>>>> ");
            this.logger.debug(" MeasDataInsFreezeCurveGetRangeRequest    : " + JsonConvertUtils.convertToString((Object)measDataInsFreezeCurveGetRangeRequest));
        }
        MeasDataInsFreezeCurveGetRangeResponse response = new MeasDataInsFreezeCurveGetRangeResponse();
        Long measPointId = measDataInsFreezeCurveGetRangeRequest.getMeasPointId();
        Set measItemCodeSet = measDataInsFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        HashMap measDataListMap = Maps.newHashMap();
        for (String measItemCode : measItemCodeSet) {
            HashMap params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataInsFreezeCurveVo> measDataInsFreezeCurveList = this.measDataInsFreezeCurve4RdsDao.getMeasDataInsFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            ArrayList measDataList = Lists.newArrayList();
            for (MeasDataInsFreezeCurveVo measDataInsFreezeCurveVo : measDataInsFreezeCurveList) {
                BigDecimal ptRate;
                BigDecimal ctRate;
                BigDecimal selfRate = measDataInsFreezeCurveVo.getSelfRate();
                if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                    selfRate = new BigDecimal("1.0");
                }
                if ((ctRate = measDataInsFreezeCurveVo.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ctRate = new BigDecimal("1.0");
                }
                if ((ptRate = measDataInsFreezeCurveVo.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().setScale(6, 4);
                if (measDataInsFreezeCurveGetRangeRequest.getMeasDataSideType() == 1) {
                    if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus"})) {
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, 4);
                    } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus"})) {
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, 4);
                    } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus"})) {
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, 4);
                    }
                }
                measDataList.add(new MeasDataInsFreezeCurveValue(measPointId, measItemCode, measDataInsFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataInsFreezeCurveVo.getMeasDataRate().setScale(6, 4), measDataInsFreezeCurveVo.getMeasDataSource(), measDataInsFreezeCurveVo.getFreezeMode(), measDataInsFreezeCurveVo.getGmtMeasData(), measDataInsFreezeCurveVo.getGmtCreate(), measDataInsFreezeCurveVo.getGmtModified()));
            }
            measDataListMap.put(measItemCode, measDataList);
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap((Map)measDataListMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataInsFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getRangeMeasDataInsFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    public MeasDataInsFreezeCurveGetRangeListResponse getRangeMeasDataInsFreezeCurveList(List<MeasDataInsFreezeCurveGetRangeRequest> measDataInsFreezeCurveGetRangeRequest) {
        return null;
    }

    public MeasDataCumDiscreteGetRangeResponse getRangeMeasDataCumDiscrete(MeasDataCumDiscreteGetRangeRequest measDataCumDiscreteGetRangeRequest) {
        return null;
    }

    public MeasDataCumFreezeCurveGetResponse getMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRequest measDataCumFreezeCurveGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getMeasDataCumFreezeCurve >>>>>>> ");
            this.logger.debug(" MeasDataCumFreezeCurveGetRequest     : " + JsonConvertUtils.convertToString((Object)measDataCumFreezeCurveGetRequest));
        }
        MeasDataCumFreezeCurveGetResponse response = new MeasDataCumFreezeCurveGetResponse();
        Long measPointId = measDataCumFreezeCurveGetRequest.getMeasPointId();
        Set measItemCodeSet = measDataCumFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveGetRequest.getGmtMeasFreeze();
        HashMap measDataMap = Maps.newHashMap();
        for (String measItemCode : measItemCodeSet) {
            BigDecimal ptRate;
            BigDecimal ctRate;
            MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo = this.measDataCumFreezeCurve4RdsDao.getMeasDataCumFreezeCurveVoByMeasPointIdAndMeasItemCodeAndGmtMeasFreeze(measPointId, measItemCode, gmtMeasFreeze);
            if (measDataCumFreezeCurveVo == null) continue;
            BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
            if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                selfRate = new BigDecimal("1.0");
            }
            if ((ctRate = measDataCumFreezeCurveVo.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                ctRate = new BigDecimal("1.0");
            }
            if ((ptRate = measDataCumFreezeCurveVo.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                ptRate = new BigDecimal("1.0");
            }
            BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, 4);
            if (measDataCumFreezeCurveGetRequest.getMeasDataSideType() == 1 && StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre"})) {
                measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, 4);
            }
            measDataMap.put(measItemCode, new MeasDataCumFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, 4), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap((Map)measDataMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataCumFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    public MeasDataCumFreezeCurveBatchGetResponse batchGetMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetRequest measDataCumFreezeCurveBatchGetRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start batchGetMeasDataCumFreezeCurve >>>>>>> ");
            this.logger.debug(" MeasDataCumFreezeCurveBatchGetRequest     : " + JsonConvertUtils.convertToString((Object)measDataCumFreezeCurveBatchGetRequest));
        }
        MeasDataCumFreezeCurveBatchGetResponse response = new MeasDataCumFreezeCurveBatchGetResponse();
        Set measPointIdSet = measDataCumFreezeCurveBatchGetRequest.getMeasPointIdSet();
        Set measItemCodeSet = measDataCumFreezeCurveBatchGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveBatchGetRequest.getGmtMeasFreeze();
        HashMap batchMeasDataMap = Maps.newHashMap();
        List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = this.measDataCumFreezeCurve4RdsDao.getMeasDataCumFreezeCurveVoListByMeasPointIdSetAndMeasItemCodeSetAndGmtMeasFreeze(measPointIdSet, measItemCodeSet, gmtMeasFreeze);
        measDataCumFreezeCurveList.forEach(measDataCumFreezeCurveVo -> {
            BigDecimal ptRate;
            BigDecimal ctRate;
            BigDecimal selfRate;
            Long measPointId = measDataCumFreezeCurveVo.getMeasPointId();
            String measItemCode = measDataCumFreezeCurveVo.getMeasItemCode();
            Map measDataMap = (Map)batchMeasDataMap.get(measPointId);
            if (measDataMap == null) {
                measDataMap = Maps.newHashMap();
            }
            if ((selfRate = measDataCumFreezeCurveVo.getSelfRate()) == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                selfRate = new BigDecimal("1.0");
            }
            if ((ctRate = measDataCumFreezeCurveVo.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                ctRate = new BigDecimal("1.0");
            }
            if ((ptRate = measDataCumFreezeCurveVo.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                ptRate = new BigDecimal("1.0");
            }
            BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
            if (measDataCumFreezeCurveBatchGetRequest.getMeasDataSideType() == 1 && StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre"})) {
                measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
            }
            measDataMap.put(measItemCode, new MeasDataCumFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, RoundingMode.HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            batchMeasDataMap.put(measPointId, measDataMap);
        });
        response.setBatchMeasDataMap((Map)batchMeasDataMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataCumFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    public MeasDataCumFreezeCurveBatchGetMTPsResponse batchGetMTPsMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetMTPsRequest measDataCumFreezeCurveBatchGetMTPsRequest) {
        return null;
    }

    public MeasDataCumFreezeCurveGetRangeResponse getRangeMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRangeRequest measDataCumFreezeCurveGetRangeRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start getRangeMeasDataCumFreezeCurve >>>>>>> ");
            this.logger.debug(" MeasDataCumFreezeCurveGetRangeRequest    : " + JsonConvertUtils.convertToString((Object)measDataCumFreezeCurveGetRangeRequest));
        }
        MeasDataCumFreezeCurveGetRangeResponse response = new MeasDataCumFreezeCurveGetRangeResponse();
        Long measPointId = measDataCumFreezeCurveGetRangeRequest.getMeasPointId();
        Set measItemCodeSet = measDataCumFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        HashMap measDataListMap = Maps.newHashMap();
        for (String measItemCode : measItemCodeSet) {
            HashMap params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = this.measDataCumFreezeCurve4RdsDao.getMeasDataCumFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            ArrayList measDataList = Lists.newArrayList();
            for (MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo : measDataCumFreezeCurveList) {
                BigDecimal ptRate;
                BigDecimal ctRate;
                BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
                if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
                    selfRate = new BigDecimal("1.0");
                }
                if ((ctRate = measDataCumFreezeCurveVo.getCtRate()) == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ctRate = new BigDecimal("1.0");
                }
                if ((ptRate = measDataCumFreezeCurveVo.getPtRate()) == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, 4);
                if (measDataCumFreezeCurveGetRangeRequest.getMeasDataSideType() == 1 && StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre"})) {
                    measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, 4);
                }
                measDataList.add(new MeasDataCumFreezeCurveValue(measPointId, measItemCode, measDataCumFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, 4), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            }
            measDataListMap.put(measItemCode, measDataList);
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap((Map)measDataListMap);
        response.setReturnCode("SUCCESS");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" MeasDataCumFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString((Object)response));
            this.logger.debug(" <<<<<<<< end getRangeMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    public MeasDataCumFreezeDayGetResponse getMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRequest measDataCumFreezeDayGetRequest) {
        return null;
    }

    public MeasDataCumFreezeDayGetRangeResponse getRangeMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRangeRequest measDataCumFreezeDayGetRangeRequest) {
        return null;
    }

    public MeasDataStateBoolDiscreteGetRangeResponse getRangeMeasDataStateBoolDiscrete(MeasDataStateBoolDiscreteGetRangeRequest measDataStateBoolDiscreteGetRangeRequest) {
        return null;
    }

    public MeasDataStateCharDiscreteGetRangeResponse getRangeMeasDataStateCharDiscrete(MeasDataStateCharDiscreteGetRangeRequest measDataStateCharDiscreteGetRangeRequest) {
        return null;
    }

    public MeasDataStatsDiscreteGetRangeResponse getRangeMeasDataStatsDiscrete(MeasDataStatsDiscreteGetRangeRequest measDataStatsDiscreteGetRangeRequest) {
        return null;
    }

    public MeasDataAlarmDiscreteGetRangeResponse getRangeMeasDataAlarmDiscrete(MeasDataAlarmDiscreteGetRangeRequest measDataAlarmDiscreteGetRangeRequest) {
        return null;
    }
}

