/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.service.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.easesource.iot.datacenter.openservice.dao.MeasDataCumFreezeCurve4RdsDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataInsFreezeCurve4RdsDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataLatest4RdsDao;
import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveDo;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestDo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="measDataStoreService4Rds")
public class MeasDataStoreService4RdsImpl
extends AbstractBaseService
implements MeasDataStoreService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private MeasDataLatest4RdsDao measDataLatest4RdsDao;
    @Resource
    private MeasDataCumFreezeCurve4RdsDao measDataCumFreezeCurve4RdsDao;
    @Resource
    private MeasDataInsFreezeCurve4RdsDao measDataInsFreezeCurve4RdsDao;

    public void updateMeasDataLatest(Long measPointId, String measItemCode, Map<String, Object> measDataInfo) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start updateMeasDataLatest >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
            this.logger.debug(" measDataInfo     : " + JsonConvertUtils.convertToString(measDataInfo));
        }
        MeasDataLatestDo measDataLatestDo = new MeasDataLatestDo();
        measDataLatestDo.setMeasPointId(measPointId);
        measDataLatestDo.setMeasItemCode(measItemCode);
        measDataLatestDo.setMeasDataInfo(JsonConvertUtils.convertToString(measDataInfo));
        measDataLatestDo.setGmtModified(System.currentTimeMillis());
        int result = this.measDataLatest4RdsDao.updateByMeasPointIdAndMeasItemCode(measDataLatestDo);
        if (result > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" measDataLatestDo is exists, update success! ");
            }
        } else {
            measDataLatestDo.setId(Long.valueOf(this.iotDataIdGenerator.nextId()));
            measDataLatestDo.setGmtCreate(measDataLatestDo.getGmtModified());
            result = this.measDataLatest4RdsDao.insert(measDataLatestDo);
            if (result > 0 && this.logger.isDebugEnabled()) {
                this.logger.debug(" measDataLatestDo is not exists, insert success! ");
            }
        }
    }

    public void batchUpdateMeasDataLatest(Map<Long, Map<String, Map<String, Object>>> batchMeasDataInfosMap) {
    }

    public void deleteMeasDataLatest(Long measPointId, String measItemCode) {
        int result;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start deleteMeasDataLatest >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
        }
        if ((result = this.measDataLatest4RdsDao.deleteByMeasPointIdAndMeasItemCode(measPointId, measItemCode)) > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(" measDataLatestDo is exists, delete success! ");
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(" measDataLatestDo is not exists. ");
        }
    }

    public void insertOrUpdateMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start insertOrUpdateMeasDataCumFreezeCurve >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
            this.logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasFreeze), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" measDataValue    : " + measDataValue);
            this.logger.debug(" measDataRate     : " + measDataRate);
            this.logger.debug(" measDataSource   : " + measDataSource);
            this.logger.debug(" gmtMeasData      : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasData), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" freezeMode       : " + freezeMode);
        }
        MeasDataCumFreezeCurveDo measDataCumFreezeCurveDo = new MeasDataCumFreezeCurveDo();
        measDataCumFreezeCurveDo.setId(Long.valueOf(this.iotDataIdGenerator.nextId()));
        measDataCumFreezeCurveDo.setMeasPointId(measPointId);
        measDataCumFreezeCurveDo.setMeasItemCode(measItemCode);
        measDataCumFreezeCurveDo.setGmtMeasFreeze(gmtMeasFreeze);
        measDataCumFreezeCurveDo.setMeasDataValue(measDataValue);
        measDataCumFreezeCurveDo.setMeasDataRate(measDataRate);
        measDataCumFreezeCurveDo.setMeasDataSource(measDataSource);
        measDataCumFreezeCurveDo.setGmtMeasData(gmtMeasData);
        measDataCumFreezeCurveDo.setFreezeMode(freezeMode);
        measDataCumFreezeCurveDo.setGmtCreate(System.currentTimeMillis());
        measDataCumFreezeCurveDo.setGmtModified(System.currentTimeMillis());
        this.measDataCumFreezeCurve4RdsDao.insert(measDataCumFreezeCurveDo);
    }

    public void batchInsertOrUpdateMeasDataCumFreezeCurve(List<MeasDataCumFreezeCurveDo> measDataCumFreezeCurveDoList) {
    }

    public void deleteMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze) {
    }

    public void deleteMeasDataCumFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd) {
    }

    public void insertOrUpdateMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start insertOrUpdateMeasDataInsFreezeCurve >>>>>>> ");
            this.logger.debug(" measPointId      : " + measPointId);
            this.logger.debug(" measItemCode     : " + measItemCode);
            this.logger.debug(" gmtMeasFreeze    : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasFreeze), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" measDataValue    : " + measDataValue);
            this.logger.debug(" measDataRate     : " + measDataRate);
            this.logger.debug(" measDataSource   : " + measDataSource);
            this.logger.debug(" gmtMeasData      : " + DateConvertUtils.convertToString((Date)new Date(gmtMeasData), (String)"yyyyMMddHHmmssSSS"));
            this.logger.debug(" freezeMode       : " + freezeMode);
        }
        MeasDataInsFreezeCurveDo measDataInsFreezeCurveDo = new MeasDataInsFreezeCurveDo();
        measDataInsFreezeCurveDo.setId(Long.valueOf(this.iotDataIdGenerator.nextId()));
        measDataInsFreezeCurveDo.setMeasPointId(measPointId);
        measDataInsFreezeCurveDo.setMeasItemCode(measItemCode);
        measDataInsFreezeCurveDo.setGmtMeasFreeze(gmtMeasFreeze);
        measDataInsFreezeCurveDo.setMeasDataValue(measDataValue);
        measDataInsFreezeCurveDo.setMeasDataRate(measDataRate);
        measDataInsFreezeCurveDo.setMeasDataSource(measDataSource);
        measDataInsFreezeCurveDo.setGmtMeasData(gmtMeasData);
        measDataInsFreezeCurveDo.setFreezeMode(freezeMode);
        measDataInsFreezeCurveDo.setGmtCreate(System.currentTimeMillis());
        measDataInsFreezeCurveDo.setGmtModified(System.currentTimeMillis());
        this.measDataInsFreezeCurve4RdsDao.insert(measDataInsFreezeCurveDo);
    }

    public void batchInsertOrUpdateMeasDataInsFreezeCurve(List<MeasDataInsFreezeCurveDo> measDataInsFreezeCurveDoList) {
    }

    public void deleteMeasDataInsFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze) {
    }

    public void deleteMeasDataInsFreezeCurveDay(Set<Long> measPointIds, long gmtMeasFreeze, long gmtMeasFreezeEnd) {
    }
}

