/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.tablestore;

import com.easesource.commons.util.MapUtils;
import com.easesource.data.bean.Pager;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public abstract class AbstractEaseIotBaseTableStoreDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final RowMapper<Map<String, Object>> mapRowMapper = (rs, rowNum) -> {
        ResultSetMetaData rsmd = rs.getMetaData();
        HashMap map = Maps.newHashMap();
        block20: for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            if (rs.getObject(i) == null) continue;
            switch (rsmd.getColumnType(i)) {
                case -6: {
                    if (rsmd.getScale(i) == 0 && rsmd.getPrecision(i) == 1) {
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getBoolean(i));
                        continue block20;
                    }
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getInt(i));
                    continue block20;
                }
                case 5: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getInt(i));
                    continue block20;
                }
                case 4: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getInt(i));
                    continue block20;
                }
                case -5: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getLong(i));
                    continue block20;
                }
                case 6: {
                    map.put(rsmd.getColumnLabel(i).trim(), new BigDecimal(Float.toString(rs.getFloat(i))));
                    continue block20;
                }
                case 7: {
                    map.put(rsmd.getColumnLabel(i).trim(), new BigDecimal(Float.toString(rs.getFloat(i))));
                    continue block20;
                }
                case 8: {
                    map.put(rsmd.getColumnLabel(i).trim(), new BigDecimal(Double.toString(rs.getDouble(i))));
                    continue block20;
                }
                case 3: {
                    if (rsmd.getScale(i) == 0) {
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i).longValue());
                        continue block20;
                    }
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i));
                    continue block20;
                }
                case 2: {
                    if (rsmd.getScale(i) == 0) {
                        map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i).longValue());
                        continue block20;
                    }
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getBigDecimal(i));
                    continue block20;
                }
                case 91: {
                    map.put(rsmd.getColumnLabel(i).trim(), new Date(rs.getDate(i).getTime()));
                    continue block20;
                }
                case 92: {
                    map.put(rsmd.getColumnLabel(i).trim(), new Date(rs.getTime(i).getTime()));
                    continue block20;
                }
                case 93: {
                    map.put(rsmd.getColumnLabel(i).trim(), new Date(rs.getTimestamp(i).getTime()));
                    continue block20;
                }
                case 1: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block20;
                }
                case -15: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block20;
                }
                case 12: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block20;
                }
                case -9: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block20;
                }
                case -1: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block20;
                }
                case -16: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getString(i));
                    continue block20;
                }
                default: {
                    map.put(rsmd.getColumnLabel(i).trim(), rs.getObject(i));
                }
            }
        }
        return map;
    };

    protected boolean isExistColumn(ResultSet rs, String columnName) {
        try {
            if (rs.findColumn(columnName) > 0) {
                return true;
            }
        }
        catch (SQLException sqle) {
            return false;
        }
        return false;
    }

    protected Map<String, Object> handleParamMapForInList(Map<String, Object> params) {
        params = MapUtils.emptyIfNull(params);
        Set keys = params.keySet();
        for (String key : keys) {
            if (params.get(key) == null || !params.get(key).getClass().isArray()) continue;
            params.put(key, Collections.singletonList(params.get(key)));
        }
        return params;
    }

    protected StringBuilder generateSqlForSorter() {
        StringBuilder sqlPaginationBuilder = new StringBuilder();
        sqlPaginationBuilder.append(" LIMIT :start, :size ");
        return sqlPaginationBuilder;
    }

    protected StringBuilder generateSqlForPager() {
        StringBuilder sqlPaginationBuilder = new StringBuilder();
        sqlPaginationBuilder.append(" LIMIT :start, :size ");
        return sqlPaginationBuilder;
    }

    protected Map<String, Object> handleParamMapForPager(Map<String, Object> params, Pager pager) {
        if (pager != null) {
            params = MapUtils.emptyIfNull(params);
            params.put("start", pager.getStart());
            params.put("size", pager.getSize());
        }
        return params;
    }
}

