/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.datacenter.openservice.tablestore.dao.impl;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.BatchGetRowRequest;
import com.alicloud.openservices.tablestore.model.BatchGetRowResponse;
import com.alicloud.openservices.tablestore.model.BatchWriteRowRequest;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.DeleteRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowRequest;
import com.alicloud.openservices.tablestore.model.GetRowResponse;
import com.alicloud.openservices.tablestore.model.MultiRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyBuilder;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.PutRowRequest;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.RowDeleteChange;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.alicloud.openservices.tablestore.model.SingleRowQueryCriteria;
import com.easesource.commons.util.NumberUtils;
import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;
import com.easesource.iot.datacenter.openservice.tablestore.AbstractEaseIotBaseTableStoreDao;
import com.easesource.iot.datacenter.openservice.tablestore.TableStoreTemplate;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataLatestDao;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class MeasDataLatestDaoImpl
extends AbstractEaseIotBaseTableStoreDao
implements MeasDataLatestDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource(name="easeIotTableStoreTemplate")
    private TableStoreTemplate easeIotTableStoreTemplate;
    @Qualifier(value="easeIotJdbcTemplate")
    @Resource(name="easeIotJdbcTemplate")
    private JdbcTemplate easeIotJdbcTemplate;

    @Override
    public int updateMeasDataInfoLatest(Long measPointId, String measItemCode, Map<String, Object> measDataInfoMap, int measDataSource, long gmtMeasDataLatest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start updateMeasDataInfoLatest >>>>>>> ");
            this.logger.debug(" measPointId          : " + measPointId);
            this.logger.debug(" measItemCode         : " + measItemCode);
            this.logger.debug(" measDataInfoMap      : " + JsonConvertUtils.convertToString(measDataInfoMap));
            this.logger.debug(" measDataSource       : " + measDataSource);
            this.logger.debug(" gmtMeasDataLatest    : " + gmtMeasDataLatest);
        }
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("meas_point_id", PrimaryKeyValue.fromLong((long)measPointId));
        primaryKeyBuilder.addPrimaryKeyColumn("meas_item_code", PrimaryKeyValue.fromString((String)measItemCode));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowPutChange rowPutChange = new RowPutChange("meas_data_latest", primaryKey);
        rowPutChange.addColumn(new Column("meas_data_info", ColumnValue.fromString((String)JsonConvertUtils.convertToString(measDataInfoMap)), System.currentTimeMillis()));
        rowPutChange.addColumn(new Column("meas_data_source", ColumnValue.fromLong((long)measDataSource), System.currentTimeMillis()));
        rowPutChange.addColumn(new Column("gmt_meas_data_latest", ColumnValue.fromLong((long)System.currentTimeMillis()), System.currentTimeMillis()));
        PutRowRequest putRowRequest = new PutRowRequest(rowPutChange);
        this.easeIotTableStoreTemplate.putRowSync(putRowRequest);
        return 1;
    }

    @Override
    public int batchUpdateMeasDataInfoLatest(Map<Long, Map<String, Map<String, Object>>> batchMeasDataInfosMap) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>>> start batchUpdateMeasDataInfoLatest >>>>>>> ");
            this.logger.debug(" batchMeasDataInfosMap    : " + JsonConvertUtils.convertToString(batchMeasDataInfosMap));
        }
        BatchWriteRowRequest batchWriteRowRequest = new BatchWriteRowRequest();
        int n = 0;
        int i = 0;
        for (Long measPointId : batchMeasDataInfosMap.keySet()) {
            Map<String, Map<String, Object>> insideMap = batchMeasDataInfosMap.get(measPointId);
            for (String measItemCode : insideMap.keySet()) {
                ++n;
                ++i;
                Map<String, Object> measDataInfoMap = insideMap.get(measItemCode);
                PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
                primaryKeyBuilder.addPrimaryKeyColumn("meas_point_id", PrimaryKeyValue.fromLong((long)measPointId));
                primaryKeyBuilder.addPrimaryKeyColumn("meas_item_code", PrimaryKeyValue.fromString((String)measItemCode));
                PrimaryKey primaryKey = primaryKeyBuilder.build();
                RowPutChange rowPutChange = new RowPutChange("meas_data_latest", primaryKey);
                int measDataSource = NumberUtils.toInt((String)ObjectUtils.toStringDefaultEmpty((Object)measDataInfoMap.get("measDataSource")), (int)0);
                long gmtMeasDataLatest = NumberUtils.toLong((String)ObjectUtils.toStringDefaultEmpty((Object)measDataInfoMap.get("gmtMeasDataLatest")), (long)System.currentTimeMillis());
                rowPutChange.addColumn(new Column("meas_data_info", ColumnValue.fromString((String)JsonConvertUtils.convertToString(measDataInfoMap)), System.currentTimeMillis()));
                rowPutChange.addColumn(new Column("meas_data_source", ColumnValue.fromLong((long)measDataSource), System.currentTimeMillis()));
                rowPutChange.addColumn(new Column("gmt_meas_data_latest", ColumnValue.fromLong((long)System.currentTimeMillis()), System.currentTimeMillis()));
                batchWriteRowRequest.addRowChange((RowChange)rowPutChange);
                if (i != 199) continue;
                this.easeIotTableStoreTemplate.batchWriteRowSync(batchWriteRowRequest);
                i = 0;
                batchWriteRowRequest = new BatchWriteRowRequest();
            }
        }
        if (i > 0) {
            this.easeIotTableStoreTemplate.batchWriteRowSync(batchWriteRowRequest);
        }
        return n;
    }

    @Override
    public int deleteByMeasPointIdAndMeasItemCode(Long measPointId, String measItemCode) {
        PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
        primaryKeyBuilder.addPrimaryKeyColumn("meas_point_id", PrimaryKeyValue.fromLong((long)measPointId));
        primaryKeyBuilder.addPrimaryKeyColumn("meas_item_code", PrimaryKeyValue.fromString((String)measItemCode));
        PrimaryKey primaryKey = primaryKeyBuilder.build();
        RowDeleteChange rowDeleteChange = new RowDeleteChange("meas_data_latest", primaryKey);
        DeleteRowRequest deleteRowRequest = new DeleteRowRequest(rowDeleteChange);
        this.easeIotTableStoreTemplate.deleteRowSync(deleteRowRequest);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, MeasDataLatestInfo> getMeasDataLatestInfoMap(Long measPointId, Set<String> measItemCodeSet, Integer measDataSideType) {
        BigDecimal ptRate;
        BigDecimal ctRate;
        BigDecimal selfRate;
        Map gdmMap;
        SqlParamsBuilder sqlParamsBuilder = new SqlParamsBuilder();
        sqlParamsBuilder.append("SELECT gdm.meas_point_id, gdm.self_rate, gdm.ct_rate, gdm.pt_rate ");
        sqlParamsBuilder.append(" FROM iesms.gm_dev_meter gdm ");
        sqlParamsBuilder.append(" WHERE gdm.meas_point_id = ? ", (Object)measPointId);
        sqlParamsBuilder.append(" LIMIT 1 ");
        try {
            gdmMap = (Map)this.easeIotJdbcTemplate.queryForObject(sqlParamsBuilder.getSql(), sqlParamsBuilder.getParams(), this.mapRowMapper);
        }
        catch (EmptyResultDataAccessException _erdae) {
            gdmMap = null;
        }
        BigDecimal bigDecimal = selfRate = gdmMap != null ? (BigDecimal)gdmMap.get("self_rate") : new BigDecimal("1.0");
        if (selfRate == null || selfRate.compareTo(BigDecimal.ZERO) <= 0) {
            selfRate = new BigDecimal("1.0");
        }
        BigDecimal bigDecimal2 = ctRate = gdmMap != null ? (BigDecimal)gdmMap.get("ct_rate") : new BigDecimal("1.0");
        if (ctRate == null || ctRate.compareTo(BigDecimal.ZERO) <= 0) {
            ctRate = new BigDecimal("1.0");
        }
        BigDecimal bigDecimal3 = ptRate = gdmMap != null ? (BigDecimal)gdmMap.get("pt_rate") : new BigDecimal("1.0");
        if (ptRate == null || ptRate.compareTo(BigDecimal.ZERO) <= 0) {
            ptRate = new BigDecimal("1.0");
        }
        HashMap measDataLatestInfoMap = Maps.newHashMap();
        ArrayList measItemCodeList = Lists.newArrayList(measItemCodeSet);
        List listList = Lists.partition((List)measItemCodeList, (int)100);
        for (List list : listList) {
            HashSet measItemCodeSetTemp = Sets.newHashSet((Iterable)list);
            MultiRowQueryCriteria multiRowQueryCriteria = new MultiRowQueryCriteria("meas_data_latest");
            for (String measItemCode : measItemCodeSetTemp) {
                if (!StringUtils.isNotBlank((CharSequence)measItemCode)) continue;
                try {
                    PrimaryKeyBuilder primaryKeyBuilder = PrimaryKeyBuilder.createPrimaryKeyBuilder();
                    primaryKeyBuilder.addPrimaryKeyColumn("meas_point_id", PrimaryKeyValue.fromLong((long)measPointId));
                    primaryKeyBuilder.addPrimaryKeyColumn("meas_item_code", PrimaryKeyValue.fromString((String)measItemCode));
                    PrimaryKey primaryKey = primaryKeyBuilder.build();
                    multiRowQueryCriteria.addRow(primaryKey);
                }
                catch (Exception _e) {
                    this.logger.error(_e.getMessage(), _e.fillInStackTrace());
                }
            }
            if (multiRowQueryCriteria.isEmpty()) {
                return measDataLatestInfoMap;
            }
            multiRowQueryCriteria.setMaxVersions(1);
            multiRowQueryCriteria.addColumnsToGet(Arrays.asList("meas_data_info", "meas_data_source", "gmt_meas_data_latest"));
            BatchGetRowRequest batchGetRowRequest = new BatchGetRowRequest();
            batchGetRowRequest.addMultiRowQueryCriteria(multiRowQueryCriteria);
            BatchGetRowResponse batchGetRowResponse = null;
            try {
                batchGetRowResponse = this.easeIotTableStoreTemplate.batchGetRowSync(batchGetRowRequest);
                List rowResults = batchGetRowResponse.getBatchGetRowResult("meas_data_latest");
                if (rowResults == null || rowResults.size() <= 0) continue;
                for (BatchGetRowResponse.RowResult rowResult : rowResults) {
                    if (rowResult.isSucceed()) {
                        Row row = rowResult.getRow();
                        if (row == null) continue;
                        MeasDataLatestInfo measDataLatestInfo = this.row2MeasDataLatestInfo(row, measDataSideType, selfRate, ctRate, ptRate);
                        measDataLatestInfoMap.put(measDataLatestInfo.getMeasItemCode(), measDataLatestInfo);
                        continue;
                    }
                    PrimaryKey primaryKey = batchGetRowRequest.getPrimaryKey(rowResult.getTableName(), rowResult.getIndex());
                    if (primaryKey == null) continue;
                    SingleRowQueryCriteria criteria = new SingleRowQueryCriteria("meas_data_latest", primaryKey);
                    criteria.setMaxVersions(1);
                    criteria.addColumnsToGet(Arrays.asList("meas_data_info", "meas_data_source", "gmt_meas_data_latest"));
                    GetRowRequest getRowRequest = new GetRowRequest(criteria);
                    GetRowResponse getRowResponse = this.easeIotTableStoreTemplate.getRowSync(getRowRequest);
                    Row row = getRowResponse.getRow();
                    if (row == null) continue;
                    MeasDataLatestInfo measDataLatestInfo = this.row2MeasDataLatestInfo(row, measDataSideType, selfRate, ctRate, ptRate);
                    measDataLatestInfoMap.put(measDataLatestInfo.getMeasItemCode(), measDataLatestInfo);
                }
            }
            catch (ClientException | TableStoreException e) {
                this.logger.error(e.getMessage(), e.fillInStackTrace());
            }
            finally {
                if (batchGetRowResponse == null) continue;
                batchGetRowResponse = null;
            }
        }
        return measDataLatestInfoMap;
    }

    @Override
    public Map<Long, Map<String, MeasDataLatestInfo>> batchGetMeasDataLatestInfoMap(Set<Long> measPointIdSet, Set<String> measItemCodeSet, Integer measDataSideType) {
        HashMap batchMeasDataLatestInfoMap = Maps.newHashMap();
        for (Long measPointId : measPointIdSet) {
            batchMeasDataLatestInfoMap.put(measPointId, this.getMeasDataLatestInfoMap(measPointId, measItemCodeSet, measDataSideType));
        }
        return batchMeasDataLatestInfoMap;
    }

    private MeasDataLatestInfo row2MeasDataLatestInfo(Row row, Integer measDataSideType, BigDecimal selfRate, BigDecimal ctRate, BigDecimal ptRate) {
        MeasDataLatestInfo measDataLatestInfo = null;
        if (row != null) {
            measDataLatestInfo = new MeasDataLatestInfo();
            PrimaryKey primaryKey = row.getPrimaryKey();
            if (primaryKey != null) {
                Column gmtMeasDataLatestCol;
                Column measDataSourceCol;
                PrimaryKeyColumn measPointIdCol = primaryKey.getPrimaryKeyColumn("meas_point_id");
                PrimaryKeyColumn measItemCodeCol = primaryKey.getPrimaryKeyColumn("meas_item_code");
                Long measPointId = measPointIdCol.getValue().asLong();
                String measItemCode = measItemCodeCol.getValue().asString();
                measDataLatestInfo.setMeasPointId(measPointId);
                measDataLatestInfo.setMeasItemCode(measItemCode);
                Column measDataInfoCol = row.getLatestColumn("meas_data_info");
                if (measDataInfoCol != null) {
                    Object measDataValueObj;
                    String measDataInfoStr = measDataInfoCol.getValue().asString();
                    Map measDataInfoMap = (Map)JsonConvertUtils.convertFromString((String)measDataInfoStr, Map.class);
                    String measDataClassName = (String)measDataInfoMap.get("meas_data_class");
                    if (StringUtils.isBlank((CharSequence)measDataClassName)) {
                        measDataClassName = (String)measDataInfoMap.get("measDataClass");
                    }
                    if ((measDataValueObj = measDataInfoMap.get("meas_data_value")) == null) {
                        measDataValueObj = measDataInfoMap.get("measDataValue");
                    }
                    Class measDataClass = null;
                    Object measDataValue = null;
                    if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.math.BigDecimal") && measDataValueObj != null) {
                        measDataClass = BigDecimal.class;
                        measDataValue = new BigDecimal(measDataValueObj.toString()).setScale(8, 4);
                        if (measDataSideType != null && measDataSideType == 1) {
                            if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus"})) {
                                measDataValue = new BigDecimal(measDataValueObj.toString()).multiply(selfRate).multiply(ptRate).setScale(8, 4);
                            } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus"})) {
                                measDataValue = new BigDecimal(measDataValueObj.toString()).multiply(selfRate).multiply(ctRate).setScale(8, 4);
                            } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus"})) {
                                measDataValue = new BigDecimal(measDataValueObj.toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(8, 4);
                            } else if (StringUtils.containsAny((CharSequence)measItemCode, (CharSequence[])new CharSequence[]{"gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre"})) {
                                measDataValue = new BigDecimal(measDataValueObj.toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(8, 4);
                            }
                        }
                    } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.lang.Boolean") && measDataValueObj != null) {
                        measDataClass = Boolean.class;
                        measDataValue = Boolean.valueOf(measDataValueObj.toString());
                    } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.lang.String") && measDataValueObj != null) {
                        measDataClass = String.class;
                        measDataValue = measDataValueObj.toString();
                    } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.lang.Integer") && measDataValueObj != null) {
                        measDataClass = Integer.class;
                        measDataValue = Integer.valueOf(measDataValueObj.toString());
                    } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.lang.Long") && measDataValueObj != null) {
                        measDataClass = Long.class;
                        measDataValue = Long.valueOf(measDataValueObj.toString());
                    } else if (StringUtils.equals((CharSequence)measDataClassName, (CharSequence)"java.util.Date") && measDataValueObj != null) {
                        measDataClass = Date.class;
                        measDataValue = new Date(Long.parseLong(measDataValueObj.toString()));
                    }
                    measDataLatestInfo.setMeasDataClass(measDataClass);
                    measDataLatestInfo.setMeasDataValue(measDataValue);
                }
                if ((measDataSourceCol = row.getLatestColumn("meas_data_source")) != null) {
                    measDataLatestInfo.setMeasDataSource(NumberUtils.toInt((String)String.valueOf(measDataSourceCol.getValue().asLong()), (int)0));
                }
                if ((gmtMeasDataLatestCol = row.getLatestColumn("gmt_meas_data_latest")) != null) {
                    long gmtMeasDataLatest = gmtMeasDataLatestCol.getValue().asLong();
                    measDataLatestInfo.setGmtMeasDataLatest(gmtMeasDataLatest);
                    measDataLatestInfo.setGmtCreate(gmtMeasDataLatestCol.getTimestamp());
                    measDataLatestInfo.setGmtModified(gmtMeasDataLatestCol.getTimestamp());
                }
            }
        }
        return measDataLatestInfo;
    }
}

