package com.easesource.iot.datacenter.openservice.service.impl;

import com.easesource.commons.util.DateUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Sorter;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasStatService;
import com.easesource.iot.datacenter.openservice.dao.MeasDataCumFreezeCurve4RdsDao;
import com.easesource.iot.datacenter.openservice.entity.*;
import com.easesource.iot.datacenter.openservice.request.*;
import com.easesource.iot.datacenter.openservice.response.*;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "measStatService4Rds")
public class MeasStatService4RdsImpl extends AbstractBaseService implements MeasStatService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private MeasDataCumFreezeCurve4RdsDao measDataCumFreezeCurve4RdsDao;

    @Override
    public MeasStatInsDayGetResponse getMeasStatInsDay(MeasStatInsDayGetRequest measStatInsDayGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasStatInsDay >>>>>>> ");
            logger.debug(" MeasStatInsDayGetRequest         : " + JsonConvertUtils.convertToString(measStatInsDayGetRequest));
        }

        MeasStatInsDayGetResponse response = new MeasStatInsDayGetResponse();
        Long measPointId = measStatInsDayGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatInsDayGetRequest.getMeasItemCodeSet();
        Date dateMeasStat = DateConvertUtils.convertFromString(measStatInsDayGetRequest.getDateMeasStat(), DateConvertUtils.PATTERNS_DATE);
        Map<String, MeasStatInsDayValue> measStatMap = Maps.newHashMap();
        /*for(String measItemCode : measItemCodeSet) {
            measStatMap.put(measItemCode, new MeasStatInsDayValue(
                    measPointId,
                    measItemCode,
                    DateConvertUtils.convertToString(dateMeasStat, DateConvertUtils.PATTERN_DATE_WITHOUTSPR),
                    new BigDecimal(1.0),
                    new BigDecimal(RandomUtils.nextDouble(1.0, 100.0)),
                    new BigDecimal(RandomUtils.nextDouble(1.0, 100.0)),
                    System.currentTimeMillis(),
                    new BigDecimal(RandomUtils.nextDouble(1.0, 100.0)),
                    System.currentTimeMillis(),
                    "meas_data_ins_freeze_curve",
                    96,
                    System.currentTimeMillis(),
                    System.currentTimeMillis()
            ));
        }*/
        response.setMeasPointId(measPointId);
        response.setMeasStatMap(measStatMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatInsDayGetResponse        : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasStatInsDay <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatInsDayBatchGetResponse batchGetMeasStatInsDay(MeasStatInsDayBatchGetRequest measStatInsDayBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatInsDayGetRangeResponse getRangeMeasStatInsDay(MeasStatInsDayGetRangeRequest measStatInsDayGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasStatInsDay >>>>>>> ");
            logger.debug(" MeasStatInsDayGetRangeRequest    : " + JsonConvertUtils.convertToString(measStatInsDayGetRangeRequest));
        }

        MeasStatInsDayGetRangeResponse response = new MeasStatInsDayGetRangeResponse();
        Long measPointId = measStatInsDayGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatInsDayGetRangeRequest.getMeasItemCodeSet();
        Date dateMeasStatStart = DateConvertUtils.convertFromString(measStatInsDayGetRangeRequest.getDateMeasStatStart(), DateConvertUtils.PATTERNS_DATE);
        Date dateMeasStatEnd = DateConvertUtils.convertFromString(measStatInsDayGetRangeRequest.getDateMeasStatEnd(), DateConvertUtils.PATTERNS_DATE);

        Map<String, List<MeasStatInsDayValue>> measStatListMap = Maps.newHashMap();
        /*for(String measItemCode : measItemCodeSet) {
            List<MeasStatInsDayValue> measStatList = Lists.newArrayList();
            while(dateMeasStatStart.getTime() < dateMeasStatEnd.getTime()) {
                measStatList.add(new MeasStatInsDayValue(
                        measPointId,
                        measItemCode,
                        DateConvertUtils.convertToString(dateMeasStatStart, DateConvertUtils.PATTERN_DATE_WITHOUTSPR),
                        new BigDecimal(1.0),
                        new BigDecimal(RandomUtils.nextDouble(1.0, 100.0)),
                        new BigDecimal(RandomUtils.nextDouble(1.0, 100.0)),
                        System.currentTimeMillis(),
                        new BigDecimal(RandomUtils.nextDouble(1.0, 100.0)),
                        System.currentTimeMillis(),
                        "meas_data_ins_freeze_curve",
                        96,
                        System.currentTimeMillis(),
                        System.currentTimeMillis()));
                dateMeasStatStart = DateUtils.addDays(dateMeasStatStart, 1);
            }
            measStatListMap.put(measItemCode, measStatList);
        }*/
        response.setMeasPointId(measPointId);
        response.setMeasStatListMap(measStatListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatInsDayGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasStatInsDay <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatInsDayBatchGetRangeResponse batchGetRangeMeasStatInsDay(MeasStatInsDayBatchGetRangeRequest measStatInsDayBatchGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatInsMonthGetResponse getMeasStatInsMonth(MeasStatInsMonthGetRequest measStatInsMonthGetRequest) {
        return null;
    }

    @Override
    public MeasStatInsMonthBatchGetResponse batchGetMeasStatInsMonth(MeasStatInsMonthBatchGetRequest measStatInsMonthBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatInsMonthGetRangeResponse getRangeMeasStatInsMonth(MeasStatInsMonthGetRangeRequest measStatInsMonthGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatInsMonthBatchGetRangeResponse batchGetRangeMeasStatInsMonth(MeasStatInsMonthBatchGetRangeRequest measStatInsMonthBatchGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatInsYearGetResponse getMeasStatInsYear(MeasStatInsYearGetRequest measStatInsYearGetRequest) {
        return null;
    }

    @Override
    public MeasStatInsYearBatchGetResponse batchGetMeasStatInsYear(MeasStatInsYearBatchGetRequest measStatInsYearBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatInsYearGetRangeResponse getRangeMeasStatInsYear(MeasStatInsYearGetRangeRequest measStatInsYearGetRangeRequest) {
        return null;
    }
    @Override
    public MeasStatInsYearBatchGetRangeResponse batchGetRangeMeasStatInsYear(MeasStatInsYearBatchGetRangeRequest measStatInsYearBatchGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatCumDayGetResponse getMeasStatCumDay(MeasStatCumDayGetRequest measStatCumDayGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasStatCumDay >>>>>>> ");
            logger.debug(" MeasStatCumDayGetRequest         : " + JsonConvertUtils.convertToString(measStatCumDayGetRequest));
        }

        MeasStatCumDayGetResponse response = new MeasStatCumDayGetResponse();
        Long measPointId = measStatCumDayGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatCumDayGetRequest.getMeasItemCodeSet();
        Date dateMeasStat = DateConvertUtils.convertFromString(measStatCumDayGetRequest.getDateMeasStat(), DateConvertUtils.PATTERNS_DATE);
        long gmtMeasFreezeStart = dateMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addMinutes(DateUtils.addDays(dateMeasStat, 1), 1).getTime();
        Map<String, MeasStatCumDayValue> measStatMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataCumFreezeCurveDo> measDataCumFreezeCurveList = measDataCumFreezeCurve4RdsDao.getList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            BigDecimal measDataRate = null;
            BigDecimal startDval = null;
            long gmtStartDval = 0L;
            BigDecimal endDval = null;
            long gmtEndDval = 0L;
            BigDecimal usageDval = null;
            BigDecimal[] usageQvals = new BigDecimal[96];
            BigDecimal[] readingQvals = new BigDecimal[97];
            String statDataSource = "meas_data_cum_freeze_curve";

            long gmtMeasFreezeClock = gmtMeasFreezeStart;
            int ic = 0;
            Map<Long, Integer> mapQuarter = Maps.newHashMap();
            while(gmtMeasFreezeClock < gmtMeasFreezeEnd) {
                if(logger.isDebugEnabled()) {
                    logger.debug("[" + String.format("%2d", ic) + "]" + " gmtMeasFreezeClock   : " + DateConvertUtils.convertToString(new Date(gmtMeasFreezeClock), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                }
                mapQuarter.put(gmtMeasFreezeClock, ic);
                ic++;
                gmtMeasFreezeClock += 15 * 60 * 1000;
            }

            if(logger.isDebugEnabled()) {
                logger.debug(" readingQvals : " + Arrays.toString(readingQvals));
            }
            for(MeasDataCumFreezeCurveDo measDataCumFreezeCurveDo : measDataCumFreezeCurveList) {
                Integer index = mapQuarter.get(measDataCumFreezeCurveDo.getGmtMeasFreeze());
                if(index != null) {
                    if(startDval == null) {
                        startDval = measDataCumFreezeCurveDo.getMeasDataValue();
                        gmtStartDval = measDataCumFreezeCurveDo.getGmtMeasFreeze();
                    }
                    measDataRate = measDataCumFreezeCurveDo.getMeasDataRate();
                    endDval = measDataCumFreezeCurveDo.getMeasDataValue();
                    gmtEndDval = measDataCumFreezeCurveDo.getGmtMeasFreeze();
                    readingQvals[index] = measDataCumFreezeCurveDo.getMeasDataValue();
                }
                //measDataList.add(new MeasDataCumFreezeCurveValue(measPointId, measItemCode, measDataCumFreezeCurveDo.getGmtMeasFreeze(), measDataCumFreezeCurveDo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP), measDataCumFreezeCurveDo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataCumFreezeCurveDo.getMeasDataSource(), measDataCumFreezeCurveDo.getFreezeMode(), measDataCumFreezeCurveDo.getGmtMeasData(), measDataCumFreezeCurveDo.getGmtCreate(), measDataCumFreezeCurveDo.getGmtModified()));
            }
            for(int i = 0; i < 96; i++) {
                usageQvals[i] = (readingQvals[i + 1] != null && readingQvals[i] != null) ? readingQvals[i + 1].subtract(readingQvals[i].setScale(8, BigDecimal.ROUND_HALF_UP)) : null;
            }
            usageDval = (endDval != null && startDval != null) ? endDval.subtract(startDval).setScale(8, BigDecimal.ROUND_HALF_UP) : null;
            if(logger.isDebugEnabled()) {
                logger.debug(" startDval    : " + startDval);
                logger.debug(" gmtStartDval : " + DateConvertUtils.convertToString(new Date(gmtStartDval), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                logger.debug(" endDval      : " + endDval);
                logger.debug(" gmtEndDval   : " + DateConvertUtils.convertToString(new Date(gmtEndDval), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                logger.debug(" readingQvals : " + Arrays.toString(readingQvals));
            }
            //measDataListMap.put(c, measDataList);
            measStatMap.put(measItemCode, new MeasStatCumDayValue(
                measPointId, measItemCode, DateConvertUtils.convertToString(dateMeasStat, DateConvertUtils.PATTERN_DATE_WITHOUTSPR),
                measDataRate, startDval, gmtStartDval, endDval, gmtEndDval, usageDval, usageQvals, statDataSource, gmtEndDval, gmtEndDval));
        }
        /*for(String measItemCode : measItemCodeSet) {
            BigDecimal[] usageQvals = new BigDecimal[96];
            Arrays.fill(usageQvals, new BigDecimal(200.0 / 96).setScale(8, BigDecimal.ROUND_HALF_UP));
            measStatMap.put(measItemCode, new MeasStatCumDayValue(
                    measPointId,
                    measItemCode,
                    DateConvertUtils.convertToString(dateMeasStat, DateConvertUtils.PATTERN_DATE_WITHOUTSPR),
                    new BigDecimal(1.0),
                    new BigDecimal(100.0),
                    dateMeasStat.getTime(),
                    new BigDecimal(300.0),
                    DateUtils.addDays(dateMeasStat, 1).getTime(),
                    new BigDecimal(200.0),
                    usageQvals,
                    "meas_data_cum_freeze_curve",
                    System.currentTimeMillis(),
                    System.currentTimeMillis()
            ));
        }*/
        response.setMeasPointId(measPointId);
        response.setMeasStatMap(measStatMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatCumDayGetResponse        : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasStatCumDay <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatCumDayBatchGetResponse batchGetMeasStatCumDay(MeasStatCumDayBatchGetRequest measStatCumDayBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatCumDayGetRangeResponse getRangeMeasStatCumDay(MeasStatCumDayGetRangeRequest measStatCumDayGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasStatCumDay >>>>>>> ");
            logger.debug(" MeasStatCumDayGetRangeRequest    : " + JsonConvertUtils.convertToString(measStatCumDayGetRangeRequest));
        }

        MeasStatCumDayGetRangeResponse response = new MeasStatCumDayGetRangeResponse();
        Long measPointId = measStatCumDayGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatCumDayGetRangeRequest.getMeasItemCodeSet();
        Date dateMeasStatStart = DateConvertUtils.convertFromString(measStatCumDayGetRangeRequest.getDateMeasStatStart(), DateConvertUtils.PATTERNS_DATE);
        Date dateMeasStatEnd = DateConvertUtils.convertFromString(measStatCumDayGetRangeRequest.getDateMeasStatEnd(), DateConvertUtils.PATTERNS_DATE);

        Map<String, List<MeasStatCumDayValue>> measStatListMap = Maps.newHashMap();
        /*for(String measItemCode : measItemCodeSet) {
            List<MeasStatCumDayValue> measStatList = Lists.newArrayList();
            while(dateMeasStatStart.getTime() < dateMeasStatEnd.getTime()) {
                BigDecimal[] usageQvals = new BigDecimal[96];
                Arrays.fill(usageQvals, new BigDecimal(200.0 / 96).setScale(8, BigDecimal.ROUND_HALF_UP));
                measStatList.add(new MeasStatCumDayValue(
                        measPointId,
                        measItemCode,
                        DateConvertUtils.convertToString(dateMeasStatStart, DateConvertUtils.PATTERN_DATE_WITHOUTSPR),
                        new BigDecimal(1.0),
                        new BigDecimal(100.0),
                        dateMeasStatStart.getTime(),
                        new BigDecimal(300.0),
                        DateUtils.addDays(dateMeasStatStart, 1).getTime(),
                        new BigDecimal(200.0),
                        usageQvals,
                        "meas_data_cum_freeze_curve",
                        System.currentTimeMillis(),
                        System.currentTimeMillis()
                ));
                dateMeasStatStart = DateUtils.addDays(dateMeasStatStart, 1);
            }
            measStatListMap.put(measItemCode, measStatList);
        }*/
        response.setMeasPointId(measPointId);
        response.setMeasStatListMap(measStatListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatCumDayGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasStatCumDay <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatCumDayGetRangeResponse getRangeMeasStatCumDayForUsageDval(MeasStatCumDayGetRangeRequest measStatCumDayGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatCumDayBatchGetRangeResponse batchGetRangeMeasStatCumDay(MeasStatCumDayBatchGetRangeRequest measStatCumDayBatchGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatCumMonthGetResponse getMeasStatCumMonth(MeasStatCumMonthGetRequest measStatCumMonthGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasStatCumMonth >>>>>>> ");
            logger.debug(" MeasStatCumMonthGetRequest       : " + JsonConvertUtils.convertToString(measStatCumMonthGetRequest));
        }

        MeasStatCumMonthGetResponse response = new MeasStatCumMonthGetResponse();
        Long measPointId = measStatCumMonthGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatCumMonthGetRequest.getMeasItemCodeSet();
        Date monthMeasStat = DateConvertUtils.convertFromString(measStatCumMonthGetRequest.getMonthMeasStat(), DateConvertUtils.PATTERNS_MONTH);
        Map<String, MeasStatCumMonthValue> measStatMap = Maps.newHashMap();
        /*for(String measItemCode : measItemCodeSet) {
            int cnt = DateUtils.subtract(DateUtils.addMonths(monthMeasStat, 1), monthMeasStat, DateUtils.TIMEUNIT_DAY);
            BigDecimal[] usageQvals = new BigDecimal[cnt];
            if(DateUtils.getYear(monthMeasStat) == 2019 && DateUtils.getMonthOfYear(monthMeasStat) < 4) {
                Arrays.fill(usageQvals, new BigDecimal(3000.0 / cnt).setScale(8, BigDecimal.ROUND_HALF_UP));
            }
            else {
                Arrays.fill(usageQvals, null);
                usageQvals[0] = new BigDecimal(100.0);
                usageQvals[1] = new BigDecimal(100.0);
                usageQvals[2] = new BigDecimal(100.0);
                usageQvals[3] = new BigDecimal(120.0);
                usageQvals[4] = new BigDecimal(120.0);
                usageQvals[5] = new BigDecimal(90.0);
                usageQvals[6] = new BigDecimal(50.0);
            }
            measStatMap.put(measItemCode, new MeasStatCumMonthValue(
                    measPointId,
                    measItemCode,
                    DateConvertUtils.convertToString(monthMeasStat, DateConvertUtils.PATTERN_MONTH_WITHOUTSPR),
                    new BigDecimal(1.0),
                    new BigDecimal(100.0),
                    monthMeasStat.getTime(),
                    new BigDecimal(3100.0),
                    DateUtils.addMonths(monthMeasStat, 1).getTime(),
                    new BigDecimal(3000.0),
                    usageQvals,
                    "meas_stat_cum_day",
                    System.currentTimeMillis(),
                    System.currentTimeMillis()
            ));
        }*/
        response.setMeasPointId(measPointId);
        response.setMeasStatMap(measStatMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatCumMonthGetResponse      : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasStatCumMonth <<<<<<<< ");
        }
        return response;
    }


    @Override
    public MeasStatCumMonthBatchGetResponse batchGetMeasStatCumMonth(MeasStatCumMonthBatchGetRequest measStatCumMonthBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatCumMonthGetRangeResponse getRangeMeasStatCumMonth(MeasStatCumMonthGetRangeRequest measStatCumMonthGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatCumMonthBatchGetRangeResponse batchGetRangeMeasStatCumMonth(MeasStatCumMonthBatchGetRangeRequest measStatCumMonthBatchGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatCumYearGetResponse getMeasStatCumYear(MeasStatCumYearGetRequest measStatCumYearGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasStatCumYear >>>>>>> ");
            logger.debug(" MeasStatCumYearGetRequest        : " + JsonConvertUtils.convertToString(measStatCumYearGetRequest));
        }

        MeasStatCumYearGetResponse response = new MeasStatCumYearGetResponse();
        Long measPointId = measStatCumYearGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatCumYearGetRequest.getMeasItemCodeSet();
        Date yearMeasStat = DateConvertUtils.convertFromString(measStatCumYearGetRequest.getYearMeasStat(), DateConvertUtils.PATTERNS_YEAR);
        Map<String, MeasStatCumYearValue> measStatMap = Maps.newHashMap();
        /*for(String measItemCode : measItemCodeSet) {
            BigDecimal[] usageQvals = new BigDecimal[12];
            if(DateUtils.getYear(yearMeasStat) < 2019) {
                Arrays.fill(usageQvals, new BigDecimal(57000.0 / 12).setScale(8, BigDecimal.ROUND_HALF_UP));
            }
            else {
                Arrays.fill(usageQvals, null);
                usageQvals[0] = new BigDecimal(3000.0);
                usageQvals[1] = new BigDecimal(2900.0);
                usageQvals[2] = new BigDecimal(3100.0);
                usageQvals[3] = new BigDecimal(700.0);
            }
            measStatMap.put(measItemCode, new MeasStatCumYearValue(
                    measPointId,
                    measItemCode,
                    DateConvertUtils.convertToString(yearMeasStat, DateConvertUtils.PATTERN_YEAR),
                    new BigDecimal(1.0),
                    new BigDecimal(100.0),
                    yearMeasStat.getTime(),
                    new BigDecimal(57100.0),
                    DateUtils.addYears(yearMeasStat, 1).getTime(),
                    new BigDecimal(57000.0),
                    usageQvals,
                    "meas_stat_cum_month",
                    System.currentTimeMillis(),
                    System.currentTimeMillis()
            ));
        }*/
        response.setMeasPointId(measPointId);
        response.setMeasStatMap(measStatMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatCumYearGetResponse      : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasStatCumYear <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatCumYearBatchGetResponse batchGetMeasStatCumYear(MeasStatCumYearBatchGetRequest measStatCumYearBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatCumYearGetRangeResponse getRangeMeasStatCumYear(MeasStatCumYearGetRangeRequest measStatCumYearGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatCumYearBatchGetRangeResponse batchGetRangeMeasStatCumYear(MeasStatCumYearBatchGetRangeRequest measStatCumYearBatchGetRangeRequest) {
        return null;
    }
}
