package com.easesource.iot.datacenter.openservice.tablestore.service.impl;

import com.easesource.commons.util.DateUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasStatService;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataCumFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.entity.*;
import com.easesource.iot.datacenter.openservice.request.*;
import com.easesource.iot.datacenter.openservice.response.*;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataInsFreezeCurveDao;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "measStatService")
public class MeasStatServiceImpl extends AbstractBaseService implements MeasStatService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private MeasDataCumFreezeCurveDao measDataCumFreezeCurveDao;

    @Resource
    private MeasDataInsFreezeCurveDao measDataInsFreezeCurveDao;

    @Override
    public MeasStatInsDayGetResponse getMeasStatInsDay(MeasStatInsDayGetRequest measStatInsDayGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasStatInsDay >>>>>>> ");
            logger.debug(" MeasStatInsDayGetRequest         : " + JsonConvertUtils.convertToString(measStatInsDayGetRequest));
        }

        MeasStatInsDayGetResponse response = new MeasStatInsDayGetResponse();
        Long measPointId = measStatInsDayGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatInsDayGetRequest.getMeasItemCodeSet();
        Date dateMeasStat = DateConvertUtils.convertFromString(measStatInsDayGetRequest.getDateMeasStat(), DateConvertUtils.PATTERNS_DATE);
        Map<String, MeasStatInsDayValue> measStatMap = Maps.newHashMap();
        long gmtMeasFreezeStart = dateMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addMillis(DateUtils.addDays(dateMeasStat, 1), -1).getTime();
        Map<String, List<MeasDataInsFreezeCurveValue>> rangeMeasDataInsFreezeCurveValueMap = measDataInsFreezeCurveDao.getRangeMeasDataInsFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreezeStart, gmtMeasFreezeEnd, measStatInsDayGetRequest.getMeasDataSideType());
        rangeMeasDataInsFreezeCurveValueMap.forEach((k, v) -> {
            if(logger.isDebugEnabled()) {
                logger.debug("key : value = " + k + " : " + JsonConvertUtils.convertToString(v));
            }
            AtomicReference<Integer> cntRef = new AtomicReference<>(0);
            AtomicReference<BigDecimal> sumRef = new AtomicReference<>(new BigDecimal("0.0"));
            AtomicReference<Long> gmtMaxRef = new AtomicReference<>(null);
            AtomicReference<BigDecimal> maxRef = new AtomicReference<>(null);
            AtomicReference<Long> gmtMinRef = new AtomicReference<>(null);
            AtomicReference<BigDecimal> minRef = new AtomicReference<>(null);
            AtomicReference<BigDecimal> rateRef = new AtomicReference<>(new BigDecimal("1.0"));
            v.forEach(o -> {
                cntRef.set(cntRef.get() + 1);
                sumRef.set(sumRef.get().add(o.getMeasDataValue()));
                if(maxRef.get() == null || maxRef.get().compareTo(o.getMeasDataValue()) < 0) {
                    gmtMaxRef.set(o.getGmtMeasFreeze());
                    maxRef.set(o.getMeasDataValue());
                }
                if(minRef.get() == null || minRef.get().compareTo(o.getMeasDataValue()) > 0) {
                    gmtMinRef.set(o.getGmtMeasFreeze());
                    minRef.set(o.getMeasDataValue());
                }
                rateRef.set(o.getMeasDataRate());
            });
            if(cntRef.get() > 0) {
                MeasStatInsDayValue measStatInsDayValue = new MeasStatInsDayValue();
                measStatInsDayValue.setMeasPointId(measPointId);
                measStatInsDayValue.setMeasItemCode(k);
                measStatInsDayValue.setDateMeasStat(DateConvertUtils.convertToString(dateMeasStat, DateConvertUtils.PATTERN_DATE_WITHOUTSPR));
                measStatInsDayValue.setMeasDataRate(rateRef.get());
                measStatInsDayValue.setAvgValue(sumRef.get().divide(new BigDecimal(cntRef.get().toString()), 8, BigDecimal.ROUND_HALF_UP));
                measStatInsDayValue.setMaxValue(maxRef.get());
                measStatInsDayValue.setGmtMaxValue(gmtMaxRef.get());
                measStatInsDayValue.setMinValue(minRef.get());
                measStatInsDayValue.setGmtMinValue(gmtMinRef.get());
                measStatInsDayValue.setStatDataSource("meas_data_ins_freeze_curve");
                measStatInsDayValue.setStatDataCount(cntRef.get());
                measStatInsDayValue.setGmtCreate(gmtMeasFreezeEnd);
                measStatInsDayValue.setGmtModified(System.currentTimeMillis());
                measStatMap.put(k, measStatInsDayValue);
            }
        });
        response.setMeasPointId(measPointId);
        response.setMeasStatMap(measStatMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatInsDayGetResponse        : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasStatInsDay <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatInsDayBatchGetResponse batchGetMeasStatInsDay(MeasStatInsDayBatchGetRequest measStatInsDayBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatInsDayGetRangeResponse getRangeMeasStatInsDay(MeasStatInsDayGetRangeRequest measStatInsDayGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasStatInsDay >>>>>>> ");
            logger.debug(" MeasStatInsDayGetRangeRequest    : " + JsonConvertUtils.convertToString(measStatInsDayGetRangeRequest));
        }

        MeasStatInsDayGetRangeResponse response = new MeasStatInsDayGetRangeResponse();
        Long measPointId = measStatInsDayGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatInsDayGetRangeRequest.getMeasItemCodeSet();
        Date dateMeasStatStart = DateConvertUtils.convertFromString(measStatInsDayGetRangeRequest.getDateMeasStatStart(), DateConvertUtils.PATTERNS_DATE);
        Date dateMeasStatEnd = DateConvertUtils.convertFromString(measStatInsDayGetRangeRequest.getDateMeasStatEnd(), DateConvertUtils.PATTERNS_DATE);

        Map<String, List<MeasStatInsDayValue>> measStatListMap = Maps.newHashMap();
        Date dateMeasStat = dateMeasStatStart;
        while(dateMeasStat.before(dateMeasStatEnd)) {
            MeasStatInsDayGetRequest measStatInsDayGetRequest = new MeasStatInsDayGetRequest();
            measStatInsDayGetRequest.setMeasPointId(measPointId);
            measStatInsDayGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatInsDayGetRequest.setDateMeasStat(DateConvertUtils.convertToString(dateMeasStat, DateConvertUtils.PATTERN_DATE_WITHOUTSPR));
            measStatInsDayGetRequest.setMeasDataSideType(measStatInsDayGetRangeRequest.getMeasDataSideType());
            MeasStatInsDayGetResponse measStatInsDayGetResponse = getMeasStatInsDay(measStatInsDayGetRequest);
            if(measStatInsDayGetResponse.isSuccess()) {
                measStatInsDayGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List<MeasStatInsDayValue> measStatInsDayValueList = measStatListMap.get(k);
                    if(CollectionUtils.isEmpty(measStatInsDayValueList)) {
                        measStatInsDayValueList = Lists.newArrayList();
                    }
                    measStatInsDayValueList.add(v);
                    measStatListMap.put(k, measStatInsDayValueList);
                });
            }
            dateMeasStat = DateUtils.addDays(dateMeasStat, 1);
        }

        response.setMeasPointId(measPointId);
        response.setMeasStatListMap(measStatListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatInsDayGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasStatInsDay <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatInsDayBatchGetRangeResponse batchGetRangeMeasStatInsDay(MeasStatInsDayBatchGetRangeRequest measStatInsDayBatchGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatInsMonthGetResponse getMeasStatInsMonth(MeasStatInsMonthGetRequest measStatInsMonthGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasStatInsMonth >>>>>>> ");
            logger.debug(" MeasStatInsMonthGetRequest       : " + JsonConvertUtils.convertToString(measStatInsMonthGetRequest));
        }

        MeasStatInsMonthGetResponse response = new MeasStatInsMonthGetResponse();
        Long measPointId = measStatInsMonthGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatInsMonthGetRequest.getMeasItemCodeSet();
        Date monthMeasStat = DateConvertUtils.convertFromString(measStatInsMonthGetRequest.getMonthMeasStat(), DateConvertUtils.PATTERNS_MONTH);
        Map<String, MeasStatInsMonthValue> measStatMap = Maps.newHashMap();
        long gmtMeasFreezeStart = monthMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addMillis(DateUtils.addMonths(monthMeasStat, 1), -1).getTime();
        Map<String, List<MeasDataInsFreezeCurveValue>> rangeMeasDataInsFreezeCurveValueMap = measDataInsFreezeCurveDao.getRangeMeasDataInsFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreezeStart, gmtMeasFreezeEnd, measStatInsMonthGetRequest.getMeasDataSideType());
        rangeMeasDataInsFreezeCurveValueMap.forEach((k, v) -> {
            if(logger.isDebugEnabled()) {
                logger.debug("key : value = " + k + " : " + JsonConvertUtils.convertToString(v));
            }
            AtomicReference<Integer> cntRef = new AtomicReference<>(0);
            AtomicReference<BigDecimal> sumRef = new AtomicReference<>(new BigDecimal("0.0"));
            AtomicReference<Long> gmtMaxRef = new AtomicReference<>(null);
            AtomicReference<BigDecimal> maxRef = new AtomicReference<>(null);
            AtomicReference<Long> gmtMinRef = new AtomicReference<>(null);
            AtomicReference<BigDecimal> minRef = new AtomicReference<>(null);
            AtomicReference<BigDecimal> rateRef = new AtomicReference<>(new BigDecimal("1.0"));
            v.forEach(o -> {
                cntRef.set(cntRef.get() + 1);
                sumRef.set(sumRef.get().add(o.getMeasDataValue()));
                if(maxRef.get() == null || maxRef.get().compareTo(o.getMeasDataValue()) < 0) {
                    gmtMaxRef.set(o.getGmtMeasFreeze());
                    maxRef.set(o.getMeasDataValue());
                }
                if(minRef.get() == null || minRef.get().compareTo(o.getMeasDataValue()) > 0) {
                    gmtMinRef.set(o.getGmtMeasFreeze());
                    minRef.set(o.getMeasDataValue());
                }
                rateRef.set(o.getMeasDataRate());
            });
            if(cntRef.get() > 0) {
                MeasStatInsMonthValue measStatInsMonthValue = new MeasStatInsMonthValue();
                measStatInsMonthValue.setMeasPointId(measPointId);
                measStatInsMonthValue.setMeasItemCode(k);
                measStatInsMonthValue.setMonthMeasStat(DateConvertUtils.convertToString(monthMeasStat, DateConvertUtils.PATTERN_MONTH_WITHOUTSPR));
                measStatInsMonthValue.setMeasDataRate(rateRef.get());
                measStatInsMonthValue.setAvgValue(sumRef.get().divide(new BigDecimal(cntRef.get().toString()), 8, BigDecimal.ROUND_HALF_UP));
                measStatInsMonthValue.setMaxValue(maxRef.get());
                measStatInsMonthValue.setGmtMaxValue(gmtMaxRef.get());
                measStatInsMonthValue.setMinValue(minRef.get());
                measStatInsMonthValue.setGmtMinValue(gmtMinRef.get());
                measStatInsMonthValue.setStatDataSource("meas_data_ins_freeze_curve");
                measStatInsMonthValue.setStatDataCount(cntRef.get());
                measStatInsMonthValue.setGmtCreate(gmtMeasFreezeEnd);
                measStatInsMonthValue.setGmtModified(System.currentTimeMillis());
                measStatMap.put(k, measStatInsMonthValue);
            }
        });
        response.setMeasPointId(measPointId);
        response.setMeasStatMap(measStatMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatInsMonthGetResponse      : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasStatInsMonth <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatInsMonthBatchGetResponse batchGetMeasStatInsMonth(MeasStatInsMonthBatchGetRequest measStatInsMonthBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatInsMonthGetRangeResponse getRangeMeasStatInsMonth(MeasStatInsMonthGetRangeRequest measStatInsMonthGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasStatInsMonth >>>>>>> ");
            logger.debug(" MeasStatInsMonthGetRangeRequest  : " + JsonConvertUtils.convertToString(measStatInsMonthGetRangeRequest));
        }

        MeasStatInsMonthGetRangeResponse response = new MeasStatInsMonthGetRangeResponse();
        Long measPointId = measStatInsMonthGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatInsMonthGetRangeRequest.getMeasItemCodeSet();
        Date monthMeasStatStart = DateConvertUtils.convertFromString(measStatInsMonthGetRangeRequest.getMonthMeasStatStart(), DateConvertUtils.PATTERNS_MONTH);
        Date monthMeasStatEnd = DateConvertUtils.convertFromString(measStatInsMonthGetRangeRequest.getMonthMeasStatEnd(), DateConvertUtils.PATTERNS_MONTH);

        Map<String, List<MeasStatInsMonthValue>> measStatListMap = Maps.newHashMap();
        Date monthMeasStat = monthMeasStatStart;
        while(monthMeasStat.before(monthMeasStatEnd)) {
            MeasStatInsMonthGetRequest measStatInsMonthGetRequest = new MeasStatInsMonthGetRequest();
            measStatInsMonthGetRequest.setMeasPointId(measPointId);
            measStatInsMonthGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatInsMonthGetRequest.setMonthMeasStat(DateConvertUtils.convertToString(monthMeasStat, DateConvertUtils.PATTERN_MONTH_WITHOUTSPR));
            measStatInsMonthGetRequest.setMeasDataSideType(measStatInsMonthGetRangeRequest.getMeasDataSideType());
            MeasStatInsMonthGetResponse measStatInsMonthGetResponse = getMeasStatInsMonth(measStatInsMonthGetRequest);
            if(measStatInsMonthGetResponse.isSuccess()) {
                measStatInsMonthGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List<MeasStatInsMonthValue> measStatInsMonthValueList = measStatListMap.get(k);
                    if(CollectionUtils.isEmpty(measStatInsMonthValueList)) {
                        measStatInsMonthValueList = Lists.newArrayList();
                    }
                    measStatInsMonthValueList.add(v);
                    measStatListMap.put(k, measStatInsMonthValueList);
                });
            }
            monthMeasStat = DateUtils.addMonths(monthMeasStat, 1);
        }

        response.setMeasPointId(measPointId);
        response.setMeasStatListMap(measStatListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatInsMonthGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasStatInsMonth <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatInsMonthBatchGetRangeResponse batchGetRangeMeasStatInsMonth(MeasStatInsMonthBatchGetRangeRequest measStatInsMonthBatchGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatInsYearGetResponse getMeasStatInsYear(MeasStatInsYearGetRequest measStatInsYearGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasStatInsYear >>>>>>> ");
            logger.debug(" MeasStatInsYearGetRequest        : " + JsonConvertUtils.convertToString(measStatInsYearGetRequest));
        }

        MeasStatInsYearGetResponse response = new MeasStatInsYearGetResponse();
        Long measPointId = measStatInsYearGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatInsYearGetRequest.getMeasItemCodeSet();
        Date yearMeasStat = DateConvertUtils.convertFromString(measStatInsYearGetRequest.getYearMeasStat(), DateConvertUtils.PATTERNS_YEAR);
        Map<String, MeasStatInsYearValue> measStatMap = Maps.newHashMap();
        long gmtMeasFreezeStart = yearMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addMillis(DateUtils.addYears(yearMeasStat, 1), -1).getTime();
        Map<String, List<MeasDataInsFreezeCurveValue>> rangeMeasDataInsFreezeCurveValueMap = measDataInsFreezeCurveDao.getRangeMeasDataInsFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreezeStart, gmtMeasFreezeEnd, measStatInsYearGetRequest.getMeasDataSideType());
        rangeMeasDataInsFreezeCurveValueMap.forEach((k, v) -> {
            if(logger.isDebugEnabled()) {
                logger.debug("key : value = " + k + " : " + JsonConvertUtils.convertToString(v));
            }
            AtomicReference<Integer> cntRef = new AtomicReference<>(0);
            AtomicReference<BigDecimal> sumRef = new AtomicReference<>(new BigDecimal("0.0"));
            AtomicReference<Long> gmtMaxRef = new AtomicReference<>(null);
            AtomicReference<BigDecimal> maxRef = new AtomicReference<>(null);
            AtomicReference<Long> gmtMinRef = new AtomicReference<>(null);
            AtomicReference<BigDecimal> minRef = new AtomicReference<>(null);
            AtomicReference<BigDecimal> rateRef = new AtomicReference<>(new BigDecimal("1.0"));
            v.forEach(o -> {
                cntRef.set(cntRef.get() + 1);
                sumRef.set(sumRef.get().add(o.getMeasDataValue()));
                if(maxRef.get() == null || maxRef.get().compareTo(o.getMeasDataValue()) < 0) {
                    gmtMaxRef.set(o.getGmtMeasFreeze());
                    maxRef.set(o.getMeasDataValue());
                }
                if(minRef.get() == null || minRef.get().compareTo(o.getMeasDataValue()) > 0) {
                    gmtMinRef.set(o.getGmtMeasFreeze());
                    minRef.set(o.getMeasDataValue());
                }
                rateRef.set(o.getMeasDataRate());
            });
            if(cntRef.get() > 0) {
                MeasStatInsYearValue measStatInsYearValue = new MeasStatInsYearValue();
                measStatInsYearValue.setMeasPointId(measPointId);
                measStatInsYearValue.setMeasItemCode(k);
                measStatInsYearValue.setYearMeasStat(DateConvertUtils.convertToString(yearMeasStat, DateConvertUtils.PATTERN_YEAR));
                measStatInsYearValue.setMeasDataRate(rateRef.get());
                measStatInsYearValue.setAvgValue(sumRef.get().divide(new BigDecimal(cntRef.get().toString()), 8, BigDecimal.ROUND_HALF_UP));
                measStatInsYearValue.setMaxValue(maxRef.get());
                measStatInsYearValue.setGmtMaxValue(gmtMaxRef.get());
                measStatInsYearValue.setMinValue(minRef.get());
                measStatInsYearValue.setGmtMinValue(gmtMinRef.get());
                measStatInsYearValue.setStatDataSource("meas_data_ins_freeze_curve");
                measStatInsYearValue.setStatDataCount(cntRef.get());
                measStatInsYearValue.setGmtCreate(gmtMeasFreezeEnd);
                measStatInsYearValue.setGmtModified(System.currentTimeMillis());
                measStatMap.put(k, measStatInsYearValue);
            }
        });
        response.setMeasPointId(measPointId);
        response.setMeasStatMap(measStatMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatInsMonthGetResponse      : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasStatInsYear <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatInsYearBatchGetResponse batchGetMeasStatInsYear(MeasStatInsYearBatchGetRequest measStatInsYearBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatInsYearGetRangeResponse getRangeMeasStatInsYear(MeasStatInsYearGetRangeRequest measStatInsYearGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasStatInsYear >>>>>>> ");
            logger.debug(" MeasStatInsYearGetRangeRequest   : " + JsonConvertUtils.convertToString(measStatInsYearGetRangeRequest));
        }

        MeasStatInsYearGetRangeResponse response = new MeasStatInsYearGetRangeResponse();
        Long measPointId = measStatInsYearGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatInsYearGetRangeRequest.getMeasItemCodeSet();
        Date yearMeasStatStart = DateConvertUtils.convertFromString(measStatInsYearGetRangeRequest.getYearMeasStatStart(), DateConvertUtils.PATTERNS_YEAR);
        Date yearMeasStatEnd = DateConvertUtils.convertFromString(measStatInsYearGetRangeRequest.getYearMeasStatEnd(), DateConvertUtils.PATTERNS_YEAR);

        Map<String, List<MeasStatInsYearValue>> measStatListMap = Maps.newHashMap();
        Date yearMeasStat = yearMeasStatStart;
        while(yearMeasStat.before(yearMeasStatEnd)) {
            MeasStatInsYearGetRequest measStatInsYearGetRequest = new MeasStatInsYearGetRequest();
            measStatInsYearGetRequest.setMeasPointId(measPointId);
            measStatInsYearGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatInsYearGetRequest.setYearMeasStat(DateConvertUtils.convertToString(yearMeasStat, DateConvertUtils.PATTERN_YEAR));
            measStatInsYearGetRequest.setMeasDataSideType(measStatInsYearGetRangeRequest.getMeasDataSideType());
            MeasStatInsYearGetResponse measStatInsYearGetResponse = getMeasStatInsYear(measStatInsYearGetRequest);
            if(measStatInsYearGetResponse.isSuccess()) {
                measStatInsYearGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List<MeasStatInsYearValue> measStatInsYearValueList = measStatListMap.get(k);
                    if(CollectionUtils.isEmpty(measStatInsYearValueList)) {
                        measStatInsYearValueList = Lists.newArrayList();
                    }
                    measStatInsYearValueList.add(v);
                    measStatListMap.put(k, measStatInsYearValueList);
                });
            }
            yearMeasStat = DateUtils.addYears(yearMeasStat, 1);
        }

        response.setMeasPointId(measPointId);
        response.setMeasStatListMap(measStatListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatInsYearGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasStatInsYear <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatInsYearBatchGetRangeResponse batchGetRangeMeasStatInsYear(MeasStatInsYearBatchGetRangeRequest measStatInsYearBatchGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatCumDayGetResponse getMeasStatCumDay(MeasStatCumDayGetRequest measStatCumDayGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasStatCumDay >>>>>>> ");
            logger.debug(" MeasStatCumDayGetRequest         : " + JsonConvertUtils.convertToString(measStatCumDayGetRequest));
        }

        MeasStatCumDayGetResponse response = new MeasStatCumDayGetResponse();
        Long measPointId = measStatCumDayGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatCumDayGetRequest.getMeasItemCodeSet();
        Date dateMeasStat = DateConvertUtils.convertFromString(measStatCumDayGetRequest.getDateMeasStat(), DateConvertUtils.PATTERNS_DATE);
        long gmtMeasFreezeStart = dateMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addMillis(DateUtils.addDays(dateMeasStat, 1), 1).getTime();

        Map<String, MeasStatCumDayValue> measStatMap = Maps.newHashMap();
        Map<String, List<MeasDataCumFreezeCurveValue>> measDataCumFreezeCurveListMap = measDataCumFreezeCurveDao.getRangeMeasDataCumFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreezeStart, gmtMeasFreezeEnd, measStatCumDayGetRequest.getMeasDataSideType());
        for(String measItemCode : measDataCumFreezeCurveListMap.keySet()) {
            List<MeasDataCumFreezeCurveValue> measDataCumFreezeCurveValueList = measDataCumFreezeCurveListMap.get(measItemCode);
            BigDecimal measDataRate = null;
            BigDecimal startDval = null;
            long gmtStartDval = 0L;
            BigDecimal endDval = null;
            long gmtEndDval = 0L;
            BigDecimal usageDval = null;
            BigDecimal[] usageQvals = new BigDecimal[96];
            BigDecimal[] readingQvals = new BigDecimal[97];
            String statDataSource = "meas_data_cum_freeze_curve";

            long gmtMeasFreezeClock = gmtMeasFreezeStart;
            int ic = 0;
            Map<Long, Integer> mapQuarter = Maps.newHashMap();
            while(gmtMeasFreezeClock < gmtMeasFreezeEnd) {
                if(logger.isDebugEnabled()) {
                    logger.debug("[" + String.format("%2d", ic) + "]" + " gmtMeasFreezeClock   : " + DateConvertUtils.convertToString(new Date(gmtMeasFreezeClock), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                }
                mapQuarter.put(gmtMeasFreezeClock, ic);
                ic++;
                gmtMeasFreezeClock += 15 * 60 * 1000;
            }

            if(logger.isDebugEnabled()) {
                logger.debug(" readingQvals : " + Arrays.toString(readingQvals));
            }
            for(MeasDataCumFreezeCurveValue measDataCumFreezeCurveValue : measDataCumFreezeCurveValueList) {
                Integer index = mapQuarter.get(measDataCumFreezeCurveValue.getGmtMeasFreeze());
                if(index != null) {
                    if(startDval == null) {
                        startDval = measDataCumFreezeCurveValue.getMeasDataValue();
                        gmtStartDval = measDataCumFreezeCurveValue.getGmtMeasFreeze();
                    }
                    measDataRate = measDataCumFreezeCurveValue.getMeasDataRate();
                    endDval = measDataCumFreezeCurveValue.getMeasDataValue();
                    gmtEndDval = measDataCumFreezeCurveValue.getGmtMeasFreeze();
                    readingQvals[index] = measDataCumFreezeCurveValue.getMeasDataValue();
                }
            }
            for(int i = 0; i < 96; i++) {
                usageQvals[i] = (readingQvals[i + 1] != null && readingQvals[i] != null) ? readingQvals[i + 1].subtract(readingQvals[i].setScale(8, BigDecimal.ROUND_HALF_UP)) : null;
            }
            usageDval = (endDval != null && startDval != null) ? endDval.subtract(startDval).setScale(8, BigDecimal.ROUND_HALF_UP) : null;
            if(logger.isDebugEnabled()) {
                logger.debug(" startDval    : " + startDval);
                logger.debug(" gmtStartDval : " + DateConvertUtils.convertToString(new Date(gmtStartDval), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                logger.debug(" endDval      : " + endDval);
                logger.debug(" gmtEndDval   : " + DateConvertUtils.convertToString(new Date(gmtEndDval), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                logger.debug(" readingQvals : " + Arrays.toString(readingQvals));
            }
            measStatMap.put(measItemCode, new MeasStatCumDayValue(
                measPointId, measItemCode, DateConvertUtils.convertToString(dateMeasStat, DateConvertUtils.PATTERN_DATE_WITHOUTSPR),
                measDataRate, startDval, gmtStartDval, endDval, gmtEndDval, usageDval, usageQvals, statDataSource, gmtEndDval, gmtEndDval));
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatMap(measStatMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatCumDayGetResponse        : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasStatCumDay <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatCumDayBatchGetResponse batchGetMeasStatCumDay(MeasStatCumDayBatchGetRequest measStatCumDayBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatCumDayGetRangeResponse getRangeMeasStatCumDay(MeasStatCumDayGetRangeRequest measStatCumDayGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasStatCumDay >>>>>>> ");
            logger.debug(" MeasStatCumDayGetRangeRequest    : " + JsonConvertUtils.convertToString(measStatCumDayGetRangeRequest));
        }

        MeasStatCumDayGetRangeResponse response = new MeasStatCumDayGetRangeResponse();
        Long measPointId = measStatCumDayGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatCumDayGetRangeRequest.getMeasItemCodeSet();
        Date dateMeasStatStart = DateConvertUtils.convertFromString(measStatCumDayGetRangeRequest.getDateMeasStatStart(), DateConvertUtils.PATTERNS_DATE);
        Date dateMeasStatEnd = DateConvertUtils.convertFromString(measStatCumDayGetRangeRequest.getDateMeasStatEnd(), DateConvertUtils.PATTERNS_DATE);

        Map<String, List<MeasStatCumDayValue>> measStatListMap = Maps.newHashMap();
        Date dateMeasStat = dateMeasStatStart;
        while(dateMeasStat.before(dateMeasStatEnd)) {
            MeasStatCumDayGetRequest measStatCumDayGetRequest = new MeasStatCumDayGetRequest();
            measStatCumDayGetRequest.setMeasPointId(measPointId);
            measStatCumDayGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatCumDayGetRequest.setDateMeasStat(DateConvertUtils.convertToString(dateMeasStat, DateConvertUtils.PATTERN_DATE_WITHOUTSPR));
            measStatCumDayGetRequest.setMeasDataSideType(measStatCumDayGetRangeRequest.getMeasDataSideType());
            MeasStatCumDayGetResponse measStatCumDayGetResponse = getMeasStatCumDay(measStatCumDayGetRequest);
            if(measStatCumDayGetResponse.isSuccess()) {
                measStatCumDayGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List<MeasStatCumDayValue> measStatCumDayValueList = measStatListMap.get(k);
                    if(CollectionUtils.isEmpty(measStatCumDayValueList)) {
                        measStatCumDayValueList = Lists.newArrayList();
                    }
                    measStatCumDayValueList.add(v);
                    measStatListMap.put(k, measStatCumDayValueList);
                });
            }
            dateMeasStat = DateUtils.addDays(dateMeasStat, 1);
        }

        response.setMeasPointId(measPointId);
        response.setMeasStatListMap(measStatListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatCumDayGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasStatCumDay <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatCumDayGetRangeResponse getRangeMeasStatCumDayForUsageDval(MeasStatCumDayGetRangeRequest measStatCumDayGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatCumDayBatchGetRangeResponse batchGetRangeMeasStatCumDay(MeasStatCumDayBatchGetRangeRequest measStatCumDayBatchGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatCumMonthGetResponse getMeasStatCumMonth(MeasStatCumMonthGetRequest measStatCumMonthGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasStatCumMonth >>>>>>> ");
            logger.debug(" MeasStatCumMonthGetRequest       : " + JsonConvertUtils.convertToString(measStatCumMonthGetRequest));
        }
        MeasStatCumMonthGetResponse response = new MeasStatCumMonthGetResponse();
        Long measPointId = measStatCumMonthGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatCumMonthGetRequest.getMeasItemCodeSet();
        Date monthMeasStat = DateConvertUtils.convertFromString(measStatCumMonthGetRequest.getMonthMeasStat(), DateConvertUtils.PATTERNS_MONTH);
        Map<String, MeasStatCumMonthValue> measStatMap = Maps.newHashMap();
        long gmtMeasFreezeStart = monthMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addMillis(DateUtils.addMonths(monthMeasStat, 1), -1).getTime();
        Map<String, List<MeasDataCumFreezeCurveValue>> measDataCumFreezeCurveListMap = measDataCumFreezeCurveDao.getRangeMeasDataCumFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreezeStart, gmtMeasFreezeEnd, measStatCumMonthGetRequest.getMeasDataSideType());
        for(String measItemCode : measDataCumFreezeCurveListMap.keySet()) {
            List<MeasDataCumFreezeCurveValue> measDataCumFreezeCurveValueList = measDataCumFreezeCurveListMap.get(measItemCode);
            BigDecimal measDataRate = null;
            BigDecimal startMval = null;
            long gmtStartMval = 0L;
            BigDecimal endMval = null;
            long gmtEndMval = 0L;
            BigDecimal usageMval = null;
            int days = DateUtils.getDaysOfMonth(monthMeasStat);
            BigDecimal[] usageDvals = new BigDecimal[days];
            BigDecimal[] readingDvals = new BigDecimal[days + 1];
            String statDataSource = "meas_data_cum_freeze_curve";

            long gmtMeasFreezeClock = gmtMeasFreezeStart;
            int ic = 0;
            Map<Long, Integer> mapDay = Maps.newHashMap();
            while(gmtMeasFreezeClock < gmtMeasFreezeEnd) {
                if(logger.isDebugEnabled()) {
                    logger.debug("[" + String.format("%2d", ic) + "]" + " gmtMeasFreezeClock   : " + DateConvertUtils.convertToString(new Date(gmtMeasFreezeClock), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                }
                mapDay.put(gmtMeasFreezeClock, ic);
                ic++;
                gmtMeasFreezeClock += 24 * 60 * 60 * 1000;
            }

            if(logger.isDebugEnabled()) {
                logger.debug(" readingDvals : " + Arrays.toString(readingDvals));
            }
            for(MeasDataCumFreezeCurveValue measDataCumFreezeCurveValue : measDataCumFreezeCurveValueList) {
                Integer index = mapDay.get(measDataCumFreezeCurveValue.getGmtMeasFreeze());
                if(index != null) {
                    if(startMval == null) {
                        startMval = measDataCumFreezeCurveValue.getMeasDataValue();
                        gmtStartMval = measDataCumFreezeCurveValue.getGmtMeasFreeze();
                    }
                    measDataRate = measDataCumFreezeCurveValue.getMeasDataRate();
                    endMval = measDataCumFreezeCurveValue.getMeasDataValue();
                    gmtEndMval = measDataCumFreezeCurveValue.getGmtMeasFreeze();
                    readingDvals[index] = measDataCumFreezeCurveValue.getMeasDataValue();
                }
            }
            for(int i = 0; i < days; i++) {
                usageDvals[i] = (readingDvals[i + 1] != null && readingDvals[i] != null) ? readingDvals[i + 1].subtract(readingDvals[i].setScale(8, BigDecimal.ROUND_HALF_UP)) : null;
            }
            usageMval = (endMval != null && startMval != null) ? endMval.subtract(startMval).setScale(8, BigDecimal.ROUND_HALF_UP) : null;
            if(logger.isDebugEnabled()) {
                logger.debug(" startMval    : " + startMval);
                logger.debug(" gmtStartMval : " + DateConvertUtils.convertToString(new Date(gmtStartMval), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                logger.debug(" endMval      : " + endMval);
                logger.debug(" gmtEndMval   : " + DateConvertUtils.convertToString(new Date(gmtEndMval), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                logger.debug(" readingDvals : " + Arrays.toString(readingDvals));
            }
            measStatMap.put(measItemCode, new MeasStatCumMonthValue(
                measPointId, measItemCode, DateConvertUtils.convertToString(monthMeasStat, DateConvertUtils.PATTERN_MONTH_WITHOUTSPR),
                measDataRate, startMval, gmtStartMval, endMval, gmtEndMval, usageMval, usageDvals, statDataSource, gmtEndMval, gmtEndMval));
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatMap(measStatMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatCumMonthGetResponse      : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasStatCumMonth <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatCumMonthBatchGetResponse batchGetMeasStatCumMonth(MeasStatCumMonthBatchGetRequest measStatCumMonthBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatCumMonthGetRangeResponse getRangeMeasStatCumMonth(MeasStatCumMonthGetRangeRequest measStatCumMonthGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasStatCumMonth >>>>>>> ");
            logger.debug(" MeasStatCumMonthGetRangeRequest  : " + JsonConvertUtils.convertToString(measStatCumMonthGetRangeRequest));
        }

        MeasStatCumMonthGetRangeResponse response = new MeasStatCumMonthGetRangeResponse();
        Long measPointId = measStatCumMonthGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatCumMonthGetRangeRequest.getMeasItemCodeSet();
        Date monthMeasStatStart = DateConvertUtils.convertFromString(measStatCumMonthGetRangeRequest.getMonthMeasStatStart(), DateConvertUtils.PATTERNS_MONTH);
        Date monthMeasStatEnd = DateConvertUtils.convertFromString(measStatCumMonthGetRangeRequest.getMonthMeasStatEnd(), DateConvertUtils.PATTERNS_MONTH);

        Map<String, List<MeasStatCumMonthValue>> measStatListMap = Maps.newHashMap();
        Date monthMeasStat = monthMeasStatStart;
        while(monthMeasStat.before(monthMeasStatEnd)) {
            MeasStatCumMonthGetRequest measStatCumMonthGetRequest = new MeasStatCumMonthGetRequest();
            measStatCumMonthGetRequest.setMeasPointId(measPointId);
            measStatCumMonthGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatCumMonthGetRequest.setMonthMeasStat(DateConvertUtils.convertToString(monthMeasStat, DateConvertUtils.PATTERN_MONTH_WITHOUTSPR));
            measStatCumMonthGetRequest.setMeasDataSideType(measStatCumMonthGetRangeRequest.getMeasDataSideType());
            MeasStatCumMonthGetResponse measStatCumMonthGetResponse = getMeasStatCumMonth(measStatCumMonthGetRequest);
            if(measStatCumMonthGetResponse.isSuccess()) {
                measStatCumMonthGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List<MeasStatCumMonthValue> measStatCumMonthValueList = measStatListMap.get(k);
                    if(CollectionUtils.isEmpty(measStatCumMonthValueList)) {
                        measStatCumMonthValueList = Lists.newArrayList();
                    }
                    measStatCumMonthValueList.add(v);
                    measStatListMap.put(k, measStatCumMonthValueList);
                });
            }
            monthMeasStat = DateUtils.addMonths(monthMeasStat, 1);
        }

        response.setMeasPointId(measPointId);
        response.setMeasStatListMap(measStatListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatCumMonthGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasStatCumMonth <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatCumMonthBatchGetRangeResponse batchGetRangeMeasStatCumMonth(MeasStatCumMonthBatchGetRangeRequest measStatCumMonthBatchGetRangeRequest) {
        return null;
    }

    @Override
    public MeasStatCumYearGetResponse getMeasStatCumYear(MeasStatCumYearGetRequest measStatCumYearGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasStatCumYear >>>>>>> ");
            logger.debug(" MeasStatCumYearGetRequest        : " + JsonConvertUtils.convertToString(measStatCumYearGetRequest));
        }

        MeasStatCumYearGetResponse response = new MeasStatCumYearGetResponse();
        Long measPointId = measStatCumYearGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatCumYearGetRequest.getMeasItemCodeSet();
        Date yearMeasStat = DateConvertUtils.convertFromString(measStatCumYearGetRequest.getYearMeasStat(), DateConvertUtils.PATTERNS_YEAR);
        Map<String, MeasStatCumYearValue> measStatMap = Maps.newHashMap();
        long gmtMeasFreezeStart = yearMeasStat.getTime();
        long gmtMeasFreezeEnd = DateUtils.addMillis(DateUtils.addYears(yearMeasStat, 1), -1).getTime();
        Map<String, List<MeasDataCumFreezeCurveValue>> measDataCumFreezeCurveListMap = measDataCumFreezeCurveDao.getRangeMeasDataCumFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreezeStart, gmtMeasFreezeEnd, measStatCumYearGetRequest.getMeasDataSideType());
        for(String measItemCode : measDataCumFreezeCurveListMap.keySet()) {
            List<MeasDataCumFreezeCurveValue> measDataCumFreezeCurveValueList = measDataCumFreezeCurveListMap.get(measItemCode);
            BigDecimal measDataRate = null;
            BigDecimal startYval = null;
            long gmtStartYval = 0L;
            BigDecimal endYval = null;
            long gmtEndYval = 0L;
            BigDecimal usageYval = null;
            BigDecimal[] usageMvals = new BigDecimal[12];
            BigDecimal[] readingMvals = new BigDecimal[13];
            String statDataSource = "meas_data_cum_freeze_curve";

            long gmtMeasFreezeClock = gmtMeasFreezeStart;
            int ic = 0;
            Map<Long, Integer> mapMonth = Maps.newHashMap();
            while(gmtMeasFreezeClock < gmtMeasFreezeEnd) {
                if(logger.isDebugEnabled()) {
                    logger.debug("[" + String.format("%2d", ic) + "]" + " gmtMeasFreezeClock   : " + DateConvertUtils.convertToString(new Date(gmtMeasFreezeClock), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                }
                mapMonth.put(gmtMeasFreezeClock, ic);
                ic++;
                gmtMeasFreezeClock = DateUtils.addMonths(new Date(gmtMeasFreezeClock), 1).getTime();
            }

            if(logger.isDebugEnabled()) {
                logger.debug(" readingMvals : " + Arrays.toString(readingMvals));
            }
            for(MeasDataCumFreezeCurveValue measDataCumFreezeCurveValue : measDataCumFreezeCurveValueList) {
                Integer index = mapMonth.get(measDataCumFreezeCurveValue.getGmtMeasFreeze());
                if(index != null) {
                    if(startYval == null) {
                        startYval = measDataCumFreezeCurveValue.getMeasDataValue();
                        gmtStartYval = measDataCumFreezeCurveValue.getGmtMeasFreeze();
                    }
                    measDataRate = measDataCumFreezeCurveValue.getMeasDataRate();
                    endYval = measDataCumFreezeCurveValue.getMeasDataValue();
                    gmtEndYval = measDataCumFreezeCurveValue.getGmtMeasFreeze();
                    readingMvals[index] = measDataCumFreezeCurveValue.getMeasDataValue();
                }
            }
            for(int i = 0; i < 12; i++) {
                usageMvals[i] = (readingMvals[i + 1] != null && readingMvals[i] != null) ? readingMvals[i + 1].subtract(readingMvals[i].setScale(8, BigDecimal.ROUND_HALF_UP)) : null;
            }
            usageYval = (endYval != null && startYval != null) ? endYval.subtract(startYval).setScale(8, BigDecimal.ROUND_HALF_UP) : null;
            if(logger.isDebugEnabled()) {
                logger.debug(" startYval    : " + startYval);
                logger.debug(" gmtStartYval : " + DateConvertUtils.convertToString(new Date(gmtStartYval), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                logger.debug(" endYval      : " + endYval);
                logger.debug(" gmtEndYval   : " + DateConvertUtils.convertToString(new Date(gmtEndYval), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                logger.debug(" readingMvals : " + Arrays.toString(readingMvals));
            }
            measStatMap.put(measItemCode, new MeasStatCumYearValue(
                measPointId, measItemCode, DateConvertUtils.convertToString(yearMeasStat, DateConvertUtils.PATTERN_YEAR),
                measDataRate, startYval, gmtStartYval, endYval, gmtEndYval, usageYval, usageMvals, statDataSource, gmtEndYval, gmtEndYval));
        }
        response.setMeasPointId(measPointId);
        response.setMeasStatMap(measStatMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatCumYearGetResponse      : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasStatCumYear <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatCumYearBatchGetResponse batchGetMeasStatCumYear(MeasStatCumYearBatchGetRequest measStatCumYearBatchGetRequest) {
        return null;
    }

    @Override
    public MeasStatCumYearGetRangeResponse getRangeMeasStatCumYear(MeasStatCumYearGetRangeRequest measStatCumYearGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasStatCumYear >>>>>>> ");
            logger.debug(" MeasStatCumYearGetRangeRequest   : " + JsonConvertUtils.convertToString(measStatCumYearGetRangeRequest));
        }

        MeasStatCumYearGetRangeResponse response = new MeasStatCumYearGetRangeResponse();
        Long measPointId = measStatCumYearGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measStatCumYearGetRangeRequest.getMeasItemCodeSet();
        Date yearMeasStatStart = DateConvertUtils.convertFromString(measStatCumYearGetRangeRequest.getYearMeasStatStart(), DateConvertUtils.PATTERNS_YEAR);
        Date yearMeasStatEnd = DateConvertUtils.convertFromString(measStatCumYearGetRangeRequest.getYearMeasStatEnd(), DateConvertUtils.PATTERNS_YEAR);

        Map<String, List<MeasStatCumYearValue>> measStatListMap = Maps.newHashMap();
        Date yearMeasStat = yearMeasStatStart;
        while(yearMeasStat.before(yearMeasStatEnd)) {
            MeasStatCumYearGetRequest measStatCumYearGetRequest = new MeasStatCumYearGetRequest();
            measStatCumYearGetRequest.setMeasPointId(measPointId);
            measStatCumYearGetRequest.setMeasItemCodeSet(measItemCodeSet);
            measStatCumYearGetRequest.setYearMeasStat(DateConvertUtils.convertToString(yearMeasStat, DateConvertUtils.PATTERN_YEAR));
            measStatCumYearGetRequest.setMeasDataSideType(measStatCumYearGetRangeRequest.getMeasDataSideType());
            MeasStatCumYearGetResponse measStatCumYearGetResponse = getMeasStatCumYear(measStatCumYearGetRequest);
            if(measStatCumYearGetResponse.isSuccess()) {
                measStatCumYearGetResponse.getMeasStatMap().forEach((k, v) -> {
                    List<MeasStatCumYearValue> measStatCumYearValueList = measStatListMap.get(k);
                    if(CollectionUtils.isEmpty(measStatCumYearValueList)) {
                        measStatCumYearValueList = Lists.newArrayList();
                    }
                    measStatCumYearValueList.add(v);
                    measStatListMap.put(k, measStatCumYearValueList);
                });
            }
            yearMeasStat = DateUtils.addYears(yearMeasStat, 1);
        }

        response.setMeasPointId(measPointId);
        response.setMeasStatListMap(measStatListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasStatCumYearGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasStatCumYear <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasStatCumYearBatchGetRangeResponse batchGetRangeMeasStatCumYear(MeasStatCumYearBatchGetRangeRequest measStatCumYearBatchGetRangeRequest) {
        return null;
    }

}
