package com.easesource.iot.datacenter.openservice.service.impl;

import com.easesource.commons.util.NumberUtils;
import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.bean.Sorter;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.dao.MeasDataCumFreezeCurve4RdsDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataInsFreezeCurve4RdsDao;
import com.easesource.iot.datacenter.openservice.dao.MeasDataLatest4RdsDao;
import com.easesource.iot.datacenter.openservice.entity.*;
import com.easesource.iot.datacenter.openservice.request.*;
import com.easesource.iot.datacenter.openservice.response.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "measDataService4Rds")
public class MeasDataService4RdsImpl extends AbstractBaseService implements MeasDataService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private MeasDataLatest4RdsDao measDataLatest4RdsDao;

    @Resource
    private MeasDataCumFreezeCurve4RdsDao measDataCumFreezeCurve4RdsDao;

    @Resource
    private MeasDataInsFreezeCurve4RdsDao measDataInsFreezeCurve4RdsDao;

    @Override
    public MeasDataLatestGetResponse getMeasDataLatest(MeasDataLatestGetRequest measDataLatestGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasDataLatest >>>>>>> ");
            logger.debug(" MeasDataLatestGetRequest     : " + JsonConvertUtils.convertToString(measDataLatestGetRequest));
        }

        MeasDataLatestGetResponse response = new MeasDataLatestGetResponse();
        Long measPointId = measDataLatestGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataLatestGetRequest.getMeasItemCodeSet();
        Map<String, MeasDataLatestInfo> measDataMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            MeasDataLatestVo measDataLatestVo = measDataLatest4RdsDao.getMeasDataLatestVoByMeasPointIdAndMeasItemCode(measPointId, measItemCode);
            //logger.info(" measDataLatestVo : " + JsonConvertUtils.convertToString(measDataLatestVo));
            if(measDataLatestVo != null && measDataLatestVo.getMeasDataInfo() != null) {
                Map measDataInfoMap = JsonConvertUtils.convertFromString(measDataLatestVo.getMeasDataInfo(), Map.class);
                String measDataClassName = (String) measDataInfoMap.get("measDataClass");
                Class measDataClass = null;
                Object measDataValue = null;
                BigDecimal selfRate = measDataLatestVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataLatestVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataLatestVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                if(StringUtils.equals(measDataClassName, "java.math.BigDecimal")) {
                    measDataClass = BigDecimal.class;
                    measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(measDataLatestGetRequest.getMeasDataSideType() == 1) {
                        //measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                        if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                            // 电压 * PT
                            measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                        }
                        else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                            // 电流 * CT
                            measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                        }
                        else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                            // 功率 * CT * PT
                            measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                        }
                        else if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                            // 电量 * CT * PT
                            measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                        }
                    }
                }
                else if(StringUtils.equals(measDataClassName, "java.lang.Boolean")) {
                    measDataClass = Boolean.class;
                    measDataValue = Boolean.valueOf(measDataInfoMap.get("measDataValue").toString());
                }
                else if(StringUtils.equals(measDataClassName, "java.lang.String")) {
                    measDataClass = String.class;
                    measDataValue = measDataInfoMap.get("measDataValue").toString();
                }
                else if(StringUtils.equals(measDataClassName, "java.lang.Integer")) {
                    measDataClass = Integer.class;
                    measDataValue = Integer.valueOf(measDataInfoMap.get("measDataValue").toString());
                }
                else if(StringUtils.equals(measDataClassName, "java.lang.Long")) {
                    measDataClass = Long.class;
                    measDataValue = Long.valueOf(measDataInfoMap.get("measDataValue").toString());
                }
                else if(StringUtils.equals(measDataClassName, "java.util.Date")) {
                    measDataClass = Date.class;
                    measDataValue = new Date(Long.parseLong(measDataInfoMap.get("measDataValue").toString()));
                }
                int measDataSource = NumberUtils.toInt(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("measDataSource")), 0);
                long gmtMeasDataLatest = NumberUtils.toLong(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("gmtMeasDataLatest")), System.currentTimeMillis());
                measDataMap.put(measItemCode, new MeasDataLatestInfo(measPointId, measItemCode, measDataClass, measDataValue, measDataSource, gmtMeasDataLatest, measDataLatestVo.getGmtCreate(), measDataLatestVo.getGmtModified()));
            }
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataLatestGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataLatest <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataLatestBatchGetResponse batchGetMeasDataLatest(MeasDataLatestBatchGetRequest measDataLatestBatchGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start batchGetMeasDataLatest >>>>>>> ");
            logger.debug(" MeasDataLatestBatchGetRequest    : " + JsonConvertUtils.convertToString(measDataLatestBatchGetRequest));
        }

        MeasDataLatestBatchGetResponse response = new MeasDataLatestBatchGetResponse();
        Set<Long> measPointIdSet = measDataLatestBatchGetRequest.getMeasPointIdSet();
        Set<String> measItemCodeSet = measDataLatestBatchGetRequest.getMeasItemCodeSet();
        Map<Long, Map<String, MeasDataLatestInfo>> batchMeasDataMap = Maps.newHashMap();
        for(Long measPointId : measPointIdSet) {
            Map<String, MeasDataLatestInfo> measDataMap = Maps.newHashMap();
            for(String measItemCode : measItemCodeSet) {
                MeasDataLatestVo measDataLatestVo = measDataLatest4RdsDao.getMeasDataLatestVoByMeasPointIdAndMeasItemCode(measPointId, measItemCode);
                //logger.info(" measDataLatestVo : " + JsonConvertUtils.convertToString(measDataLatestVo));
                if(measDataLatestVo != null && measDataLatestVo.getMeasDataInfo() != null) {
                    Map measDataInfoMap = JsonConvertUtils.convertFromString(measDataLatestVo.getMeasDataInfo(), Map.class);
                    String measDataClassName = (String) measDataInfoMap.get("measDataClass");
                    Class measDataClass = null;
                    Object measDataValue = null;
                    BigDecimal selfRate = measDataLatestVo.getSelfRate();
                    if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                        selfRate = new BigDecimal("1.0");
                    }
                    BigDecimal ctRate = measDataLatestVo.getCtRate();
                    if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ctRate = new BigDecimal("1.0");
                    }
                    BigDecimal ptRate = measDataLatestVo.getPtRate();
                    if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                        ptRate = new BigDecimal("1.0");
                    }
                    if(StringUtils.equals(measDataClassName, "java.math.BigDecimal")) {
                        measDataClass = BigDecimal.class;
                        measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).setScale(6, BigDecimal.ROUND_HALF_UP);
                        if(measDataLatestBatchGetRequest.getMeasDataSideType() == 1) {
                            //measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                            if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                                // 电压 * PT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                            }
                            else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                                // 电流 * CT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                            }
                            else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                                // 功率 * CT * PT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                            }
                            else if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                                // 电量 * CT * PT
                                measDataValue = new BigDecimal(measDataInfoMap.get("measDataValue").toString()).multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                            }
                        }
                    }
                    else if(StringUtils.equals(measDataClassName, "java.lang.Boolean")) {
                        measDataClass = Boolean.class;
                        measDataValue = Boolean.valueOf(measDataInfoMap.get("measDataValue").toString());
                    }
                    else if(StringUtils.equals(measDataClassName, "java.lang.String")) {
                        measDataClass = String.class;
                        measDataValue = measDataInfoMap.get("measDataValue").toString();
                    }
                    else if(StringUtils.equals(measDataClassName, "java.lang.Integer")) {
                        measDataClass = Integer.class;
                        measDataValue = Integer.valueOf(measDataInfoMap.get("measDataValue").toString());
                    }
                    else if(StringUtils.equals(measDataClassName, "java.util.Date")) {
                        measDataClass = Date.class;
                        measDataValue = new Date(Long.parseLong(measDataInfoMap.get("measDataValue").toString()));
                    }
                    int measDataSource = NumberUtils.toInt(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("measDataSource")), 0);
                    long gmtMeasDataLatest = NumberUtils.toLong(ObjectUtils.toStringDefaultEmpty(measDataInfoMap.get("gmtMeasDataLatest")), System.currentTimeMillis());
                    measDataMap.put(measItemCode, new MeasDataLatestInfo(measPointId, measItemCode, measDataClass, measDataValue, measDataSource, gmtMeasDataLatest, measDataLatestVo.getGmtCreate(), measDataLatestVo.getGmtModified()));
                }
            }
            batchMeasDataMap.put(measPointId, measDataMap);
        }
        response.setBatchMeasDataMap(batchMeasDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataLatestBatchGetResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end batchGetMeasDataLatest <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataInsDiscreteGetRangeResponse getRangeMeasDataInsDiscrete(MeasDataInsDiscreteGetRangeRequest measDataInsDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataInsFreezeCurveGetResponse getMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRequest measDataInsFreezeCurveGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasDataInsFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataInsFreezeCurveGetRequest     : " + JsonConvertUtils.convertToString(measDataInsFreezeCurveGetRequest));
        }

        MeasDataInsFreezeCurveGetResponse response = new MeasDataInsFreezeCurveGetResponse();
        Long measPointId = measDataInsFreezeCurveGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataInsFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataInsFreezeCurveGetRequest.getGmtMeasFreeze();
        Map<String, MeasDataInsFreezeCurveValue> measDataMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            MeasDataInsFreezeCurveVo measDataInsFreezeCurveVo = measDataInsFreezeCurve4RdsDao.getMeasDataInsFreezeCurveVoByMeasPointIdAndMeasItemCodeAndGmtMeasFreeze(measPointId, measItemCode, gmtMeasFreeze);
            if(measDataInsFreezeCurveVo != null) {
                BigDecimal selfRate = measDataInsFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataInsFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataInsFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                if(measDataInsFreezeCurveGetRequest.getMeasDataSideType() == 1) {
                    //measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                        // 电压 * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                        // 电流 * CT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                        // 功率 * CT * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                }
                measDataMap.put(measItemCode, new MeasDataInsFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataInsFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataInsFreezeCurveVo.getMeasDataSource(), measDataInsFreezeCurveVo.getFreezeMode(), measDataInsFreezeCurveVo.getGmtMeasData(), measDataInsFreezeCurveVo.getGmtCreate(), measDataInsFreezeCurveVo.getGmtModified()));
            }
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataInsFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataInsFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataInsFreezeCurveGetRangeResponse getRangeMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRangeRequest measDataInsFreezeCurveGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasDataInsFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataInsFreezeCurveGetRangeRequest    : " + JsonConvertUtils.convertToString(measDataInsFreezeCurveGetRangeRequest));
        }

        MeasDataInsFreezeCurveGetRangeResponse response = new MeasDataInsFreezeCurveGetRangeResponse();
        Long measPointId = measDataInsFreezeCurveGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataInsFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        Map<String, List<MeasDataInsFreezeCurveValue>> measDataListMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataInsFreezeCurveVo> measDataInsFreezeCurveList = measDataInsFreezeCurve4RdsDao.getMeasDataInsFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            List<MeasDataInsFreezeCurveValue> measDataList = Lists.newArrayList();
            for(MeasDataInsFreezeCurveVo measDataInsFreezeCurveVo : measDataInsFreezeCurveList) {
                BigDecimal selfRate = measDataInsFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataInsFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataInsFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                if(measDataInsFreezeCurveGetRangeRequest.getMeasDataSideType() == 1) {
                    //measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_ua", "gen_watt_ub", "gen_watt_uc", "gen_watt_upv", "gen_watt_ur", "gen_watt_ubus")) {
                        // 电压 * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_ia", "gen_watt_ib", "gen_watt_ic", "gen_watt_in", "gen_watt_ipv", "gen_watt_ir", "gen_watt_ibus")) {
                        // 电流 * CT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                    else if(StringUtils.containsAny(measItemCode, "gen_watt_acp", "gen_watt_rep", "gen_watt_app", "gen_watt_ppv", "gen_watt_pr", "gen_watt_pbus")) {
                        // 功率 * CT * PT
                        measDataValue = measDataInsFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                }
                measDataList.add(new MeasDataInsFreezeCurveValue(measPointId, measItemCode, measDataInsFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataInsFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataInsFreezeCurveVo.getMeasDataSource(), measDataInsFreezeCurveVo.getFreezeMode(), measDataInsFreezeCurveVo.getGmtMeasData(), measDataInsFreezeCurveVo.getGmtCreate(), measDataInsFreezeCurveVo.getGmtModified()));
            }
            measDataListMap.put(measItemCode, measDataList);
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap(measDataListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataInsFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasDataInsFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataInsFreezeCurveGetRangeListResponse getRangeMeasDataInsFreezeCurveList(List<MeasDataInsFreezeCurveGetRangeRequest> measDataInsFreezeCurveGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataCumDiscreteGetRangeResponse getRangeMeasDataCumDiscrete(MeasDataCumDiscreteGetRangeRequest measDataCumDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataCumFreezeCurveGetResponse getMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRequest measDataCumFreezeCurveGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataCumFreezeCurveGetRequest     : " + JsonConvertUtils.convertToString(measDataCumFreezeCurveGetRequest));
        }

        MeasDataCumFreezeCurveGetResponse response = new MeasDataCumFreezeCurveGetResponse();
        Long measPointId = measDataCumFreezeCurveGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataCumFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveGetRequest.getGmtMeasFreeze();
        Map<String, MeasDataCumFreezeCurveValue> measDataMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo = measDataCumFreezeCurve4RdsDao.getMeasDataCumFreezeCurveVoByMeasPointIdAndMeasItemCodeAndGmtMeasFreeze(measPointId, measItemCode, gmtMeasFreeze);
            if(measDataCumFreezeCurveVo != null) {
                BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataCumFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataCumFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                if(measDataCumFreezeCurveGetRequest.getMeasDataSideType() == 1) {
                    // measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                        // 电量 * CT * PT
                        measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                }
                measDataMap.put(measItemCode, new MeasDataCumFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            }
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataCumFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataCumFreezeCurveBatchGetResponse batchGetMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetRequest measDataCumFreezeCurveBatchGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start batchGetMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataCumFreezeCurveBatchGetRequest     : " + JsonConvertUtils.convertToString(measDataCumFreezeCurveBatchGetRequest));
        }

        MeasDataCumFreezeCurveBatchGetResponse response = new MeasDataCumFreezeCurveBatchGetResponse();
        Set<Long> measPointIdSet = measDataCumFreezeCurveBatchGetRequest.getMeasPointIdSet();
        Set<String> measItemCodeSet = measDataCumFreezeCurveBatchGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveBatchGetRequest.getGmtMeasFreeze();
        Map<Long, Map<String, MeasDataCumFreezeCurveValue>> batchMeasDataMap = Maps.newHashMap();
        List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = measDataCumFreezeCurve4RdsDao.getMeasDataCumFreezeCurveVoListByMeasPointIdSetAndMeasItemCodeSetAndGmtMeasFreeze(measPointIdSet, measItemCodeSet, gmtMeasFreeze);
        measDataCumFreezeCurveList.forEach(measDataCumFreezeCurveVo -> {
            Long measPointId = measDataCumFreezeCurveVo.getMeasPointId();
            String measItemCode = measDataCumFreezeCurveVo.getMeasItemCode();
            Map<String, MeasDataCumFreezeCurveValue> measDataMap = batchMeasDataMap.get(measPointId);
            if(measDataMap == null) {
                measDataMap = Maps.newHashMap();
            }
            BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
            if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                selfRate = new BigDecimal("1.0");
            }
            BigDecimal ctRate = measDataCumFreezeCurveVo.getCtRate();
            if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                ctRate = new BigDecimal("1.0");
            }
            BigDecimal ptRate = measDataCumFreezeCurveVo.getPtRate();
            if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                ptRate = new BigDecimal("1.0");
            }
            BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, RoundingMode.HALF_UP);
            if(measDataCumFreezeCurveBatchGetRequest.getMeasDataSideType() == 1) {
                // measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                    // 电量 * CT * PT
                    measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, RoundingMode.HALF_UP);
                }
            }
            measDataMap.put(measItemCode, new MeasDataCumFreezeCurveValue(measPointId, measItemCode, gmtMeasFreeze, measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, RoundingMode.HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            batchMeasDataMap.put(measPointId, measDataMap);
        });
        response.setBatchMeasDataMap(batchMeasDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataCumFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataCumFreezeCurveBatchGetMTPsResponse batchGetMTPsMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetMTPsRequest measDataCumFreezeCurveBatchGetMTPsRequest) {
        return null;
    }

    @Override
    public MeasDataCumFreezeCurveGetRangeResponse getRangeMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRangeRequest measDataCumFreezeCurveGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataCumFreezeCurveGetRangeRequest    : " + JsonConvertUtils.convertToString(measDataCumFreezeCurveGetRangeRequest));
        }

        MeasDataCumFreezeCurveGetRangeResponse response = new MeasDataCumFreezeCurveGetRangeResponse();
        Long measPointId = measDataCumFreezeCurveGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataCumFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        Map<String, List<MeasDataCumFreezeCurveValue>> measDataListMap = Maps.newHashMap();
        for(String measItemCode : measItemCodeSet) {
            Map<String, Object> params = Maps.newHashMap();
            params.put("measPointId", measPointId);
            params.put("measItemCode", measItemCode);
            params.put("gmtMeasFreezeStart", gmtMeasFreezeStart);
            params.put("gmtMeasFreezeEnd", gmtMeasFreezeEnd);
            List<MeasDataCumFreezeCurveVo> measDataCumFreezeCurveList = measDataCumFreezeCurve4RdsDao.getMeasDataCumFreezeCurveVoList(params, new Sorter("gmt_meas_freeze", "ASC"), null);
            List<MeasDataCumFreezeCurveValue> measDataList = Lists.newArrayList();
            for(MeasDataCumFreezeCurveVo measDataCumFreezeCurveVo : measDataCumFreezeCurveList) {
                BigDecimal selfRate = measDataCumFreezeCurveVo.getSelfRate();
                if(!(selfRate != null && selfRate.compareTo(BigDecimal.ZERO) > 0)) {
                    selfRate = new BigDecimal("1.0");
                }
                BigDecimal ctRate = measDataCumFreezeCurveVo.getCtRate();
                if(!(ctRate != null && ctRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ctRate = new BigDecimal("1.0");
                }
                BigDecimal ptRate = measDataCumFreezeCurveVo.getPtRate();
                if(!(ptRate != null && ptRate.compareTo(BigDecimal.ZERO) > 0)) {
                    ptRate = new BigDecimal("1.0");
                }
                BigDecimal measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().setScale(6, BigDecimal.ROUND_HALF_UP);
                if(measDataCumFreezeCurveGetRangeRequest.getMeasDataSideType() == 1) {
                    // measDataValue = measDataValue.multiply(new BigDecimal("2.0")).setScale(6, BigDecimal.ROUND_HALF_UP);
                    if(StringUtils.containsAny(measItemCode, "gen_watt_pae", "gen_watt_rae", "gen_watt_cae", "gen_watt_q1re", "gen_watt_q2re", "gen_watt_q3re", "gen_watt_q4re", "gen_watt_pre", "gen_watt_rre")) {
                        // 电量 * CT * PT
                        measDataValue = measDataCumFreezeCurveVo.getMeasDataValue().multiply(selfRate).multiply(ctRate).multiply(ptRate).setScale(6, BigDecimal.ROUND_HALF_UP);
                    }
                }
                measDataList.add(new MeasDataCumFreezeCurveValue(measPointId, measItemCode, measDataCumFreezeCurveVo.getGmtMeasFreeze(), measDataValue, measDataCumFreezeCurveVo.getMeasDataRate().setScale(6, BigDecimal.ROUND_HALF_UP), measDataCumFreezeCurveVo.getMeasDataSource(), measDataCumFreezeCurveVo.getFreezeMode(), measDataCumFreezeCurveVo.getGmtMeasData(), measDataCumFreezeCurveVo.getGmtCreate(), measDataCumFreezeCurveVo.getGmtModified()));
            }
            measDataListMap.put(measItemCode, measDataList);
        }
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap(measDataListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataCumFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataCumFreezeDayGetResponse getMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRequest measDataCumFreezeDayGetRequest) {
        return null;
    }

    @Override
    public MeasDataCumFreezeDayGetRangeResponse getRangeMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRangeRequest measDataCumFreezeDayGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataStateBoolDiscreteGetRangeResponse getRangeMeasDataStateBoolDiscrete(MeasDataStateBoolDiscreteGetRangeRequest measDataStateBoolDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataStateCharDiscreteGetRangeResponse getRangeMeasDataStateCharDiscrete(MeasDataStateCharDiscreteGetRangeRequest measDataStateCharDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataStatsDiscreteGetRangeResponse getRangeMeasDataStatsDiscrete(MeasDataStatsDiscreteGetRangeRequest measDataStatsDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataAlarmDiscreteGetRangeResponse getRangeMeasDataAlarmDiscrete(MeasDataAlarmDiscreteGetRangeRequest measDataAlarmDiscreteGetRangeRequest) {
        return null;
    }

}
