package com.easesource.iot.datacenter.openservice.tablestore.dao;

import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveValue;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author Nick Zhang
 */
public interface MeasDataCumFreezeCurveDao {

    /**
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @param gmtMeasFreeze
     *          量测曲线时间
     * @param measDataValue
     *          量测数据值
     * @param measDataRate
     *          量测数据倍率值
     * @param measDataSource
     *          量测数据来源
     * @param gmtMeasData
     *          量测数据时间
     * @param freezeMode
     *          曲线冻结方式
     * @return
     *          结果
     */
    int updateMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze, BigDecimal measDataValue, BigDecimal measDataRate, int measDataSource, long gmtMeasData, int freezeMode);

    /**
     * 删除
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCode
     *          量测项编码
     * @param gmtMeasFreeze
     *          量测冻结时间
     * @return
     *          结果
     */
    int deleteMeasDataCumFreezeCurve(Long measPointId, String measItemCode, long gmtMeasFreeze);

    /**
     *
     * @param measPointId
     *          量测点标识
     * @param measDataLatestInfoMap
     *          量测点最新数据Map
     * @param gmtMeasFreeze
     *          量测曲线时间
     * @param freezeMode
     *          曲线冻结方式
     * @return
     *          结果
     */
    int batchUpdateMeasDataCumFreezeCurve(Long measPointId, Map<String, MeasDataLatestInfo> measDataLatestInfoMap, long gmtMeasFreeze, int freezeMode);

    /**
     * 获取量测点最新数据Map
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCodeSet
     *          量测项编码集
     * @param gmtMeasFreeze
     *          量测曲线时间
     * @return
     *          量测点最新数据Map
     */
    Map<String, MeasDataCumFreezeCurveValue> getMeasDataCumFreezeCurveValueMap(Long measPointId, Set<String> measItemCodeSet, long gmtMeasFreeze, Integer measDataSideType);

    /**
     * 获取批量量测点数据信息Map
     *
     * @param measPointId
     *          量测点标识
     * @param measItemCodeSet
     *          量测项编码集
     * @param gmtMeasFreezeStart
     *          量测曲线时间开始时间
     * @param gmtMeasFreezeEnd
     *          量测曲线时间结束时间
     * @return
     *          批量量测点数据信息Map
     */
    Map<String, List<MeasDataCumFreezeCurveValue>> getRangeMeasDataCumFreezeCurveValueMap(Long measPointId, Set<String> measItemCodeSet, long gmtMeasFreezeStart, long gmtMeasFreezeEnd, Integer measDataSideType);

}
