package com.easesource.iot.datacenter.openservice.tablestore.service.impl;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.base.service.AbstractBaseService;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.entity.MeasDataCumFreezeCurveValue;
import com.easesource.iot.datacenter.openservice.entity.MeasDataInsFreezeCurveValue;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;
import com.easesource.iot.datacenter.openservice.request.*;
import com.easesource.iot.datacenter.openservice.response.*;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataCumFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataInsFreezeCurveDao;
import com.easesource.iot.datacenter.openservice.tablestore.dao.MeasDataLatestDao;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author Nick Zhang
 */
@Service(value = "measDataService")
public class MeasDataServiceImpl extends AbstractBaseService implements MeasDataService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private MeasDataLatestDao measDataLatestDao;

    @Resource
    private MeasDataCumFreezeCurveDao measDataCumFreezeCurveDao;

    @Resource
    private MeasDataInsFreezeCurveDao measDataInsFreezeCurveDao;

    @Override
    public MeasDataLatestGetResponse getMeasDataLatest(MeasDataLatestGetRequest measDataLatestGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasDataLatest >>>>>>> ");
            logger.debug(" MeasDataLatestGetRequest     : " + JsonConvertUtils.convertToString(measDataLatestGetRequest));
        }

        MeasDataLatestGetResponse response = new MeasDataLatestGetResponse();
        Long measPointId = measDataLatestGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataLatestGetRequest.getMeasItemCodeSet();
        Map<String, MeasDataLatestInfo> measDataMap = measDataLatestDao.getMeasDataLatestInfoMap(measPointId, measItemCodeSet, measDataLatestGetRequest.getMeasDataSideType());
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataLatestGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataLatest <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataLatestBatchGetResponse batchGetMeasDataLatest(MeasDataLatestBatchGetRequest measDataLatestBatchGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start batchGetMeasDataLatest >>>>>>> ");
            logger.debug(" MeasDataLatestBatchGetRequest    : " + JsonConvertUtils.convertToString(measDataLatestBatchGetRequest));
        }

        MeasDataLatestBatchGetResponse response = new MeasDataLatestBatchGetResponse();
        Set<Long> measPointIdSet = measDataLatestBatchGetRequest.getMeasPointIdSet();
        Set<String> measItemCodeSet = measDataLatestBatchGetRequest.getMeasItemCodeSet();
        Map<Long, Map<String, MeasDataLatestInfo>> batchMeasDataMap = measDataLatestDao.batchGetMeasDataLatestInfoMap(measPointIdSet, measItemCodeSet, measDataLatestBatchGetRequest.getMeasDataSideType());
        response.setBatchMeasDataMap(batchMeasDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataLatestBatchGetResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end batchGetMeasDataLatest <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataInsDiscreteGetRangeResponse getRangeMeasDataInsDiscrete(MeasDataInsDiscreteGetRangeRequest measDataInsDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataInsFreezeCurveGetResponse getMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRequest measDataInsFreezeCurveGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasDataInsFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataInsFreezeCurveGetRequest     : " + JsonConvertUtils.convertToString(measDataInsFreezeCurveGetRequest));
        }

        MeasDataInsFreezeCurveGetResponse response = new MeasDataInsFreezeCurveGetResponse();
        Long measPointId = measDataInsFreezeCurveGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataInsFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataInsFreezeCurveGetRequest.getGmtMeasFreeze();
        Map<String, MeasDataInsFreezeCurveValue> measDataMap = measDataInsFreezeCurveDao.getMeasDataInsFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreeze, measDataInsFreezeCurveGetRequest.getMeasDataSideType());
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataInsFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataInsFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataInsFreezeCurveGetRangeResponse getRangeMeasDataInsFreezeCurve(MeasDataInsFreezeCurveGetRangeRequest measDataInsFreezeCurveGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasDataInsFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataInsFreezeCurveGetRangeRequest    : " + JsonConvertUtils.convertToString(measDataInsFreezeCurveGetRangeRequest));
        }

        MeasDataInsFreezeCurveGetRangeResponse response = new MeasDataInsFreezeCurveGetRangeResponse();
        Long measPointId = measDataInsFreezeCurveGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataInsFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataInsFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        Map<String, List<MeasDataInsFreezeCurveValue>> measDataListMap = measDataInsFreezeCurveDao.getRangeMeasDataInsFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreezeStart, gmtMeasFreezeEnd, measDataInsFreezeCurveGetRangeRequest.getMeasDataSideType());
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap(measDataListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataInsFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasDataInsFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataInsFreezeCurveGetRangeListResponse getRangeMeasDataInsFreezeCurveList(List<MeasDataInsFreezeCurveGetRangeRequest> measDataInsFreezeCurveGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataCumDiscreteGetRangeResponse getRangeMeasDataCumDiscrete(MeasDataCumDiscreteGetRangeRequest measDataCumDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataCumFreezeCurveGetResponse getMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRequest measDataCumFreezeCurveGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataCumFreezeCurveGetRequest     : " + JsonConvertUtils.convertToString(measDataCumFreezeCurveGetRequest));
        }

        MeasDataCumFreezeCurveGetResponse response = new MeasDataCumFreezeCurveGetResponse();
        Long measPointId = measDataCumFreezeCurveGetRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataCumFreezeCurveGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveGetRequest.getGmtMeasFreeze();
        Map<String, MeasDataCumFreezeCurveValue> measDataMap = measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreeze, measDataCumFreezeCurveGetRequest.getMeasDataSideType());
        response.setMeasPointId(measPointId);
        response.setMeasDataMap(measDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataCumFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataCumFreezeCurveBatchGetResponse batchGetMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetRequest measDataCumFreezeCurveBatchGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start batchGetMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataCumFreezeCurveBatchGetRequest     : " + JsonConvertUtils.convertToString(measDataCumFreezeCurveBatchGetRequest));
        }

        MeasDataCumFreezeCurveBatchGetResponse response = new MeasDataCumFreezeCurveBatchGetResponse();
        Set<Long> measPointIdSet = measDataCumFreezeCurveBatchGetRequest.getMeasPointIdSet();
        Set<String> measItemCodeSet = measDataCumFreezeCurveBatchGetRequest.getMeasItemCodeSet();
        long gmtMeasFreeze = measDataCumFreezeCurveBatchGetRequest.getGmtMeasFreeze();
        Map<Long, Map<String, MeasDataCumFreezeCurveValue>> batchMeasDataMap = Maps.newHashMap();

        for(Long measPointId : measPointIdSet) {
            Map<String, MeasDataCumFreezeCurveValue> measDataMap = measDataCumFreezeCurveDao.getMeasDataCumFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreeze, measDataCumFreezeCurveBatchGetRequest.getMeasDataSideType());
            batchMeasDataMap.put(measPointId, measDataMap);
        }

        response.setBatchMeasDataMap(batchMeasDataMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataCumFreezeCurveGetResponse    : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataCumFreezeCurveBatchGetMTPsResponse batchGetMTPsMeasDataCumFreezeCurve(MeasDataCumFreezeCurveBatchGetMTPsRequest measDataCumFreezeCurveBatchGetMTPsRequest) {
        return null;
    }

    @Override
    public MeasDataCumFreezeCurveGetRangeResponse getRangeMeasDataCumFreezeCurve(MeasDataCumFreezeCurveGetRangeRequest measDataCumFreezeCurveGetRangeRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>>> start getRangeMeasDataCumFreezeCurve >>>>>>> ");
            logger.debug(" MeasDataCumFreezeCurveGetRangeRequest    : " + JsonConvertUtils.convertToString(measDataCumFreezeCurveGetRangeRequest));
        }

        MeasDataCumFreezeCurveGetRangeResponse response = new MeasDataCumFreezeCurveGetRangeResponse();
        Long measPointId = measDataCumFreezeCurveGetRangeRequest.getMeasPointId();
        Set<String> measItemCodeSet = measDataCumFreezeCurveGetRangeRequest.getMeasItemCodeSet();
        long gmtMeasFreezeStart = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeStart();
        long gmtMeasFreezeEnd = measDataCumFreezeCurveGetRangeRequest.getGmtMeasFreezeEnd();
        Map<String, List<MeasDataCumFreezeCurveValue>> measDataListMap = measDataCumFreezeCurveDao.getRangeMeasDataCumFreezeCurveValueMap(measPointId, measItemCodeSet, gmtMeasFreezeStart, gmtMeasFreezeEnd, measDataCumFreezeCurveGetRangeRequest.getMeasDataSideType());
        response.setMeasPointId(measPointId);
        response.setMeasDataListMap(measDataListMap);
        response.setReturnCode("SUCCESS");

        if(logger.isDebugEnabled()) {
            logger.debug(" MeasDataCumFreezeCurveGetRangeResponse   : " + JsonConvertUtils.convertToString(response));
            logger.debug(" <<<<<<<< end getRangeMeasDataCumFreezeCurve <<<<<<<< ");
        }
        return response;
    }

    @Override
    public MeasDataCumFreezeDayGetResponse getMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRequest measDataCumFreezeDayGetRequest) {
        return null;
    }

    @Override
    public MeasDataCumFreezeDayGetRangeResponse getRangeMeasDataCumFreezeDay(MeasDataCumFreezeDayGetRangeRequest measDataCumFreezeDayGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataStateBoolDiscreteGetRangeResponse getRangeMeasDataStateBoolDiscrete(MeasDataStateBoolDiscreteGetRangeRequest measDataStateBoolDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataStateCharDiscreteGetRangeResponse getRangeMeasDataStateCharDiscrete(MeasDataStateCharDiscreteGetRangeRequest measDataStateCharDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataStatsDiscreteGetRangeResponse getRangeMeasDataStatsDiscrete(MeasDataStatsDiscreteGetRangeRequest measDataStatsDiscreteGetRangeRequest) {
        return null;
    }

    @Override
    public MeasDataAlarmDiscreteGetRangeResponse getRangeMeasDataAlarmDiscrete(MeasDataAlarmDiscreteGetRangeRequest measDataAlarmDiscreteGetRangeRequest) {
        return null;
    }

}
