package com.easesource.iot.springbootapps.gateway.socket.iec104.controller;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.protoparser.iec104.model.Message;
import com.easesource.iot.protoparser.iec104.packagedata.PackageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

import static com.easesource.iot.gateway.base.model.MqConstants.*;

@RestController
public class TestController {
    private static final Logger logger = LoggerFactory.getLogger(TestController.class);

    @Autowired
    private com.easesource.iot.gateway.base.sender.RabbitSender rabbitSender;
    @GetMapping("/test")
    public Mono<ResponseEntity<String>> test() {
        if (logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start FormatWriter >>>>>> ");
        }
        Message msg = new Message();
        PackageData.pacakageD2Data(msg);
        rabbitSender.sendMessage(DIRECT_EXCHANGE1, DIRECT_KEY3, JsonConvertUtils.convertToString(msg));
        return Mono.just(new ResponseEntity<>("FormatWriter ok", HttpStatus.OK));
    }

}
