package com.easesource.iot.springbootapps.gateway.socket.iec104.initial;

import com.easesource.iot.protoparser.iec104.model.ProtocolDataConfig;
import com.easesource.iot.protoparser.iec104.utils.CastorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

@Component
public class InitialConfiguration {
    private final Logger log = LoggerFactory.getLogger(getClass());
    private final String mappingResource = "/conf/protocol-data-config-mapping.xml";
    private final String dataResource = "/conf/protocol-data-config.xml";
    @PostConstruct
    public void init(){
        ProtocolDataConfig dataConfig = (ProtocolDataConfig) CastorUtil.unmarshal(mappingResource, dataResource);
        dataConfig.fillMap();
    }
}
