package com.easesource.iot.gateway.socket.iec104.netty.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 超时事件处理类
 */
@ChannelHandler.Sharable
public class AcceptorIdleStateTrigger extends ChannelInboundHandlerAdapter {
    private static final Logger log =  LoggerFactory.getLogger(AcceptorIdleStateTrigger.class);
    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if(evt instanceof IdleStateEvent){
            IdleState state = ((IdleStateEvent)evt).state();
            if(state == IdleState.READER_IDLE){
                //多少s内没读到信息，就关闭链路
                ctx.channel().close();
                if(log.isDebugEnabled()){
                    log.debug("超过指定时间>>>>>>> 关闭链路"+ctx.channel().id());
                }
            }
        }else {
            super.userEventTriggered(ctx,evt);
        }
    }
}
