/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.gateway.socket.iec104.netty.configuration;

import com.easesource.iot.gateway.socket.iec104.netty.handler.NettySocketChannelInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@PropertySource(value={"classpath:/nettyserver.properties"})
@Configuration
public class NettyConfiguration {
    @Value(value="${tcp.port}")
    private int tcpPort;
    @Value(value="${boss.thread.count}")
    private int bossCount;
    @Value(value="${worker.thread.count}")
    private int workerCount;
    @Value(value="${so.keepalive}")
    private boolean keepAlive;
    @Value(value="${so.backlog}")
    private int backlog;
    @Autowired
    @Qualifier(value="NettySocketChannelInitializer")
    private NettySocketChannelInitializer NettySocketChannelInitializer;

    @Bean(name={"serverBootstrap"})
    public ServerBootstrap bootstrap() {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup(), (EventLoopGroup)this.workerGroup()).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)this.NettySocketChannelInitializer);
        Map<ChannelOption<?>, Object> tcpChannelOptions = this.tcpChannelOptions();
        Set<ChannelOption<?>> keySet = tcpChannelOptions.keySet();
        for (ChannelOption<?> option : keySet) {
            b.option(option, tcpChannelOptions.get(option));
        }
        return b;
    }

    @Bean(name={"tcpChannelOptions"})
    public Map<ChannelOption<?>, Object> tcpChannelOptions() {
        HashMap options = new HashMap();
        options.put(ChannelOption.SO_KEEPALIVE, this.keepAlive);
        options.put(ChannelOption.SO_BACKLOG, this.backlog);
        options.put(ChannelOption.RCVBUF_ALLOCATOR, new FixedRecvByteBufAllocator(65536));
        options.put(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        return options;
    }

    @Bean(name={"bossGroup"}, destroyMethod="shutdownGracefully")
    public NioEventLoopGroup bossGroup() {
        return new NioEventLoopGroup(this.bossCount);
    }

    @Bean(name={"workerGroup"}, destroyMethod="shutdownGracefully")
    public NioEventLoopGroup workerGroup() {
        return new NioEventLoopGroup(this.workerCount);
    }

    @Bean(name={"tcpSocketAddress"})
    public InetSocketAddress tcpPort() {
        return new InetSocketAddress(this.tcpPort);
    }
}

