/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.gateway.socket.iec104.netty.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TCPServer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="serverBootstrap")
    private ServerBootstrap serverBootstrap;
    @Autowired
    @Qualifier(value="tcpSocketAddress")
    private InetSocketAddress tcpPort;
    private Channel serverChannel;

    public void start() throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" start TCPServer ");
        }
        this.serverChannel = this.serverBootstrap.bind((SocketAddress)this.tcpPort).sync().channel().closeFuture().sync().channel();
    }

    @PreDestroy
    public void stop() throws Exception {
        if (this.serverChannel != null) {
            this.serverChannel.close();
            this.serverChannel.parent().close();
        }
    }

    public ServerBootstrap getServerBootstrap() {
        return this.serverBootstrap;
    }

    public void setServerBootstrap(ServerBootstrap serverBootstrap) {
        this.serverBootstrap = serverBootstrap;
    }

    public InetSocketAddress getTcpPort() {
        return this.tcpPort;
    }

    public void setTcpPort(InetSocketAddress tcpPort) {
        this.tcpPort = tcpPort;
    }
}

