package com.easesource.iot.gateway.socket.iec104.netty.handler;


import com.easesource.iot.gateway.base.sender.RabbitSender;
import com.easesource.iot.protoparser.iec104.model.Message;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import static com.easesource.iot.gateway.base.model.MqConstants.*;


/**
 * 进行业务处理器
 */
@Component
@Qualifier("ServerHandler")
@ChannelHandler.Sharable
public class ServerHandler extends ChannelInboundHandlerAdapter {

    private final Logger log = LoggerFactory.getLogger(ServerHandler.class);

    @Autowired
    private RabbitSender rabbitSender;

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            //待过滤(需要在网关处理的数据不用发送至业务处理器)
            Message msg1 = (Message) msg;
        try {
            if (msg1 != null) {
                //过滤掉6个字节的测试命令(这些没用的信息，尽量在网关这卡死，不要堆积在rabbitmq中)
                if(msg1.getData() != null){
                    rabbitSender.sendMessage(DIRECT_EXCHANGE1, DIRECT_KEY4, msg1);
                }
            }
        }finally {
            ctx.flush();
            ReferenceCountUtil.release(msg1);
        }
    }
}
