package com.easesource.iot.gateway.socket.iec104.netty.handler;



import com.easesource.iot.protoparser.iec104.handler.read.MessageRecognizer;
import com.easesource.iot.protoparser.iec104.handler.read.MessageReadHandler;
import com.easesource.iot.protoparser.iec104.handler.writer.MessageEncoder;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import java.util.concurrent.TimeUnit;


@Component
@Qualifier("NettySocketChannelInitializer")
public class NettySocketChannelInitializer extends ChannelInitializer<SocketChannel> {

    private final static AcceptorIdleStateTrigger idleStateTrigger = new AcceptorIdleStateTrigger();
    @Autowired
    private MessageReadHandler messageReadHandler;
    @Autowired
    private ServerHandler ServerHandler;
    @Autowired
    private MessageEncoder messageEncoder;
    @Override
    public void initChannel(SocketChannel ch) throws Exception {//2
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new IdleStateHandler(15*60,0,0, TimeUnit.SECONDS));
        pipeline.addLast(idleStateTrigger);
        pipeline.addLast(new MessageRecognizer());
        pipeline.addLast(messageReadHandler);
        //业务处理器
        pipeline.addLast(ServerHandler);
        pipeline.addLast(messageEncoder);
    }
}
