/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.gateway.socket.iec104.netty.handler;

import com.easesource.iot.gateway.socket.iec104.netty.handler.AcceptorIdleStateTrigger;
import com.easesource.iot.gateway.socket.iec104.netty.handler.ServerHandler;
import com.easesource.iot.protoparser.iec104.handler.read.MessageReadHandler;
import com.easesource.iot.protoparser.iec104.handler.read.MessageRecognizer;
import com.easesource.iot.protoparser.iec104.handler.writer.MessageEncoder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="NettySocketChannelInitializer")
public class NettySocketChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final AcceptorIdleStateTrigger idleStateTrigger = new AcceptorIdleStateTrigger();
    @Autowired
    private MessageReadHandler messageReadHandler;
    @Autowired
    private ServerHandler ServerHandler;
    @Autowired
    private MessageEncoder messageEncoder;

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(900L, 0L, 0L, TimeUnit.SECONDS)});
        pipeline.addLast(new ChannelHandler[]{idleStateTrigger});
        pipeline.addLast(new ChannelHandler[]{new MessageRecognizer()});
        pipeline.addLast(new ChannelHandler[]{this.messageReadHandler});
        pipeline.addLast(new ChannelHandler[]{this.ServerHandler});
        pipeline.addLast(new ChannelHandler[]{this.messageEncoder});
    }
}

