package com.easesource.iot.protoparser.base.thread;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Queue;
import java.util.concurrent.*;

public abstract  class BaseThreadPool<T> implements Runnable {
    private final Logger log = LoggerFactory.getLogger(getClass());
    private final Queue<T> queue = new ConcurrentLinkedDeque<T>();
    //线程池用来处理 threadEventHandler
    protected ThreadPoolExecutor threadPool = null;
    //开辟此一个线程用来 运行线程池
    protected Thread thread;
    protected int poolMinSize = 128;
    protected int poolMaxSize = 128;
    protected int poolQueueSize = 128;
    protected int keepAliveTime = 60;
    private ArrayBlockingQueue<Runnable> threadBlockingQueue;

    public boolean init() {
        //threadBlockingQueue = new ArrayBlockingQueue<Runnable>(poolQueueSize);
        /*threadPool = new ThreadPoolExecutor(poolMinSize, poolMaxSize, getKeepAliveTime(), TimeUnit.SECONDS,
            threadBlockingQueue, new ThreadPoolExecutor.AbortPolicy());*/
        threadPool = new ThreadPoolExecutor(poolMinSize, poolMaxSize, getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingDeque<>());
        return true;
    }

    public boolean start() {
        this.thread = new Thread(this);
        this.thread.start();
        return true;
    }

    public void destory() {

    }


    public boolean offer(T o) {
        boolean bRet = queue.offer(o);
        synchronized (queue) {
            queue.notifyAll();
        }
        return bRet;
    }

    public T takeData(long timeout) {
        if (queue.isEmpty()) {
            Queue<T> oldQueue = queue;
            synchronized (oldQueue) {
                try {
                    oldQueue.wait(timeout);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return queue.poll();
    }

    public int getPoolMinSize() {
        return poolMinSize;
    }

    public void setPoolMinSize(int poolSize) {
        this.poolMinSize = poolSize;
        if (threadPool != null) {
            threadPool.setCorePoolSize(poolMinSize);
        }
    }

    public int getPoolMaxSize() {
        return poolMaxSize;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
        if (threadPool != null) {
            threadPool.setMaximumPoolSize(poolMaxSize);
        }
    }

    public int getKeepAliveTime() {
        return keepAliveTime;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        if (threadPool != null)
            threadPool.setKeepAliveTime(keepAliveTime, TimeUnit.SECONDS);
    }

    public int getPoolQueueSize() {
        return poolQueueSize;
    }

    public void setPoolQueueSize(int poolQueueSize) {
        this.poolQueueSize = poolQueueSize;
        resetThreadPoolParam();
    }

    public int getWaitCount() {
        return threadBlockingQueue.size();
    }

    // 统计信息
    @PerformanceMethod("当前激活线程数")
    public int getActiveCount() {
        return (threadPool == null) ? 0 : threadPool.getActiveCount();
    }

    @PerformanceMethod("已经完成任务数")
    public long getCompletedTaskCount() {
        return (threadPool == null) ? 0 : threadPool.getCompletedTaskCount();
    }

    @PerformanceMethod("最大线程数")
    public int getLargestPoolSize() {
        return (threadPool == null) ? 0 : threadPool.getLargestPoolSize();
    }

    private void resetThreadPoolParam() {
        if (threadPool != null) {
            synchronized (threadPool) {
                log.warn("线程池参数被修改，停止原有线程池");
                threadPool.shutdown();
                //ArrayBlockingQueue<Runnable> threadBlockingQueue = new ArrayBlockingQueue<Runnable>(poolQueueSize);
                /*threadPool = new ThreadPoolExecutor(poolMinSize, poolMaxSize, keepAliveTime, TimeUnit.SECONDS,
                    threadBlockingQueue, new ThreadPoolExecutor.AbortPolicy());*/
                threadPool = new ThreadPoolExecutor(poolMinSize, poolMaxSize, getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingDeque<>());
                /*log.warn("启用新的线程池，poolQueueSize：{}，poolMinSize：{}，poolMaxSize：{}，keepAliveTime：{}秒",
                    new Object[]{poolQueueSize, poolMinSize, poolMaxSize, keepAliveTime});*/
                log.warn("启用新的线程池，poolMinSize：{}，poolMaxSize：{}，keepAliveTime：{}秒", poolMinSize, poolMaxSize, keepAliveTime);
            }
        }
    }

}
