package com.easesource.iot.protoparser.base.thread.handler;

import com.easesource.iot.protoparser.base.thread.BaseThreadPool;
import com.easesource.iot.protoparser.base.thread.PerformanceMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.concurrent.*;

public class ThreadPool<T> extends BaseThreadPool<T> {
    private final Logger log = LoggerFactory.getLogger(getClass());
    protected IThreadEventHandler<T> threadEventHandler;
    private int queueCapacity = 10000;
    private int queueStrategy = 0;
    protected LinkedBlockingQueue<T> waitLinkedList = null;

    @Override
    public boolean init() {
        waitLinkedList = new LinkedBlockingQueue<T>(queueCapacity);
        if (threadEventHandler == null) {
            log.error("threadHandleEvent not set.");
            return false;
        }
        return super.init();
    }

    @Override
    public void destory() {
        waitLinkedList.clear();
        super.destory();
    }

    @Override
    public void run() {
        T o;
        T msg = null;

        while (true) {
            try {
                while (msg != null || (msg = waitLinkedList.peek()) != null) {
                    try {
                          threadPool.execute(new ThreadWork(msg));
                          msg = null;
                          waitLinkedList.remove();
                    } catch (RejectedExecutionException e) {
                        break;
                    } catch (Exception e) {
                        log.error("线程池执行出错", e);
                        waitLinkedList.remove();
                    }
                }

                if ((o = takeData(500)) == null) {
                    continue;
                }
                if(log.isDebugEnabled()){
                    log.debug("ThreadPool>>>>>>>"+o.toString());
                }
                if(o != null){
                    if (threadEventHandler.isNeedNewThread(o)) {
                        offerWaitObjct(o);
                    }
                }
            } catch (Exception e) {
                log.error("Exception:", e);
            }
        }
    }
    private void offerWaitObjct(T o) {
        if (!waitLinkedList.offer(o)) {
            log.warn("队列超限{},根据策略进行{}操作", queueCapacity, queueStrategy == 0 ? "出栈压栈" : "丢弃");
            if (queueStrategy == 0) {
                waitLinkedList.poll();
                waitLinkedList.offer(o);
            }
        }
    }

    public IThreadEventHandler getThreadEventHandler() {
        return threadEventHandler;
    }

    public void setThreadEventHandler(IThreadEventHandler threadEventHandler) {
        this.threadEventHandler = threadEventHandler;
    }

    public int getQueueCapacity() {
        return queueCapacity;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        if (waitLinkedList != null) {
            LinkedBlockingQueue<T> newLinkedList = new LinkedBlockingQueue<T>(queueCapacity);
            synchronized (waitLinkedList) {
                while (!waitLinkedList.isEmpty()) {
                    newLinkedList.offer(waitLinkedList.poll());
                }
            }
            waitLinkedList = newLinkedList;
        }
    }

    public int getQueueStrategy() {
        return queueStrategy;
    }

    public void setQueueStrategy(int queueStrategy) {
        this.queueStrategy = queueStrategy;
    }

    @PerformanceMethod("等待处理任务数")
    @Override
    public int getWaitCount() {
        return this.waitLinkedList.size();
    }

    // 是否需要排队
    public boolean isPoolWait() {
        return !waitLinkedList.isEmpty();
    }

    class ThreadWork implements Runnable {
        private T msg;

        public ThreadWork(T msg) {
            super();
            this.msg = msg;
        }

        @Override
        public void run() {
            try {
                threadEventHandler.handleEvent(msg);
                msg = null;
            } catch (Exception e) {
                log.error("Exception:", e);
            }
        }
    }
}
