/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.base.thread.handler;

import com.easesource.iot.protoparser.base.thread.BaseThreadPool;
import com.easesource.iot.protoparser.base.thread.PerformanceMethod;
import com.easesource.iot.protoparser.base.thread.handler.IThreadEventHandler;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPool<T>
extends BaseThreadPool<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected IThreadEventHandler<T> threadEventHandler;
    private int queueCapacity = 10000;
    private int queueStrategy = 0;
    protected LinkedBlockingQueue<T> waitLinkedList = null;

    @Override
    public boolean init() {
        this.waitLinkedList = new LinkedBlockingQueue(this.queueCapacity);
        if (this.threadEventHandler == null) {
            this.log.error("threadHandleEvent not set.");
            return false;
        }
        return super.init();
    }

    @Override
    public void destory() {
        this.waitLinkedList.clear();
        super.destory();
    }

    @Override
    public void run() {
        Object msg = null;
        while (true) {
            try {
                while (true) {
                    Object o;
                    block10: {
                        block9: {
                            if (msg != null) break block9;
                            T t = this.waitLinkedList.peek();
                            msg = t;
                            if (t == null) break block10;
                        }
                        try {
                            this.threadPool.execute(new ThreadWork(msg));
                            msg = null;
                            this.waitLinkedList.remove();
                            continue;
                        }
                        catch (RejectedExecutionException e) {
                        }
                        catch (Exception e) {
                            this.log.error("\u7ebf\u7a0b\u6c60\u6267\u884c\u51fa\u9519", (Throwable)e);
                            this.waitLinkedList.remove();
                            continue;
                        }
                    }
                    if ((o = this.takeData(500L)) == null) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("ThreadPool>>>>>>>" + o.toString());
                    }
                    if (o == null || !this.threadEventHandler.isNeedNewThread(o)) continue;
                    this.offerWaitObjct(o);
                }
            }
            catch (Exception e) {
                this.log.error("Exception:", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void offerWaitObjct(T o) {
        if (!this.waitLinkedList.offer(o)) {
            this.log.warn("\u961f\u5217\u8d85\u9650{},\u6839\u636e\u7b56\u7565\u8fdb\u884c{}\u64cd\u4f5c", (Object)this.queueCapacity, (Object)(this.queueStrategy == 0 ? "\u51fa\u6808\u538b\u6808" : "\u4e22\u5f03"));
            if (this.queueStrategy == 0) {
                this.waitLinkedList.poll();
                this.waitLinkedList.offer(o);
            }
        }
    }

    public IThreadEventHandler getThreadEventHandler() {
        return this.threadEventHandler;
    }

    public void setThreadEventHandler(IThreadEventHandler threadEventHandler) {
        this.threadEventHandler = threadEventHandler;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        if (this.waitLinkedList != null) {
            LinkedBlockingQueue<T> newLinkedList = new LinkedBlockingQueue<T>(queueCapacity);
            LinkedBlockingQueue<T> linkedBlockingQueue = this.waitLinkedList;
            synchronized (linkedBlockingQueue) {
                while (!this.waitLinkedList.isEmpty()) {
                    newLinkedList.offer(this.waitLinkedList.poll());
                }
            }
            this.waitLinkedList = newLinkedList;
        }
    }

    public int getQueueStrategy() {
        return this.queueStrategy;
    }

    public void setQueueStrategy(int queueStrategy) {
        this.queueStrategy = queueStrategy;
    }

    @Override
    @PerformanceMethod(value="\u7b49\u5f85\u5904\u7406\u4efb\u52a1\u6570")
    public int getWaitCount() {
        return this.waitLinkedList.size();
    }

    public boolean isPoolWait() {
        return !this.waitLinkedList.isEmpty();
    }

    class ThreadWork
    implements Runnable {
        private T msg;

        public ThreadWork(T msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            try {
                ThreadPool.this.threadEventHandler.handleEvent(this.msg);
                this.msg = null;
            }
            catch (Exception e) {
                ThreadPool.this.log.error("Exception:", (Throwable)e);
            }
        }
    }
}

