/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.base.utils;

import com.easesource.iot.protoparser.base.utils.BytesUtil;
import java.nio.ByteBuffer;

public class HexDump {
    private static final byte[] highDigits;
    private static final byte[] lowDigits;

    public static String hexDump(ByteBuffer in) {
        if (null == in) {
            return "null";
        }
        int size = in.remaining();
        if (size == 0) {
            return "empty";
        }
        StringBuffer out = new StringBuffer(in.remaining() * 3 - 1);
        int i = in.position();
        int byteValue = in.get(i) & 0xFF;
        out.append((char)highDigits[byteValue]);
        out.append((char)lowDigits[byteValue]);
        --size;
        ++i;
        while (size > 0) {
            out.append(' ');
            byteValue = in.get(i) & 0xFF;
            out.append((char)highDigits[byteValue]);
            out.append((char)lowDigits[byteValue]);
            ++i;
            --size;
        }
        return out.toString();
    }

    public static String hexDumpCompact(ByteBuffer in) {
        if (null == in) {
            return "";
        }
        int size = in.remaining();
        if (size == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(in.remaining() * 2);
        int i = in.position();
        while (size > 0) {
            int byteValue = in.get(i) & 0xFF;
            out.append((char)highDigits[byteValue]);
            out.append((char)lowDigits[byteValue]);
            ++i;
            --size;
        }
        return out.toString();
    }

    public static String hexDumpCompactSilent(ByteBuffer in) {
        if (null == in) {
            return "";
        }
        int size = in.remaining();
        if (size == 0) {
            return "";
        }
        StringBuffer out = new StringBuffer(in.remaining() * 2);
        int i = in.position();
        while (size > 0) {
            int byteValue = in.get(i) & 0xFF;
            out.append((char)highDigits[byteValue]);
            out.append((char)lowDigits[byteValue]);
            ++i;
            --size;
        }
        return out.toString();
    }

    public static String hexDump(byte[] in) {
        return in == null ? "empty" : HexDump.hexDump(in, 0, in.length);
    }

    public static String hexDump(byte[] in, int offset, int length) {
        int size = in.length;
        if (size == 0 || length < 0 || length > size || offset < 0 || offset > size) {
            return "empty";
        }
        if (offset + length > size) {
            return "empty";
        }
        StringBuffer out = new StringBuffer(length * 3 - 1);
        int byteValue = in[offset++] & 0xFF;
        out.append((char)highDigits[byteValue]);
        out.append((char)lowDigits[byteValue]);
        --length;
        while (length > 0) {
            out.append(' ');
            byteValue = in[offset++] & 0xFF;
            out.append((char)highDigits[byteValue]);
            out.append((char)lowDigits[byteValue]);
            --length;
        }
        return out.toString();
    }

    public static String hexNoSpaceDump(byte[] in) {
        return in == null ? "empty" : HexDump.hexNoSpaceDump(in, 0, in.length);
    }

    public static String hexNoSpaceDump(byte[] in, int offset, int length) {
        int size = in.length;
        if (size == 0 || length < 0 || length > size || offset < 0 || offset > size) {
            return "empty";
        }
        if (offset + length > size) {
            return "empty";
        }
        StringBuffer out = new StringBuffer(length * 3 - 1);
        int byteValue = in[offset++] & 0xFF;
        out.append((char)highDigits[byteValue]);
        out.append((char)lowDigits[byteValue]);
        --length;
        while (length > 0) {
            byteValue = in[offset++] & 0xFF;
            out.append((char)highDigits[byteValue]);
            out.append((char)lowDigits[byteValue]);
            --length;
        }
        return out.toString();
    }

    public static String hexDumpCompact(byte[] in) {
        return in == null ? "" : HexDump.hexDumpCompact(in, 0, in.length);
    }

    public static String hexDumpCompact(byte[] in, int offset, int length) {
        if (null == in) {
            return "";
        }
        int size = in.length;
        if (size == 0 || length < 0 || length > size || offset < 0 || offset > size) {
            return "";
        }
        if (offset + length > size) {
            return "";
        }
        StringBuffer out = new StringBuffer(length * 2);
        while (length > 0) {
            int byteValue = in[offset++] & 0xFF;
            out.append((char)highDigits[byteValue]);
            out.append((char)lowDigits[byteValue]);
            --length;
        }
        return out.toString();
    }

    public static String toHex(byte byteValue) {
        StringBuffer out = new StringBuffer(2);
        int index = byteValue & 0xFF;
        out.append((char)highDigits[index]);
        out.append((char)lowDigits[index]);
        return out.toString();
    }

    public static String toHex(short shortValue) {
        StringBuffer out = new StringBuffer(5);
        int index = shortValue >> 8 & 0xFF;
        out.append((char)highDigits[index]);
        out.append((char)lowDigits[index]);
        index = shortValue & 0xFF;
        out.append((char)highDigits[index]);
        out.append((char)lowDigits[index]);
        return out.toString();
    }

    public static String toHex(int i) {
        StringBuffer out = new StringBuffer(8);
        int index = i >> 24 & 0xFF;
        out.append((char)highDigits[index]);
        out.append((char)lowDigits[index]);
        index = i >> 16 & 0xFF;
        out.append((char)highDigits[index]);
        out.append((char)lowDigits[index]);
        index = i >> 8 & 0xFF;
        out.append((char)highDigits[index]);
        out.append((char)lowDigits[index]);
        index = i & 0xFF;
        out.append((char)highDigits[index]);
        out.append((char)lowDigits[index]);
        return out.toString();
    }

    public static String toHex(long i) {
        ByteBuffer buff = ByteBuffer.allocate(8);
        buff.putLong(i);
        buff.flip();
        return HexDump.hexDumpCompact(buff);
    }

    public static ByteBuffer toByteBuffer(String str) {
        ByteBuffer buff = ByteBuffer.wrap(new byte[str.length() / 2]);
        for (int i = 0; i < str.length() - 1; i += 2) {
            char c1 = str.charAt(i);
            char c2 = str.charAt(i + 1);
            byte b1 = (byte)(HexDump.char2byte(c1) << 4 | 0xF & HexDump.char2byte(c2));
            buff.put(b1);
        }
        buff.flip();
        return buff;
    }

    public static ByteBuffer toByteBuffer(ByteBuffer dest, String str) {
        if (null == str || str.length() == 0) {
            return dest;
        }
        for (int i = 0; i < str.length() - 1; i += 2) {
            char c1 = str.charAt(i);
            char c2 = str.charAt(i + 1);
            byte b1 = (byte)(HexDump.char2byte(c1) << 4 | 0xF & HexDump.char2byte(c2));
            dest.put(b1);
        }
        return dest;
    }

    private static byte char2byte(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(c - 65 + 10);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(c - 97 + 10);
        }
        return 0;
    }

    public static void main(String[] args) {
        byte[] b;
        int rtuId = 295109209;
        for (byte a : b = BytesUtil.intToBytes(rtuId)) {
            System.out.println(a);
        }
        System.out.println(HexDump.hexNoSpaceDump(b));
    }

    static {
        byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        byte[] high = new byte[256];
        byte[] low = new byte[256];
        for (int i = 0; i < 256; ++i) {
            high[i] = digits[i >>> 4];
            low[i] = digits[i & 0xF];
        }
        highDigits = high;
        lowDigits = low;
    }
}

