package com.easesource.iot.protoparser.base.utils;

import java.util.Calendar;
import java.util.Date;

public class ParseUtils {

    public static Date readTime(byte[] bytes) {
        if (bytes == null || bytes.length != 6) {
            throw new IllegalArgumentException("time bytes length != 6");
        }
        int seconds = bytes[0] & 0x3F;
        seconds = seconds > 59 ? 59 : seconds;
        int minute = bytes[1] & 0x3F;
        minute = minute > 59 ? 59 : minute;
        int hour = bytes[2] & 0x1F;
        hour = hour > 23 ? 23 : hour;
        int day = bytes[3] & 0x1F;
        int month = bytes[4] & 0x0F;
        month = month > 12 ? 12 : month;
        int year = 2000 + (bytes[5] & 0x7F);

        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hour, minute, seconds);// Calendar的月份从0开始，0是一月份
        cal.set(Calendar.MILLISECOND, 0);
        return cal.getTime();
    }

    public static int[] readStatus(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("bytes length <=0");
        }
        int[] status = new int[8 * bytes.length];
        for (int i = 0; i < 8; i++) {
            for (int j = 0; j < bytes.length; j++) {
                status[i + 8 * j] = (bytes[j] >> i) & 0x1;
            }
        }
        return status;
    }

    public static int readBit(byte bt, int position) {
        if (position < 0 || position >= 8) {
            throw new IllegalArgumentException("position range 0-7");
        }
        return (bt >> position) & 0x1;
    }

    public static byte[] dateToByte(Date date){
        byte[] result = new byte[7];
        Calendar cal=Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(Calendar.YEAR);//获取年份
        int month=cal.get(Calendar.MONTH);//获取月份
        int day=cal.get(Calendar.DATE);//获取日
        int hour=cal.get(Calendar.HOUR);//小时
        int minute=cal.get(Calendar.MINUTE);//分
        int second=cal.get(Calendar.SECOND);//秒
        int millis = cal.get(Calendar.MILLISECOND); //毫秒
        int milliseconds = second * 1000 +millis;
        int yr = year-2000;
        System.out.println("年"+year+"月"+month+"日"+day+"小时"+hour+"分"+minute+""+"毫秒"+milliseconds);
        byte[] millisecondsBytes = intTo2Byte(milliseconds);
        byte[] datetime = {(byte) minute,(byte)hour,(byte)day,(byte)month,(byte)yr};
        result = BytesUtil.byteMerger(millisecondsBytes,datetime);
        return result;
    }
    /**
     * 整型数据拆分为长度为2的字节数组，低8位存放在序号小的元素，高8位存放在序号大的元素中(小端存储)
     *
     * @param data
     * @return
     */
    public static byte[] intTo2Byte(int data) {
        byte[] byteArray = new byte[2];
        byteArray[0] = (byte) data;
        byteArray[1] = (byte) (data >> 8);
        return byteArray;
    }


    public static void main(String[] args) {
//        byte aa = (byte) 0x0f;
//        for (int i = 7; i >= 0; i--) {
//            System.out.println(ParseUtils.readBit(aa, i));
//        }
//        System.out.println(Integer.MAX_VALUE);

    }
}
