/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.base.utils;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.iot.protoparser.base.cache.ChannelIpPortCache;
import com.easesource.iot.protoparser.base.cache.DcuIdChannelCache;
import com.easesource.iot.protoparser.base.utils.FileUtil;
import com.easesource.iot.protoparser.base.utils.HexDump;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatWriter {
    private static final Logger logger = LoggerFactory.getLogger(DateConvertUtils.class);

    public static void formatWriter(String rtuId, byte[] data, String upOrDown) throws Exception {
        String filename = "datalogs" + File.separator + rtuId + "." + FormatWriter.getDay() + ".txt";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String formatStr = formatter.format(new Date());
        String ipAndPort = ChannelIpPortCache.getKeyCache(DcuIdChannelCache.getKeyCache(Integer.parseInt(rtuId, 16)));
        String target = upOrDown + formatStr + "|" + ipAndPort + "|" + HexDump.hexNoSpaceDump(data) + "\n";
        FileUtil.writeString(filename, target);
    }

    public static String getDay() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String formatStr = formatter.format(new Date());
        return formatStr;
    }

    public static void upData(String rtuId, byte[] data) throws Exception {
        FormatWriter.formatWriter(rtuId, data, "  Up| ");
    }

    public static void downData(String rtuId, byte[] data) throws Exception {
        FormatWriter.formatWriter(rtuId, data, "Down| ");
    }

    public static void main(String[] args) throws Exception {
    }
}

