package com.easesource.iot.protoparser.base.utils;

import java.io.*;
import java.nio.channels.FileChannel;

public class FileUtil {

    public static String writeData(String fileName, byte[] data) throws Exception {
        FileOutputStream out = null;
        try {
            fileName = fileName.trim();
            int pos = fileName.lastIndexOf(File.separator);
            String path = fileName.substring(0, pos);

            if (!"".equals(path)) {
                File file = new File(path);
                if (file.exists() && !file.isDirectory()) {
                    throw new Exception("[" + path + "] is file not directory ");
                }
                if (!file.exists() && !file.mkdirs()) {
                    throw new Exception("can't create directory:" + path);
                }
            }
            out = new FileOutputStream(fileName, false);
            out.write(data);
            return path;
        } finally {
            close(out);
        }
    }
    public static String writeString(String fileName, String data) throws Exception {
        FileOutputStream out = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            fileName = fileName.trim();
            int pos = fileName.lastIndexOf(File.separator);
            String path = fileName.substring(0, pos);

            if (!"".equals(path)) {
                File file = new File(path);
                if (file.exists() && !file.isDirectory()) {
                    throw new Exception("[" + path + "] is file not directory ");
                }
                if (!file.exists() && !file.mkdirs()) {
                    throw new Exception("can't create directory:" + path);
                }
            }
            out = new FileOutputStream(fileName, true);
            osw = new OutputStreamWriter(out,"UTF-8");
            bw = new BufferedWriter(osw);
            bw.write(data);
            bw.flush();
            return path;
        } finally {
            close(out);
            if(osw != null){
                osw.close();
            }
            if(bw != null){
                bw.close();
            }
        }
    }
    public static String trimSeparator(String path) {
        path = path.trim();
        if (path.length() > 1) {
            path = path.replace("/", File.separator);
            path = path.replace("\\", File.separator);
            while (path.indexOf(File.separator) == 0) {
                path = path.substring(1, path.length());
            }
            while (path.lastIndexOf(File.separator) == path.length() - 1) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }


    public static void writeFile(String str, String fileName) throws IOException {
        FileWriter out = null;
        BufferedWriter bw = null;
        try {
            out = new FileWriter(fileName);
            bw = new BufferedWriter(out);
            bw.write(str);
        } finally {
            close(bw);
            close(out);
        }
    }

    public static byte[] readBytesFromFile(String fileName) throws IOException {
        return readBytesFromFile(new File(fileName));
    }

    public static byte[] readBytesFromFile(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(fin.available());
        streamCopy(fin, outStream);
        close(fin);
        return outStream.toByteArray();
    }

    public static long streamCopy(InputStream in, OutputStream out) throws IOException {
        long writeCount = 0;
        if ((in == null) || (out == null)) {
            return 0;
        }
        byte[] buffer = new byte[32 * 1024];
        int bytesRead = 0;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            writeCount += bytesRead;
        }
        return writeCount;
    }

    public static void close(InputStream iStream) {
        if (iStream != null) {
            try {
                iStream.close();
            } catch (final Exception e) {
                //
            }
        }
    }

    public static void close(OutputStream oStream) {
        if (oStream != null) {
            try {
                oStream.close();
            } catch (final Exception e) {
                //
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            } catch (final Exception e) {
                //
            }
        }
    }

    public static long getFileSize(String  path){
        File file = new File(path);
        FileChannel fc = null;
        try {
            if(file.exists() && file.isFile()){
                String fileName = file.getName();
                FileInputStream fis = new FileInputStream(file);
                fc = fis.getChannel();
                System.out.println("文件"+fileName+"的大小是："+fc.size()+"\n");
                return fc.size();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }finally{
            if(null!=fc){
                try {
                    fc.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }
}
