package com.easesource.iot.protoparser.base.utils;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.iot.protoparser.base.cache.ChannelIpPortCache;
import com.easesource.iot.protoparser.base.cache.DcuIdChannelCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import static com.easesource.iot.protoparser.base.constant.Constants.*;

/**
 * @author YUZHANG
 */
public class FormatWriter {

    private static final Logger logger = LoggerFactory.getLogger(DateConvertUtils.class);

    public static void formatWriter(String rtuId , byte[] data , String upOrDown) throws Exception {
        String filename = FILE_PATH + File.separator + rtuId + POINT + getDay() + SUFFIX;
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_PATTERN);
        String formatStr = formatter.format(new Date());
        String ipAndPort = ChannelIpPortCache.getKeyCache(DcuIdChannelCache.getKeyCache(Integer.parseInt(rtuId,16)));
        String target = upOrDown + formatStr + PK_DELIMITED + ipAndPort + PK_DELIMITED + HexDump.hexNoSpaceDump(data) + ENTER;
        /*if(logger.isInfoEnabled() && StringUtils.equals(rtuId, "401012A0")) {
            logger.info("逻辑地址: " + rtuId + " 保存报文，写文件。");
            logger.info("frame : " + target);
        }*/
        FileUtil.writeString(filename, target);
    }

    public static String  getDay(){
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT_DAY);
        String formatStr = formatter.format(new Date());
        return formatStr;
    }

    public static void upData(String rtuId,byte[] data) throws Exception {
        formatWriter(rtuId,data,UP_DATA);
    }
    public static void downData(String rtuId,byte[] data) throws Exception {
        formatWriter(rtuId,data,DOWN_DATA);
    }
    public static void main(String[] args) throws Exception {
    }

}
