package com.easesource.iot.protoparser.base.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Check {
    private  static final Logger log = LoggerFactory.getLogger(Check.class);

    public static boolean checkBytesCol(byte[] data,String col){
        boolean flag = true;
        if(data.length == 46){
            if(col.equals("84")){
                //先放行
                return true;
            }else if(col.equals("81")){
                for(int i = 3; i <= 43;i++){
                    //第27是2C为符号位，不包括ST位。
                    if(i != 27 ){
                        if(!isNumber(HexDump.toHex(data[i]))){
                            log.error("报文中的"+HexDump.toHex(data[i])+">>>>不符合格式要求");
                            return false;
                        }
                    }
                }
            }
        }

        return flag;
    }
    /**
     * 校验指定数据域中只能出现0-9数字
     * @param data
     * @return
     */
    public static boolean checkBytes(byte[] data){
           String s = null;
           boolean flag = true;
           for(byte b:data){
               s = HexDump.toHex(b);
               if(!isNumber(s)){
                   return false;
               }
           }
           return flag;
    }
    public static  boolean isNumber(String str)
    {
        java.util.regex.Pattern pattern = java.util.regex.Pattern.compile("[0-9]*");
        java.util.regex.Matcher match = pattern.matcher(str);
        if(match.matches() == false)
        {
            return false;
        }
        else
        {
            return true;
        }
    }

}
