/*
 * Decompiled with CFR 0.152.
 */
package com.easesource.iot.protoparser.base.utils;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeData(String fileName, byte[] data) throws Exception {
        String string;
        FileOutputStream out = null;
        try {
            fileName = fileName.trim();
            int pos = fileName.lastIndexOf(File.separator);
            String path = fileName.substring(0, pos);
            if (!"".equals(path)) {
                File file = new File(path);
                if (file.exists() && !file.isDirectory()) {
                    throw new Exception("[" + path + "] is file not directory ");
                }
                if (!file.exists() && !file.mkdirs()) {
                    throw new Exception("can't create directory:" + path);
                }
            }
            out = new FileOutputStream(fileName, false);
            out.write(data);
            string = path;
        }
        catch (Throwable throwable) {
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close(out);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeString(String fileName, String data) throws Exception {
        String string;
        FileOutputStream out = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            fileName = fileName.trim();
            int pos = fileName.lastIndexOf(File.separator);
            String path = fileName.substring(0, pos);
            if (!"".equals(path)) {
                File file = new File(path);
                if (file.exists() && !file.isDirectory()) {
                    throw new Exception("[" + path + "] is file not directory ");
                }
                if (!file.exists() && !file.mkdirs()) {
                    throw new Exception("can't create directory:" + path);
                }
            }
            out = new FileOutputStream(fileName, true);
            osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            bw = new BufferedWriter(osw);
            bw.write(data);
            bw.flush();
            string = path;
        }
        catch (Throwable throwable) {
            FileUtil.close(out);
            if (osw != null) {
                osw.close();
            }
            if (bw != null) {
                bw.close();
            }
            throw throwable;
        }
        FileUtil.close(out);
        if (osw != null) {
            osw.close();
        }
        if (bw != null) {
            bw.close();
        }
        return string;
    }

    public static String trimSeparator(String path) {
        if ((path = path.trim()).length() > 1) {
            path = path.replace("/", File.separator);
            path = path.replace("\\", File.separator);
            while (path.indexOf(File.separator) == 0) {
                path = path.substring(1, path.length());
            }
            while (path.lastIndexOf(File.separator) == path.length() - 1) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String str, String fileName) throws IOException {
        FileWriter out = null;
        BufferedWriter bw = null;
        try {
            out = new FileWriter(fileName);
            bw = new BufferedWriter(out);
            bw.write(str);
        }
        catch (Throwable throwable) {
            FileUtil.close(bw);
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close(bw);
        FileUtil.close(out);
    }

    public static byte[] readBytesFromFile(String fileName) throws IOException {
        return FileUtil.readBytesFromFile(new File(fileName));
    }

    public static byte[] readBytesFromFile(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(fin.available());
        FileUtil.streamCopy(fin, outStream);
        FileUtil.close(fin);
        return outStream.toByteArray();
    }

    public static long streamCopy(InputStream in, OutputStream out) throws IOException {
        long writeCount = 0L;
        if (in == null || out == null) {
            return 0L;
        }
        byte[] buffer = new byte[32768];
        int bytesRead = 0;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            writeCount += (long)bytesRead;
        }
        return writeCount;
    }

    public static void close(InputStream iStream) {
        if (iStream != null) {
            try {
                iStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(OutputStream oStream) {
        if (oStream != null) {
            try {
                oStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileSize(String path) {
        File file = new File(path);
        AbstractInterruptibleChannel fc = null;
        try {
            if (file.exists() && file.isFile()) {
                String fileName = file.getName();
                FileInputStream fis = new FileInputStream(file);
                fc = fis.getChannel();
                System.out.println("\u6587\u4ef6" + fileName + "\u7684\u5927\u5c0f\u662f\uff1a" + ((FileChannel)fc).size() + "\n");
                long l = ((FileChannel)fc).size();
                return l;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != fc) {
                try {
                    fc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return 0L;
    }
}

